/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.junit.Ignore;
import org.junit.Test;

public class SnapshotLabelTest
extends AbstractSnapshotTest {
    private static final String SNAPSHOT_LABEL = "some_label";
    private static final String SNAPSHOT_2_LABEL = "another_label";
    private static final String CACHE_NAME = "cache_name";
    private static final Long CACHE_KEY = 1L;
    private static final String CACHE_VALUE = "test";
    private static final int COMPRESSION_LEVEL = -1;
    private File targetDirectory;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.targetDirectory = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"temp", (boolean)true);
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        U.delete((File)this.targetDirectory);
    }

    @Test
    public void testLegacySnapshotParameters() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        cache.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        SnapshotCommonParameters parameters = new SnapshotCommonParameters();
        SnapshotCreateParameters createParameters = new SnapshotCreateParameters(CompressionOption.NONE, -1, 0, true, SNAPSHOT_LABEL);
        SnapshotFuture snp = gg.snapshot().createFullSnapshot(Collections.singleton(CACHE_NAME), null, parameters, createParameters, null);
        snp.get();
        this.assertSnapshotWithLabelExists(snp.snapshotOperation().snapshotId(), SNAPSHOT_LABEL);
    }

    @Test
    public void testNewSnapshotParameters() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        cache.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        IgniteCache cache2 = ig.getOrCreateCache("cache2");
        cache2.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        IgniteCache cache3 = ig.getOrCreateCache("cache3");
        cache3.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        SnapshotCreateParams createParameters = new SnapshotCreateParams(CompressionOption.NONE, -1, 0, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), SNAPSHOT_LABEL);
        SnapshotFuture snp = gg.snapshot().createFullSnapshot((Set)Sets.newHashSet((Object[])new String[]{CACHE_NAME, "cache2"}), null, new SnapshotCommonParams(), createParameters, null);
        SnapshotCreateParams createParametersForAnotherSnapshot = new SnapshotCreateParams(CompressionOption.NONE, -1, 0, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), SNAPSHOT_2_LABEL);
        snp.get();
        SnapshotFuture snp2 = gg.snapshot().createFullSnapshot(Collections.singleton("cache3"), null, new SnapshotCommonParams(), createParametersForAnotherSnapshot, null);
        snp2.get();
        this.assertSnapshotWithLabelExists(snp.snapshotOperation().snapshotId(), SNAPSHOT_LABEL);
        this.assertSnapshotWithLabelExists(snp2.snapshotOperation().snapshotId(), SNAPSHOT_2_LABEL);
    }

    @Test
    public void testDontSearchHumanReadablePart() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long snapshotId = this.createSnapshot((Ignite)ig, gg);
        File snapDirInside = SnapshotLabelTest.snapshotFolder(snapshotId, ig);
        File snapDir = new File(snapDirInside.getParent());
        String newNamePrefix = "ts_11111111_";
        File newName = new File(snapDir.getParent(), newNamePrefix + snapshotId + ".snapshot");
        snapDir.renameTo(newName);
        File file = SnapshotLabelTest.snapshotFolder(snapshotId, ig);
        SnapshotLabelTest.assertTrue((boolean)file.toString().contains(newNamePrefix));
        SnapshotLabelTest.assertTrue((boolean)file.exists());
    }

    @Test
    public void testMoveSnapshot() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long id = this.createSnapshot((Ignite)ig, gg);
        SnapshotFuture move = gg.snapshot().moveSnapshot(id, this.targetDirectory, true, null);
        move.get();
        Path moveSnapDir = Paths.get(this.targetDirectory.getAbsolutePath(), FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        this.assertMetadataExists(moveSnapDir.toFile(), CompressionOption.NONE);
    }

    @Test
    public void testCopySnapshot() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long id = this.createSnapshot((Ignite)ig, gg);
        SnapshotFuture copy = gg.snapshot().copySnapshot(id, this.targetDirectory, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, false, null), null);
        copy.get();
        Path moveSnapDir = Paths.get(this.targetDirectory.getAbsolutePath(), FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        this.assertMetadataExists(moveSnapDir.toFile(), CompressionOption.NONE);
    }

    @Test
    public void testRemoveSnapshot() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long id = this.createSnapshot((Ignite)ig, gg);
        File snapshotFolder = SnapshotLabelTest.snapshotFolder(id, ig);
        SnapshotLabelTest.assertTrue((boolean)snapshotFolder.exists());
        SnapshotFuture delete = gg.snapshot().deleteSnapshot(id, null);
        delete.get();
        SnapshotLabelTest.assertFalse((boolean)snapshotFolder.exists());
    }

    @Test
    public void testRestore() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        cache.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        SnapshotCreateParams createParameters = new SnapshotCreateParams(CompressionOption.NONE, -1, 0, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), SNAPSHOT_LABEL);
        SnapshotFuture snp = gg.snapshot().createFullSnapshot(Collections.singleton(CACHE_NAME), null, new SnapshotCommonParams(), createParameters, null);
        snp.get();
        this.assertSnapshotWithLabelExists(snp.snapshotOperation().snapshotId(), SNAPSHOT_LABEL);
        this.stopAllGrids();
        ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snp.snapshotOperation().snapshotId(), null, null);
        cache = ig.getOrCreateCache(CACHE_NAME);
        SnapshotLabelTest.assertEquals((String)CACHE_VALUE, (String)((String)cache.get((Object)CACHE_KEY)));
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-14373")
    public void testScheduledSnapshotWithLabel() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        this.setupSnapshotListener(ignite);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        SnapshotSchedule schedule = new SnapshotSchedule("", "", SnapshotOperationType.CREATE, "*/2 * * * *", "* * * * *", null, 10L, "", true, new SnapshotCommonParameters(), new SnapshotCreateParameters(CompressionOption.NONE, -1, 0, true, SNAPSHOT_LABEL));
        scheduler.start(schedule);
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
        SnapshotLabelTest.loadWithIntsAsync((Ignite)ignite, CACHE_NAME, 1, 1, 300);
        GridSnapshotOperationEx operation = this.waitForSnapshot(snapshotManager, true);
        this.assertSnapshotWithLabelExists(operation.snapshotId(), SNAPSHOT_LABEL);
    }

    private void assertSnapshotWithLabelExists(long snapshotId, String label) throws IgniteCheckedException {
        for (String folder : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)folder, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, (String)label));
            SnapshotLabelTest.assertTrue((boolean)fullSnapDir.exists());
        }
    }

    public long createSnapshot(Ignite ig, GridGain gg) throws IgniteCheckedException {
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        cache.put((Object)CACHE_KEY, (Object)CACHE_VALUE);
        SnapshotCreateParams createParameters = new SnapshotCreateParams(CompressionOption.NONE, -1, 0, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), SNAPSHOT_LABEL);
        SnapshotFuture snp = gg.snapshot().createFullSnapshot((Set)Sets.newHashSet((Object[])new String[]{CACHE_NAME}), null, new SnapshotCommonParams(), createParameters, null);
        snp.get();
        long id = snp.snapshotOperation().snapshotId();
        this.assertSnapshotWithLabelExists(id, SNAPSHOT_LABEL);
        return id;
    }
}

