/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Test;

public class GridPointInTimeRecoveryWithWalPageCompressionSharedFolderTest
extends GridPointInTimeRecoveryAbstractTest {
    private final int NODES = DiskPageCompression.values().length;

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration().setName("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(0)};
    }

    private IgniteConfiguration getConfiguration(String name, DiskPageCompression walPageCompression) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalPageCompression(walPageCompression);
        return cfg;
    }

    private Ignite startGrid(int idx, DiskPageCompression walPageCompression) throws Exception {
        String igniteInstanceName = this.getTestIgniteInstanceName(idx);
        return this.startGrid(igniteInstanceName, this.optimize(this.getConfiguration(igniteInstanceName, walPageCompression)), null);
    }

    private Ignite startGridsWithWalPageCompression(int cnt) throws Exception {
        assert (cnt > 0);
        Ignite ignite = null;
        for (int i = 0; i < cnt; ++i) {
            DiskPageCompression walPageCompression = DiskPageCompression.fromOrdinal((int)(i % this.NODES));
            if (ignite == null) {
                ignite = this.startGrid(i, walPageCompression);
                continue;
            }
            this.startGrid(i, walPageCompression);
        }
        if (this.checkTopology()) {
            this.checkTopology(cnt);
        }
        assert (ignite != null);
        return ignite;
    }

    protected long getTestTimeout() {
        return super.getTestTimeout() * 2L;
    }

    @Test
    public void testRecoveryOnCleanGridWithBiggerTopology() throws Exception {
        this.testRecoveryOnCleanGrid(this.NODES + 1);
    }

    @Test
    public void testRecoveryOnCleanGridWithSmallerTopology() throws Exception {
        this.testRecoveryOnCleanGrid(this.NODES - 1);
    }

    private void testRecoveryOnCleanGrid(int newTopSize) throws Exception {
        this.consistentIdPrefix = "OLD";
        Ignite ig0 = this.startGridsWithWalPageCompression(this.NODES);
        assert (this.grid(1).configuration().getDataStorageConfiguration().getWalPageCompression() != DataStorageConfiguration.DFLT_WAL_PAGE_COMPRESSION);
        ig0.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext(ig0, "default");
        test.loadByTime(1200L);
        GridGain gg0 = (GridGain)ig0.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoveryWithWalPageCompressionSharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture full = snp.createFullSnapshot(null, null);
        full.get();
        test.loadByTime(1100L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint p = test.savePoint();
        test.loadByTime(1000L);
        snp.createFullSnapshot(null, null).get();
        List infos = snp.list();
        GridPointInTimeRecoveryWithWalPageCompressionSharedFolderTest.assertEquals((int)3, (int)infos.size());
        infos.sort(SnapshotIdComparator.INSTANCE);
        File sharedFolder = this.createSharedFolder();
        this.moveTheChainOfSnapshots(((SnapshotInfo)infos.get(1)).snapshotId(), sharedFolder, snp);
        this.stopAllGrids();
        this.deleteWorkFiles();
        this.consistentIdPrefix = "NEW";
        ig0 = this.startGridsWithWalPageCompression(newTopSize);
        ig0.cluster().active(true);
        gg0 = (GridGain)ig0.plugin("GridGain");
        snp = (GridSnapshotEx)gg0.snapshot();
        GridPointInTimeRecoveryWithWalPageCompressionSharedFolderTest.assertNotNull((Object)snp);
        SnapshotFuture recoveryFut = snp.recoveryTo(p.time, Collections.singleton(sharedFolder), null, "Recovery from shared folder (clean grid).");
        recoveryFut.get();
        this.awaitPartitionMapExchange(true, true, null, true);
        test.checkPoint(p, G.allGrids());
    }

    private void moveTheChainOfSnapshots(long id, File sharedFolder, GridSnapshotEx snp) {
        snp.forceMoveSnapshot(id, sharedFolder, null).get();
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false));
    }

    private static class SnapshotIdComparator
    implements Comparator<SnapshotInfo> {
        static final SnapshotIdComparator INSTANCE = new SnapshotIdComparator();

        private SnapshotIdComparator() {
        }

        @Override
        public int compare(SnapshotInfo o1, SnapshotInfo o2) {
            return Long.compare(o1.snapshotId(), o2.snapshotId());
        }
    }
}

