/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.AbstractReleaseSegmentTest;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecoveryProcessor;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class GridPointInTimeRecoveryReleaseSegmentTest
extends AbstractReleaseSegmentTest {
    private File snapshotDir;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true))});
    }

    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        this.snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false);
        U.delete((File)this.snapshotDir);
    }

    @Test
    public void testRecoveryInitStep() throws Exception {
        this.checkReleaseSegmentOnRecovery(new CIX2<GridRecoveryProcessor, IgniteEx>(){

            public void applyx(GridRecoveryProcessor spy, IgniteEx n) throws IgniteCheckedException {
                ((GridRecoveryProcessor)Mockito.doAnswer(m -> {
                    GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)GridPointInTimeRecoveryReleaseSegmentTest.this.segmentAware(n).minReserveIndex(Long.MAX_VALUE));
                    return m.callRealMethod();
                }).when((Object)spy)).initRecovery((PITRParameters)ArgumentMatchers.any());
            }
        }, false);
    }

    @Test
    public void testRecoveryThirdStep() throws Exception {
        this.checkReleaseSegmentOnRecovery(new CIX2<GridRecoveryProcessor, IgniteEx>(){

            public void applyx(GridRecoveryProcessor spy, IgniteEx n) {
                ((GridRecoveryProcessor)Mockito.doAnswer(m -> {
                    GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)GridPointInTimeRecoveryReleaseSegmentTest.this.segmentAware(n).minReserveIndex(Long.MAX_VALUE));
                    return m.callRealMethod();
                }).when((Object)spy)).scanForLeftNodes();
            }
        }, true);
    }

    @Test
    public void testRecoveryFinalStep() throws Exception {
        this.checkReleaseSegmentOnRecovery(new CIX2<GridRecoveryProcessor, IgniteEx>(){

            public void applyx(GridRecoveryProcessor spy, IgniteEx n) {
                ((GridRecoveryProcessor)Mockito.doAnswer(m -> {
                    GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)GridPointInTimeRecoveryReleaseSegmentTest.this.segmentAware(n).minReserveIndex(Long.MAX_VALUE));
                    return m.callRealMethod();
                }).when((Object)spy)).recoveryLocalUpdates((SnapshotOperationContext)ArgumentMatchers.any());
            }
        }, true);
    }

    @Test
    public void testCopyAndMoveWithoutSegmentReservation() throws Exception {
        this.checkCopyMoveOperation((IgniteThrowableConsumer<IgniteEx>)(IgniteThrowableConsumer & Serializable)n -> GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)this.segmentAware((IgniteEx)n).minReserveIndex(Long.MAX_VALUE)), false);
    }

    @Test
    public void testCopyAndMoveWithDeleteSegments() throws Exception {
        this.checkCopyMoveOperation((IgniteThrowableConsumer<IgniteEx>)(IgniteThrowableConsumer & Serializable)n -> {
            DatabaseSnapshotSpi spy = (DatabaseSnapshotSpi)Mockito.spy((Object)this.snapshotSpi((IgniteEx)n));
            ((DatabaseSnapshotSpi)Mockito.doAnswer(m -> {
                Collection segments = (Collection)m.getArgument(1);
                GridPointInTimeRecoveryReleaseSegmentTest.assertFalse((boolean)segments.isEmpty());
                File first = (File)F.first((Iterable)segments);
                File tmp = new File(first.getParentFile(), first.getName() + ".tmpTest");
                GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)first.renameTo(tmp));
                try {
                    Object object = m.callRealMethod();
                    return object;
                }
                finally {
                    GridPointInTimeRecoveryReleaseSegmentTest.assertTrue((boolean)tmp.renameTo(first));
                }
            }).when((Object)spy)).copyWalSegments(ArgumentMatchers.anyLong(), (Collection)ArgumentMatchers.any(), (SnapshotPath)ArgumentMatchers.any(), (SnapshotOperationContext)ArgumentMatchers.any());
            this.snapshotSpi((IgniteEx)n, spy);
        }, true);
    }

    private void checkReleaseSegmentOnRecovery(CIX2<GridRecoveryProcessor, IgniteEx> spyConsumer, boolean expAfterSnap) throws Exception {
        IgniteEx n = this.startGrid(0);
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate(cache, 100, 0);
        this.snapshotEx(n).createFullSnapshot(null, "first full").get(this.getTestTimeout());
        long recoveryPointInTime = U.currentTimeMillis() + (long)(expAfterSnap ? 1000 : 0);
        this.populate(cache, 100, 100);
        GridRecoveryProcessor spy = (GridRecoveryProcessor)Mockito.spy((Object)this.recoveryProcessor(n));
        spyConsumer.applyx((Object)spy, (Object)n);
        this.recoveryProcessor(n, spy);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.snapshotEx(n).recoveryTo(new RecoveryParams().time(recoveryPointInTime)).get(this.getTestTimeout()), IgniteCheckedException.class, null);
        if (expAfterSnap) {
            GridPointInTimeRecoveryReleaseSegmentTest.assertEquals((int)100, (int)cache.size(new CachePeekMode[0]));
        } else {
            GridPointInTimeRecoveryReleaseSegmentTest.assertEquals((int)200, (int)cache.size(new CachePeekMode[0]));
        }
    }

    private void checkCopyMoveOperation(IgniteThrowableConsumer<IgniteEx> nodeConsumer, boolean expErr) throws Exception {
        IgniteEx n = this.startGrid(0);
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate(cache, 100, 0);
        SnapshotFuture fullFut0 = this.snapshotEx(n).createFullSnapshot(null, "first full");
        fullFut0.get(this.getTestTimeout());
        this.populate(cache, 100, 100);
        SnapshotFuture fullFut1 = this.snapshotEx(n).createFullSnapshot(null, "second full");
        fullFut1.get(this.getTestTimeout());
        nodeConsumer.accept((Object)n);
        File tmpDir = new File(this.snapshotDir, U.maskForFileName((CharSequence)this.getTestIgniteInstanceName()));
        long snapId = fullFut0.snapshotOperation().snapshotId();
        org.gridgain.grid.persistentstore.SnapshotPath dest = org.gridgain.grid.persistentstore.SnapshotPath.file().path(new File(tmpDir, "copy")).build();
        CopySnapshotParams cpParams = new CopySnapshotParams().snapshotId(snapId).destinationPath(dest);
        dest = org.gridgain.grid.persistentstore.SnapshotPath.file().path(new File(tmpDir, "move")).build();
        MoveSnapshotParams moveParams = new MoveSnapshotParams().snapshotId(snapId).destinationPath(dest);
        if (expErr) {
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> (Void)this.snapshotEx(n).copy(cpParams).get(this.getTestTimeout()), IgniteCheckedException.class, null);
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> (Void)this.snapshotEx(n).move(moveParams).get(this.getTestTimeout()), IgniteCheckedException.class, null);
        } else {
            this.snapshotEx(n).copy(cpParams).get(this.getTestTimeout());
            this.snapshotEx(n).move(moveParams).get(this.getTestTimeout());
        }
        GridPointInTimeRecoveryReleaseSegmentTest.assertEquals((int)1, (int)G.allGrids().size());
    }

    private GridSnapshotEx snapshotEx(IgniteEx n) {
        GridGain gg = (GridGain)n.plugin("GridGain");
        return (GridSnapshotEx)gg.snapshot();
    }

    private GridRecoveryProcessor recoveryProcessor(IgniteEx n) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        return (GridRecoveryProcessor)gg.provider().recovery();
    }

    private void recoveryProcessor(IgniteEx n, GridRecoveryProcessor spy) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        GridTestUtils.setFieldValue((Object)gg.provider(), (String)"recMgr", (Object)spy);
    }

    private DatabaseSnapshotSpi snapshotSpi(IgniteEx n) {
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)n.context().cache().context().snapshot();
        return snapshotMgr.snapshotSpi();
    }

    private void snapshotSpi(IgniteEx n, DatabaseSnapshotSpi spy) {
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)n.context().cache().context().snapshot();
        GridTestUtils.setFieldValue((Object)snapshotMgr, (String)"dbSnapshotSpi", (Object)spy);
    }
}

