/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryRebalanceTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(4);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void testRecoveryFailsIfWalDisabled() throws Exception {
        this.doTest(4, 4, true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_FAIL_NODE_ON_UNRECOVERABLE_PARTITION_INCONSISTENCY", value="true")
    public void testRecoveryNotFailsIfWalSomewhereEnabled() throws Exception {
        this.doTest(8, 4, false);
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_DISABLE_WAL_DURING_REBALANCING", value="false"), @WithSystemProperty(key="IGNITE_FAIL_NODE_ON_UNRECOVERABLE_PARTITION_INCONSISTENCY", value="true")})
    public void testRecoveryNotFailsIfWalWasntDisableDuringRebalancing() throws Exception {
        this.doTest(4, 4, false);
    }

    private void doTest(int nodeCount, int restartNodeCount, boolean shouldFail) throws Exception {
        this.startGrids(nodeCount);
        IgniteEx ig = this.startClient(nodeCount);
        ig.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig, "default");
        for (int k = 0; k < restartNodeCount; ++k) {
            test.loadByTime(3000L);
            this.stopGrid(k);
            test.loadByTime(3000L);
            this.startGrid(k);
            this.awaitPartitionMapExchange();
        }
        ig = this.grid(0);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        try {
            snp.recoveryTo(pnt.time, pnt.msg).get();
        }
        catch (Exception ex) {
            if (shouldFail) {
                return;
            }
            throw ex;
        }
        GridPointInTimeRecoveryRebalanceTest.assertFalse((String)"Recovery should fail.", (boolean)shouldFail);
        test.checkPoint(pnt, G.allGrids());
    }
}

