/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotProgressMessage;
import org.junit.Assert;

public abstract class GridPointInTimeRecoveryAbstractTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String TEST_LIST = IgniteSystemProperties.getString((String)"PITR_SAVE_TESTS_DB_FILES");
    private static final String PATH = IgniteSystemProperties.getString((String)"PITR_SAVE_DB_FILE_PATH");
    private static final String OUT_SUB_DIR = "out";
    public static final Set<String> PITR_SAVE_TESTS_DB_FILES = new HashSet<String>();
    private volatile String testName;
    private volatile boolean client;
    protected volatile String consistentIdPrefix = "NODE";
    protected final int NODES = 4;

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        char last = name.charAt(name.length() - 1);
        cfg.setConsistentId((Serializable)((Object)(this.consistentIdPrefix + "$" + String.valueOf(last))));
        cfg.setCacheConfiguration(this.prepareCachesConfiguration());
        String storePath = this.storePath();
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(IP_FINDER));
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setWalMode(this.walMode()).setStoragePath(storePath).setWalPath(storePath + "/wal").setWalArchivePath(storePath + "/archive").setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x80000000L)));
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true).setSnapshotsPath(storePath + "/snapshot/" + U.maskForFileName((CharSequence)cfg.getConsistentId().toString())))});
        if (this.client) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected WALMode walMode() {
        return WALMode.DEFAULT;
    }

    protected String storePath() {
        return this.testName.toLowerCase() + "/" + this.getName();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        SB sb = new SB();
        for (String patter : PITR_SAVE_TESTS_DB_FILES) {
            sb.a(patter).a(" ");
        }
        log.warning("Test patterns for save persistence after test finished: " + sb);
        log.warning("Test path for save persistence after test finished: " + PATH != null ? PATH : "{ignite.home}/out/");
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
        this.testName = ((Object)((Object)this)).getClass().getSimpleName();
        File testDir = this.testDir();
        log.warning("Test directory:" + testDir.getPath());
        FileUtils.deleteDirectory((File)testDir);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        String relatedPath = this.storePath();
        String igHome = U.defaultWorkDirectory();
        File sourcePath = this.testDir();
        if (this.matched(this.fullTestName())) {
            File target = new File(igHome + "/" + OUT_SUB_DIR + "/" + relatedPath);
            if (target.exists() && target.delete()) {
                log.warning("fail to delete " + target.getAbsolutePath());
            }
            if (PATH != null) {
                File storePath = new File(PATH + "/" + OUT_SUB_DIR + "/");
                log.warning("PITR_SAVE_DB_FILE_PATH:=" + storePath.getAbsolutePath());
                if (!storePath.exists()) {
                    sourcePath.mkdirs();
                }
                if ((target = new File(storePath, relatedPath)).exists() && target.delete()) {
                    log.warning("fail to delete " + target.getAbsolutePath());
                }
            }
            log.warning("coping files \nsource:" + sourcePath.getAbsolutePath() + "\ntarget:" + target.getAbsolutePath());
            FileUtils.copyDirectory((File)sourcePath, (File)target);
        }
        U.delete((File)sourcePath);
        sourcePath.getParentFile().delete();
        this.deleteWorkFiles();
    }

    protected IgniteEx startClient(int idx) throws Exception {
        this.client = true;
        IgniteEx ig = this.startGrid(idx);
        this.client = false;
        return ig;
    }

    protected void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        this.deleteSnapshotFolder();
    }

    protected void deleteSnapshotFolder() throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    protected boolean matched(String testName) {
        boolean res = PITR_SAVE_TESTS_DB_FILES.contains(testName);
        if (res) {
            return res;
        }
        for (String test : PITR_SAVE_TESTS_DB_FILES) {
            if (test.startsWith("*") && test.endsWith("*")) {
                return testName.contains(test.substring(1, test.length() - 1));
            }
            if (test.startsWith("*")) {
                return testName.contains(test.substring(1));
            }
            if (!test.endsWith("*")) continue;
            return testName.contains(test.substring(0, test.length() - 1));
        }
        return false;
    }

    protected String fullTestName() {
        return this.testName + "." + this.getName();
    }

    protected File testDir() throws IgniteCheckedException {
        return new File(U.defaultWorkDirectory(), this.storePath());
    }

    protected void waitForRebalancing(int id, int major, int minor) throws IgniteCheckedException {
        this.waitForRebalancing(this.grid(id), new AffinityTopologyVersion((long)major, minor));
    }

    protected void waitForRebalancing(int id, int major) throws IgniteCheckedException {
        this.waitForRebalancing(this.grid(id), new AffinityTopologyVersion((long)major));
    }

    protected void waitForRebalancing() throws IgniteCheckedException {
        for (Ignite ignite : G.allGrids()) {
            this.waitForRebalancing((IgniteEx)ignite, null);
        }
    }

    protected void waitForRebalancing(IgniteEx ignite, AffinityTopologyVersion top) throws IgniteCheckedException {
        if (ignite.configuration().isClientMode().booleanValue()) {
            return;
        }
        try {
            this.awaitPartitionMapExchange(false, false, Collections.singleton(ignite.cluster().localNode()));
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException("Waiting of rebalance was interrupted.", (Throwable)e);
        }
    }

    protected File createSharedFolder() throws IgniteCheckedException {
        File sharedFolder = new File(U.defaultWorkDirectory() + "/shared");
        if (sharedFolder.exists()) {
            U.delete((File)sharedFolder);
        }
        if (!sharedFolder.mkdir()) {
            log.warning("Directory wasn't created: " + sharedFolder);
        }
        return sharedFolder;
    }

    protected void sniffProgressMessages(List<SnapshotProgressMessage> messages) {
        for (Ignite ign : G.allGrids()) {
            ((IgniteEx)ign).context().cache().context().gridIO().addMessageListener(GridTopic.TOPIC_SNAPSHOT, (nodeId, msg, plc) -> {
                if (msg instanceof SnapshotProgressMessage) {
                    messages.add((SnapshotProgressMessage)msg);
                }
            });
        }
    }

    protected abstract CacheConfiguration[] prepareCachesConfiguration();

    public TransactionConcurrency randomConcurrency() {
        return this.random(2L) == 0L ? TransactionConcurrency.OPTIMISTIC : TransactionConcurrency.PESSIMISTIC;
    }

    public TransactionIsolation randomIsolation() {
        switch ((int)this.random(3L)) {
            case 0: {
                return TransactionIsolation.READ_COMMITTED;
            }
            case 1: {
                return TransactionIsolation.REPEATABLE_READ;
            }
            case 2: {
                return TransactionIsolation.SERIALIZABLE;
            }
        }
        throw new IllegalStateException("Unexpected type");
    }

    private long random(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    static {
        if (TEST_LIST != null) {
            PITR_SAVE_TESTS_DB_FILES.addAll(Arrays.asList(TEST_LIST.split(",")));
        }
    }

    protected static class RecoveryPoint {
        protected final long time;
        protected final long cursorVal;
        protected final int batchSize;
        protected final Set<Long> skipped;
        protected final String msg;

        private RecoveryPoint(long time, long cursorVal, int batchSize, Set<Long> skipped) {
            this.time = time;
            this.cursorVal = cursorVal;
            this.skipped = new HashSet<Long>(skipped);
            this.msg = "Point in time recovery to " + time;
            this.batchSize = batchSize;
        }

        public String toString() {
            return "RecoveryPoint[time=" + this.time + ", cursorVal=" + this.cursorVal + ", batchSize=" + this.batchSize + ", skipped=" + this.skipped + ", msg='" + this.msg + '\'' + ']';
        }
    }

    protected class TestContext {
        protected final int batchSize = 10;
        protected final AtomicLong cursor = new AtomicLong();
        protected final Set<Long> skipped = new GridConcurrentHashSet();
        protected final Ignite ig;
        protected final String cacheName;
        protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        protected final List<RecoveryPoint> recPoints = new ArrayList<RecoveryPoint>();

        protected TestContext(Ignite ig, String cacheName) {
            this.ig = ig;
            this.cacheName = cacheName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RecoveryPoint savePoint() throws IgniteInterruptedCheckedException {
            this.rwLock.writeLock().lock();
            try {
                long time = U.currentTimeMillis();
                log.info("Save recovery point " + time);
                RecoveryPoint recPnt = new RecoveryPoint(time, this.cursor.get(), 10, this.skipped);
                while (time == U.currentTimeMillis()) {
                    U.sleep((long)50L);
                }
                this.recPoints.add(recPnt);
                RecoveryPoint recoveryPoint = recPnt;
                return recoveryPoint;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        IgniteInternalFuture loadAsync(final long time) {
            return GridTestUtils.runAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    TestContext.this.loadByTime(time);
                }
            });
        }

        void loadByTime(long time) {
            long stopTime = U.currentTimeMillis() + time;
            this.doLoad(true);
            while (U.currentTimeMillis() <= stopTime) {
                this.doLoad(false);
            }
            this.doLoad(true);
        }

        void removeByTime(long time) {
            long stopTime = U.currentTimeMillis() + time;
            while (U.currentTimeMillis() <= stopTime) {
                this.doRemove();
            }
        }

        void multiThreadLoad(final long time, int threads) throws Exception {
            GridTestUtils.runMultiThreaded((Runnable)new Runnable(){

                @Override
                public void run() {
                    TestContext.this.loadByTime(time);
                }
            }, (int)threads, (String)"tx-loader-");
        }

        IgniteInternalFuture multiThreadLoadAsync(final long time, int threads) {
            return GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    TestContext.this.loadByTime(time);
                }
            }, (int)threads, (String)"tx-loader-");
        }

        void checkPoint(RecoveryPoint pnt, List<Ignite> igs) {
            for (Ignite ig : igs) {
                System.out.println("Check on " + ig.name());
                this.checkPoint(pnt, ig);
                System.out.println("Success check " + ig.name());
            }
        }

        void checkPoint(RecoveryPoint pnt, Ignite ... igs) {
            this.checkPoint(pnt, Arrays.asList(igs));
        }

        void checkPoint(RecoveryPoint pnt, Ignite ig) {
            log.info("Check recovery point " + pnt + " ig:" + ig.name());
            IgniteCache cache = ig.cache(this.cacheName);
            Affinity aff = GridCommonAbstractTest.affinity((IgniteCache)cache);
            ArrayList<Long> miss = new ArrayList<Long>();
            for (long i = 0L; i < pnt.cursorVal; ++i) {
                if (pnt.skipped.contains(i)) {
                    for (long inner = i; inner < i + (long)pnt.batchSize; ++inner) {
                        Long r = (Long)cache.get((Object)inner);
                        Assert.assertNull((Object)r);
                    }
                    i += 9L;
                    continue;
                }
                Long res = (Long)cache.get((Object)i);
                if (res != null && res.equals(i)) continue;
                miss.add(i);
            }
            if (!miss.isEmpty()) {
                TreeSet<Integer> parts = new TreeSet<Integer>(Integer::compareTo);
                StringBuilder sb = new StringBuilder();
                sb.append("\nkey | part | primary | backups*\n");
                for (Long key : miss) {
                    int part = aff.partition((Object)key);
                    parts.add(part);
                    Collection nodes = aff.mapPartitionToPrimaryAndBackups(part);
                    sb.append(key).append(" - ").append(part).append(" ");
                    ArrayList<String> nodeIds = new ArrayList<String>(nodes.size());
                    sb.append("[ ");
                    for (ClusterNode node : nodes) {
                        nodeIds.add(node.consistentId().toString());
                    }
                    String last = (String)nodeIds.get(nodeIds.size() - 1);
                    for (String constId : nodeIds) {
                        IgniteEx grid = GridPointInTimeRecoveryAbstractTest.this.grid(Integer.valueOf(constId.substring(constId.length() - 1)));
                        GridDhtPartitionTopology top = grid.context().cache().cache(this.cacheName).context().group().topology();
                        sb.append(constId).append(" - ").append(top.localPartition(part).state()).append("(").append(top.localPartition(part).updateCounter()).append(")");
                        if (constId.equals(last)) continue;
                        sb.append(" ");
                    }
                    sb.append("]\n");
                }
                sb.append("parts - ").append(parts.size()).append(" ").append(parts).append(" request from ").append(ig.name());
                GridPointInTimeRecoveryAbstractTest.fail((String)(sb + " cursor:" + pnt.cursorVal));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doLoad(boolean printToLog) {
            this.rwLock.readLock().lock();
            try {
                long endRangeValue;
                long currOffset;
                while (!this.cursor.compareAndSet(currOffset = this.cursor.get(), endRangeValue = currOffset + 10L)) {
                }
                long startRangeValue = currOffset;
                assert (startRangeValue >= 0L);
                assert (endRangeValue > 0L);
                HashMap<Long, Long> m = new HashMap<Long, Long>();
                for (long i = startRangeValue; i < endRangeValue; ++i) {
                    m.put(i, i);
                }
                String msg = "add [" + startRangeValue + ".." + (startRangeValue + 10L - 1L) + "] " + m.size();
                IgniteCache c = this.ig.cache(this.cacheName);
                boolean txCache = ((CacheConfiguration)c.getConfiguration(CacheConfiguration.class)).getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
                try {
                    if (txCache) {
                        try (Transaction tx = this.ig.transactions().txStart();){
                            c.putAll(m);
                            tx.commit();
                        }
                    } else {
                        c.putAll(m);
                    }
                    this.skipped.remove(startRangeValue);
                    if ((printToLog || startRangeValue % 1000L == 0L) && log != null && log.isInfoEnabled()) {
                        log.info("Tx commited " + msg);
                    }
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)log, (Object)("Fail load " + msg), (Throwable)e);
                    this.skipped.add(startRangeValue);
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRemove() {
            this.rwLock.readLock().lock();
            try {
                long startRangeValue;
                long currOffset;
                do {
                    if ((startRangeValue = (currOffset = this.cursor.get()) - 10L) >= 0L) continue;
                    return;
                } while (!this.cursor.compareAndSet(currOffset, startRangeValue) || this.skipped.contains(startRangeValue));
                long endRangeValue = currOffset;
                assert (startRangeValue >= 0L);
                assert (endRangeValue > 0L);
                HashSet<Long> m = new HashSet<Long>();
                for (long i = startRangeValue; i < endRangeValue; ++i) {
                    m.add(i);
                }
                String msg = "remove [" + endRangeValue + ".." + startRangeValue + "] " + m.size();
                IgniteCache c = this.ig.cache(this.cacheName);
                boolean txCache = ((CacheConfiguration)c.getConfiguration(CacheConfiguration.class)).getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
                try {
                    if (txCache) {
                        try (Transaction tx = this.ig.transactions().txStart();){
                            c.removeAll(m);
                            tx.commit();
                        }
                        catch (Throwable e) {
                            U.error((IgniteLogger)log, (Object)("Fail commited tx " + msg), (Throwable)e);
                        }
                    } else {
                        c.removeAll(m);
                    }
                    if (log != null && log.isInfoEnabled()) {
                        log.info("Tx commited " + msg);
                    }
                    this.skipped.add(startRangeValue);
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)log, (Object)("Fail remove " + msg), (Throwable)e);
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
    }
}

