/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.testframework.GridTestSafeThreadFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Ignore;
import org.junit.Test;

public abstract class GridDestroyCacheDuringSnapshotAbstractTest
extends GridPointInTimeRecoveryAbstractTest {
    private static final String CACHE_1 = "cache1";
    private static final String CACHE_2 = "cache2";
    private static final String DYN_CACHE_1 = "dyn-cache1";
    private static final String DYN_CACHE_2 = "dyn-cache2";
    private static final Set<String> NO_CACHE_NAMES = null;
    private static final List<Callable<?>> NO_ACTIONS = null;
    private static final int ENTRIES_COUNT = 512;
    private boolean disablePitr;
    private Map<String, Integer> expBinaryMetaCntsAfterSnapshot;
    private GridFutureAdapter<SnapshotFuture<Void>> snapshotOperationStartedFut;

    protected long getTestTimeout() {
        return 300000L;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.disablePitr = false;
        this.snapshotOperationStartedFut = new GridFutureAdapter();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        if (this.disablePitr) {
            GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
            ggCfg.getSnapshotConfiguration().setPointInTimeRecoveryEnabled(false);
        }
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg1 = new CacheConfiguration(CACHE_1);
        GridDestroyCacheDuringSnapshotAbstractTest.applyCommonCacheCfg(ccfg1);
        ccfg1.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        CacheConfiguration ccfg2 = new CacheConfiguration(CACHE_2);
        GridDestroyCacheDuringSnapshotAbstractTest.applyCommonCacheCfg(ccfg2);
        ccfg2.setIndexedTypes(new Class[]{Long.class, Long.class});
        return new CacheConfiguration[]{ccfg1, ccfg2};
    }

    public void executeScenario(boolean expectFailure, Collection<String> cacheNames, List<Callable<?>> actionsBeforeSnapshots, List<Callable<?>> actionsDuringSnapshots, List<Callable<?>> actionsAfterSnapshots) throws Exception {
        HashSet<String> cacheNamesSet;
        HashSet<String> hashSet = cacheNamesSet = cacheNames == null ? null : new HashSet<String>(cacheNames);
        if (cacheNamesSet != null) {
            this.disablePitr = true;
        }
        this.doTest(this.initialNodesCount(), actionsBeforeSnapshots, () -> {
            IgniteEx ignite = this.grid(0);
            GridGain gg = (GridGain)ignite.plugin("GridGain");
            SnapshotFuture<Void> snapFut = this.startSnapshotOperation(cacheNamesSet, gg);
            this.snapshotOperationStartedFut.onDone(snapFut);
            long snapshotId = snapFut.snapshotOperation().snapshotId();
            GridDestroyCacheDuringSnapshotAbstractTest.waitForSnapshotFuture(expectFailure, snapFut);
            if (expectFailure) {
                return null;
            }
            GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)5000L);
            ignite = this.restartCluster();
            for (String cacheName : ignite.cacheNames()) {
                ignite.cache(cacheName).destroy();
            }
            ignite = this.restartCluster();
            this.restoreSnapshot(ignite, snapshotId);
            Collection names = ignite.cacheNames();
            GridDestroyCacheDuringSnapshotAbstractTest.assertEquals((String)names.toString(), (int)(cacheNames == null ? 6 : cacheNames.size()), (int)names.size());
            for (int gridIdx = 0; gridIdx < this.initialNodesCount(); ++gridIdx) {
                this.validateCachesContent(this.grid(gridIdx), names);
            }
            return null;
        }, actionsDuringSnapshots, actionsAfterSnapshots);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void waitForSnapshotFuture(boolean expectFailure, SnapshotFuture<Void> snapFut) {
        if (expectFailure) {
            try {
                snapFut.get();
                GridDestroyCacheDuringSnapshotAbstractTest.fail((String)"Expected failure but snapshot has not failed");
                return;
            }
            catch (IgniteException e) {
                String msg = e.getMessage();
                if (msg != null && (msg.contains("Snapshot operation has been cancelled") || msg.contains("Node stopping"))) return;
                throw e;
            }
        } else {
            snapFut.get();
        }
    }

    protected IgniteEx restartCluster() throws Exception {
        this.stopAllGrids();
        IgniteEx ignite = this.startGridsDisabledAutoActivation(this.initialNodesCount());
        ignite.cluster().state(ClusterState.ACTIVE);
        return ignite;
    }

    private IgniteEx startGridsDisabledAutoActivation(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.startGrid(i, cfg -> cfg.setClusterStateOnStart(ClusterState.INACTIVE));
        }
        return this.grid(0);
    }

    protected void restoreSnapshot(IgniteEx ignite, long snapshotId) {
        GridSnapshot snapshot = ((GridGain)ignite.plugin("GridGain")).snapshot();
        RestoreSnapshotParams params = new RestoreSnapshotParams().snapshotId(snapshotId).message("Restoring snapshot for test purposes");
        snapshot.restore(params).get(30L, TimeUnit.SECONDS);
    }

    protected void validateCachesContent(IgniteEx ignite, Collection<String> names) {
        for (String cacheName : names) {
            IgniteCache cache = ignite.cache(cacheName);
            GridDestroyCacheDuringSnapshotAbstractTest.assertEquals((String)(ignite.localNode().consistentId() + ":" + cacheName + ", cacheNames=" + names), (int)512, (int)cache.size(new CachePeekMode[0]));
        }
    }

    protected abstract int initialNodesCount();

    protected abstract SnapshotFuture<Void> startSnapshotOperation(Set<String> var1, GridGain var2);

    private void doTest(int nodes, List<Callable<?>> actionsBeforeSnapshots, Callable<?> snapshotOp, List<Callable<?>> actionsDuringSnapshots, List<Callable<?>> actionsAfterSnapshots) throws Exception {
        IgniteEx ignite = this.startGridsDisabledAutoActivation(nodes);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridDestroyCacheDuringSnapshotAbstractTest.createCaches((Ignite)ignite);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(NO_CACHE_NAMES, "Explicit initial test snapshot.").get();
        GridDestroyCacheDuringSnapshotAbstractTest.putSomeDataInAllCaches((Ignite)ignite, 0, 512);
        ArrayList calls = new ArrayList(actionsDuringSnapshots);
        calls.add(snapshotOp);
        GridTestSafeThreadFactory threadFactory = new GridTestSafeThreadFactory(((Object)((Object)this)).getClass().getName(), false);
        if (actionsBeforeSnapshots != null) {
            GridTestUtils.runMultiThreaded(actionsBeforeSnapshots, (GridTestSafeThreadFactory)threadFactory);
        }
        GridTestUtils.runMultiThreaded(calls, (GridTestSafeThreadFactory)threadFactory);
        if (actionsAfterSnapshots != null) {
            GridTestUtils.runMultiThreaded(actionsAfterSnapshots, (GridTestSafeThreadFactory)threadFactory);
        }
    }

    @Test
    public void testDestroyCacheViaCachApiDuringSnapshot() throws Exception {
        this.executeScenario(true, NO_CACHE_NAMES, NO_ACTIONS, Collections.singletonList(() -> this.destroyCache(DYN_CACHE_1)), NO_ACTIONS);
    }

    @Test
    public void testDestroyCacheViaSQLDuringSnapshot() throws Exception {
        this.executeScenario(true, NO_CACHE_NAMES, NO_ACTIONS, Collections.singletonList(() -> this.dropSqlCache(DYN_CACHE_2, "sqlCache2")), NO_ACTIONS);
    }

    @Test
    public void testDropIndexDuringSnapshot() throws Exception {
        this.executeScenario(false, NO_CACHE_NAMES, NO_ACTIONS, Collections.singletonList(() -> this.dropSqlIndex(DYN_CACHE_1, "v1")), Collections.singletonList(() -> {
            IgniteEx ignite = this.grid(0);
            String plan = ((List)ignite.cache(DYN_CACHE_1).query(new SqlFieldsQuery("explain select * from sqlCache1 where v between 0 and ?").setArgs(new Object[]{512})).getAll().get(0)).get(0).toString();
            GridDestroyCacheDuringSnapshotAbstractTest.assertFalse((String)plan, (boolean)plan.contains("V1"));
            return null;
        }));
    }

    @Test
    public void testCreateSqlIndexDuringSnapshot() throws Exception {
        this.executeScenario(false, NO_CACHE_NAMES, NO_ACTIONS, Arrays.asList(() -> this.createSqlIndex(DYN_CACHE_1, "sqlCache1", "w", "w1"), () -> {
            SnapshotFuture snapshotFuture = (SnapshotFuture)this.snapshotOperationStartedFut.get();
            snapshotFuture.initFuture().get();
            IgniteCache dynCache1 = this.grid(0).cache(DYN_CACHE_1);
            for (int i = 512; i < 532; ++i) {
                dynCache1.query(new SqlFieldsQuery(String.format("INSERT INTO PUBLIC.sqlCache1(id, v, w) VALUES (%d, %<d, %<d)", i))).getAll();
            }
            return null;
        }), Arrays.asList(() -> {
            IgniteEx ignite = this.grid(0);
            boolean idxUsed = GridTestUtils.waitForCondition(() -> {
                String plan = ((List)ignite.cache(DYN_CACHE_1).query(new SqlFieldsQuery("explain select * from sqlCache1 where w between 0 and ?").setArgs(new Object[]{512})).getAll().get(0)).get(0).toString();
                return plan.contains("W1");
            }, (long)5000L);
            GridDestroyCacheDuringSnapshotAbstractTest.assertTrue((String)"index created during snapshot is not exists", (boolean)idxUsed);
            String plan = ((List)ignite.cache(DYN_CACHE_1).query(new SqlFieldsQuery("explain select * from sqlCache1 where w between 0 and ?").setArgs(new Object[]{512})).getAll().get(0)).get(0).toString();
            GridDestroyCacheDuringSnapshotAbstractTest.assertTrue((String)plan, (boolean)plan.contains("W1"));
            return null;
        }, () -> {
            IgniteCache dynCache1 = this.grid(0).cache(DYN_CACHE_1);
            for (int i = 512; i < 522; ++i) {
                dynCache1.query(new SqlFieldsQuery(String.format("INSERT INTO PUBLIC.sqlCache1(id, v, w) VALUES (%d, %<d, %<d)", i))).getAll();
            }
            this.validateIndexes();
            return null;
        }));
    }

    @Test
    public void testNewBinaryMetaDuringSnapshot() throws Exception {
        this.executeScenario(false, NO_CACHE_NAMES, Collections.singletonList(() -> {
            String dirBinaryMeta = String.join((CharSequence)File.separator, U.defaultWorkDirectory(), "db/binary_meta");
            this.expBinaryMetaCntsAfterSnapshot = Stream.of(new File(dirBinaryMeta).listFiles()).collect(Collectors.toMap(File::getName, nodeDir -> nodeDir.list().length + 1));
            return null;
        }), Collections.singletonList(() -> this.insert(DYN_CACHE_1, 1, new Val1())), Collections.singletonList(() -> {
            String dirBinaryMeta = String.join((CharSequence)File.separator, U.defaultWorkDirectory(), "db/binary_meta");
            Map<String, Integer> actualBinaryMetaCntsAfterSnapshot = Stream.of(new File(dirBinaryMeta).listFiles()).collect(Collectors.toMap(File::getName, nodeDir -> nodeDir.list().length));
            GridDestroyCacheDuringSnapshotAbstractTest.assertEquals((String)"binary meta count after snapshot restore not as expected", this.expBinaryMetaCntsAfterSnapshot, actualBinaryMetaCntsAfterSnapshot);
            return null;
        }));
    }

    @Test
    public void testDestroyCacheInParticipatingCacheGroupDuringSnapshot() throws Exception {
        this.executeScenario(true, Arrays.asList(CACHE_1, CACHE_2, QueryUtils.createTableCacheName((String)"PUBLIC", (String)"SQLCACHE1")), Collections.singletonList(() -> {
            this.destroyCache(DYN_CACHE_1);
            this.createCache(DYN_CACHE_1, GridDestroyCacheDuringSnapshotAbstractTest.groupName(CACHE_1));
            try (IgniteDataStreamer ds = this.grid(0).dataStreamer(DYN_CACHE_1);){
                for (int i = 0; i < 512; ++i) {
                    ds.addData((Object)i, (Object)i);
                }
            }
            return null;
        }), Collections.singletonList(() -> this.destroyCache(DYN_CACHE_1)), NO_ACTIONS);
    }

    @Test
    public void testDestroyCacheInUnrelatedCacheGroupDuringSnapshot() throws Exception {
        this.executeScenario(false, Arrays.asList(CACHE_1, CACHE_2, QueryUtils.createTableCacheName((String)"PUBLIC", (String)"SQLCACHE1")), NO_ACTIONS, Arrays.asList(() -> this.destroyCache(DYN_CACHE_1), () -> this.dropSqlCache(DYN_CACHE_2, "sqlCache2")), NO_ACTIONS);
    }

    @Test
    @Ignore(value="GG-26240")
    public void testCreateCacheInParticipatingCacheGroupDuringSnapshot() throws Exception {
        this.executeScenario(false, Arrays.asList(CACHE_1, CACHE_2, QueryUtils.createTableCacheName((String)"PUBLIC", (String)"SQLCACHE1")), NO_ACTIONS, Collections.singletonList(() -> this.createCache("cache3", GridDestroyCacheDuringSnapshotAbstractTest.groupName(CACHE_1))), NO_ACTIONS);
    }

    @Test
    @Ignore(value="GG-26240")
    public void testCreateCacheInUnrelatedCacheGroupDuringSnapshot() throws Exception {
        this.executeScenario(false, Arrays.asList(CACHE_2, QueryUtils.createTableCacheName((String)"PUBLIC", (String)"SQLCACHE1")), NO_ACTIONS, Collections.singletonList(() -> this.createCache("cache3", GridDestroyCacheDuringSnapshotAbstractTest.groupName(CACHE_1))), NO_ACTIONS);
    }

    @Test
    @WithSystemProperty(key="GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", value="true")
    public void testStopNodeAndSetBaselineDuringSnapshot() throws Exception {
        this.executeScenario(false, NO_CACHE_NAMES, Collections.singletonList(() -> this.stopGridCallable(1)), Collections.singletonList(this::setCurrentTopologyBaseline), NO_ACTIONS);
    }

    @Test
    @WithSystemProperty(key="GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", value="true")
    public void testStartNodeAndSetBaselineDuringSnapshot() throws Exception {
        this.executeScenario(false, NO_CACHE_NAMES, Collections.singletonList(() -> this.startGrid(G.allGrids().size())), Collections.singletonList(this::setCurrentTopologyBaseline), NO_ACTIONS);
    }

    @Test
    public void testDeactivateClusterDuringSnapshot() throws Exception {
        this.executeScenario(true, NO_CACHE_NAMES, NO_ACTIONS, Collections.singletonList(this::deactivateCluster), NO_ACTIONS);
    }

    private Object stopGridCallable(int idx) {
        this.stopGrid(idx);
        return null;
    }

    private Object deactivateCluster() {
        this.grid(0).cluster().state(ClusterState.INACTIVE);
        return null;
    }

    private Object setCurrentTopologyBaseline() {
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        IgniteClusterEx cluster = this.grid(0).cluster();
        try {
            cluster.setBaselineTopology(cluster.topologyVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object dropSqlIndex(String dynCacheName, String idxName) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(dynCacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        return cache.query(new SqlFieldsQuery(String.format("DROP INDEX PUBLIC.%s", idxName))).getAll();
    }

    private Object createSqlIndex(String dynCacheName, String tblName, String fieldName, String idxName) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(dynCacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        return cache.query(new SqlFieldsQuery(String.format("CREATE INDEX %s ON PUBLIC.%s (%s ASC)", idxName, tblName, fieldName))).getAll();
    }

    private Object dropSqlCache(String dynCacheName, String tblName) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(dynCacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        return cache.query(new SqlFieldsQuery("DROP TABLE PUBLIC." + tblName)).getAll();
    }

    private Object createCache(String cacheName, String cacheGrpName) {
        IgniteEx ignite = this.grid(0);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.applyCommonCacheCfg(ccfg).setGroupName(cacheGrpName);
        return ignite.createCache(ccfg);
    }

    private Object destroyCache(String cacheName) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(cacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        cache.destroy();
        return null;
    }

    private Object validateIndexes() throws Exception {
        List nodes = IntStream.range(0, this.initialNodesCount() - 1).mapToObj(index -> this.grid(index).localNode().id()).collect(Collectors.toList());
        VisorValidateIndexesTaskArg arg = new VisorValidateIndexesTaskArg(null, null, 1000, 1, true, true);
        VisorTaskArgument visorTaskArg = new VisorTaskArgument(nodes, (Object)arg, true);
        long issues = ((VisorValidateIndexesTaskResult)this.grid(0).context().task().execute((ComputeTask)new VisorValidateIndexesTask(), (Object)visorTaskArg).get()).results().values().stream().peek(System.err::println).filter(VisorValidateIndexesJobResult::hasIssues).count();
        GridDestroyCacheDuringSnapshotAbstractTest.assertEquals((long)issues, (long)0L);
        return null;
    }

    private Object insert(String cacheName, Object key, Object val) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(cacheName);
        GridDestroyCacheDuringSnapshotAbstractTest.doSleep((long)100L);
        cache.put(key, val);
        return null;
    }

    private static CacheConfiguration<?, ?> applyCommonCacheCfg(CacheConfiguration<?, ?> ccfg) {
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(1);
        ccfg.setGroupName(GridDestroyCacheDuringSnapshotAbstractTest.groupName(ccfg.getName()));
        return ccfg;
    }

    private static String groupName(String cacheName) {
        return cacheName + "-group";
    }

    private static void createCaches(Ignite ignite) {
        CacheConfiguration ccfg1 = new CacheConfiguration(DYN_CACHE_1);
        GridDestroyCacheDuringSnapshotAbstractTest.applyCommonCacheCfg(ccfg1);
        IgniteCache dynCache1 = ignite.createCache(ccfg1);
        dynCache1.query(new SqlFieldsQuery("CREATE TABLE PUBLIC.sqlCache1 (id INTEGER PRIMARY KEY, v INTEGER, w INTEGER) WITH \"backups=1\"")).getAll();
        dynCache1.query(new SqlFieldsQuery("CREATE INDEX v1 ON PUBLIC.sqlCache1 (v ASC)")).getAll();
        CacheConfiguration ccfg2 = new CacheConfiguration(DYN_CACHE_2);
        GridDestroyCacheDuringSnapshotAbstractTest.applyCommonCacheCfg(ccfg2);
        IgniteCache dynCache2 = ignite.createCache(ccfg2);
        dynCache2.query(new SqlFieldsQuery("CREATE TABLE PUBLIC.sqlCache2 (id INTEGER PRIMARY KEY, v INTEGER, w INTEGER) WITH \"backups=1\"")).getAll();
        dynCache2.query(new SqlFieldsQuery("CREATE INDEX v2 ON PUBLIC.sqlCache2 (v ASC)")).getAll();
    }

    private static void putSomeDataInAllCaches(Ignite ignite, int from, int to) {
        try (IgniteDataStreamer ds = ignite.dataStreamer(CACHE_1);){
            for (int i = from; i < to; ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        ds = ignite.dataStreamer(CACHE_2);
        var4_4 = null;
        try {
            for (long i = (long)from; i < (long)to; ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable i) {
            var4_4 = i;
            throw i;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable i) {
                        var4_4.addSuppressed(i);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = ignite.dataStreamer(DYN_CACHE_1);
        var4_4 = null;
        try {
            for (int i = from; i < to; ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable i) {
            var4_4 = i;
            throw i;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable i) {
                        var4_4.addSuppressed(i);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = ignite.dataStreamer(DYN_CACHE_2);
        var4_4 = null;
        try {
            for (long i = (long)from; i < (long)to; ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable i) {
            var4_4 = i;
            throw i;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable i) {
                        var4_4.addSuppressed(i);
                    }
                } else {
                    ds.close();
                }
            }
        }
        IgniteCache dynCache1 = ignite.getOrCreateCache(DYN_CACHE_1);
        for (int i = from; i < to; ++i) {
            dynCache1.query(new SqlFieldsQuery(String.format("INSERT INTO PUBLIC.sqlCache1(id, v, w) VALUES (%d, %<d, %<d)", i)));
        }
        IgniteCache dynCache2 = ignite.getOrCreateCache(DYN_CACHE_2);
        for (int i = from; i < to; ++i) {
            dynCache2.query(new SqlFieldsQuery(String.format("INSERT INTO PUBLIC.sqlCache2(id, v, w) VALUES (%d, %<d, %<d)", i)));
        }
    }

    public static class Val1 {
        public int a;
    }
}

