/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteRestoreSnapshotFromAnotherDirTest
extends GridCommonAbstractTest {
    private static final String IDX_NAME_1 = "custom_idx_1";
    private static final String IDX_NAME_2 = "custom_idx_2";
    private static final int PAGE_CACHE_SIZE = 0xC800000;
    private static final int CACHES = 4;
    private static final int GRIDS = 5;
    private static final int CACHE_WITH_FILTER = 3;
    private static final int CACHE_ENTRIES = 2000;
    private final CacheConfiguration[] ccfg = new CacheConfiguration[4];
    private final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private String snapshotDir;
    private boolean startNewCluster;

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(this.ipFinder);
        cfg.setConsistentId((Serializable)((Object)("constId" + name.substring(name.length() - 1))));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        if (this.startNewCluster) {
            ggDbCfg.setSnapshotsPath(this.snapshotDir);
        }
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setCacheConfiguration(this.ccfg);
        return cfg;
    }

    private CacheConfiguration randomCacheConfiguration(String name) {
        Random rnd = new Random();
        CacheAtomicityMode mode = rnd.nextBoolean() ? CacheAtomicityMode.ATOMIC : CacheAtomicityMode.TRANSACTIONAL;
        CacheRebalanceMode rebalanceMod = rnd.nextBoolean() ? CacheRebalanceMode.ASYNC : CacheRebalanceMode.SYNC;
        CacheWriteSynchronizationMode synchronizationMode = CacheWriteSynchronizationMode.fromOrdinal((int)rnd.nextInt(3));
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(name);
        ccfg.setAtomicityMode(mode);
        ccfg.setRebalanceMode(rebalanceMod);
        ccfg.setWriteSynchronizationMode(synchronizationMode);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, rnd.nextInt(1024) + 1));
        ccfg.setBackups(rnd.nextInt(4));
        QueryEntity qryEntity = new QueryEntity(String.class.getName(), TestValue.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("v1", Integer.class.getName());
        fields.put("v2", Integer.class.getName());
        qryEntity.setFields(fields);
        QueryIndex idx1 = new QueryIndex("v1");
        idx1.setIndexType(QueryIndexType.SORTED);
        idx1.setName(IDX_NAME_1);
        QueryIndex idx2 = new QueryIndex("v2");
        idx2.setIndexType(QueryIndexType.SORTED);
        idx2.setName(IDX_NAME_2);
        qryEntity.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{idx1, idx2}));
        ccfg.setQueryEntities(Collections.singleton(qryEntity));
        return ccfg;
    }

    private void prepareCacheConfig() {
        Random rnd = new Random();
        int cacheWithFilter = 3;
        for (int i = 0; i < 4; ++i) {
            CacheConfiguration cfg = this.randomCacheConfiguration("cache" + i);
            if (cacheWithFilter > 0) {
                cfg.setNodeFilter((IgnitePredicate)new TestNodeFilter(rnd.nextInt(3) + 1, rnd.nextBoolean()));
                --cacheWithFilter;
            }
            this.info("Cache configuration: " + cfg.getName() + "\n" + cfg);
            this.ccfg[i] = cfg;
        }
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.startNewCluster = false;
        this.snapshotDir = null;
        this.deleteWorkFiles();
    }

    protected long getTestTimeout() {
        return 900000L;
    }

    @Test
    public void test() throws Exception {
        this.prepareCacheConfig();
        this.startGrids(5).active(true);
        IgniteEx ig = this.grid(0);
        ArrayList<IgniteInternalFuture> futs = new ArrayList<IgniteInternalFuture>();
        ArrayList caches = new ArrayList(ig.cacheNames());
        IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((!caches.isEmpty() ? 1 : 0) != 0);
        for (String name : caches) {
            futs.add(GridTestUtils.runAsync((Runnable)new Runnable((Ignite)ig, name){
                final /* synthetic */ Ignite val$ig;
                final /* synthetic */ String val$name;
                {
                    this.val$ig = ignite;
                    this.val$name = string;
                }

                @Override
                public void run() {
                    IgniteCache cache = this.val$ig.cache(this.val$name);
                    IgniteRestoreSnapshotFromAnotherDirTest.this.info("Start load data in:" + this.val$name);
                    for (int i = 0; i < 2000; ++i) {
                        cache.put((Object)String.valueOf(i), (Object)new TestValue(i + 1, -i - 1));
                        if (i % 100 != 0 || i <= 0) continue;
                        IgniteRestoreSnapshotFromAnotherDirTest.this.info("Loaded entries in " + this.val$name + ":" + i);
                    }
                }
            }));
        }
        for (IgniteInternalFuture f : futs) {
            f.get();
        }
        this.info("Load data completed");
        this.printCacheOwners((Ignite)ig);
        GridGain ggPlugin = (GridGain)ig.plugin("GridGain");
        SnapshotFuture snapShotFut = ggPlugin.snapshot().createFullSnapshot(null, null);
        snapShotFut.get();
        long snapShotId = snapShotFut.snapshotOperation().snapshotId();
        this.info("Created full snapshot with id:" + snapShotId);
        this.stopAllGrids();
        this.info("All grid stopped");
        this.cleanPersistenceDir();
        this.info("Db folder cleaned");
        File file = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        if (!file.delete()) {
            IgniteRestoreSnapshotFromAnotherDirTest.fail((String)"Can not remove db folder");
        }
        this.snapshotDir = U.defaultWorkDirectory() + "/snapshot2";
        this.startNewCluster = true;
        this.startGrids(5).active(true);
        Files.move(Paths.get(U.defaultWorkDirectory() + "/snapshot", new String[0]), Paths.get(this.snapshotDir, new String[0]), new CopyOption[0]);
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        this.info("New cluster is ready for restore");
        IgniteEx newIg = this.grid(0);
        GridGain newGgPlugin = (GridGain)newIg.plugin("GridGain");
        SnapshotFuture checkFut = newGgPlugin.snapshot().checkSnapshot(snapShotId, null, false, null);
        IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((boolean)((List)checkFut.get()).isEmpty());
        SnapshotFuture restoreFut = newGgPlugin.snapshot().restoreSnapshot(snapShotId, null, null);
        restoreFut.get();
        HashMap missVal = new HashMap();
        AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < 5; ++i) {
            IgniteEx g = this.grid(i);
            this.info("Start check keys/value for:" + g.name());
            IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((!caches.isEmpty() ? 1 : 0) != 0);
            for (String name : caches) {
                IgniteCache cache = g.cache(name);
                for (int j = 0; j < 2000; ++j) {
                    TestValue exp = new TestValue(j + 1, -j - 1);
                    TestValue val = (TestValue)cache.get((Object)String.valueOf(j));
                    if (!exp.equals(val)) {
                        ArrayList<T2> cacheValues;
                        HashMap<String, ArrayList<T2>> gridMap = (HashMap<String, ArrayList<T2>>)missVal.get(g.name());
                        if (gridMap == null) {
                            gridMap = new HashMap<String, ArrayList<T2>>();
                            missVal.put(g.name(), gridMap);
                        }
                        if ((cacheValues = (ArrayList<T2>)gridMap.get(cache.getName())) == null) {
                            cacheValues = new ArrayList<T2>();
                            gridMap.put(name, cacheValues);
                        }
                        cacheValues.add(new T2((Object)exp, (Object)val));
                        continue;
                    }
                    cnt.incrementAndGet();
                }
            }
            this.info("Finished check keys/value for:" + g.name() + " in " + Arrays.toString(caches.toArray()) + " key/value found " + cnt.get() + "/" + caches.size() * 2000);
            cnt.set(0);
        }
        if (!missVal.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Miss value \n");
            for (Map.Entry e0 : missVal.entrySet()) {
                sb.append("grid:").append((String)e0.getKey()).append("\n");
                for (Map.Entry e1 : ((Map)e0.getValue()).entrySet()) {
                    sb.append(" cache:").append((String)e1.getKey()).append(" missVal:").append(((List)e1.getValue()).size()).append("\n");
                }
            }
            System.out.println(sb);
            IgniteRestoreSnapshotFromAnotherDirTest.fail();
        }
    }

    public void ignoreManual() throws Exception {
        this.prepareCacheConfig();
        this.startGrids(5).active(true);
        IgniteEx ig = this.grid(0);
        ArrayList<IgniteInternalFuture> futs = new ArrayList<IgniteInternalFuture>();
        ArrayList caches = new ArrayList(ig.cacheNames());
        IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((!caches.isEmpty() ? 1 : 0) != 0);
        for (String name : caches) {
            futs.add(GridTestUtils.runAsync((Runnable)new Runnable((Ignite)ig, name){
                final /* synthetic */ Ignite val$ig;
                final /* synthetic */ String val$name;
                {
                    this.val$ig = ignite;
                    this.val$name = string;
                }

                @Override
                public void run() {
                    IgniteCache cache = this.val$ig.cache(this.val$name);
                    IgniteRestoreSnapshotFromAnotherDirTest.this.info("Start load data in:" + this.val$name);
                    for (int i = 0; i < 2000; ++i) {
                        cache.put((Object)String.valueOf(i), (Object)new TestValue(i + 1, -i - 1));
                        if (i % 100 != 0 || i <= 0) continue;
                        IgniteRestoreSnapshotFromAnotherDirTest.this.info("Loaded entries in " + this.val$name + ":" + i);
                    }
                }
            }));
        }
        for (IgniteInternalFuture f : futs) {
            f.get();
        }
        this.info("Load data completed");
        this.printCacheOwners((Ignite)ig);
        GridGain ggPlugin = (GridGain)ig.plugin("GridGain");
        SnapshotFuture snapShotFut = ggPlugin.snapshot().createFullSnapshot(null, null);
        snapShotFut.get();
        long snapShotId = snapShotFut.snapshotOperation().snapshotId();
        this.info("Created full snapshot with id:" + snapShotId);
        this.stopAllGrids();
        this.info("All grid stopped");
        System.out.println("You must remove db folder manual, you have 20 sec for this.");
        U.sleep((long)20000L);
        this.snapshotDir = U.defaultWorkDirectory() + "/snapshot2";
        this.startNewCluster = true;
        this.startGrids(5).active(true);
        System.out.println("You must move snapshot to snapshot2 folder manual, you have 20 sec for this.");
        U.sleep((long)20000L);
        this.info("New cluster is ready for restore");
        IgniteEx newIg = this.grid(0);
        GridGain newGgPlugin = (GridGain)newIg.plugin("GridGain");
        SnapshotFuture checkFut = newGgPlugin.snapshot().checkSnapshot(snapShotId, null, false, null);
        IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((boolean)((List)checkFut.get()).isEmpty());
        SnapshotFuture restoreFut = newGgPlugin.snapshot().restoreSnapshot(snapShotId, null, null);
        restoreFut.get();
        HashMap missVal = new HashMap();
        AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < 5; ++i) {
            IgniteEx g = this.grid(i);
            this.info("Start check keys/value for:" + g.name());
            IgniteRestoreSnapshotFromAnotherDirTest.assertTrue((!caches.isEmpty() ? 1 : 0) != 0);
            for (String name : caches) {
                IgniteCache cache = g.cache(name);
                for (int j = 0; j < 2000; ++j) {
                    TestValue exp = new TestValue(j + 1, -j - 1);
                    TestValue val = (TestValue)cache.get((Object)String.valueOf(j));
                    if (!exp.equals(val)) {
                        ArrayList<T2> cacheValues;
                        HashMap<String, ArrayList<T2>> gridMap = (HashMap<String, ArrayList<T2>>)missVal.get(g.name());
                        if (gridMap == null) {
                            gridMap = new HashMap<String, ArrayList<T2>>();
                            missVal.put(g.name(), gridMap);
                        }
                        if ((cacheValues = (ArrayList<T2>)gridMap.get(cache.getName())) == null) {
                            cacheValues = new ArrayList<T2>();
                            gridMap.put(name, cacheValues);
                        }
                        cacheValues.add(new T2((Object)exp, (Object)val));
                        continue;
                    }
                    cnt.incrementAndGet();
                }
            }
            this.info("Finished check keys/value for:" + g.name() + " in " + Arrays.toString(caches.toArray()) + " key/value found " + cnt.get() + "/" + caches.size() * 2000);
            cnt.set(0);
        }
        if (!missVal.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Miss value \n");
            for (Map.Entry e0 : missVal.entrySet()) {
                sb.append("grid:").append((String)e0.getKey()).append("\n");
                for (Map.Entry e1 : ((Map)e0.getValue()).entrySet()) {
                    sb.append(" cache:").append((String)e1.getKey()).append(" missVal:").append(((List)e1.getValue()).size()).append("\n");
                }
            }
            System.out.println(sb);
            IgniteRestoreSnapshotFromAnotherDirTest.fail();
        }
    }

    private void printCacheOwners(Ignite ig) {
        for (String name : ig.cacheNames()) {
            CacheConfiguration cfg = (CacheConfiguration)ig.cache(name).getConfiguration(CacheConfiguration.class);
            ArrayList<ClusterNode> owners = new ArrayList<ClusterNode>();
            for (ClusterNode node : ig.cluster().nodes()) {
                if (!cfg.getNodeFilter().apply((Object)node)) continue;
                owners.add(node);
            }
            System.out.println("Cache " + cfg.getName() + " owners:" + F.nodeIds(owners));
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot2", (boolean)false));
    }

    private static class TestValue
    implements Serializable {
        private final int v1;
        private final int v2;

        private TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue val = (TestValue)o;
            return this.v1 == val.v1 && this.v2 == val.v2;
        }

        public int hashCode() {
            int res = this.v1;
            res = 31 * res + this.v2;
            return res;
        }

        public String toString() {
            return S.toString(TestValue.class, (Object)this);
        }
    }

    private static class TestNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private final int gridBound;
        private final boolean mark;

        private TestNodeFilter(int bound, boolean mark) {
            this.gridBound = bound;
            this.mark = mark;
        }

        public boolean apply(ClusterNode node) {
            String consId = (String)node.consistentId();
            int idx = Integer.valueOf(consId.substring(consId.length() - 1));
            return this.mark ? idx > this.gridBound : idx < this.gridBound;
        }
    }
}

