/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotWriteThrottlingTest
extends AbstractSnapshotTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    private void loadCache(Ignite ig, String cacheName, int arraySize, int entriesCnt) {
        try (IgniteDataStreamer ldr = ig.dataStreamer(cacheName);){
            ldr.allowOverwrite(true);
            HashMap map = U.newHashMap((int)entriesCnt);
            for (int i = 0; i < entriesCnt; ++i) {
                map.put(i, new byte[arraySize]);
            }
            ldr.addData((Map)map);
        }
    }

    @Test
    public void testSnapshotWriteThrottlingTimingTest() throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        this.loadCache((Ignite)ig, this.getOrCreateDefaultCacheName((Ignite)ig), 1024, 1000);
        long throttlingOff = this.createSnapshotWithTimeMeasuring(gg, 0);
        long throttlingOn = this.createSnapshotWithTimeMeasuring(gg, 409600);
        IgniteDbSnapshotWriteThrottlingTest.assertTrue((String)("Unexpected timings: op with throttling off took " + throttlingOff + " millis, op with throttling on took " + throttlingOn + " millis."), (throttlingOn > throttlingOff ? 1 : 0) != 0);
        throttlingOff = this.createSnapshotWithTimeMeasuring(gg, 0);
        IgniteDbSnapshotWriteThrottlingTest.assertTrue((String)("Unexpected timings: op with throttling off took " + throttlingOff + " millis, op with throttling on took " + throttlingOn + " millis."), (throttlingOn > throttlingOff ? 1 : 0) != 0);
    }

    private long createSnapshotWithTimeMeasuring(GridGain gg, int snapshotThrottling) {
        long startTime = System.currentTimeMillis();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, snapshotThrottling), null);
        fut.get();
        return System.currentTimeMillis() - startTime;
    }
}

