/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteDbSnapshotSameTopologyTestCustomAffinityFunction
extends IgniteDbSnapshotSameTopologyTest {
    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        Map attrs = cfg.getUserAttributes();
        if (!(cfg.isClientMode() != null && cfg.isClientMode().booleanValue() || cfg.isDaemon())) {
            attrs.put("ZONE", "ZONE_01");
        }
        return cfg;
    }

    @Override
    @NotNull
    protected CacheConfiguration<?, ?> getCacheConfig(String cacheName) {
        CacheConfiguration<?, ?> ccfg = super.getCacheConfig(cacheName);
        if ("cache4".equals(cacheName)) {
            ccfg.setAffinity((AffinityFunction)new CustomAffinityFunction());
        }
        return ccfg;
    }

    public static class CustomAffinityFunction
    extends RendezvousAffinityFunction {
        public List<ClusterNode> assignPartition(int part, List<ClusterNode> nodes, int backups, @Nullable Map<UUID, Collection<ClusterNode>> neighborhoodCache) {
            if (nodes.stream().filter(node -> !node.isClient() && !node.isDaemon()).anyMatch(node -> !node.attributes().containsKey("ZONE"))) {
                throw new RuntimeException("Attribute not present");
            }
            return super.assignPartition(part, nodes, backups, neighborhoodCache);
        }
    }
}

