/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.visor.database.snapshot.VisorRestoreSnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotRestoreWithDifferentXmlConfigTest
extends GridCommonAbstractTest {
    public static final String SNAPSHOT_PATH = "snapshot";
    private static final int NODES_COUNT = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        GridGainConfiguration ggCfg = new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath("snapshot/" + igniteInstanceName + "/"));
        return super.getConfiguration(igniteInstanceName).setPluginConfigurations(new PluginConfiguration[]{ggCfg}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceAndSnapshotDirs();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceAndSnapshotDirs();
        super.afterTest();
    }

    @Test
    public void testRestoring() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        log.info("Creating cache...");
        IgniteCache cache = ignite.getOrCreateCache("default");
        log.info("Uploading data...");
        int keyCount = 1000;
        for (int i = 0; i < keyCount; ++i) {
            cache.put((Object)i, (Object)i);
        }
        log.info("Creating a full snapshot...");
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get(TimeUnit.SECONDS.toMillis(30L));
        log.info("Restoring the snapshot...");
        VisorSnapshotInfo.Builder argBuilder = new VisorSnapshotInfo.Builder().withSnapshotId(snapshotId).withMessage("Restore").withCacheConfigurations(IgniteDbSnapshotRestoreWithDifferentXmlConfigTest.getCacheConfigurationXml());
        ignite.compute().execute(VisorRestoreSnapshotTask.class.getName(), (Object)new VisorTaskArgument(ignite.cluster().node().id(), (Object)argBuilder.build(), false));
        cache = ignite.cache("default");
        for (int i = 0; i < keyCount; ++i) {
            IgniteDbSnapshotRestoreWithDifferentXmlConfigTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    private void cleanPersistenceAndSnapshotDirs() throws Exception {
        this.cleanPersistenceDir();
        IgniteDbSnapshotRestoreWithDifferentXmlConfigTest.cleanSnapshotNodeDir();
    }

    private static void cleanSnapshotNodeDir() throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_PATH, (boolean)false));
    }

    private static String getCacheConfigurationXml() {
        return "<beans\n        xmlns=\"http://www.springframework.org/schema/beans\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:schemaLocation=\"\n       http://www.springframework.org/schema/beans\n       http://www.springframework.org/schema/beans/spring-beans.xsd\">\n    <bean id=\"grid.cfg\" class=\"org.apache.ignite.configuration.IgniteConfiguration\">\n        <property name=\"cacheConfiguration\">\n            <bean class=\"org.apache.ignite.configuration.CacheConfiguration\">\n                <property name=\"name\" value=\"default\"/>\n            </bean>\n        </property>\n    </bean>\n</beans>";
    }
}

