/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.LogListener;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.internal.processors.dr.DrCommandHandlerAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DrCommandHandlerWithSnapshotTest
extends DrCommandHandlerAbstractTest {
    private Set<String> snapshotDirs = new HashSet<String>();

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x10000000L).setPersistenceEnabled(true)));
        this.snapshotDirs.add(gridName);
        return cfg;
    }

    @Before
    public void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @After
    public void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        for (String snapshotDir : this.snapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
    }

    private void startTwoDCTopology() throws Exception {
        this.startTopology(this.dataCenter((byte)2, new DrCommandHandlerAbstractTest.NodeCfg[]{DrCommandHandlerWithSnapshotTest.serverNode((String)"top2_node_rcv").withCaches(new CacheConfiguration[]{this.cacheConfig("cache", CacheMode.PARTITIONED, true).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1))}).receiving(this.receiverHubConfig(12311))}));
        this.startTopology(this.dataCenter((byte)1, new DrCommandHandlerAbstractTest.NodeCfg[]{DrCommandHandlerWithSnapshotTest.serverNode((String)"top1_node").withCaches(new CacheConfiguration[]{this.cacheConfig("cache", CacheMode.PARTITIONED, true).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1))}), DrCommandHandlerWithSnapshotTest.clientNode((String)"top1_node_snd").sending(this.useSenderGroups() ? "group-1" : "cache", new DrSenderConnectionConfiguration[]{this.senderHubReplicaConfig((byte)2, new String[]{"127.0.0.1:12311"})})}));
    }

    @Test
    public void testIncrementalTransfer() throws Exception {
        this.startTwoDCTopology();
        GridGain gg = (GridGain)this.grid("top1_node").plugin("GridGain");
        GridDr dr1 = ((GridGain)this.grid("top1_node").plugin("GridGain")).dr();
        dr1.stopReplication("cache");
        IgniteCache cache1 = G.ignite((String)"top1_node").cache("cache");
        IgniteCache cache2 = G.ignite((String)"top2_node_rcv").cache("cache");
        cache1.put((Object)1, (Object)1);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        cache1.put((Object)2, (Object)2);
        long snapId = fut.snapshotOperation().snapshotId();
        dr1.startReplication("cache");
        GridTestUtils.waitForCondition(() -> F.eq((Object)cache2.get((Object)1), (Object)1) && F.eq((Object)cache2.get((Object)1), (Object)1), (long)5000L);
        cache2.clear();
        this.executeCommand(G.ignite((String)"top1_node"), Arrays.asList("--dr", "full-state-transfer", "start", "--caches", "cache", "--snapshot", String.valueOf(snapId), "--data-centers", String.valueOf(2)), 0, true, new LogListener[]{LogListener.matches((String)"Data Center ID: 1").build("data center"), LogListener.matches((Pattern)Pattern.compile("^Full state transfer command completed successfully")).build("completed successfully")});
        GridTestUtils.waitForCondition(() -> F.eq((Object)cache2.get((Object)2), (Object)2), (long)5000L);
        GridTestUtils.waitForCondition(() -> F.eq((Object)cache2.get((Object)1), null), (long)5000L);
    }

    @Test
    public void testSnapshotRestore() throws Exception {
        this.startTwoDCTopology();
        Ignite node1 = G.ignite((String)"top1_node");
        Ignite node2 = G.ignite((String)"top2_node_rcv");
        node1.cache("cache").put((Object)1, (Object)1);
        this.waitForCacheReplicated("cache", new String[]{"top1_node"});
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)1, (Object)node2.cache("cache").get((Object)1));
        SnapshotFuture fut = DrCommandHandlerWithSnapshotTest.snapshot((Ignite)node2).createFullSnapshot(Collections.singleton("cache"), null);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        node1.cache("cache").removeAll();
        this.waitForCacheReplicated("cache", new String[]{"top1_node"});
        DrCommandHandlerWithSnapshotTest.assertEquals((int)0, (int)node1.cache("cache").size(new CachePeekMode[0]));
        DrCommandHandlerWithSnapshotTest.assertEquals((int)0, (int)node2.cache("cache").size(new CachePeekMode[0]));
        DrCommandHandlerWithSnapshotTest.snapshot((Ignite)node1).restore(new RestoreSnapshotParams().snapshotId(snapId).cacheNames(Collections.singleton("cache"))).get();
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)1, (Object)node1.cache("cache").get((Object)1));
        DrCommandHandlerWithSnapshotTest.assertNull((Object)node2.cache("cache").get((Object)1));
        node1.cache("cache").put((Object)2, (Object)2);
        this.waitForCacheReplicated("cache", new String[]{"top1_node"});
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)1, (Object)node1.cache("cache").get((Object)1));
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)2, (Object)node1.cache("cache").get((Object)2));
        DrCommandHandlerWithSnapshotTest.assertNull((Object)node2.cache("cache").get((Object)1));
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)2, (Object)node2.cache("cache").get((Object)2));
        node1.cache("cache").removeAll();
        this.waitForCacheReplicated("cache", new String[]{"top1_node"});
        DrCommandHandlerWithSnapshotTest.assertEquals((int)0, (int)node1.cache("cache").size(new CachePeekMode[0]));
        DrCommandHandlerWithSnapshotTest.assertEquals((int)0, (int)node2.cache("cache").size(new CachePeekMode[0]));
        DrCommandHandlerWithSnapshotTest.snapshot((Ignite)node1).restore(new RestoreSnapshotParams().snapshotId(snapId)).get();
        node1.cache("cache").put((Object)3, (Object)3);
        this.waitForCacheReplicated("cache", new String[]{"top1_node"});
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)1, (Object)node1.cache("cache").get((Object)1));
        DrCommandHandlerWithSnapshotTest.assertNull((Object)node1.cache("cache").get((Object)2));
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)3, (Object)node1.cache("cache").get((Object)3));
        DrCommandHandlerWithSnapshotTest.assertNull((Object)node2.cache("cache").get((Object)1));
        DrCommandHandlerWithSnapshotTest.assertNull((Object)node2.cache("cache").get((Object)2));
        DrCommandHandlerWithSnapshotTest.assertEquals((Object)3, (Object)node2.cache("cache").get((Object)3));
    }

    @Test
    public void testFSTCommands() throws Exception {
        this.startTwoDCTopology();
        this.executeCommand(G.ignite((String)"top1_node"), Arrays.asList("--dr", "full-state-transfer", "list"), 0, false, new LogListener[]{LogListener.matches((String)"Data Center ID: 1").build("data center"), LogListener.matches((Pattern)Pattern.compile("^Full state transfer states:")).build("completed successfully")});
        this.executeCommand(G.ignite((String)"top1_node"), Arrays.asList("--dr", "full-state-transfer", "cancel", IgniteUuid.randomUuid().toString()), 0, false, new LogListener[]{LogListener.matches((String)"Data Center ID: 1").build("data center"), LogListener.matches((Pattern)Pattern.compile("^Full state transfer canceled, task")).build("completed successfully")});
    }

    protected boolean useSenderGroups() {
        return false;
    }
}

