/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotChainedCreation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class AbstractSnapshotTest
extends GridCommonAbstractTest {
    protected static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    protected static final Set<String> snapshotDirs = new HashSet<String>();
    public static final int ENTRIES_COUNT = 300;
    protected static final int SNAPSHOTS = 5;
    public static final String TEST_COMMUNICATION_SPI = "recording-communication-spi";
    public static final String CACHE_NAME = "cache1";
    protected static final String CACHE_2_NAME = "cache2";
    protected static final String CACHE_2_GROUP_NAME = "Group2";
    protected static final String CACHE_3_NAME = "cache3";
    protected static final String CACHE_4_NAME = "cache4";
    public static final String NON_PERSISTENT_CACHE = "noPersistence";
    public static final String CACHE_5_G1 = "cache5_g1";
    public static final String CACHE_6_G1 = "cache6_g1";
    public static final String CACHE_7_G1 = "cache7_g1";
    public static final String GROUP1 = "group_1";
    public static final String GROUP2 = "group_2";
    public static final String CACHE_8_G2 = "cache8_g2";
    public static final String CACHE_9_G2 = "cache9_g2";
    public static final String CACHE_10_G2 = "cache10_g2";
    public static final String CACHE_11 = "cache11";
    public static final String CACHE_12 = "cache12";
    public static final String CACHE_13 = "cache13";
    protected static final String TEST_ATTRIBUTE = "test-attribute";
    protected static final int CACHE_ID = CU.cacheId((String)"cache1");
    protected static final String DUMMY_GRID_NAME = "dummy";
    protected static final String CLIENT_GRID_NAME = "client";
    protected static final String DAEMON_GRID_NAME = "daemon";
    public static final String LOCAL_CACHE = "localCache";
    public static final String SNAPSHOT_PATH = "snapshot";
    public static final String NEW_CACHE_8_G2 = "cache4_g2";
    private static volatile CountDownLatch snapshotRestoreStartLatch;
    protected static int slowTaskQueue;
    protected LinkedBlockingQueue<StartSnapshotOperationDiscoveryMessage> messages = new LinkedBlockingQueue();
    private boolean snapshotListenerSetUp = false;
    private static final AtomicReference<CountDownLatch> snapshotRestorePauseLatch;
    protected static final List<String> staticCacheConfigs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(SnapshotPath file) {
        try (InputStream in = file.inputStream();){
            boolean bl = SnapshotUtils.isZipInputStream((InputStream)in);
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected CountDownLatch nextRestoreShouldAwait(CountDownLatch restorePauseLatch) {
        snapshotRestoreStartLatch = restorePauseLatch;
        CountDownLatch latch = new CountDownLatch(1);
        snapshotRestorePauseLatch.set(latch);
        return latch;
    }

    protected boolean checkTopology() {
        return false;
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.messages.clear();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration dbCfg = this.getDataStorageConfiguration();
        cfg.setCacheConfiguration(this.getCacheConfigs());
        if (Boolean.valueOf(System.getProperty(TEST_COMMUNICATION_SPI)).booleanValue()) {
            cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        }
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = this.getSnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setDataStorageConfiguration(dbCfg);
        if (gridName.startsWith(CLIENT_GRID_NAME)) {
            cfg.setClientMode(true);
        }
        if (DAEMON_GRID_NAME.equals(gridName)) {
            cfg.setDaemon(true);
        }
        if (gridName.contains(DUMMY_GRID_NAME)) {
            cfg.setUserAttributes(F.asMap((Object)TEST_ATTRIBUTE, (Object)false));
        } else {
            cfg.setUserAttributes(F.asMap((Object)TEST_ATTRIBUTE, (Object)true));
        }
        cfg.setConsistentId((Serializable)((Object)gridName));
        FileDatabaseSnapshotSpi spi = new FileDatabaseSnapshotSpi();
        String dir = this.snapshotPathForNode(gridName);
        snapshotDirs.add(dir);
        spi.setSnapshotDirectory(dir);
        if (GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.get() == null) {
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(this.wrapDataBaseSnapshotSpi((DatabaseSnapshotSpi)spi));
        }
        return cfg;
    }

    public DataStorageConfiguration getDataStorageConfiguration() {
        DataRegionConfiguration dataReg = new DataRegionConfiguration();
        dataReg.setMaxSize(0x40000000L);
        dataReg.setName("dfltDataRegion");
        dataReg.setPersistenceEnabled(true);
        DataRegionConfiguration noPersistence = new DataRegionConfiguration();
        noPersistence.setMaxSize(50000000L);
        noPersistence.setName(NON_PERSISTENT_CACHE);
        DataStorageConfiguration dbCfg = new DataStorageConfiguration();
        dbCfg.setWalMode(WALMode.LOG_ONLY);
        dbCfg.setDefaultDataRegionConfiguration(dataReg);
        dbCfg.setDataRegionConfigurations(new DataRegionConfiguration[]{noPersistence});
        return dbCfg;
    }

    protected SnapshotConfiguration getSnapshotConfiguration() {
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggDbCfg.setMessageDigestFactory(this.getMessageDigestFactory());
        ggDbCfg.setRegistryTransformer(this.getRegistryTransformer());
        return ggDbCfg;
    }

    protected String snapshotPathForNode(String gridName) {
        return SNAPSHOT_PATH;
    }

    protected CacheConfiguration[] getCacheConfigs() {
        return (CacheConfiguration[])staticCacheConfigs.stream().map(this::getCacheConfig).toArray(CacheConfiguration[]::new);
    }

    protected CacheConfiguration<?, ?> getCacheConfig(String cacheName) {
        switch (cacheName) {
            case "cache1": {
                CacheConfiguration ccfg1 = new CacheConfiguration();
                ccfg1.setName(cacheName);
                ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
                ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
                ccfg1.setIndexedTypes(new Class[]{Integer.class, Integer.class});
                ccfg1.setNodeFilter((IgnitePredicate)new TestNodeFilter());
                ccfg1.setBackups(this.getBackupCount());
                return ccfg1;
            }
            case "cache2": {
                CacheConfiguration ccfg2 = new CacheConfiguration();
                ccfg2.setName(CACHE_2_NAME);
                ccfg2.setGroupName(CACHE_2_GROUP_NAME);
                ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
                ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
                ccfg2.setNodeFilter((IgnitePredicate)new TestNodeFilter());
                ccfg2.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
                ccfg2.setBackups(this.getBackupCount());
                return ccfg2;
            }
            case "cache3": {
                CacheConfiguration ccfg3 = new CacheConfiguration();
                ccfg3.setName(CACHE_3_NAME);
                ccfg3.setAtomicityMode(CacheAtomicityMode.ATOMIC);
                ccfg3.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                ccfg3.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
                ccfg3.setNodeFilter((IgnitePredicate)new TestNodeFilter());
                ccfg3.setBackups(this.getBackupCount());
                return ccfg3;
            }
            case "cache4": {
                return new CacheConfiguration().setName(CACHE_4_NAME).setCacheMode(CacheMode.REPLICATED);
            }
            case "cache5_g1": 
            case "cache6_g1": 
            case "cache7_g1": {
                return new CacheConfiguration().setName(cacheName).setCacheMode(CacheMode.PARTITIONED).setGroupName(GROUP1).setBackups(this.getBackupCount());
            }
            case "cache8_g2": 
            case "cache9_g2": 
            case "cache10_g2": {
                return new CacheConfiguration().setName(cacheName).setCacheMode(CacheMode.PARTITIONED).setGroupName(GROUP2).setBackups(this.getBackupCount());
            }
            case "cache11": 
            case "cache12": 
            case "cache13": {
                return new CacheConfiguration().setName(cacheName).setCacheMode(CacheMode.PARTITIONED).setBackups(this.getBackupCount());
            }
            case "noPersistence": {
                return new CacheConfiguration().setName(NON_PERSISTENT_CACHE).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setDataRegionName(NON_PERSISTENT_CACHE).setBackups(this.getBackupCount());
            }
            case "localCache": {
                return new CacheConfiguration().setName(LOCAL_CACHE).setCacheMode(CacheMode.LOCAL);
            }
            case "cache4_g2": {
                return new CacheConfiguration(NEW_CACHE_8_G2).setCacheMode(CacheMode.PARTITIONED).setGroupName(GROUP2).setBackups(this.getBackupCount());
            }
        }
        throw new AssertionError((Object)("Unable to provide config for cache [" + cacheName + "]"));
    }

    protected DatabaseSnapshotSpi wrapDataBaseSnapshotSpi(DatabaseSnapshotSpi original) {
        return new RestorePauseSnapshotSpiWrapper(original);
    }

    protected int getBackupCount() {
        return 0;
    }

    protected void removeFileOfOneNode(long id) throws IgniteCheckedException {
        File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_PATH, (boolean)false);
        File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        File[] files = fullSnapDir.listFiles();
        assert (files != null);
        File consistentIdDir = null;
        for (File file : files) {
            if (file.getName().contains(DUMMY_GRID_NAME) || !file.isDirectory()) continue;
            consistentIdDir = file;
            break;
        }
        U.delete(consistentIdDir);
    }

    protected Set<String> snapshotFolders() {
        return Collections.singleton(SNAPSHOT_PATH);
    }

    protected void cleanSnapshotDirs() throws Exception {
        this.cleanSnapshotDirs(true);
    }

    protected void cleanSnapshotDirs(boolean cleanMoveDir) throws Exception {
        this.cleanPersistenceDir();
        this.clearSnapshotNodeDir(this.snapshotFolders());
        if (cleanMoveDir) {
            U.delete((File)this.getMoveDir());
        }
    }

    protected void clearSnapshotNodeDir(Set<String> strings) throws IgniteCheckedException {
        for (String snapDir : strings) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false));
        }
    }

    protected void load(Ignite ig) throws IgniteCheckedException {
        this.load(ig, 0);
    }

    protected void load(Ignite ig, int shift) throws IgniteCheckedException {
        IgniteInternalFuture f1 = AbstractSnapshotTest.loadWithIntsAsync(ig, this.getOrCreateDefaultCacheName(ig), shift, 1);
        IgniteInternalFuture f2 = AbstractSnapshotTest.loadWithTestValuesAsync(ig, CACHE_2_NAME, 300, shift);
        f1.get(this.getTestTimeout());
        f2.get(this.getTestTimeout());
    }

    @NotNull
    protected String getOrCreateDefaultCacheName(Ignite ig) {
        return CACHE_NAME;
    }

    public static IgniteInternalFuture loadWithTestValuesAsync(final Ignite ig, final String cacheName, final int entriesCnt, final int shift) {
        return GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (IgniteDataStreamer ldr = ig.dataStreamer(cacheName);){
                    ldr.allowOverwrite(true);
                    HashMap<Integer, TestValue> map = new HashMap<Integer, TestValue>();
                    for (int i = 0; i < entriesCnt; ++i) {
                        map.put(i, new TestValue(i, i + shift));
                    }
                    ldr.addData(map);
                }
            }
        });
    }

    protected static IgniteInternalFuture loadWithIntsAsync(Ignite ig, String cacheName, int shift, int multiply) {
        return AbstractSnapshotTest.loadWithIntsAsync(ig, cacheName, shift, multiply, 300);
    }

    protected static IgniteInternalFuture loadWithIntsAsync(final Ignite ig, final String cacheName, final int shift, final int multiply, final int entriesCnt) {
        return GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (IgniteDataStreamer ldr = ig.dataStreamer(cacheName);){
                    ldr.allowOverwrite(true);
                    HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                    for (int i = 0; i < entriesCnt; ++i) {
                        map.put(i, i * multiply + shift);
                    }
                    ldr.addData(map);
                }
            }
        });
    }

    protected File createOrCleanMoveDir() throws IgniteCheckedException {
        File moveDir = this.getMoveDir();
        moveDir.mkdirs();
        return moveDir;
    }

    protected File getMoveDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)true);
    }

    protected long getSnapshotSizeInByteOnCluster(long snapshotId) throws IgniteCheckedException {
        long totalSize = 0L;
        for (String s : this.snapshotFolders()) {
            File snapshotRootDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)s, (boolean)false);
            for (File snapshotDir : snapshotRootDir.listFiles()) {
                if (!snapshotDir.isDirectory() || !snapshotDir.getName().contains(Long.toString(snapshotId))) continue;
                for (File consistentIdDir : snapshotDir.listFiles()) {
                    for (File groupDir : consistentIdDir.listFiles()) {
                        if (!groupDir.isDirectory()) continue;
                        for (File file3 : groupDir.listFiles()) {
                            if (!file3.isFile() || !file3.getName().startsWith("part") || !file3.getName().endsWith("bin")) continue;
                            totalSize += file3.length();
                        }
                    }
                }
            }
        }
        return totalSize;
    }

    protected static File snapshotFolder(long snapId, IgniteEx ign) {
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ign.context().cache().context().snapshot();
        DatabaseSnapshotSpi spi = snapMgr.snapshotSpi();
        FsSnapshotPath dir = spi.findLocalCurNodeSnapshotDir(snapId);
        return dir.getFile();
    }

    static long sizeOfSnapshotOnDisc(long snapId, IgniteEx ign) {
        File nodeSpecificSnapDir = AbstractSnapshotTest.snapshotFolder(snapId, ign);
        return nodeSpecificSnapDir.exists() ? AbstractSnapshotTest.folderSize(nodeSpecificSnapDir) : 0L;
    }

    static long snapshotPartitionsCount(long snapId, IgniteEx ign) {
        File nodeSpecificSnapDir = AbstractSnapshotTest.snapshotFolder(snapId, ign);
        return nodeSpecificSnapDir.exists() ? AbstractSnapshotTest.partitionsCount(nodeSpecificSnapDir) : 0L;
    }

    private static long folderSize(File directory) {
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += AbstractSnapshotTest.folderSize(file);
        }
        return length;
    }

    private static long partitionsCount(File directory) {
        long cnt = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getName();
                if (fileName.contains("snapshot-meta.bin") || fileName.contains("snapshot-registry.bin") || !fileName.endsWith(".bin") && !fileName.endsWith(".zip") && !fileName.endsWith(".zst") && !fileName.endsWith(".lz4") && !fileName.endsWith(".snappy")) continue;
                ++cnt;
                continue;
            }
            cnt += AbstractSnapshotTest.partitionsCount(file);
        }
        return cnt;
    }

    protected void setupSnapshotListener(IgniteEx ignite) {
        ignite.context().discovery().setCustomEventListener(StartSnapshotOperationDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<StartSnapshotOperationDiscoveryMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartSnapshotOperationDiscoveryMessage msg) {
                AbstractSnapshotTest.this.messages.add(msg);
            }
        });
        this.snapshotListenerSetUp = true;
    }

    protected GridSnapshotOperationEx waitForSnapshot(GridCacheSnapshotManager snapMgr, boolean fullSnap) throws Exception {
        if (!this.snapshotListenerSetUp) {
            throw new IllegalStateException("Snapshot listener is not set up. Did you forgot to call setupSnapshotListener()?");
        }
        StartSnapshotOperationDiscoveryMessage msg = this.messages.poll(2L, TimeUnit.MINUTES);
        AbstractSnapshotTest.assertNotNull((String)"No snapshot start message was received in time", (Object)msg);
        AbstractSnapshotTest.assertEquals((boolean)fullSnap, (boolean)AbstractSnapshotTest.isFullSnapshot(msg));
        log.info("Waiting for ongoing snapshot to complete");
        IgniteFuture future = snapMgr.getOngoingOperationFuture();
        if (future != null) {
            future.get();
        }
        log.info("Finished waiting for ongoing snapshot to complete");
        return msg.snapshotOperation();
    }

    protected long waitAndCheckSnapshot(GridCacheSnapshotManager snapMgr, boolean fullSnap) throws Exception {
        this.waitForSnapshot(snapMgr, fullSnap);
        SnapshotMetricsMXBean snapMetrics = (SnapshotMetricsMXBean)U.field((Object)snapMgr, (String)"snapshotMetricsMXBean");
        long throttlingTime = snapMetrics.getWriteThrottlingTime(0);
        this.checkDuration(snapMetrics, throttlingTime);
        return throttlingTime;
    }

    private void checkDuration(SnapshotMetricsMXBean snapMetrics, long throttlingTime) {
        long snapDuration = snapMetrics.getLastSnapshotFinishTime() - snapMetrics.getLastSnapshotStartTime();
        Assert.assertThat((Object)(2L * snapDuration), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(throttlingTime)));
    }

    protected static boolean isFullSnapshot(StartSnapshotOperationDiscoveryMessage message) {
        Map extraParams = (Map)message.snapshotOperation().extraParameter();
        if (extraParams.containsKey("FULL_SNAPSHOT")) {
            return extraParams.get("FULL_SNAPSHOT") == Boolean.TRUE;
        }
        if (extraParams.containsKey("CUSTOM_STAGES_CONFIGURATION")) {
            CustomStagesConfiguration cfg = (CustomStagesConfiguration)extraParams.get("CUSTOM_STAGES_CONFIGURATION");
            for (int i = 0; i < cfg.stagesNum(); ++i) {
                Runnable runnable;
                CustomStage stage = cfg.stage(i);
                if (!(stage instanceof ScheduledSnapshotOperationStage) || !((runnable = (Runnable)U.field((Object)stage, (String)"stageRunnable")) instanceof ScheduledSnapshotChainedCreation)) continue;
                return (Boolean)U.field((Object)runnable, (String)"fullSnapshotCreation");
            }
        }
        throw new IgniteException("There is no way to know if the snapshot is full");
    }

    protected CountDownLatch addWaitingStageFinishListener(final SnapshotOperationStage stage, final IgniteEx ig) {
        final CountDownLatch latch = new CountDownLatch(1);
        if (ig != null) {
            ig.context().io().addMessageListener(GridTopic.TOPIC_SNAPSHOT, new GridMessageListener(){

                public void onMessage(UUID nodeId, Object msg, byte plc) {
                    if (msg instanceof ClusterWideSnapshotOperationStageFinishedMessage) {
                        ClusterWideSnapshotOperationStageFinishedMessage stageFinishedMessage = (ClusterWideSnapshotOperationStageFinishedMessage)msg;
                        log.info("!!! Stage: " + stageFinishedMessage.stage() + " from node: " + nodeId);
                        if (stageFinishedMessage.stage() == stage) {
                            latch.countDown();
                            ig.context().io().removeMessageListener(GridTopic.TOPIC_SNAPSHOT, (GridMessageListener)this);
                        }
                    }
                }
            });
        } else {
            GridTestUtils.runAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean opStarted = false;
                    boolean stageStarted = false;
                    boolean stageFinished = false;
                    while (!(opStarted && stageStarted && stageFinished)) {
                        SnapshotStatus snapshotStatus = IgniteDbSnapshotSameTopologyTest.gg.snapshot().ongoingSnapshotOperation();
                        if (snapshotStatus == null) continue;
                        opStarted = true;
                        if (snapshotStatus.getStageNum() == stage.ordinal()) {
                            stageStarted = true;
                        }
                        if (!stageStarted || snapshotStatus.getStageNum() == stage.ordinal()) continue;
                        stageFinished = true;
                    }
                    latch.countDown();
                }
            });
        }
        return latch;
    }

    protected void verifySnapshotContent(File movedDir, long snapId, final GridGain gg, Ignite ignite, final boolean walPresent, CompressionOption compressionOption) {
        final Path snapshotDir = movedDir.toPath().resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapId, null));
        if (compressionOption == null) {
            compressionOption = gg.configuration().getSnapshotConfiguration().getCompressionOption();
        }
        final CompressionOption finalCompressionOption = compressionOption;
        final SnapshotSecurityLevel securityLevel = ((GridCacheSnapshotManager)((IgniteEx)ignite).context().cache().context().snapshot()).resolveSecurityLevel();
        ignite.cluster().currentBaselineTopology().forEach(new Consumer<BaselineNode>(){

            @Override
            public void accept(BaselineNode node) {
                Path nodeDir = snapshotDir.resolve(U.maskForFileName((CharSequence)node.consistentId().toString()));
                if (nodeDir.toFile().isDirectory()) {
                    AbstractSnapshotTest.this.assertMetadataExists(nodeDir.toFile(), finalCompressionOption);
                    if (securityLevel != SnapshotSecurityLevel.DISABLED) {
                        AbstractSnapshotTest.this.assertDigestRegistryExists(nodeDir.toFile(), finalCompressionOption);
                    }
                    if (!node.consistentId().equals(AbstractSnapshotTest.DUMMY_GRID_NAME)) {
                        block3: for (File file : nodeDir.toFile().listFiles()) {
                            AbstractSnapshotTest.this.assertNoTmpFiles(file);
                            if (!file.isDirectory() || file.getName().equals("wal")) continue;
                            AbstractSnapshotTest.this.assertIndexExists(file, finalCompressionOption);
                            if (finalCompressionOption != CompressionOption.NONE) {
                                AbstractSnapshotTest.this.assertNoBinFiles(file);
                            }
                            if (finalCompressionOption != CompressionOption.ZIP) {
                                AbstractSnapshotTest.this.assertNoZipFiles(file);
                            }
                            if (finalCompressionOption != CompressionOption.ZSTD) {
                                AbstractSnapshotTest.this.assertNoZstdFiles(file);
                            }
                            if (finalCompressionOption != CompressionOption.LZ4) {
                                AbstractSnapshotTest.this.assertNoLz4Files(file);
                            }
                            switch (finalCompressionOption) {
                                case NONE: 
                                case ZIP: 
                                case ZSTD: 
                                case LZ4: 
                                case SNAPPY: {
                                    continue block3;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unsupported compression");
                                }
                            }
                        }
                        File walDir = nodeDir.resolve("wal").toFile();
                        if (gg.configuration().getSnapshotConfiguration().isPointInTimeRecoveryEnabled()) {
                            if (!walPresent) {
                                AbstractSnapshotTest.assertFalse((boolean)(walDir.exists() && walDir.isDirectory()));
                            } else {
                                AbstractSnapshotTest.assertTrue((boolean)(walDir.exists() && walDir.isDirectory()));
                            }
                        } else {
                            AbstractSnapshotTest.assertFalse((boolean)(walDir.exists() && walDir.isDirectory()));
                        }
                    }
                    AbstractSnapshotTest.assertFalse((boolean)nodeDir.resolve(".copy").toFile().exists());
                    AbstractSnapshotTest.this.assertNoTmpFiles(nodeDir.toFile());
                }
            }
        });
    }

    private void assertNoFilesWithExtension(File directory, String extension) {
        if (directory.exists() && directory.isDirectory()) {
            String[] list = directory.list((dir, name) -> name.endsWith(extension));
            AbstractSnapshotTest.assertNotNull((Object)list);
            AbstractSnapshotTest.assertEquals((int)0, (int)list.length);
        }
    }

    private void assertNoTmpFiles(File directory) {
        this.assertNoFilesWithExtension(directory, ".tmp");
    }

    private void assertNoZipFiles(File directory) {
        this.assertNoFilesWithExtension(directory, ".zip");
    }

    private void assertNoZstdFiles(File directory) {
        this.assertNoFilesWithExtension(directory, ".zst");
    }

    private void assertNoLz4Files(File directory) {
        this.assertNoFilesWithExtension(directory, ".lz4");
    }

    private void assertNoBinFiles(File directory) {
        this.assertNoFilesWithExtension(directory, ".bin");
    }

    protected void assertIndexExists(File cacheDir, CompressionOption option) {
        File idxFile = Paths.get(cacheDir.getAbsolutePath(), "index.bin").toFile();
        File idxFileZip = Paths.get(cacheDir.getAbsolutePath(), "index.bin.zip").toFile();
        try {
            switch (option) {
                case NONE: {
                    AbstractSnapshotTest.assertTrue((boolean)idxFile.exists());
                    AbstractSnapshotTest.assertFalse((boolean)idxFileZip.exists());
                    break;
                }
                case ZIP: {
                    AbstractSnapshotTest.assertFalse((boolean)idxFile.exists());
                    AbstractSnapshotTest.assertTrue((boolean)idxFileZip.exists());
                }
            }
        }
        catch (AssertionError e) {
            throw new AssertionError("index.bin=" + idxFile.getAbsolutePath() + ", index.bin.zip=" + idxFileZip.getAbsolutePath(), (Throwable)((Object)e));
        }
    }

    protected void assertMetadataExists(File directory, CompressionOption option) {
        File metadataFile = Paths.get(directory.getAbsolutePath(), "snapshot-meta.bin").toFile();
        File metadataFileZip = Paths.get(directory.getAbsolutePath(), "snapshot-meta.bin.zip").toFile();
        switch (option) {
            case NONE: {
                AbstractSnapshotTest.assertTrue((boolean)metadataFile.exists());
                AbstractSnapshotTest.assertFalse((boolean)metadataFileZip.exists());
                break;
            }
            case ZIP: {
                AbstractSnapshotTest.assertFalse((boolean)metadataFile.exists());
                AbstractSnapshotTest.assertTrue((boolean)metadataFileZip.exists());
            }
        }
    }

    protected void assertDigestRegistryExists(File directory, CompressionOption option) {
        File registryFile = Paths.get(directory.getAbsolutePath(), "snapshot-registry.bin").toFile();
        File registryFileZip = Paths.get(directory.getAbsolutePath(), "snapshot-registry.bin.zip").toFile();
        switch (option) {
            case NONE: {
                AbstractSnapshotTest.assertTrue((boolean)registryFile.exists());
                AbstractSnapshotTest.assertFalse((boolean)registryFileZip.exists());
                break;
            }
            case ZIP: {
                AbstractSnapshotTest.assertFalse((boolean)registryFile.exists());
                AbstractSnapshotTest.assertTrue((boolean)registryFileZip.exists());
            }
        }
    }

    @Nullable
    protected File getMetadataFile(IgniteEx ignite, long snapId, Path dir) throws IgniteCheckedException {
        Path currentSnapshotPath;
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        DatabaseSnapshotSpi spi = snapMgr.snapshotSpi();
        Path path = currentSnapshotPath = dir == null ? spi.generateCurNodeSnapshotFolderPath(snapId).getFile().toPath() : dir.resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapId, null));
        if (!Files.exists(currentSnapshotPath, new LinkOption[0])) {
            return null;
        }
        return SnapshotUtils.resolve((Path)currentSnapshotPath, (String)"snapshot-meta.bin").toFile();
    }

    protected void corruptFile(File file) throws Exception {
        if (file == null) {
            return;
        }
        try (RandomAccessFile fh = new RandomAccessFile(file, "rw");){
            for (int i = 0; i < 100; ++i) {
                if (fh.length() <= (long)(i * 3)) continue;
                fh.seek(i * 3);
                int old = fh.read();
                fh.seek(i * 3);
                fh.write(old + 1);
            }
            fh.getChannel().force(true);
        }
    }

    protected File[] getSnapshotNodeDirs(String snapshotDir, long snapshotId) throws IgniteCheckedException {
        assert (snapshotDir != null);
        String dir = snapshotDir.endsWith("/") ? snapshotDir : snapshotDir + "/";
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)(dir + FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null)), (boolean)false).listFiles();
    }

    protected MessageDigestFactory getMessageDigestFactory() {
        return null;
    }

    protected SnapshotRegistryTransformer getRegistryTransformer() {
        return null;
    }

    protected SnapshotScheduleProcessor snapshotSchedule(IgniteEx n) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        return (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
    }

    protected GridSnapshotManager snapshotManager(IgniteEx n) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        return (GridSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
    }

    static {
        slowTaskQueue = -1;
        snapshotRestorePauseLatch = new AtomicReference();
        staticCacheConfigs = Arrays.asList(CACHE_NAME, CACHE_2_NAME, CACHE_3_NAME, CACHE_4_NAME, NON_PERSISTENT_CACHE, CACHE_5_G1, CACHE_6_G1, CACHE_7_G1, CACHE_8_G2, CACHE_9_G2, CACHE_10_G2, CACHE_11, CACHE_12, CACHE_13);
    }

    protected class RestorePauseOnFileWrittingFileSnapshotWrapper
    extends FileSnapshot {
        private FileSnapshot delegate;

        RestorePauseOnFileWrittingFileSnapshotWrapper(FileSnapshot delegate, IgniteConfiguration igCfg) {
            super(igCfg, null, 0L, null, null, null, false, true, null, null, null, null);
            this.delegate = delegate;
        }

        public long id() {
            return this.delegate.id();
        }

        public Set<Integer> cacheGroupIds() {
            return this.delegate.cacheGroupIds();
        }

        public SnapshotPath snapshotDirectory() {
            return this.delegate.snapshotDirectory();
        }

        public SnapshotMetadataV2 metadata(SnapshotPath snapDir) {
            return this.delegate.metadata(snapDir);
        }

        @Nullable
        public SnapshotMetadataV2 metadata() {
            return this.delegate.metadata();
        }

        @Nullable
        public SnapshotMetadataV2 metadata(String consistentId) {
            return this.delegate.metadata(consistentId);
        }

        public SnapshotMetadataV2 verifiedMetadata() throws IgniteCheckedException {
            return this.delegate.verifiedMetadata();
        }

        public SnapshotInputStream indexStream(int cacheGrpId, BitSet parts) {
            return this.delegate.indexStream(cacheGrpId, parts);
        }

        public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, int partId) {
            CountDownLatch latch = null;
            latch = snapshotRestorePauseLatch.getAndSet(null);
            if (latch != null) {
                latch.countDown();
                try {
                    AbstractSnapshotTest.assertTrue((boolean)snapshotRestoreStartLatch.await(AbstractSnapshotTest.this.getTestTimeout(), TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.delegate.cacheInputStreams(cacheGrpId, cacheOrGrpName, partId);
        }

        public boolean isDefaultPath() {
            return this.delegate.isDefaultPath();
        }

        public SnapshotInputStream indexStream(int cacheGrpId, String consistentId) {
            return this.delegate.indexStream(cacheGrpId, consistentId);
        }

        public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, String consistentId, int partId) {
            return this.delegate.cacheInputStreams(cacheGrpId, cacheOrGrpName, consistentId, partId);
        }

        public Iterable<Snapshot> getPreviousSnapshots(@Nullable Set<Integer> groupIds, @Nullable Collection<SnapshotPath> paths) {
            return this.delegate.getPreviousSnapshots(groupIds, paths);
        }

        public boolean isPresent() {
            return this.delegate.isPresent();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    protected class RestorePauseSnapshotSpiWrapper
    implements DatabaseSnapshotSpi {
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;
        private final DatabaseSnapshotSpi delegate;

        RestorePauseSnapshotSpiWrapper(DatabaseSnapshotSpi delegate) {
            this.delegate = delegate;
        }

        public File snapshotWorkingDirectory() {
            return this.delegate.snapshotWorkingDirectory();
        }

        public void start() throws IgniteCheckedException {
            if (this.delegate instanceof FileDatabaseSnapshotSpi) {
                try {
                    Field igniteField = FileDatabaseSnapshotSpi.class.getDeclaredField("ignite");
                    igniteField.setAccessible(true);
                    igniteField.set(this.delegate, this.ignite);
                    Field logField = FileDatabaseSnapshotSpi.class.getDeclaredField("log");
                    logField.setAccessible(true);
                    logField.set(this.delegate, this.log);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            this.delegate.start();
        }

        public void stop() throws IgniteCheckedException {
            this.delegate.stop();
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            return this.delegate.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions);
        }

        public Iterable<SnapshotMetadataV2> localSnapshots(boolean sort) throws IgniteCheckedException {
            return this.delegate.localSnapshots(sort);
        }

        public Iterable<SnapshotMetadataV2> listRemoteSnapshots(SnapshotPath searchPath) throws IgniteCheckedException {
            return this.delegate.listRemoteSnapshots(searchPath);
        }

        public Snapshot snapshot(long id, @Nullable Collection<SnapshotPath> optSearchPath, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, @Nullable SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
            Snapshot snapshot = this.delegate.snapshot(id, optSearchPath, c, ignoreMissedClasses, securityLevel, needDecryptKeys);
            if (snapshot instanceof FileSnapshot) {
                return new RestorePauseOnFileWrittingFileSnapshotWrapper((FileSnapshot)snapshot, this.ignite.configuration());
            }
            return snapshot;
        }

        public void copySinglePartition(long snapshotId, int grpId, int partId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copySinglePartition(snapshotId, grpId, partId, path, context);
        }

        public void deleteSnapshot(long id, SnapshotOperationContext ctx) throws IgniteCheckedException {
            this.delegate.deleteSnapshot(id, ctx);
        }

        public boolean isCopyRequired(long snapshotId, SnapshotPath pathToMove) throws IgniteCheckedException {
            return this.delegate.isCopyRequired(snapshotId, pathToMove);
        }

        public void startCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.startCopy(snapshotId, path);
        }

        public void copySnapshotEntirely(long snapshotId, SnapshotPath path, SnapshotOperationContext ctx, ExecutorService taskExecutor) throws IgniteCheckedException {
            this.delegate.copySnapshotEntirely(snapshotId, path, ctx, taskExecutor);
        }

        public void copyMetadata(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyMetadata(snapshotId, path, context);
        }

        public void copyDigestRegistry(long snapshotId, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyDigestRegistry(snapshotId, path, context);
        }

        public void copyWalSegments(long snapshotId, Collection<File> segments, SnapshotPath path, SnapshotOperationContext context) throws IgniteCheckedException {
            this.delegate.copyWalSegments(snapshotId, segments, path, context);
        }

        public void finishCopy(long snapshotId, SnapshotPath path) throws IgniteCheckedException {
            this.delegate.finishCopy(snapshotId, path);
        }

        public <T extends SnapshotPath> T findSnapshotDir(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public <T extends SnapshotPath> T generateSnapshotFolderPath(T path, long id) {
            return (T)this.delegate.findSnapshotDir(path, id);
        }

        public FsSnapshotPath findLocalCurNodeSnapshotDir(long id) {
            return this.delegate.findLocalCurNodeSnapshotDir(id);
        }

        public void setSnapshotMetrics(SnapshotMetricsMXBean metrics) {
            this.delegate.setSnapshotMetrics(metrics);
        }

        public FsSnapshotPath generateCurNodeSnapshotFolderPath(long id) {
            return this.delegate.generateCurNodeSnapshotFolderPath(id);
        }

        public <T extends SnapshotPath> T generateCurNodeSnapshotFolderPathWithLabel(T snapshotBaseFolder, long id, String label) {
            return (T)this.delegate.generateCurNodeSnapshotFolderPathWithLabel(snapshotBaseFolder, id, label);
        }

        public <T extends SnapshotPath> T findCurNodeSnapshotDir(T path, long id) {
            return (T)this.delegate.findCurNodeSnapshotDir(path, id);
        }

        @Nullable
        public SnapshotMetadataV2 nextLocalSnapshot(long id) {
            return this.delegate.nextLocalSnapshot(id);
        }

        public Map<Long, Long> remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath) {
            return this.delegate.remoteSnapshotWalSizes(searchPath);
        }

        public long remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath, long snapshotId) {
            return this.delegate.remoteSnapshotWalSizes(searchPath, snapshotId);
        }
    }

    protected static class SnapshotMetricsCollector {
        protected final int historySize;
        protected final LinkedList<SnapshotMetrics> snapshotHistory = new LinkedList();
        protected final SnapshotMetricsMXBean snapshotMetricsMXBean;
        private final IgniteEx ignite;

        protected SnapshotMetricsCollector(int size, SnapshotMetricsMXBean bean, IgniteEx ignite) {
            this.historySize = size;
            this.snapshotMetricsMXBean = bean;
            this.ignite = ignite;
        }

        public LinkedList<SnapshotMetrics> historySnapshots() {
            return this.snapshotHistory;
        }

        public void runSnapshotOperation(IgniteCallable<SnapshotFuture> executeSnapshot) throws Exception {
            SnapshotMetrics m = new SnapshotMetrics();
            m.startTime = U.currentTimeMillis();
            SnapshotFuture fut = (SnapshotFuture)executeSnapshot.call();
            m.snapshotId = fut.snapshotOperation().snapshotId();
            m.operationType = fut.snapshotOperation().operationType().name();
            while (!this.snapshotMetricsMXBean.isSnapshotInProgress()) {
                U.sleep((long)0L);
            }
            Assert.assertEquals((long)-1L, (long)this.snapshotMetricsMXBean.snapshotFinishTime(0));
            fut.get();
            m.finishTime = U.currentTimeMillis();
            m.writeThrottlingTime = this.snapshotMetricsMXBean.getWriteThrottlingTime(0);
            if (fut.snapshotOperation().operationType() == SnapshotOperationType.CREATE) {
                m.bytesWritten = AbstractSnapshotTest.sizeOfSnapshotOnDisc(m.snapshotId, this.ignite);
            }
            for (SnapshotMetrics metrics : this.snapshotHistory) {
                if (metrics.snapshotId != m.snapshotId || !metrics.operationType.equals(m.operationType)) continue;
                return;
            }
            this.snapshotHistory.addFirst(m);
        }
    }

    protected static class SnapshotMetrics {
        protected long snapshotId;
        protected long startTime;
        protected long finishTime;
        protected String operationType = "N/A";
        public long bytesWritten = 0L;
        public long writeThrottlingTime = 0L;

        protected SnapshotMetrics() {
        }
    }

    protected static class TestValue
    implements Serializable {
        @QuerySqlField(index=true, descending=true)
        private final int v1;
        @QuerySqlField(index=true)
        private final int v2;
        @QuerySqlField(index=true)
        private final String v3;
        @QuerySqlField(index=true)
        private final String v4;
        @QuerySqlField(index=false)
        private final int v5;
        private final String v6;
        private final String v7;
        private final String v8;
        private final byte[] v9;

        protected TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = Integer.toBinaryString(v1) + Integer.toHexString(v2);
            this.v4 = Integer.toBinaryString(v2) + Integer.toHexString(v1);
            this.v5 = v2;
            this.v6 = this.v3 + this.v4;
            this.v7 = this.v4 + this.v3;
            this.v8 = this.v6 + this.v7;
            this.v9 = new byte[Math.abs(v1 % 50 * (v2 % 10))];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue value = (TestValue)o;
            return this.v1 == value.v1 && this.v2 == value.v2;
        }

        public int hashCode() {
            int result = this.v1;
            result = 31 * result + this.v2;
            return result;
        }

        public String toString() {
            return S.toString(TestValue.class, (Object)this);
        }
    }

    protected static class EmptyNodeFilter
    implements IgnitePredicate<ClusterNode> {
        protected EmptyNodeFilter() {
        }

        public boolean apply(ClusterNode node) {
            return false;
        }
    }

    protected static class TestNodeFilter
    implements IgnitePredicate<ClusterNode> {
        protected TestNodeFilter() {
        }

        public boolean apply(ClusterNode clusterNode) {
            return Boolean.TRUE.equals(clusterNode.attribute(AbstractSnapshotTest.TEST_ATTRIBUTE));
        }
    }
}

