/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.io.IOException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.AbstractSnapshotPathDescriptor;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.SnapshotPathIOFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SnapshotPathDescriptor
implements Comparable<SnapshotPathDescriptor>,
AbstractSnapshotPathDescriptor {
    private static final int WAL_SEGMENT_FILE_NAME_LENGTH = 16;
    private final SnapshotPath file;
    private final long idx;

    public SnapshotPathDescriptor(@NotNull SnapshotPath file) {
        this(file, null);
    }

    public SnapshotPathDescriptor(@NotNull SnapshotPath file, @Nullable Long idx) {
        this.file = file;
        String fileName = file.getName();
        assert (fileName.contains(".wal"));
        this.idx = idx == null ? Long.parseLong(fileName.substring(0, 16)) : idx;
    }

    @Override
    public int compareTo(@NotNull SnapshotPathDescriptor o) {
        return Long.compare(this.idx, o.idx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnapshotPathDescriptor)) {
            return false;
        }
        SnapshotPathDescriptor that = (SnapshotPathDescriptor)o;
        return this.idx == that.idx;
    }

    public int hashCode() {
        return (int)(this.idx ^ this.idx >>> 32);
    }

    public long getIdx() {
        return this.idx;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isCompressed() {
        return this.file.getName().endsWith(".zip");
    }

    @Override
    public SnapshotPath file() {
        return this.file;
    }

    @Override
    public long idx() {
        return this.idx;
    }

    @Override
    public SegmentIO toReadOnlyIO() throws IOException {
        FileIO fileIO = this.isCompressed() ? SnapshotPathIOFactory.unzipFileIO(this.file()) : SnapshotPathIOFactory.readFileIO(this.file());
        return new SegmentIO(this.idx, fileIO);
    }
}

