/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.copy;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.copy.CopyStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;

public class TwoPhaseFilesCopyStrategy
implements CopyStrategy {
    private final boolean onlyIfNotExists;
    private final IgniteLogger igniteLogger;

    public TwoPhaseFilesCopyStrategy(boolean onlyIfNotExists, IgniteLogger igniteLogger) {
        this.onlyIfNotExists = onlyIfNotExists;
        this.igniteLogger = igniteLogger;
    }

    public void copy(Path srcFile, SnapshotPath targetDirectory) throws IOException {
        if (this.onlyIfNotExists) {
            this.twoPhaseCopyIfNotExists(srcFile, targetDirectory);
        } else {
            this.twoPhaseCopy(srcFile, targetDirectory);
        }
    }

    private void twoPhaseCopyIfNotExists(Path srcFile, SnapshotPath targetDirectory) throws IOException {
        SnapshotPath target = targetDirectory.resolve(srcFile.getFileName().toString());
        if (target.exists() && target.isFile()) {
            if (this.igniteLogger.isDebugEnabled()) {
                this.igniteLogger.debug("Skip copy [{}]", srcFile.toString());
            }
            return;
        }
        this.twoPhaseCopy(srcFile, targetDirectory);
        if (this.igniteLogger.isDebugEnabled()) {
            this.igniteLogger.debug("Copied [{}]", srcFile.toString());
        }
    }

    private void twoPhaseCopy(Path srcFile, SnapshotPath targetDirectory) throws IOException {
        SnapshotPath tmpPath = targetDirectory.resolve(srcFile.getFileName().toString());
        tmpPath.copyFrom(srcFile);
    }
}

