/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStreamListener;
import org.gridgain.grid.internal.util.GridUtils;

public class FileSnapshotOutputStream
implements SnapshotOutputStream {
    private final FileChannel fileChannel;
    private final SnapshotOutputStreamListener listener;
    private final AtomicLong pos = new AtomicLong(0L);

    FileSnapshotOutputStream(FileChannel fileChannel, SnapshotOutputStreamListener listener) {
        this.fileChannel = fileChannel;
        this.listener = listener;
    }

    public void plainWrite(ByteBuffer data) throws IgniteCheckedException {
        try {
            long off = this.pos.getAndAdd(data.remaining());
            while (data.hasRemaining()) {
                int written = this.fileChannel.write(data, off);
                off += (long)written;
            }
        }
        catch (IOException e) {
            if (GridUtils.isDiskFullException((IOException)e)) {
                throw new IgniteCheckedException("Storage device is full, error writing snapshot file", (Throwable)e);
            }
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public void close() throws IgniteCheckedException {
        boolean isOpen = false;
        try {
            isOpen = this.fileChannel.isOpen();
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            if (isOpen) {
                this.listener.onClose();
            }
        }
    }

    public long position() {
        return this.pos.get();
    }
}

