/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.UserCommandExceptions;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorServerNodeTask;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorRestoreSnapshotTask
extends VisorServerNodeTask<VisorSnapshotInfo, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorRestoreSnapshotJob job(VisorSnapshotInfo arg) {
        return new VisorRestoreSnapshotJob(arg, this.debug);
    }

    protected boolean nodeFilter(ClusterNode node, VisorSnapshotInfo argument) {
        if (!F.isEmpty(argument.getExcludedCacheNames())) {
            return IgniteFeatures.allNodesSupport((GridKernalContext)this.ignite.context(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER);
        }
        return true;
    }

    private static class CacheConfigurations
    implements IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> {
        private static final long serialVersionUID = 0L;
        private final Map<String, CacheConfiguration> cfgMap;
        @IgniteInstanceResource
        private Ignite ignite;

        CacheConfigurations(Map<String, CacheConfiguration> cfgMap) {
            this.cfgMap = cfgMap;
        }

        public CacheConfiguration apply(String cacheName, CacheConfiguration oldConf) {
            CacheConfiguration newConf = this.cfgMap.get(cacheName);
            try {
                if (newConf != null) {
                    CU.initializeConfigDefaults((IgniteLogger)new NullLogger(), (CacheConfiguration)newConf, (CacheObjectContext)((IgniteEx)this.ignite).context().cacheObjects().contextForCache(newConf));
                    newConf.setAffinityMapper(null);
                }
                return newConf != null ? newConf : oldConf;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    private static class VisorRestoreSnapshotJob
    extends VisorJob<VisorSnapshotInfo, Void> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture<?> fut;

        VisorRestoreSnapshotJob(VisorSnapshotInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected Void run(@Nullable VisorSnapshotInfo arg) throws IgniteException {
            if (this.fut == null) {
                GridSnapshotEx snapshot = VisorSnapshots.snapshot((Ignite)this.ignite);
                if (arg.getSnapshotId() >= 0L) {
                    String ccfgs = arg.getCacheConfigs();
                    if (F.isEmpty((String)ccfgs)) {
                        this.fut = snapshot.restore(new RestoreSnapshotParams().snapshotId(arg.getSnapshotId()).optionalSearchPaths(arg.paths()).cacheNames(arg.getCacheNames()).excludedCacheNames(arg.getExcludedCacheNames()).forceRestore(arg.isForce()).message(arg.getMessage()).parallelism(Integer.valueOf(arg.getSnapshotCommonParameters().getSnapshotOperationParallelism())));
                    } else {
                        try {
                            IgniteBiTuple loaded = IgnitionEx.loadConfigurations((InputStream)new ByteArrayInputStream(ccfgs.getBytes()));
                            HashMap<String, CacheConfiguration> cfgMap = new HashMap<String, CacheConfiguration>();
                            for (CacheConfiguration c : ((IgniteConfiguration)F.first((Iterable)((Iterable)loaded.get1()))).getCacheConfiguration()) {
                                cfgMap.put(c.getName(), c);
                            }
                            this.fut = snapshot.restore(new RestoreSnapshotParams().snapshotId(arg.getSnapshotId()).optionalSearchPaths(arg.paths()).cacheNames(arg.getCacheNames()).excludedCacheNames(arg.getExcludedCacheNames()).forceRestore(arg.isForce()).conversionClosure((IgniteBiClosure)new CacheConfigurations(cfgMap)).message(arg.getMessage()).parallelism(Integer.valueOf(arg.getSnapshotCommonParameters().getSnapshotOperationParallelism())));
                        }
                        catch (IgniteCheckedException e) {
                            throw U.convertException((IgniteCheckedException)e);
                        }
                    }
                } else {
                    if (!F.isEmpty(arg.getCacheNames())) {
                        throw UserCommandExceptions.invalidUserCommandException((String)"Recovery to a specific point in time is not supported for cache subset, please, don't specify caches to recover.", (GridKernalContext)this.ignite.context());
                    }
                    this.fut = snapshot.recoveryTo(new RecoveryParams().time(arg.getTime()).optionalSearchPaths(arg.paths()).message(arg.getMessage()));
                }
                if (this.fut.isDone()) {
                    this.fut.get();
                } else {
                    this.jobCtx.holdcc();
                    this.fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                        public void apply(IgniteFuture f) {
                            jobCtx.callcc();
                        }
                    });
                }
                return null;
            }
            this.fut.get();
            return null;
        }

        public String toString() {
            return S.toString(VisorRestoreSnapshotJob.class, (Object)((Object)this));
        }
    }
}

