/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.File;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorServerNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ClusterNoCachesException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCreateSnapshotTask
extends VisorServerNodeTask<VisorSnapshotInfo, VisorSnapshotInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorCreateSnapshotJob job(VisorSnapshotInfo info) {
        return new VisorCreateSnapshotJob(info, this.debug);
    }

    protected boolean nodeFilter(ClusterNode node, VisorSnapshotInfo argument) {
        if (!F.isEmpty(argument.getExcludedCacheNames())) {
            return IgniteFeatures.allNodesSupport((GridKernalContext)this.ignite.context(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER);
        }
        return true;
    }

    private static class VisorCreateSnapshotJob
    extends VisorJob<VisorSnapshotInfo, VisorSnapshotInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private SnapshotFuture fut;

        VisorCreateSnapshotJob(VisorSnapshotInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected VisorSnapshotInfo run(@Nullable VisorSnapshotInfo arg) throws IgniteException {
            if (this.fut == null) {
                GridSnapshotEx snapshot = VisorSnapshots.snapshot((Ignite)this.ignite);
                SnapshotPath dest0 = (SnapshotPath)F.first(arg.paths());
                File dest = dest0 == null ? null : dest0.path();
                try {
                    this.fut = arg.isFullSnapshot() ? snapshot.createFullSnapshot(arg.getCacheNames(), arg.getExcludedCacheNames(), dest, SnapshotCommonParameters.convertToSnapshotCommonParams((SnapshotCommonParameters)arg.getSnapshotCommonParameters()), SnapshotCreateParameters.convertSnapshotCreateParameters((SnapshotCreateParameters)arg.getSnapshotCreateParameters()), arg.getMessage()) : snapshot.createSnapshot(arg.getCacheNames(), arg.getExcludedCacheNames(), dest, SnapshotCommonParameters.convertToSnapshotCommonParams((SnapshotCommonParameters)arg.getSnapshotCommonParameters()), SnapshotCreateParameters.convertSnapshotCreateParameters((SnapshotCreateParameters)arg.getSnapshotCreateParameters()), arg.getMessage());
                }
                catch (ClusterNoCachesException e) {
                    throw new IgniteException("There are no caches in the cluster and nothing can be stored to the snapshot. Please create a cache before triggering a snapshot. For the first snapshot please use -type=full option", (Throwable)e);
                }
                if (this.fut.isDone()) {
                    this.fut.get();
                } else {
                    this.jobCtx.holdcc();
                    this.fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                        public void apply(IgniteFuture f) {
                            jobCtx.callcc();
                        }
                    });
                }
                return null;
            }
            this.fut.get();
            return VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)this.fut.snapshotOperation()).withClusterName(this.ignite.cluster().tag()).build();
        }

        public String toString() {
            return S.toString(VisorCreateSnapshotJob.class, (Object)((Object)this));
        }
    }
}

