/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorServerNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCopySnapshotTask
extends VisorServerNodeTask<VisorSnapshotInfo, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorCopySnapshotJob job(VisorSnapshotInfo info) {
        return new VisorCopySnapshotJob(info, this.debug);
    }

    private static class VisorCopySnapshotJob
    extends VisorJob<VisorSnapshotInfo, Void> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private SnapshotFuture fut;

        VisorCopySnapshotJob(VisorSnapshotInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected Void run(@Nullable VisorSnapshotInfo arg) throws IgniteException {
            if (this.fut == null) {
                GridSnapshotEx snapshot = VisorSnapshots.snapshot((Ignite)this.ignite);
                CopySnapshotParams params = new CopySnapshotParams().snapshotId(arg.getSnapshotId()).destinationPath((SnapshotPath)F.first(arg.paths())).skipWalMove(arg.isSkipWalCopy()).message(arg.getMessage());
                SnapshotUpdateOperationParameters specificParams = arg.getUpdateOperationParams();
                if (specificParams != null) {
                    params.chainMode(specificParams.chainMode()).parallelismLevel(specificParams.parallelismLevel()).deleteSources(specificParams.removeSources()).singleFileCopy(specificParams.singleFileCopy());
                }
                this.fut = snapshot.copy(params);
                if (this.fut.isDone()) {
                    this.fut.get();
                } else {
                    this.jobCtx.holdcc();
                    this.fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                        public void apply(IgniteFuture f) {
                            jobCtx.callcc();
                        }
                    });
                }
                return null;
            }
            this.fut.get();
            return null;
        }

        public String toString() {
            return S.toString(VisorCopySnapshotJob.class, (Object)((Object)this));
        }
    }
}

