/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.jetbrains.annotations.Nullable;

public class TopologyEventsTracker {
    private static final String METASTORE_EVENT_LOG_KEY = "metastoreReplicationTopologyEventsKey";
    private final GridKernalContext ctx;
    private TransactionalDrProcessorImpl txdrProc;
    @GridToStringInclude
    private final Map<Object, LogEvents> bltNodesLastEvts;
    private final DiscoveryEventListener discoLsnr = (evt, discoCache) -> {
        BaselineTopology top;
        assert (evt.type() == 11 || evt.type() == 12) : evt;
        ReplicationSessionDescriptor locDesc0 = this.txdrProc.localState();
        if (locDesc0.role() == ClusterRole.MASTER && locDesc0.state() == ReplicationState.RUNNING && (top = discoCache.state().baselineTopology()) != null && top.attributes(evt.eventNode().consistentId()) != null) {
            this.fireNodeLeftEvent(evt.eventNode(), new AffinityTopologyVersion(evt.topologyVersion()));
        }
    };
    private final GridMessageListener fullMsgLsnr = (nodeId, msg, plc) -> {
        GridCacheMessage cacheMsg = (GridCacheMessage)msg;
        if (cacheMsg.partitionExchangeMessage() && msg instanceof GridDhtPartitionsFullMessage) {
            GridDhtPartitionsFullMessage fullMsg = (GridDhtPartitionsFullMessage)msg;
            this.onPartitionsFullMessagePrepared(fullMsg.exchangeId(), fullMsg);
        }
    };

    public TopologyEventsTracker(GridKernalContext ctx, AffinityTopologyVersion topVer) {
        this.ctx = ctx;
        this.txdrProc = ctx.txDr() instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)ctx.txDr() : null;
        Set aliveNodes = ctx.discovery().discoCache(topVer).aliveBaselineNodes().stream().map(BaselineNode::consistentId).collect(Collectors.toSet());
        this.bltNodesLastEvts = ctx.discovery().discoCache(topVer).baselineNodes().stream().collect(Collectors.toMap(BaselineNode::consistentId, n -> {
            LogEvents evts = new LogEvents();
            if (!aliveNodes.contains(n.consistentId())) {
                evts.fireLeftEvent(topVer);
            }
            return evts;
        }));
    }

    private TopologyEventsTracker(GridKernalContext ctx, TransactionalDrProcessorImpl txdrProc, Map<Object, LogEvents> bltNodesLastEvts) {
        this.ctx = ctx;
        this.txdrProc = txdrProc;
        this.bltNodesLastEvts = bltNodesLastEvts;
    }

    public static TopologyEventsTracker fromMetastorage(GridKernalContext ctx, TransactionalDrProcessorImpl txdrProc, ReadOnlyMetastorage metastorage, boolean updateAlives) throws IgniteCheckedException {
        Map nodesLastEvts = (Map)((Object)metastorage.read(METASTORE_EVENT_LOG_KEY));
        if (nodesLastEvts == null) {
            return null;
        }
        nodesLastEvts.forEach((consistentId, evt) -> {
            if (((LogEvents)evt).leftTopVer.compareTo(((LogEvents)evt).joinTopVer) > 0) {
                ((LogEvents)evt).leftTopVer = AffinityTopologyVersion.ZERO;
                ((LogEvents)evt).joinTopVer = AffinityTopologyVersion.NONE;
            } else {
                ((LogEvents)evt).leftTopVer = AffinityTopologyVersion.NONE;
                ((LogEvents)evt).joinTopVer = AffinityTopologyVersion.ZERO;
            }
        });
        if (updateAlives) {
            AffinityTopologyVersion topVer = ctx.discovery().topologyVersionEx();
            Set aliveNodes = ctx.discovery().discoCache(topVer).aliveBaselineNodes().stream().map(BaselineNode::consistentId).collect(Collectors.toSet());
            nodesLastEvts.forEach((consistentId, evts) -> {
                if (!aliveNodes.contains(consistentId) && (((LogEvents)evts).joinCutId > ((LogEvents)evts).leftCutId || ((LogEvents)evts).joinCutId == -1L && ((LogEvents)evts).leftCutId == -1L)) {
                    evts.fireLeftEvent(topVer);
                }
            });
        }
        return new TopologyEventsTracker(ctx, txdrProc, nodesLastEvts);
    }

    public static TopologyEventsTracker fromRawSnapshot(GridKernalContext ctx, TransactionalDrProcessorImpl txdrProc, TopologyEventsSnapshot snapshot) {
        return new TopologyEventsTracker(ctx, txdrProc, snapshot.bltNodesLastEvts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new LogEvents((LogEvents)e.getValue()))));
    }

    public void start() {
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, 12, new int[]{11});
        this.ctx.io().addMessageListener(GridTopic.TOPIC_CACHE, this.fullMsgLsnr);
    }

    public void stop() {
        this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_CACHE, this.fullMsgLsnr);
    }

    public synchronized void baselineNodeLeft(Object consistentId, AffinityTopologyVersion topVer) {
        this.bltNodesLastEvts.remove(consistentId);
        this.storeEventLog();
    }

    public synchronized void baselineNodeJoin(Object consistentId, boolean online, AffinityTopologyVersion topVer) {
        LogEvents evt = new LogEvents();
        if (!online) {
            evt.fireLeftEvent(topVer);
        }
        this.bltNodesLastEvts.put(consistentId, evt);
        this.storeEventLog();
    }

    private synchronized void fireNodeLeftEvent(ClusterNode node, AffinityTopologyVersion topVer) {
        LogEvents evts = this.bltNodesLastEvts.get(node.consistentId());
        if (evts == null) {
            return;
        }
        if (evts.getLeftTopology().compareTo(topVer) > 0) {
            return;
        }
        evts.fireLeftEvent(topVer);
        this.storeEventLog();
    }

    private synchronized void fireNodeJoinEvent(AffinityTopologyVersion topVer) {
        Set offlineNodes = this.bltNodesLastEvts.entrySet().stream().filter(e -> ((LogEvents)e.getValue()).getLeftTopology().compareTo(((LogEvents)e.getValue()).getJoinTopology()) > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!offlineNodes.isEmpty()) {
            DiscoCache discoCache = this.ctx.discovery().discoCache(topVer);
            assert (discoCache != null);
            for (ClusterNode n : discoCache.aliveServerNodes()) {
                if (!offlineNodes.contains(n.consistentId())) continue;
                LogEvents evts = this.bltNodesLastEvts.get(n.consistentId());
                assert (evts != null) : "Node join event has been fired for non-registered cluster node [node=" + n + ", topVer=" + topVer + "]";
                if (evts.getJoinTopology().compareTo(topVer) > 0) continue;
                evts.fireJoinEvent(topVer);
            }
            this.storeEventLog();
        }
    }

    public synchronized TopologyEventsSnapshot snapshot(long cutId, AffinityTopologyVersion topVer) {
        Map<Object, LogEvents> cp = this.bltNodesLastEvts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            LogEvents evt = new LogEvents((LogEvents)e.getValue());
            evt.assign(cutId);
            return evt;
        }));
        return new TopologyEventsSnapshot(cutId, topVer, cp);
    }

    public synchronized TopologyEventsSnapshot snapshotForFakeCut(long cutId, AffinityTopologyVersion topVer) {
        TopologyEventsSnapshot snapshot = this.snapshot(cutId, topVer);
        this.merge(snapshot);
        return snapshot;
    }

    public synchronized TopologyEventsSnapshot rawSnapshot() {
        Map<Object, LogEvents> cp = this.bltNodesLastEvts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new LogEvents((LogEvents)e.getValue())));
        return new TopologyEventsSnapshot(-1L, AffinityTopologyVersion.NONE, cp);
    }

    public synchronized void merge(TopologyEventsSnapshot crdSnapshot) {
        crdSnapshot.bltNodesLastEvts.entrySet().stream().filter(e -> this.bltNodesLastEvts.containsKey(e.getKey())).forEach(e -> this.bltNodesLastEvts.get(e.getKey()).update((LogEvents)e.getValue()));
        this.storeEventLog();
    }

    public void onPartitionsFullMessagePrepared(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionsFullMessage fullMsg) {
        AffinityTopologyVersion topVer;
        boolean hasMovingParts = false;
        block0: for (Map.Entry entry : fullMsg.partitions().entrySet()) {
            GridDhtPartitionFullMap partMap = (GridDhtPartitionFullMap)entry.getValue();
            for (Map.Entry e : partMap.entrySet()) {
                if (!((GridDhtPartitionMap)e.getValue()).hasMovingPartitions()) continue;
                hasMovingParts = true;
                continue block0;
            }
        }
        AffinityTopologyVersion affinityTopologyVersion = topVer = fullMsg.resultTopologyVersion() != null ? fullMsg.resultTopologyVersion() : fullMsg.topologyVersion();
        if (!hasMovingParts) {
            this.fireNodeJoinEvent(topVer);
        }
    }

    private void storeEventLog() throws IgniteException {
        MetaStorage metastorage = this.ctx.cache().context().database().metaStorage();
        assert (metastorage != null) : "Metastorage must be initialized first.";
        assert (this.bltNodesLastEvts instanceof Serializable) : "The bltNodesLastEvts must implement the Serializable interface.";
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            metastorage.write(METASTORE_EVENT_LOG_KEY, (Serializable)((Object)this.bltNodesLastEvts));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    public String toString() {
        return S.toString(TopologyEventsTracker.class, (Object)this);
    }

    public static class LogEvents
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private AffinityTopologyVersion leftTopVer = AffinityTopologyVersion.NONE;
        private boolean leftEvtFired;
        private AffinityTopologyVersion joinTopVer = AffinityTopologyVersion.NONE;
        private boolean joinEvtFired;
        private long leftCutId = -1L;
        private long joinCutId = -1L;

        public LogEvents() {
        }

        public LogEvents(LogEvents other) {
            this.leftCutId = other.leftCutId;
            this.joinCutId = other.joinCutId;
            this.leftTopVer = other.leftTopVer;
            this.leftEvtFired = other.leftEvtFired;
            this.joinTopVer = other.joinTopVer;
            this.joinEvtFired = other.joinEvtFired;
        }

        public void fireLeftEvent(AffinityTopologyVersion topVer) {
            if (this.joinTopVer.compareTo(topVer) > 0) {
                return;
            }
            this.leftTopVer = topVer;
            this.leftEvtFired = true;
            this.joinEvtFired = false;
        }

        public AffinityTopologyVersion getLeftTopology() {
            return this.leftTopVer;
        }

        public long leftCutId() {
            return this.leftCutId;
        }

        public void fireJoinEvent(AffinityTopologyVersion topVer) {
            if (this.leftTopVer.compareTo(topVer) > 0) {
                return;
            }
            this.joinTopVer = topVer;
            this.joinEvtFired = true;
            this.leftEvtFired = false;
        }

        public AffinityTopologyVersion getJoinTopology() {
            return this.joinTopVer;
        }

        public long joinCutId() {
            return this.joinCutId;
        }

        public void assign(long consistentCutId) {
            if (this.leftEvtFired) {
                this.leftCutId = consistentCutId;
            }
            if (this.joinEvtFired) {
                this.joinCutId = consistentCutId;
            }
        }

        public void update(LogEvents upd) {
            this.leftCutId = upd.leftCutId;
            if (this.leftTopVer.compareTo(upd.leftTopVer) <= 0) {
                this.leftEvtFired = false;
                this.leftTopVer = upd.leftTopVer;
            }
            this.joinCutId = upd.joinCutId;
            if (this.joinTopVer.compareTo(upd.joinTopVer) <= 0) {
                this.joinEvtFired = false;
                this.joinTopVer = upd.joinTopVer;
            }
        }

        public String toString() {
            return S.toString(LogEvents.class, (Object)this);
        }
    }
}

