/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.events.ClusterStateChangeEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;

public class SnapshotConfigurationCorrectnessChecker
implements GridLocalEventListener {
    public static final String IMPROPER_SCHEDULE_FOR_PITR_MESSAGE = "Point in time recovery is enabled but snapshot schedule isn't set up properly. This may lead to excessive storage space usage. Schedule periodic snapshot create/move/delete using 'snapshot-utility.(sh|bat) schedule' command.";
    private final GridKernalContext igniteCtx;
    private final IgniteLogger log;

    public SnapshotConfigurationCorrectnessChecker(GridKernalContext igniteCtx, IgniteLogger log) {
        this.igniteCtx = igniteCtx;
        this.log = log;
    }

    public void onEvent(Event evt) {
        assert (evt.type() == 144) : "Unexpected event: " + evt;
        ClusterStateChangeEvent cscEvt = (ClusterStateChangeEvent)evt;
        if (cscEvt.state() == ClusterState.ACTIVE) {
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)this.igniteCtx.cache().context().snapshot();
            SnapshotScheduleProcessor scheduleProcessor = VisorSnapshots.scheduler((Ignite)this.igniteCtx.grid());
            if (snapshotMgr.pointInTimeRecoveryEnabled() && !SnapshotUtils.isScheduleProperForPitr(scheduleProcessor.list())) {
                U.warn((IgniteLogger)this.log, (Object)IMPROPER_SCHEDULE_FOR_PITR_MESSAGE);
            }
        }
    }
}

