/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;

class DeduplicatingSingleThreadExecutor
extends ThreadPoolExecutor {
    public DeduplicatingSingleThreadExecutor(ThreadFactory threadFactory, IgniteLogger log) {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new DeduplicatingBlockingQueue(log), threadFactory);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("Callables are not supported by this executor");
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T val) {
        return new RunnableFutureTask<T>(runnable, val);
    }

    private static class RunnableFutureTask<V>
    extends FutureTask<V> {
        private final Runnable runnable;

        public RunnableFutureTask(Runnable runnable, V res) {
            super(runnable, res);
            this.runnable = runnable;
        }
    }

    private static class DeduplicatingBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 0L;
        private final IgniteLogger log;

        DeduplicatingBlockingQueue(IgniteLogger log) {
            this.log = log;
        }

        @Override
        public synchronized Runnable take() throws InterruptedException {
            Runnable res = (Runnable)super.take();
            this.removeDuplicatesOf(res);
            return res;
        }

        @Override
        public synchronized Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable res = (Runnable)super.poll(timeout, unit);
            this.removeDuplicatesOf(res);
            return res;
        }

        @Override
        public synchronized Runnable poll() {
            Runnable res = (Runnable)super.poll();
            this.removeDuplicatesOf(res);
            return res;
        }

        private void removeDuplicatesOf(Runnable referenceTask) {
            Runnable actualReferenceTask = this.unwrapRunnable(referenceTask);
            this.removeIf(task -> {
                boolean duplicate;
                Runnable unwrappedTask = this.unwrapRunnable((Runnable)task);
                boolean bl = duplicate = unwrappedTask == actualReferenceTask;
                if (duplicate) {
                    this.log.warning("Discarded scheduled snapshot operation because it is duplicated: " + unwrappedTask);
                }
                return duplicate;
            });
        }

        private Runnable unwrapRunnable(Runnable task) {
            if (task instanceof RunnableFutureTask) {
                return ((RunnableFutureTask)task).runnable;
            }
            return task;
        }
    }
}

