/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;

public class VerifiableSnapshotDigestRegistry
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String TRANSFORM_ERROR = "Error computing verification code for snapshot digest registry, transformer failed.";
    public static final String REGISTRY_AUTH_ERROR = "Snapshot digest registry authentication failure.";
    private byte[] code;
    private byte[] data;

    protected void writeExternalData(ObjectOutput out) throws IOException {
        if (this.code == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.code.length);
            out.write(this.code);
        }
        if (this.data == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException {
        if (protoVer != 1) {
            throw new SnapshotDigestException("Incompatible version of snapshot digest registry. [version=" + protoVer + ", expected=" + 1 + ", class='" + ((Object)((Object)this)).getClass().getName() + "']");
        }
        int len = in.readInt();
        this.code = new byte[len];
        if (len > 0) {
            in.readFully(this.code);
        }
        len = in.readInt();
        this.data = new byte[len];
        if (len > 0) {
            in.readFully(this.data);
        }
    }

    public void prepareMarshal(SnapshotRegistryTransformer transformer, SnapshotDigestRegistry registry) throws IgniteCheckedException {
        assert (transformer != null);
        this.data = new JdkMarshaller().marshal((Object)registry);
        try {
            this.code = transformer.transform(this.data);
        }
        catch (Throwable t) {
            throw new SnapshotDigestException(TRANSFORM_ERROR, t);
        }
    }

    public SnapshotDigestRegistry finishUnmarshal(SnapshotRegistryTransformer transformer, ClassLoader clsLdr) throws IgniteCheckedException {
        assert (transformer != null);
        try {
            transformer.verify(this.data, this.code);
        }
        catch (Throwable t) {
            throw new SnapshotDigestException(REGISTRY_AUTH_ERROR, t);
        }
        return (SnapshotDigestRegistry)((Object)new JdkMarshaller().unmarshal(this.data, clsLdr));
    }
}

