/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.SnapshotRecord;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampedConsistentCutRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.gridgain.grid.internal.compression.SnapshotCompressionUtils;
import org.gridgain.grid.internal.io.GridReadableByteChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannelWrapper;
import org.gridgain.grid.internal.processors.cache.database.SnapshotAffinityFunctionContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.NodeStartPoint;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataDigestWriter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.VerifiableSnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.jetbrains.annotations.Nullable;

public class SnapshotUtils {
    public static final String INCOMPATIBLE_LEVEL_ERROR = "Can't perform snapshot operation due to incompatible security level on nodes.";
    public static final String REGISTRY_IS_CORRUPTED_ERROR = "Snapshot digest registry is corrupted.";
    private static final long MASK = 0xFFFFFFFFL;
    private static final int EOF = -1;
    private static final List<CompressionOption> COMPRESSION_CODECS = Arrays.stream(CompressionOption.values()).filter(CompressionOption::isCompressed).collect(Collectors.toList());

    @Nullable
    public static List<List<ClusterNode>> calcAffinityAssignment(GridResourceProcessor rsrc, List<ClusterNode> allNodes, CacheConfiguration<?, ?> cfg, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        SnapshotAffinityFunctionContext affCtx = new SnapshotAffinityFunctionContext(cfg.getBackups(), allNodes, topVer);
        AffinityFunction affinity = cfg.getAffinity();
        rsrc.injectGeneric((Object)affinity);
        return affinity.assignPartitions((AffinityFunctionContext)affCtx);
    }

    public static long uniquePartId(int grpId, int partId) {
        return (long)partId << 32 | (long)grpId & 0xFFFFFFFFL;
    }

    public static int grpId(long uniquePartId) {
        return (int)(uniquePartId & 0xFFFFFFFFL);
    }

    public static int partId(long uniquePartId) {
        return (int)(uniquePartId >> 32);
    }

    @Nullable
    public static ClusterNode getSnapshotCrd(@Nullable AffinityTopologyVersion topVer, GridCacheSharedContext cctx) {
        DiscoCache cache = topVer == AffinityTopologyVersion.NONE || topVer == null ? cctx.discovery().discoCache() : cctx.discovery().discoCache(topVer);
        BaselineTopology baselineTop = cctx.kernalContext().state().clusterState().baselineTopology();
        if (baselineTop != null) {
            Set cIds = baselineTop.consistentIds();
            for (ClusterNode n : cache.serverNodes()) {
                if (!cIds.contains(n.consistentId())) continue;
                return n;
            }
            return null;
        }
        return cache.oldestAliveServerNode();
    }

    public static boolean nodeIsNotInBaseline(ClusterNode node, GridCacheSharedContext cctx, AffinityTopologyVersion topVer) {
        DiscoCache cache = topVer == null || AffinityTopologyVersion.NONE.equals((Object)topVer) ? cctx.discovery().discoCache() : cctx.discovery().discoCache(topVer);
        BaselineTopology top = cache.state().baselineTopology();
        return top != null && top.attributes(node.consistentId()) == null;
    }

    public static boolean isZipInputStream(InputStream in) {
        ZipInputStream zipInputStream = new ZipInputStream(in);
        try {
            return zipInputStream.getNextEntry() != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    @Nullable
    private static SnapshotData data(SnapshotPath file, boolean optimizedCompressedEncryption) {
        SnapshotPath canonicalFile = SnapshotUtils.resolveCanonicalFile(file);
        if (canonicalFile.exists()) {
            int bufSize = 16384;
            InputStream in = SnapshotUtils.newBufferedStream(file, bufSize);
            in.mark(bufSize);
            if (SnapshotUtils.isZipInputStream(in)) {
                U.closeQuiet((AutoCloseable)in);
                throw new IgniteException("File " + canonicalFile.getAbsolutePath() + " has wrong extension!");
            }
            in = SnapshotUtils.resetInputStream(in, file, bufSize);
            boolean isLocal = canonicalFile instanceof FsSnapshotPath;
            return new SnapshotData(canonicalFile, CompressionOption.NONE, in, isLocal);
        }
        T2<SnapshotPath, CompressionOption> pair = SnapshotUtils.getCompressedFileIfExists(canonicalFile);
        if (pair != null) {
            InputStream in;
            SnapshotPath compressedFile = (SnapshotPath)pair.get1();
            try {
                in = compressedFile.inputStream();
            }
            catch (FileNotFoundException e) {
                throw new IgniteException((Throwable)e);
            }
            CompressionOption codec = (CompressionOption)pair.get2();
            if (!optimizedCompressedEncryption) {
                in = SnapshotUtils.decompressingInputStream(codec, in, canonicalFile);
            }
            return new SnapshotData(canonicalFile, codec, in, false);
        }
        return null;
    }

    public static InputStream decompressingInputStream(CompressionOption codec, InputStream in, SnapshotPath canonicalFile) {
        switch (codec) {
            case ZIP: {
                return SnapshotCompressionUtils.openZipInputStream(canonicalFile.getAbsolutePath(), in, canonicalFile.getName());
            }
            case ZSTD: {
                return SnapshotCompressionUtils.openZstdInputStream(in);
            }
            case LZ4: {
                return SnapshotCompressionUtils.openLz4InputStream(in);
            }
            case SNAPPY: {
                return SnapshotCompressionUtils.openSnappyInputStream(in);
            }
        }
        throw new IgniteException("Unknown codec: " + codec);
    }

    public static SnapshotPath resolveCanonicalFile(SnapshotPath file) {
        String fileName = file.getName();
        for (CompressionOption codec : COMPRESSION_CODECS) {
            String ext = codec.fileExtension();
            if (!fileName.endsWith(ext)) continue;
            return file.resolveSibling(fileName.substring(0, file.getName().length() - ext.length()));
        }
        return file;
    }

    @Nullable
    private static T2<SnapshotPath, CompressionOption> getCompressedFileIfExists(SnapshotPath canonicalFile) {
        for (CompressionOption codec : COMPRESSION_CODECS) {
            String ext = codec.fileExtension();
            SnapshotPath compressedFile = canonicalFile.resolveSibling(canonicalFile.getName() + ext);
            if (!compressedFile.exists() || !compressedFile.isFile()) continue;
            return new T2((Object)compressedFile, (Object)codec);
        }
        return null;
    }

    private static InputStream newBufferedStream(SnapshotPath file, int bufSize) {
        BufferedInputStream in;
        try {
            in = new BufferedInputStream(file.inputStream(), bufSize);
        }
        catch (FileNotFoundException e) {
            throw new IgniteException((Throwable)e);
        }
        return in;
    }

    private static InputStream resetInputStream(InputStream in, SnapshotPath file, int pageSize) {
        assert (in.markSupported());
        try {
            in.reset();
            return in;
        }
        catch (IOException e) {
            U.closeQuiet((AutoCloseable)in);
            return SnapshotUtils.newBufferedStream(file, pageSize);
        }
    }

    @Nullable
    public static InputStream stream(SnapshotPath file) {
        try {
            SnapshotData data = SnapshotUtils.data(file, false);
            if (data == null) {
                return null;
            }
            return data.stream;
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static CompressedChannelInfo channel(SnapshotPath file, FileStore fileStore, boolean optimizedCompressedEncryption) {
        try {
            SnapshotData data = SnapshotUtils.data(file, optimizedCompressedEncryption);
            if (data == null) {
                return new CompressedChannelInfo(null, CompressionOption.NONE);
            }
            switch (data.type) {
                case NONE: {
                    if (data.isLocal && (fileStore == null || !SnapshotUtils.isNfsFileStore(fileStore))) {
                        U.closeQuiet((AutoCloseable)data.stream);
                        Path path = ((FsSnapshotPath)data.path).getFile().toPath();
                        return new CompressedChannelInfo(new SnapshotReadableByteChannelWrapper(FileChannel.open(path, StandardOpenOption.READ)), CompressionOption.NONE);
                    }
                }
                case ZIP: 
                case ZSTD: 
                case LZ4: 
                case SNAPPY: {
                    return new CompressedChannelInfo(new GridReadableByteChannel(data.stream), data.type);
                }
            }
            throw new IllegalStateException("Unexpected value: " + data.type);
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private static boolean isNfsFileStore(FileStore fileStore) {
        return fileStore.type().toLowerCase(Locale.ENGLISH).startsWith("nfs");
    }

    public static Path resolve(Path path, String name) {
        for (CompressionOption opt : CompressionOption.values()) {
            Path file = path.resolve(name + opt.fileExtension());
            if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    public static Path buildPartitionPath(Path snapshotDir, int grpId, int partId) throws IgniteCheckedException {
        Path cacheDir = snapshotDir.resolve(String.valueOf(grpId));
        U.ensureDirectory((Path)cacheDir, (String)("snapshot directory for cache group '" + grpId + "'"), null);
        if (partId == 65535) {
            return cacheDir.resolve("index.bin");
        }
        if (partId <= 65500) {
            return cacheDir.resolve("part-" + partId + ".bin");
        }
        throw new IgniteCheckedException("Invalid partition value: " + partId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SnapshotMetadataV2 readSnapshotMetadata(SnapshotPath consistentIdDir, boolean ignoreMissedClasses, IgniteConfiguration igniteConfiguration, IgniteLogger log, boolean warnIfMetafileIsMissing, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> cacheClosure) {
        SnapshotPath snapshotMeta = consistentIdDir.resolve("snapshot-meta.bin");
        try (InputStream inputStream = SnapshotUtils.stream(snapshotMeta);){
            if (inputStream != null) {
                Object obj;
                ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)igniteConfiguration);
                Boolean rslvAddrs = (Boolean)TcpDiscoveryNode.RESOLVE_ADDRESSES.get();
                TcpDiscoveryNode.RESOLVE_ADDRESSES.set(false);
                try {
                    obj = new JdkMarshaller().unmarshal(inputStream, ldr);
                }
                finally {
                    TcpDiscoveryNode.RESOLVE_ADDRESSES.set(rslvAddrs);
                }
                if (obj instanceof SnapshotMetadataV2) {
                    SnapshotMetadataV2 metadata = (SnapshotMetadataV2)obj;
                    metadata.finishUnmarshal(ldr, cacheClosure, ignoreMissedClasses);
                    SnapshotMetadataV2 snapshotMetadataV2 = metadata;
                    return snapshotMetadataV2;
                }
                if (!(obj instanceof SnapshotMetadata)) throw new IgniteCheckedException("Unknown metadata class: " + obj.getClass());
                SnapshotMetadata oldMetadata = (SnapshotMetadata)obj;
                SnapshotMetadataV2 metadata = new SnapshotMetadataV2(oldMetadata);
                metadata.finishUnmarshal(ldr, cacheClosure, ignoreMissedClasses);
                SnapshotMetadataV2 snapshotMetadataV2 = metadata;
                return snapshotMetadataV2;
            }
            if (!warnIfMetafileIsMissing) return null;
            U.warn((IgniteLogger)log, (Object)("Snapshot metadata file is missing: " + snapshotMeta));
            return null;
        }
        catch (IOException | IgniteCheckedException | IgniteException e) {
            U.warn((IgniteLogger)log, (Object)("Can not read snapshot metadata file: " + snapshotMeta), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static SnapshotMetadataV2 readSnapshotMetadata(SnapshotPath consistentIdDir, boolean ignoreMissedClasses, IgniteConfiguration igniteConfiguration, IgniteLogger log, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> cacheClosure) {
        return SnapshotUtils.readSnapshotMetadata(consistentIdDir, ignoreMissedClasses, igniteConfiguration, log, true, cacheClosure);
    }

    public static long copyLarge(InputStream input, OutputStream output, int bufferSize, SnapshotOperationContext snapshotOperationContext) throws IOException, IgniteCheckedException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            SnapshotUtils.checkSnapshotCancellation(snapshotOperationContext);
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static Set<String> getSnapshotFolders(Map<Object, Map<String, String>> allAttrs) {
        if (allAttrs != null) {
            HashSet<String> res = new HashSet<String>();
            for (Map.Entry<Object, Map<String, String>> e : allAttrs.entrySet()) {
                for (Map.Entry<String, String> e0 : e.getValue().entrySet()) {
                    if (e0.getKey().equals("SNAPSHOT_DIR")) {
                        res.add(e0.getValue());
                        continue;
                    }
                    if (!e0.getValue().equals("SNAPSHOT_DIR")) continue;
                    res.add(e0.getKey());
                }
            }
            return res;
        }
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnapshotDigestRegistry readSnapshotDigestRegistry(SnapshotPath consistentIdDir, SnapshotRegistryTransformer transformer, IgniteConfiguration igniteConfiguration, IgniteLogger log) {
        SnapshotPath path = consistentIdDir.resolve("snapshot-registry.bin");
        try (InputStream inputStream = SnapshotUtils.stream(path);){
            if (inputStream != null) {
                ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)igniteConfiguration);
                Object obj = new JdkMarshaller().unmarshal(inputStream, ldr);
                if (!(obj instanceof VerifiableSnapshotDigestRegistry)) throw new IgniteCheckedException("Unknown registry class: " + obj.getClass());
                VerifiableSnapshotDigestRegistry auth = (VerifiableSnapshotDigestRegistry)((Object)obj);
                SnapshotDigestRegistry snapshotDigestRegistry = auth.finishUnmarshal(transformer, ldr);
                return snapshotDigestRegistry;
            }
            if (log == null) return null;
            if (!log.isInfoEnabled()) return null;
            log.info("Snapshot digest registry couldn't be found: " + path);
            return null;
        }
        catch (IOException | IgniteCheckedException | IgniteException e) {
            U.warn((IgniteLogger)log, (Object)("Can not read snapshot registry file: " + path.getAbsolutePath()), (Throwable)e);
            SnapshotDigestException ex = (SnapshotDigestException)((Object)X.cause((Throwable)e, SnapshotDigestException.class));
            if (ex == null) throw new SnapshotDigestException("Snapshot digest registry is corrupted. [path='" + path + "']", e);
            throw ex;
        }
    }

    public static MessageDigest createMessageDigest(MessageDigestFactory msgDigestFactory, long snapshotId) {
        MessageDigest msgDigest = msgDigestFactory.createDigest();
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(snapshotId);
        buf.rewind();
        msgDigest.update(buf);
        return msgDigest;
    }

    public static MessageDigestFactory messageDigestFactoryWithId(final MessageDigestFactory msgDigestFactory, final long snapshotId) {
        if (msgDigestFactory == null) {
            return null;
        }
        return new MessageDigestFactory(){

            public String getAlgorithmCode() {
                return msgDigestFactory.getAlgorithmCode();
            }

            public MessageDigest createDigest() {
                MessageDigest msgDigest = msgDigestFactory.createDigest();
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putLong(snapshotId);
                buf.rewind();
                msgDigest.update(buf);
                return msgDigest;
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static byte[] computeMetadataDigest(SnapshotMetadataDigestWriter digestWriter, MessageDigestFactory msgDigestFactory, SnapshotMetadataV2 metadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkSecurityLevel(GridCacheSharedContext cctx, UUID initiatorId, GridSnapshotOperationEx snapshotOperation, SnapshotSecurityLevel securityLevel) throws IgniteCheckedException {
        SnapshotSecurityLevel msgSecurityLevel = GridSnapshotOperationAttrs.getSecurityLevel((GridSnapshotOperationEx)snapshotOperation);
        if (msgSecurityLevel != securityLevel) {
            throw new IgniteCheckedException("Can't perform snapshot operation due to incompatible security level on nodes. [operation=" + snapshotOperation.type().name() + ", initiatorSecurityLevel=" + msgSecurityLevel + ", localSecurityLevel=" + securityLevel + ", initiatorNode=" + cctx.node(initiatorId) + ", localNode=" + cctx.localNode() + "]");
        }
    }

    public static void checkSnapshotCancellation(SnapshotOperationContext snapCtx) throws IgniteCheckedException {
        if (snapCtx != null && snapCtx.isCancelled()) {
            throw new IgniteCheckedException("Snapshot operation has been cancelled");
        }
    }

    public static boolean walFilesWereDeleted(long snapshotTs, WALPointer snapshotPtr, List<NodeStartPoint> nodeStartedPointers) {
        FileWALPointer prevStartedPointer = new FileWALPointer(0L, 0, 0);
        for (NodeStartPoint point : nodeStartedPointers) {
            if (point.timestamp() < snapshotTs) continue;
            FileWALPointer currStartedPointer = point.walPointer();
            if (currStartedPointer.compareTo(prevStartedPointer) < 0) {
                return true;
            }
            if (currStartedPointer.compareTo((FileWALPointer)snapshotPtr) < 0) {
                return true;
            }
            prevStartedPointer = currStartedPointer;
        }
        return false;
    }

    public static boolean lfsWasDeleted(long snapshotId, WALPointer snapshotPtr, IgniteWriteAheadLogManager wal, IgniteLogger log) {
        return SnapshotUtils.lfsWasDeleted(snapshotId, snapshotPtr, false, wal, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lfsWasDeleted(long snapshotId, WALPointer recoveryPtr, boolean exchangelessRecovery, IgniteWriteAheadLogManager wal, IgniteLogger log) {
        if (!wal.reserve(recoveryPtr)) {
            return true;
        }
        try {
            boolean found;
            WALRecord walRecord = wal.read(recoveryPtr);
            WALRecord.RecordType recordType = walRecord.type();
            boolean bl = exchangelessRecovery ? recordType == WALRecord.RecordType.TIME_STAMPED_CONSISTENT_CUT && ((TimeStampedConsistentCutRecord)walRecord).snapshotId() == snapshotId : (found = recordType == WALRecord.RecordType.SNAPSHOT && ((SnapshotRecord)walRecord).getSnapshotId() == snapshotId);
            if (!found && log.isDebugEnabled()) {
                log.debug("Recovery pointer does not point to the expected record. It seems local file systemt has been cleaned manually [snapshotId=" + snapshotId + ", recoveryPtr=" + recoveryPtr + ", recordType=" + recordType + ", record=" + walRecord + ']');
            }
            boolean bl2 = !found;
            return bl2;
        }
        catch (Throwable t) {
            log.error("Failed to validate snapshot WAL record: " + recoveryPtr, t);
            boolean bl = true;
            return bl;
        }
        finally {
            wal.release(recoveryPtr);
        }
    }

    public static Map<Integer, GroupKey> createSnapshotEncryptionKeys(EncryptionSpi encryptionSpi, Set<Integer> grpIds) {
        assert (!(encryptionSpi instanceof NoopEncryptionSpi)) : "Encryption is not supported.";
        HashMap<Integer, GroupKey> encryptionKeys = new HashMap<Integer, GroupKey>();
        for (Integer id : grpIds) {
            encryptionKeys.put(id, new GroupKey(0, encryptionSpi.create()));
        }
        return encryptionKeys;
    }

    public static Map<Integer, GroupKeyEncrypted> encryptSnapshotEncryptionKeys(EncryptionSpi encryptionSpi, Map<Integer, GroupKey> encryptionKeys, String masterKeyName) {
        assert (!(encryptionSpi instanceof NoopEncryptionSpi)) : "Encryption is not supported.";
        HashMap<Integer, GroupKeyEncrypted> encryptedTdeKyes = new HashMap<Integer, GroupKeyEncrypted>();
        for (Map.Entry<Integer, GroupKey> grpKey : encryptionKeys.entrySet()) {
            encryptedTdeKyes.put(grpKey.getKey(), new GroupKeyEncrypted((int)grpKey.getValue().id(), encryptionSpi.encryptKey(grpKey.getValue().key(), masterKeyName)));
        }
        return encryptedTdeKyes;
    }

    public static IgniteBiPredicate<WALRecord.RecordType, WALPointer> snapshotWalRecordFilter() {
        return (IgniteBiPredicate & Serializable)(type, pointer) -> {
            assert (type == WALRecord.RecordType.DATA_RECORD || type == WALRecord.RecordType.DATA_RECORD_V2 || type == WALRecord.RecordType.MVCC_DATA_RECORD || type == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V2 || type == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V3) : "Unexpected record type [type=" + type + ", pointer=" + pointer + "]";
            return true;
        };
    }

    public static EncryptionCacheKeyProvider snapshotEncryptionProvider(final C1<Integer, Serializable> closure) {
        return new EncryptionCacheKeyProvider(){

            @Nullable
            public GroupKey getActiveKey(int grpId) {
                return this.groupKey(grpId, 0);
            }

            @Nullable
            public GroupKey groupKey(int grpId, int keyId) {
                assert (keyId == 0) : "Unexpected encryption key id [grpId=" + grpId + ", keyId=" + keyId + ']';
                return new GroupKey(keyId, (Serializable)closure.apply((Object)grpId));
            }
        };
    }

    public static boolean isScheduleProperForPitr(List<SnapshotScheduleV2> schedules) {
        boolean createOpFound = false;
        boolean moveOrDeleteOpFound = false;
        for (SnapshotScheduleV2 schedule : schedules) {
            if (!schedule.isEnabled()) continue;
            SnapshotOperationType type = schedule.getOperationType();
            if (type == SnapshotOperationType.CREATE) {
                createOpFound = true;
            } else if (type == SnapshotOperationType.MOVE || type == SnapshotOperationType.DELETE) {
                moveOrDeleteOpFound = true;
            }
            if (!createOpFound || !moveOrDeleteOpFound) continue;
            return true;
        }
        return false;
    }

    public static class CompressedChannelInfo {
        @Nullable
        public final SnapshotReadableByteChannel channel;
        public final CompressionOption compressionOption;

        public CompressedChannelInfo(@Nullable SnapshotReadableByteChannel channel, CompressionOption option) {
            this.channel = channel;
            this.compressionOption = option;
        }
    }

    private static class SnapshotData {
        private final SnapshotPath path;
        private final CompressionOption type;
        private final boolean isLocal;
        private final InputStream stream;

        public SnapshotData(SnapshotPath path, CompressionOption type, InputStream stream, boolean isLocal) {
            this.path = path;
            this.type = type;
            this.stream = stream;
            this.isLocal = isLocal;
        }
    }
}

