/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.messages;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.grid.internal.processors.cache.database.messages.AbstractSnapshotLifecycleMessage;

public class SnapshotProgressMessage
extends AbstractSnapshotLifecycleMessage {
    private static final long serialVersionUID = 0L;
    private double progress;
    private long processed;
    private long total;

    public SnapshotProgressMessage() {
    }

    public SnapshotProgressMessage(IgniteUuid operationId, long processed, long total) {
        this.id = operationId;
        this.processed = processed;
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public long getTotal() {
        return this.total;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("operationId", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("processed", this.processed)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeDouble("progress", this.progress)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("total", this.total)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.id = reader.readIgniteUuid("operationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.processed = reader.readLong("processed");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.progress = reader.readDouble("progress");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.total = reader.readLong("total");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotProgressMessage.class);
    }

    public short directType() {
        return 2051;
    }

    public byte fieldsCount() {
        return 4;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(SnapshotProgressMessage.class, (Object)this, (String)"operationId", (Object)this.id, (String)"processed", (Object)this.processed, (String)"total", (Object)this.total);
    }
}

