/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrGlobalStatus;
import org.junit.Test;

public class TxDrReplicaDebugModeTest
extends AbstractReplicationTest {
    private static final String TX_DR_REPLICA_DEBUG_MODE = "TX_DR_REPLICA_DEBUG_MODE";

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 2;
        this.consistentCutInterval = Long.MAX_VALUE;
    }

    @Override
    protected void afterTest() throws Exception {
        System.clearProperty(TX_DR_REPLICA_DEBUG_MODE);
        super.afterTest();
    }

    @Test
    public void testReplicaDebugModePauseOnEveryCut() throws Exception {
        this.doTestReplicaDebugMode(DebugMode.PAUSE_ON_EVERY_CUT);
    }

    @Test
    public void testReplicaDebugModePauseOnFailure() throws Exception {
        this.doTestReplicaDebugMode(DebugMode.PAUSE_ON_FAILURE);
    }

    private void doTestReplicaDebugMode(DebugMode debugMode) throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        System.setProperty(TX_DR_REPLICA_DEBUG_MODE, debugMode.name());
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx master0 = masterCluster.get(0);
        IgniteEx replica0 = replicaCluster.get(0);
        master0.cluster().active(true);
        replica0.cluster().active(true);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(bootstrapSesId);
        TxDrReplicaDebugModeTest.assertTrue((this.txdr((Ignite)replica0).debugMode() == debugMode ? 1 : 0) != 0);
        IgniteInternalFuture loadFut = this.startTxLoad(3, ClusterRole.MASTER);
        List<Long> createdCutsIds = this.createConsistentCuts(master0, 5, 2000L);
        createdCutsIds.add(0, bootstrapSesId);
        this.stopTxLoad(loadFut);
        log.info("Created consistent cuts: " + createdCutsIds);
        long finalCut = createdCutsIds.get(createdCutsIds.size() - 1);
        for (Long cutId : createdCutsIds) {
            TransactionalDrGlobalStatus status0 = (TransactionalDrGlobalStatus)this.txdr((Ignite)replica0).status().get();
            if (status0.state() == ReplicationState.PAUSED && status0.lastSuccessfullyAppliedCutId() < cutId) {
                TxDrReplicaDebugModeTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
                    try {
                        if (this.snapMgr((Ignite)replica0).getOngoingOperation() != null) {
                            return false;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        return false;
                    }
                    return true;
                }, (long)60000L));
                this.txdr((Ignite)replica0).resume().get();
            }
            long startTs = U.currentTimeMillis();
            TxDrReplicaDebugModeTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
                TransactionalDrGlobalStatus status = (TransactionalDrGlobalStatus)this.txdr((Ignite)replica0).status().get();
                return debugMode == DebugMode.PAUSE_ON_FAILURE ? this.proceedAfterAppliedCutOrPausedOnFailure(cutId, finalCut, status, replica0) : this.pausedOnAppliedCut(cutId, status);
            }, (long)60000L));
            log.info("ConsistentCut[id=" + cutId + "] applied in " + (U.currentTimeMillis() - startTs) + " ms.");
        }
    }

    private List<Long> createConsistentCuts(IgniteEx ignite, int numOfCuts, long interval) {
        ArrayList<Long> consistentIds = new ArrayList<Long>(numOfCuts);
        for (int i = 0; i < numOfCuts; ++i) {
            TxDrReplicaDebugModeTest.doSleep((long)interval);
            consistentIds.add(this.forceConsistentCut((Ignite)ignite));
        }
        return consistentIds;
    }

    private boolean pausedOnAppliedCut(long cutId, TransactionalDrGlobalStatus status) {
        return status.lastSuccessfullyAppliedCutId() == cutId && status.state() == ReplicationState.PAUSED;
    }

    private boolean proceedAfterAppliedCutOrPausedOnFailure(long cutId, long finalCutId, TransactionalDrGlobalStatus status, IgniteEx node) {
        if (status.lastSuccessfullyAppliedCutId() > cutId) {
            return true;
        }
        if (status.lastSuccessfullyAppliedCutId() == cutId) {
            boolean pausedOnIdleVerify = status.state() == ReplicationState.PAUSED && !this.idleVerifyReplica(node);
            boolean stoppedOnFinalCut = cutId == finalCutId && status.state() == ReplicationState.RUNNING && this.idleVerifyReplica(node);
            return pausedOnIdleVerify || stoppedOnFinalCut;
        }
        return false;
    }
}

