/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class TxDrBootstrapReplicaTest
extends AbstractReplicationTest {
    @Test
    public void testBootstrapReplica() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER, 3);
        IgniteCache cacheMaster = this.node(ClusterRole.MASTER).getOrCreateCache("default");
        this.awaitPartitionMapExchange();
        for (int i = 0; i < 100; ++i) {
            cacheMaster.put((Object)i, (Object)i);
        }
        GridGain ggMaster = (GridGain)this.node(ClusterRole.MASTER).plugin("GridGain");
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        SnapshotFuture snapshotFut = ggMaster.snapshot().createFullSnapshot(null, snapshotDir, new SnapshotCreateParams(), null);
        snapshotFut.get();
        long bootstrapSesId = snapshotFut.snapshotOperation().snapshotId();
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA, 3);
        this.txdr(ClusterRole.REPLICA).bootstrap(snapshotDir, bootstrapSesId).get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        IgniteCache cacheReplica = replicaCluster.get(0).cache("default");
        for (int i = 0; i < 100; ++i) {
            TxDrBootstrapReplicaTest.assertEquals((int)i, (int)((Integer)cacheReplica.get((Object)i)));
        }
    }

    @Test
    public void testBootstrapReplicaWithWalDisabling() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER, 3);
        masterCluster.get(0).cluster().active(true);
        IgniteCache cacheMaster = this.node(ClusterRole.MASTER).getOrCreateCache("default");
        this.awaitPartitionMapExchange();
        for (int i = 0; i < 100; ++i) {
            cacheMaster.put((Object)i, (Object)i);
        }
        GridGain ggMaster = (GridGain)this.node(ClusterRole.MASTER).plugin("GridGain");
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        SnapshotFuture snapshotFut = ggMaster.snapshot().createFullSnapshot(null, snapshotDir, new SnapshotCreateParams(), null);
        snapshotFut.get();
        long bootstrapSesId = snapshotFut.snapshotOperation().snapshotId();
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA, 3);
        IgniteEx replica0 = replicaCluster.get(0);
        replica0.cluster().active(true);
        String replicaCacheName = "replica_cache";
        replica0.getOrCreateCache("replica_cache");
        assert (((Boolean)replica0.context().cache().context().walState().changeWalMode(Collections.singletonList("replica_cache"), false).get()).booleanValue());
        try {
            this.txdr(ClusterRole.REPLICA).bootstrap(snapshotDir, bootstrapSesId).get();
            TxDrBootstrapReplicaTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (((Boolean)replica0.context().cache().context().walState().changeWalMode(Collections.singletonList("replica_cache"), true).get()).booleanValue());
        this.txdr(ClusterRole.REPLICA).bootstrap(snapshotDir, bootstrapSesId).get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        try {
            replica0.context().cache().context().walState().changeWalMode(Collections.singletonList("replica_cache"), false).get();
            TxDrBootstrapReplicaTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

