/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.LocalPendingTransactionsTracker;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutContext;
import org.gridgain.grid.internal.processors.cache.database.txdr.TestLocalTxEngine;
import org.mockito.Mockito;

public class TestNodeContext {
    private LocalPendingTransactionsTracker tracker;
    private GridCacheSharedContext<?, ?> cctx;
    private ConsistentCutContext consistentCutCtx;
    private IgniteWriteAheadLogManager mockWal;
    private IgniteTxManager mockTm;
    private AtomicInteger walCnt;
    private TestLocalTxEngine txEngine;
    private final int nodeId;
    private final UUID uuid = UUID.randomUUID();

    public TestNodeContext(int nodeId, ScheduledExecutorService timeoutExecutor) throws IgniteCheckedException {
        this(nodeId, timeoutExecutor, new TestLocalTxEngine.SimpleCheckPolicy());
    }

    public TestNodeContext(int nodeId, ScheduledExecutorService timeoutExecutor, TestLocalTxEngine.LockPolicy plc) throws IgniteCheckedException {
        this.nodeId = nodeId;
        GridTimeoutProcessor time = (GridTimeoutProcessor)Mockito.mock(GridTimeoutProcessor.class);
        Mockito.when((Object)time.addTimeoutObject((GridTimeoutObject)Mockito.any())).thenAnswer(mock -> {
            GridTimeoutObject timeoutObj = (GridTimeoutObject)mock.getArguments()[0];
            long endTime = timeoutObj.endTime();
            timeoutExecutor.schedule(() -> ((GridTimeoutObject)timeoutObj).onTimeout(), endTime - U.currentTimeMillis(), TimeUnit.MILLISECONDS);
            return null;
        });
        this.cctx = (GridCacheSharedContext)Mockito.mock(GridCacheSharedContext.class);
        Mockito.when((Object)this.cctx.time()).thenReturn((Object)time);
        this.tracker = new LocalPendingTransactionsTracker(this.cctx);
        this.walCnt = new AtomicInteger(1);
        this.mockWal = (IgniteWriteAheadLogManager)Mockito.mock(IgniteWriteAheadLogManager.class);
        Mockito.when((Object)this.cctx.wal()).thenReturn((Object)this.mockWal);
        Mockito.when((Object)this.mockWal.log((WALRecord)Mockito.any())).thenAnswer(arg -> new FileWALPointer((long)nodeId, this.walCnt.getAndIncrement(), 1));
        Mockito.when((Object)this.mockWal.log((WALRecord)Mockito.any(), (RolloverType)Mockito.any())).thenAnswer(arg -> new FileWALPointer((long)nodeId, this.walCnt.getAndIncrement(), 1));
        this.mockTm = (IgniteTxManager)Mockito.mock(IgniteTxManager.class);
        Mockito.when((Object)this.cctx.tm()).thenReturn((Object)this.mockTm);
        Mockito.when((Object)this.mockTm.pendingTxsTracker()).thenReturn((Object)this.tracker);
        IgniteCacheDatabaseSharedManager mockDb = (IgniteCacheDatabaseSharedManager)Mockito.mock(IgniteCacheDatabaseSharedManager.class);
        Mockito.when((Object)mockDb.checkpointLockIsHeldByThread()).thenReturn((Object)true);
        Mockito.when((Object)this.cctx.database()).thenReturn((Object)mockDb);
        this.consistentCutCtx = new ConsistentCutContext(U.currentTimeMillis(), U.currentTimeMillis(), this.cctx);
        this.txEngine = new TestLocalTxEngine(this.mockWal, this.tracker, plc);
    }

    public LocalPendingTransactionsTracker tracker() {
        return this.tracker;
    }

    public ConsistentCutContext consistentCutContext() {
        return this.consistentCutCtx;
    }

    public IgniteWriteAheadLogManager mockWal() {
        return this.mockWal;
    }

    public IgniteTxManager mockTm() {
        return this.mockTm;
    }

    public AtomicInteger walCount() {
        return this.walCnt;
    }

    public TestLocalTxEngine txEngine() {
        return this.txEngine;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public UUID nodeUuid() {
        return this.uuid;
    }

    public void resetConsistentCutContext() {
        this.consistentCutCtx.reset();
        this.consistentCutCtx = new ConsistentCutContext(U.currentTimeMillis(), U.currentTimeMillis(), this.cctx);
    }
}

