/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutGC;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.FileConsistentCutStore;
import org.junit.Ignore;
import org.junit.Test;

public class ConsistentCutGCTest
extends GridCommonAbstractTest {
    private static final String TRANSFER_FOLDER_NAME = "transfer-folder";
    private File transferDir;
    private AtomicLong walSegmentCntr = new AtomicLong();
    private AtomicLong ccCntr = new AtomicLong();

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.transferDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)TRANSFER_FOLDER_NAME, (boolean)true);
        this.walSegmentCntr.set(0L);
        this.ccCntr.set(0L);
    }

    protected void afterTest() throws Exception {
        U.delete((File)this.transferDir);
        super.afterTest();
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/TDR-136")
    public void testPerform() throws Exception {
        File nodeDir = this.transferDir;
        File walDir = new File(nodeDir, "wal");
        U.ensureDirectory((File)walDir, (String)"WAL dir", (IgniteLogger)log);
        File cutsDir = new File(nodeDir, "cuts");
        U.ensureDirectory((File)cutsDir, (String)"Cuts dir", (IgniteLogger)log);
        FileConsistentCutStore store = new FileConsistentCutStore(cutsDir, (Marshaller)new JdkMarshaller());
        ConsistentCutGC gc = new ConsistentCutGC(log, (ConsistentCutStore)store, walDir);
        long spawnId0 = U.currentTimeMillis();
        File spawnWalDir0 = new File(walDir, Long.toString(spawnId0));
        U.ensureDirectory((File)spawnWalDir0, (String)("Spawn[" + spawnId0 + "] WAL dir"), (IgniteLogger)log);
        File walFile0 = this.createWalSegment(spawnWalDir0);
        File walFile1 = this.createWalSegment(spawnWalDir0);
        ConsistentCut cut0 = this.createConsistentCut((ConsistentCutStore)store, spawnId0, 1L, 1L);
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut0.id()));
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile0.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile1.exists());
        gc.updateLastAppliedCut(cut0);
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertFalse((boolean)walFile0.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile1.exists());
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile1.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut0.id()));
        long spawnId1 = spawnId0 + 10000L;
        File spawnWalDir1 = new File(walDir, Long.toString(spawnId1));
        U.ensureDirectory((File)spawnWalDir1, (String)("Spawn[" + spawnId1 + "] WAL dir"), (IgniteLogger)log);
        this.walSegmentCntr.set(0L);
        File walFile0_1 = this.createWalSegment(spawnWalDir1);
        File walFile1_1 = this.createWalSegment(spawnWalDir1);
        ConsistentCut cut1 = this.createConsistentCut((ConsistentCutStore)store, spawnId1, 1L, 1L);
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Arrays.asList(cut0.id(), cut1.id()));
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile0_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)spawnWalDir0.exists());
        ConsistentCutGCTest.assertTrue((boolean)spawnWalDir1.exists());
        gc.updateLastAppliedCut(cut1);
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertFalse((boolean)walFile1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile0_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertFalse((boolean)spawnWalDir0.exists());
        ConsistentCutGCTest.assertTrue((boolean)spawnWalDir1.exists());
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertFalse((boolean)walFile0_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Arrays.asList(cut0.id(), cut1.id()));
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut1.id()));
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut1.id()));
        File walFile2 = this.createWalSegment(spawnWalDir1);
        File walFile3 = this.createWalSegment(spawnWalDir1);
        ConsistentCut cut2 = this.createConsistentCut((ConsistentCutStore)store, spawnId1, 3L, 3L);
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Arrays.asList(cut1.id(), cut2.id()));
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile2.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile3.exists());
        gc.updateLastAppliedCut(cut2);
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertFalse((boolean)walFile1_1.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile2.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile3.exists());
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertFalse((boolean)walFile2.exists());
        ConsistentCutGCTest.assertTrue((boolean)walFile3.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Arrays.asList(cut1.id(), cut2.id()));
        ConsistentCutGCTest.assertTrue((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile3.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut2.id()));
        ConsistentCutGCTest.assertFalse((boolean)gc.perform());
        ConsistentCutGCTest.assertTrue((boolean)walFile3.exists());
        ConsistentCutGCTest.assertEqualsCollections((Collection)store.list(), Collections.singletonList(cut2.id()));
    }

    private File createWalSegment(File walDir) throws IOException {
        File walFile = new File(walDir, FileDescriptor.fileName((long)this.walSegmentCntr.getAndIncrement()));
        if (!walFile.exists()) {
            ConsistentCutGCTest.assertTrue((boolean)walFile.createNewFile());
        }
        return walFile;
    }

    private ConsistentCut createConsistentCut(ConsistentCutStore store, long spawnId, long fuzzyBorderStartPtrIdx, long cutPtrIdx) throws IgniteCheckedException {
        ConsistentCut cut = new ConsistentCut(this.ccCntr.getAndIncrement(), spawnId, (WALPointer)new FileWALPointer(fuzzyBorderStartPtrIdx, 0, 1), (WALPointer)new FileWALPointer(cutPtrIdx, 0, 1), -1L, Collections.emptySet(), Collections.emptyMap(), null, false, Collections.emptyMap(), null);
        store.save(cut);
        return cut;
    }
}

