/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.ListSnapshotParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotInfoParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class SnapshotSizeSelfTest
extends AbstractSnapshotTest {
    private boolean pitr;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.getDataStorageConfiguration().setWalSegments(5).setWalSegmentSize(0x100000).setWalArchivePath("db/wal").setMaxWalArchiveSize(-1L);
        return cfg;
    }

    @Override
    protected SnapshotConfiguration getSnapshotConfiguration() {
        return super.getSnapshotConfiguration().setPointInTimeRecoveryEnabled(this.pitr);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testLocalCheckingSnapshotSizeWithoutPitr() throws Exception {
        this.checkLocalSnapshotSizes((info, snapshot) -> {
            String idStr = String.valueOf(info.snapshotId());
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)0L, (long)info.walSize());
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)0L, (long)snapshot.walSize());
        });
    }

    @Test
    public void testLocalCheckingSnapshotSizeWithPitr() throws Exception {
        this.pitr = true;
        Supplier<Map<Long, Long>> walSizeSupplier = new Supplier<Map<Long, Long>>(){
            @Nullable
            Map<Long, Long> walSizes;

            @Override
            public Map<Long, Long> get() {
                if (this.walSizes == null) {
                    this.walSizes = G.allGrids().stream().map(x$0 -> SnapshotSizeSelfTest.localWalSizes(x$0)).flatMap(m -> m.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue)));
                }
                return this.walSizes;
            }
        };
        this.checkLocalSnapshotSizes((arg_0, arg_1) -> SnapshotSizeSelfTest.lambda$testLocalCheckingSnapshotSizeWithPitr$1((Supplier)walSizeSupplier, arg_0, arg_1));
    }

    @Test
    public void testSortLocalSnapshots() throws Exception {
        IgniteEx n = this.startGrids(1);
        n.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        IgniteCache c = n.getOrCreateCache("cache1");
        IntStream.range(0, 100).forEach(i -> c.put((Object)i, (Object)i));
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        SnapshotFuture snapFut0 = gg.snapshot().createFullSnapshot(null, "full_0");
        snapFut0.get(1L, TimeUnit.MINUTES);
        IntStream.range(100, 200).forEach(i -> c.put((Object)i, (Object)i));
        SnapshotFuture snapFut1 = gg.snapshot().createSnapshot(null, "inc_1");
        snapFut1.get(1L, TimeUnit.MINUTES);
        IntStream.range(200, 300).forEach(i -> c.put((Object)i, (Object)i));
        SnapshotFuture snapFut2 = gg.snapshot().createSnapshot(null, "inc_2");
        snapFut2.get(1L, TimeUnit.MINUTES);
        IntStream.range(300, 400).forEach(i -> c.put((Object)i, (Object)i));
        SnapshotFuture snapFut3 = gg.snapshot().createSnapshot(null, "inc_3");
        snapFut3.get(1L, TimeUnit.MINUTES);
        IntStream.range(400, 500).forEach(i -> c.put((Object)i, (Object)i));
        SnapshotFuture snapFut4 = gg.snapshot().createFullSnapshot(null, "full_4");
        snapFut4.get(1L, TimeUnit.MINUTES);
        List expSnapshotIds = Stream.of(snapFut0, snapFut1, snapFut2, snapFut3, snapFut4).map(f -> f.snapshotOperation().snapshotId()).collect(Collectors.toList());
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        List actSnapshotIds = StreamSupport.stream(snapMgr.snapshotSpi().localSnapshots(true).spliterator(), false).map(SnapshotMetadataV2::id).collect(Collectors.toList());
        SnapshotSizeSelfTest.assertEqualsCollections(expSnapshotIds, actSnapshotIds);
        TreeSet expSnapshotIdSet = new TreeSet(expSnapshotIds);
        for (Long id : expSnapshotIdSet) {
            SnapshotSizeSelfTest.assertEquals((String)id.toString(), (Object)expSnapshotIdSet.higher(id), Optional.ofNullable(snapMgr.snapshotSpi().nextLocalSnapshot(id.longValue())).map(SnapshotMetadataV2::id).orElse(null));
        }
    }

    @Test
    public void testExtractSnapshotId() {
        long snapshotId = System.currentTimeMillis();
        SnapshotSizeSelfTest.assertEquals((long)snapshotId, (long)FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName((String)FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null)));
        SnapshotSizeSelfTest.assertEquals((long)snapshotId, (long)FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName((String)FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, (String)"null")));
        SnapshotSizeSelfTest.assertEquals((long)snapshotId, (long)FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName((String)FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, (String)"")));
        SnapshotSizeSelfTest.assertEquals((long)-1L, (long)FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName((String)"1"));
    }

    @Test
    public void testRemoteSnapshotWalSizes() throws Exception {
        this.pitr = true;
        List<Long> snapshotIds = this.prepareCluster();
        GridGainImpl gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        gg.snapshot().createSnapshot(null, "new_last_snapshot_for_pitr").get(1L, TimeUnit.MINUTES);
        org.gridgain.grid.persistentstore.SnapshotPath moveDir = org.gridgain.grid.persistentstore.SnapshotPath.file().path(this.createOrCleanMoveDir()).build();
        for (Long id : snapshotIds) {
            gg.snapshot().move(new MoveSnapshotParams().snapshotId(id.longValue()).chainMode(SnapshotChainMode.SINGLE).destinationPath(moveDir)).get(1L, TimeUnit.MINUTES);
        }
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        FsSnapshotPath movePath = new FsSnapshotPath(moveDir.path());
        SnapshotSizeSelfTest.assertEquals((long)0L, (long)snapMgr.snapshotSpi().remoteSnapshotWalSizes(null, 0L));
        SnapshotSizeSelfTest.assertEquals((long)0L, (long)snapMgr.snapshotSpi().remoteSnapshotWalSizes(null, 1L));
        SnapshotSizeSelfTest.assertEquals((long)0L, (long)snapMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)movePath, 0L));
        SnapshotSizeSelfTest.assertEquals((long)0L, (long)snapMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)movePath, 1L));
        HashMap<Long, Long> expWalSizes = new HashMap<Long, Long>();
        for (Long id : snapshotIds) {
            FsSnapshotPath snapshotPath = movePath.resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
            SnapshotSizeSelfTest.assertTrue((String)snapshotPath.toString(), (snapshotPath.exists() && snapshotPath.isDirectory() && !snapshotPath.isEmptyDirectory() ? 1 : 0) != 0);
            for (Ignite n : G.allGrids()) {
                FsSnapshotPath cidPath = snapshotPath.resolve(U.maskForFileName((CharSequence)n.cluster().localNode().consistentId().toString()));
                SnapshotSizeSelfTest.assertTrue((String)cidPath.toString(), (cidPath.exists() && cidPath.isDirectory() && !cidPath.isEmptyDirectory() ? 1 : 0) != 0);
                FsSnapshotPath walPath = cidPath.resolve("wal");
                SnapshotSizeSelfTest.assertTrue((String)walPath.toString(), (walPath.exists() && walPath.isDirectory() && !walPath.isEmptyDirectory() ? 1 : 0) != 0);
                long walSize = walPath.getEntries().stream().peek(e -> SnapshotSizeSelfTest.assertTrue((e.isFile() && FileWriteAheadLogManager.isSegmentFileName((String)e.getName()) ? 1 : 0) != 0)).mapToLong(e -> e.length()).sum();
                expWalSizes.merge(id, walSize, Long::sum);
            }
        }
        Map actWalSizes = snapMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)movePath);
        SnapshotSizeSelfTest.assertEquals((int)expWalSizes.size(), (int)actWalSizes.size());
        for (Long id : snapshotIds) {
            String idStr = String.valueOf(id);
            SnapshotSizeSelfTest.assertEquals((String)idStr, expWalSizes.get(id), actWalSizes.get(id));
            long specific = snapMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)movePath, id.longValue());
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)((Long)expWalSizes.get(id)), (long)specific);
        }
    }

    @Test
    public void testRemoteCheckingSnapshotSizeWithoutPitr() throws Exception {
        this.checkRemoteSnapshotSizes((info, ex) -> {
            String idStr = String.valueOf(info.snapshotId());
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)0L, (long)info.walSize());
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)0L, (long)ex.walSize());
        });
    }

    @Test
    public void testRemoteCheckingSnapshotSizeWithPitr() throws Exception {
        this.pitr = true;
        final File moveDir = this.getMoveDir();
        Supplier<Map<Long, Long>> walSizeSupplier = new Supplier<Map<Long, Long>>(){
            @Nullable
            Map<Long, Long> walSizes;

            @Override
            public Map<Long, Long> get() {
                if (this.walSizes == null) {
                    this.walSizes = SnapshotSizeSelfTest.remoteWalSizes((Ignite)SnapshotSizeSelfTest.this.grid(0), moveDir);
                }
                return this.walSizes;
            }
        };
        this.checkRemoteSnapshotSizes((arg_0, arg_1) -> SnapshotSizeSelfTest.lambda$testRemoteCheckingSnapshotSizeWithPitr$11((Supplier)walSizeSupplier, arg_0, arg_1));
    }

    private List<Long> prepareCluster() throws Exception {
        IgniteEx n = this.startGrids(2);
        n.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        IgniteCache c = n.getOrCreateCache("cache1");
        IntStream.range(0, 10000).forEach(i -> c.put((Object)i, (Object)i));
        GridGain gg = (GridGain)n.plugin("GridGain");
        SnapshotFuture fullFut = gg.snapshot().createFullSnapshot(null, "full");
        fullFut.get(1L, TimeUnit.MINUTES);
        IntStream.range(10000, 20000).forEach(i -> c.put((Object)i, (Object)i));
        SnapshotFuture incFut = gg.snapshot().createSnapshot(null, "inc");
        incFut.get(1L, TimeUnit.MINUTES);
        return Stream.of(fullFut, incFut).map(f -> f.snapshotOperation().snapshotId()).sorted().collect(Collectors.toList());
    }

    private void checkLocalSnapshotSizes(@Nullable BiConsumer<SnapshotInfo, SnapshotInfoEx> afterCheckSizeC) throws Exception {
        List<Long> snapshotIds = this.prepareCluster();
        for (Ignite n : G.allGrids()) {
            SnapshotSizeSelfTest.disableWal((IgniteEx)((IgniteEx)n), (boolean)true);
        }
        GridGainImpl gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        List infos = gg.snapshot().list(null);
        SnapshotSizeSelfTest.assertTrue((boolean)infos.stream().map(SnapshotInfo::snapshotId).collect(Collectors.toSet()).containsAll(snapshotIds));
        for (SnapshotInfo info : infos) {
            long id = info.snapshotId();
            String idStr = String.valueOf(id);
            long sumSize = G.allGrids().stream().mapToLong(g -> SnapshotSizeSelfTest.localMeta(g, id).sizeInBytes()).sum();
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)info.size(), (long)sumSize);
            SnapshotInfoEx infoEx = gg.snapshot().snapshot(new SnapshotInfoParams().snapshotId(id));
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)sumSize, (long)infoEx.size());
            if (afterCheckSizeC == null) continue;
            afterCheckSizeC.accept(info, infoEx);
        }
    }

    private void checkRemoteSnapshotSizes(@Nullable BiConsumer<SnapshotInfo, SnapshotInfoEx> afterCheckSizeC) throws Exception {
        List<Long> snapshotIds = this.prepareCluster();
        GridGainImpl gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        if (this.pitr) {
            gg.snapshot().createSnapshot(null, "new_last_snapshot_for_pitr").get(1L, TimeUnit.MINUTES);
        }
        org.gridgain.grid.persistentstore.SnapshotPath moveDir = org.gridgain.grid.persistentstore.SnapshotPath.file().path(this.createOrCleanMoveDir()).build();
        for (Long snapshotId : snapshotIds) {
            gg.snapshot().move(new MoveSnapshotParams().snapshotId(snapshotId.longValue()).destinationPath(moveDir).chainMode(SnapshotChainMode.SINGLE)).get(1L, TimeUnit.MINUTES);
        }
        List infos = gg.snapshot().list(new ListSnapshotParams().optionalSearchPaths(Arrays.asList(moveDir)));
        SnapshotSizeSelfTest.assertTrue((boolean)infos.stream().map(SnapshotInfo::snapshotId).collect(Collectors.toSet()).containsAll(snapshotIds));
        for (SnapshotInfo info : infos.stream().filter(i -> snapshotIds.contains(i.snapshotId())).collect(Collectors.toList())) {
            long id = info.snapshotId();
            String idStr = String.valueOf(id);
            SnapshotMetadataV2 remoteMeta = SnapshotSizeSelfTest.remoteMeta(gg, id, moveDir.path());
            long expSize = remoteMeta.sizeInBytes();
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expSize, (long)info.size());
            SnapshotInfoEx infoEx = gg.snapshot().snapshot(new SnapshotInfoParams().snapshotId(id).optionalSearchPaths(Arrays.asList(moveDir)));
            SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expSize, (long)infoEx.size());
            if (afterCheckSizeC == null) continue;
            afterCheckSizeC.accept(info, infoEx);
        }
    }

    private static SnapshotMetadataV2 localMeta(Ignite n, long id) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        try {
            return StreamSupport.stream(snapMgr.snapshotSpi().localSnapshots(false).spliterator(), false).filter(snapMeta -> snapMeta.id() == id).findAny().get();
        }
        catch (IgniteCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Long, Long> localWalSizes(Ignite n) {
        Iterable snapIter;
        IgniteEx nEx = (IgniteEx)n;
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)nEx.context().cache().context().snapshot();
        try {
            snapIter = snapMgr.snapshotSpi().localSnapshots(false);
        }
        catch (IgniteCheckedException e2) {
            throw new IgniteException((Throwable)e2);
        }
        TreeMap locMetas = StreamSupport.stream(snapIter.spliterator(), false).collect(Collectors.toMap(SnapshotMetadataV2::id, Function.identity(), (m0, m1) -> {
            throw new RuntimeException();
        }, TreeMap::new));
        HashMap<Long, Long> walSizes = new HashMap<Long, Long>();
        FileWriteAheadLogManager walMgr = SnapshotSizeSelfTest.walMgr((IgniteEx)nEx);
        for (SnapshotMetadataV2 currVal : locMetas.values()) {
            FileWALPointer startPtr = (FileWALPointer)F.firstEntry((Map)currVal.walPoints()).getValue();
            FileWALPointer endPtr = (FileWALPointer)Optional.ofNullable(locMetas.higherEntry(currVal.id())).map(e -> (WALPointer)F.firstEntry((Map)((SnapshotMetadataV2)e.getValue()).walPoints()).getValue()).orElseGet(() -> ((FileWriteAheadLogManager)walMgr).lastWritePointer());
            long walSize = LongStream.range(startPtr.index(), endPtr.index()).map(arg_0 -> ((FileWriteAheadLogManager)walMgr).segmentSize(arg_0)).sum();
            if (locMetas.higherEntry(currVal.id()) == null) {
                walSize += (long)(endPtr.fileOffset() + endPtr.length());
            }
            walSizes.put(currVal.id(), walSize);
        }
        return walSizes;
    }

    private static SnapshotMetadataV2 remoteMeta(GridGainImpl gg, long id, File searchPath) {
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        try {
            return StreamSupport.stream(snapMgr.snapshotSpi().listRemoteSnapshots((SnapshotPath)new FsSnapshotPath(searchPath)).spliterator(), false).filter(snapMeta -> snapMeta.id() == id).findAny().get();
        }
        catch (IgniteCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Long, Long> remoteWalSizes(Ignite n, File dir) {
        GridGainImpl gg = (GridGainImpl)n.plugin("GridGain");
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)gg.provider().databaseManager();
        return snapMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)new FsSnapshotPath(dir));
    }

    private static /* synthetic */ void lambda$testRemoteCheckingSnapshotSizeWithPitr$11(Supplier walSizeSupplier, SnapshotInfo info, SnapshotInfoEx ex) {
        String idStr = String.valueOf(info.snapshotId());
        long expWalSize = (Long)((Map)walSizeSupplier.get()).get(info.snapshotId());
        SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expWalSize, (long)info.walSize());
        SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expWalSize, (long)ex.walSize());
    }

    private static /* synthetic */ void lambda$testLocalCheckingSnapshotSizeWithPitr$1(Supplier walSizeSupplier, SnapshotInfo info, SnapshotInfoEx ex) {
        long expWalSize = (Long)((Map)walSizeSupplier.get()).get(info.snapshotId());
        String idStr = String.valueOf(info.snapshotId());
        SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expWalSize, (long)info.walSize());
        SnapshotSizeSelfTest.assertEquals((String)idStr, (long)expWalSize, (long)ex.walSize());
    }
}

