/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotTestFuture;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class SnapshotOperationFutureTopologyVersionTest
extends AbstractSnapshotTest {
    private static final int NODES_CNT = 4;

    @Test
    public void testChangeBaseline() throws Exception {
        this.startGrids(4);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicReference<Object> err = new AtomicReference<Object>(null);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            while (!stop.get()) {
                try {
                    this.stopGrid(3);
                    ignite.cluster().setBaselineTopology(ignite.cluster().forServers().nodes());
                    this.awaitPartitionMapExchange();
                    this.startGrid(3);
                    ignite.cluster().setBaselineTopology(ignite.cluster().forServers().nodes());
                    this.awaitPartitionMapExchange();
                }
                catch (Throwable t) {
                    log.error("Unexpected error: ", t);
                    err.compareAndSet(null, t);
                }
            }
        }, (String)"change-blt-thread");
        long curTs = System.currentTimeMillis();
        boolean timedOut = false;
        while (System.currentTimeMillis() - curTs < 30000L) {
            GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
            SnapshotFuture testFut = mgr.startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"DELEGATE_FACTORY", (Object)TestFutureFactory.class.getName()), null);
            try {
                testFut.get(20000L);
            }
            catch (IgniteFutureTimeoutException ignored) {
                timedOut = true;
                break;
            }
        }
        stop.set(true);
        fut.get();
        SnapshotOperationFutureTopologyVersionTest.assertNull(err.get());
        if (timedOut) {
            SnapshotOperationFutureTopologyVersionTest.fail((String)"Snapshot operation timed out.");
        }
    }

    public static class TestFutureFactory
    implements SnapshotTestFuture.DelegateFactory {
        public SnapshotOperationFuture<Object> createDelegate(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
            return new TestFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        }

        public static class TestFuture
        extends SnapshotTestFuture {
            TestFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
                super(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
            }

            @Nullable
            protected SnapshotOperationFuture<Object> createDelegate(SnapshotOperationInfoImpl snapshotInfo) {
                return null;
            }

            protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
                if (!success) {
                    return SnapshotOperationStage.CANCELLED;
                }
                switch (stage) {
                    case FIRST: {
                        return SnapshotOperationStage.SECOND;
                    }
                    case SECOND: {
                        return SnapshotOperationStage.THIRD;
                    }
                    case THIRD: {
                        return SnapshotOperationStage.FOURTH;
                    }
                    case FOURTH: {
                        return SnapshotOperationStage.FINISH;
                    }
                    case CANCELLED: {
                        return SnapshotOperationStage.CANCELLED;
                    }
                }
                throw new IllegalStateException("Unexpected stage in nextStage, passed stage=" + stage);
            }
        }
    }
}

