/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import junit.framework.TestCase;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.gridgain.grid.internal.processors.cache.database.recovery.WALPointerIntervalProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WALPointerIntervalProgressCalculatorTest
extends TestCase {
    private IgniteLogger mockLogger;
    private int index;

    public void testSameIndexPointer() throws IgniteCheckedException {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(1L, 50, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)0, (Object)recoveryProgressCalculator.addWALPointers(startPointer, endPointer));
        recoveryProgressCalculator.calculateStep();
        recoveryProgressCalculator.reportWork(new FileWALPointer(1L, 0, 10), Integer.valueOf(0));
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 0, 10), 0L, 0.0, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 0, 10), 0L, 0.0, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 50, 10), 50L, 1.0, 2);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 50, 10), 50L, 1.0, 2);
        recoveryProgressCalculator.reportWork(new FileWALPointer(1L, 10001, 10), Integer.valueOf(0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContext});
        ((IgniteLogger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.times((int)1))).isDebugEnabled();
    }

    public void testDifferentIndexPointer() throws IgniteCheckedException {
        FileWALPointer initPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(2L, 50, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)0, (Object)recoveryProgressCalculator.addWALPointers(initPointer, endPointer));
        recoveryProgressCalculator.calculateStep();
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 0, 10), 0L, 0.0, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 0, 10), 0L, 0.0, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 50, 10), 50L, 0.33, 2);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(2L, 0, 10), 100L, 0.67, 3);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(2L, 0, 10), 100L, 0.67, 3);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(2L, 50, 10), 150L, 1.0, 4);
    }

    private void testProgress(SnapshotOperationContext mockContext, WALPointerIntervalProgressCalculator recoveryProgressCalculator, FileWALPointer walPointer, long expectedWork, double expectedProgress, int expectedInvocations) {
        recoveryProgressCalculator.reportWork(walPointer, Integer.valueOf(this.index));
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((SnapshotOperationContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)expectedInvocations))).reportWork(((Long)captor.capture()).longValue());
        WALPointerIntervalProgressCalculatorTest.assertEquals((long)expectedWork, (long)((Long)captor.getValue()));
        WALPointerIntervalProgressCalculatorTest.assertEquals((double)expectedProgress, (double)((double)recoveryProgressCalculator.progress(((Long)captor.getValue()).longValue()) / (double)recoveryProgressCalculator.total()), (double)0.005);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    public void testEqualPointers() {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(1L, 0, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        try {
            WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
            recoveryProgressCalculator.addWALPointers(startPointer, endPointer);
            WALPointerIntervalProgressCalculatorTest.fail((String)"Validation should fail, passing equal pointers");
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
    }

    public void testNullIndex() throws IgniteCheckedException {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(1L, 1, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)0, (Object)recoveryProgressCalculator.addWALPointers(startPointer, endPointer));
        recoveryProgressCalculator.calculateStep();
        recoveryProgressCalculator.reportWork(new FileWALPointer(1L, 1, 10), null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((SnapshotOperationContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).reportWork(((Long)captor.capture()).longValue());
    }

    public void testSmallStep() throws IgniteCheckedException {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(1L, 1, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)0, (Object)recoveryProgressCalculator.addWALPointers(startPointer, endPointer));
        recoveryProgressCalculator.calculateStep();
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 0, 10), 0L, 0.0, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 1, 10), 1L, 1.0, 2);
    }

    public void testTwoIterators() throws IgniteCheckedException {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        FileWALPointer endPointer = new FileWALPointer(2L, 50, 10);
        FileWALPointer startPointer2 = new FileWALPointer(10L, 0, 10);
        FileWALPointer endPointer2 = new FileWALPointer(11L, 50, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)0, (Object)recoveryProgressCalculator.addWALPointers(startPointer, endPointer));
        WALPointerIntervalProgressCalculatorTest.assertEquals((Object)1, (Object)recoveryProgressCalculator.addWALPointers(startPointer2, endPointer2));
        recoveryProgressCalculator.calculateStep();
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 25, 10), 25L, 0.08, 1);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(2L, 25, 10), 125L, 0.42, 2);
        this.testProgress(mockContext, recoveryProgressCalculator, endPointer, 150L, 0.5, 3);
        this.index = 1;
        this.testProgress(mockContext, recoveryProgressCalculator, startPointer2, 150L, 0.5, 3);
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(11L, 0, 10), 250L, 0.83, 4);
        this.testProgress(mockContext, recoveryProgressCalculator, endPointer2, 300L, 1.0, 5);
    }

    public void addNullEndPointer() throws IgniteCheckedException {
        FileWALPointer startPointer = new FileWALPointer(1L, 0, 10);
        SnapshotOperationContext mockContext = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        this.mockLogger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(100, 2, mockContext, this.mockLogger);
        WALPointerIntervalProgressCalculatorTest.assertNull((Object)recoveryProgressCalculator.addWALPointers(startPointer, null));
        this.testProgress(mockContext, recoveryProgressCalculator, new FileWALPointer(1L, 25, 10), 0L, 0.0, 0);
        ((IgniteLogger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.times((int)1))).isDebugEnabled();
    }
}

