/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationProcessor;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class GridPointInTimeRecoveryWithoutExchangeTest
extends GridPointInTimeRecoveryAbstractTest {
    private LogListener exchangelessEnabledLsnr = LogListener.matches((String)"Snapshot worker started new snapshot operation").andMatches("exchangelessSnapshot=true").andMatches("EXCHANGELESS_SNAPSHOT=true").build();
    private LogListener exchangelessDesabledLsnr = LogListener.matches((String)"Snapshot worker started new snapshot operation").andMatches("exchangelessSnapshot=false").andMatches("EXCHANGELESS_SNAPSHOT=false").build();
    private final ListeningTestLogger testLog = new ListeningTestLogger(this.log(), new LogListener[]{this.exchangelessEnabledLsnr, this.exchangelessDesabledLsnr});

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)this.testLog);
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void testExchangelessLogMessages() throws Exception {
        IgniteEx g0 = this.startGrids(2);
        g0.cluster().state(ClusterState.ACTIVE);
        GridPointInTimeRecoveryWithoutExchangeTest.assertFalse((boolean)this.exchangelessEnabledLsnr.check());
        GridPointInTimeRecoveryWithoutExchangeTest.assertTrue((boolean)this.exchangelessDesabledLsnr.check());
        this.exchangelessEnabledLsnr.reset();
        this.exchangelessDesabledLsnr.reset();
        SnapshotCreateParams createParams = new SnapshotCreateParams(CompressionOption.NONE, -1, 0, true);
        ((GridGain)g0.plugin("GridGain")).snapshot().createFullSnapshot(null, null, createParams, null).get();
        GridPointInTimeRecoveryWithoutExchangeTest.assertTrue((boolean)this.exchangelessEnabledLsnr.check());
        GridPointInTimeRecoveryWithoutExchangeTest.assertFalse((boolean)this.exchangelessDesabledLsnr.check());
        this.exchangelessEnabledLsnr.reset();
        this.exchangelessDesabledLsnr.reset();
        DistributedConfigurationProcessor distrProc = g0.context().distributedConfiguration();
        DistributedChangeableProperty prop = distrProc.property("exchangelessPointInTimeRecoveryEnabled");
        MatcherAssert.assertThat((String)("Distributed property exchangelessPointInTimeRecoveryEnabled is not registered or has unexpected type [prop=" + prop + ']'), (Object)prop, (Matcher)Matchers.isA(DistributedBooleanProperty.class));
        DistributedBooleanProperty exchangelessPitrProp = (DistributedBooleanProperty)prop;
        exchangelessPitrProp.propagate((Serializable)Boolean.valueOf(false));
        ((GridGain)g0.plugin("GridGain")).snapshot().createFullSnapshot(null, null, createParams, null).get();
        GridPointInTimeRecoveryWithoutExchangeTest.assertFalse((boolean)this.exchangelessEnabledLsnr.check());
        GridPointInTimeRecoveryWithoutExchangeTest.assertTrue((boolean)this.exchangelessDesabledLsnr.check());
    }
}

