/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationProcessor;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class GridPointInTimeRecoveryDistributedPropertyTest
extends GridCommonAbstractTest {
    private static final String CLIENT = "client";
    private boolean pitrEnabled;
    private final LogListener crdInitFromConfigLsnrEnabled = LogListener.matches((String)"Parameter 'pointInTimeRecoveryEnabled' has been picked up from configuration, point-in-time recovery is now enabled.").build();
    private final LogListener applyingClusterWideLsnrEnabled = LogListener.matches((String)"Ignoring configuration property 'pointInTimeRecoveryEnabled', applying cluster-wide property value, point-in-time recovery is now enabled.").build();
    private final LogListener crdInitFromConfigLsnrDisabled = LogListener.matches((String)"Parameter 'pointInTimeRecoveryEnabled' has been picked up from configuration, point-in-time recovery is now disabled.").build();
    private final LogListener applyingClusterWideLsnrDisabled = LogListener.matches((String)"Ignoring configuration property 'pointInTimeRecoveryEnabled', applying cluster-wide property value, point-in-time recovery is now disabled.").build();
    private final LogListener mixedClusterWarningLsnr = LogListener.matches((String)"There are nodes in cluster that don't support pointInTimeRecoveryEnabled distributed property, using value from node configuration, point-in-time recovery is now ").build();
    private final ListeningTestLogger testLog = new ListeningTestLogger(this.log(), new LogListener[]{this.crdInitFromConfigLsnrEnabled, this.applyingClusterWideLsnrEnabled, this.crdInitFromConfigLsnrDisabled, this.applyingClusterWideLsnrDisabled, this.mixedClusterWarningLsnr});

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(this.pitrEnabled))}).setGridLogger((IgniteLogger)this.testLog).setClientMode(igniteInstanceName.startsWith(CLIENT));
    }

    private void checkPITREnabled(IgniteEx ignite, boolean expected) {
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)expected, (boolean)snapshotManager.pointInTimeRecoveryEnabled());
    }

    private void checkExchangelessPITREnabled(IgniteEx ignite, boolean expected) {
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((String)"Unexpected value of the exchangeless PITR mode.", (boolean)expected, (boolean)snapshotManager.exchangelessPointInTimeRecoveryModeEnabled());
    }

    @Test
    public void testPropertyOnNodesInitiallyEnabled() throws Exception {
        this.testPropertyOnNodes(true);
    }

    @Test
    public void testPropertyOnNodesInitiallyDisabled() throws Exception {
        this.testPropertyOnNodes(false);
    }

    @Test
    public void testExchangelessPitrModeChanging() throws Exception {
        this.pitrEnabled = true;
        IgniteEx ignite0 = this.startGrid(0);
        ignite0.cluster().state(ClusterState.ACTIVE);
        this.checkExchangelessPITREnabled(ignite0, true);
    }

    @Test
    public void testExchangelessPitrMode() throws Exception {
        this.pitrEnabled = true;
        IgniteEx ignite0 = this.startGrid(0);
        ignite0.cluster().state(ClusterState.ACTIVE);
        this.checkExchangelessPITREnabled(ignite0, true);
        DistributedConfigurationProcessor distrProc = ignite0.context().distributedConfiguration();
        DistributedChangeableProperty prop = distrProc.property("exchangelessPointInTimeRecoveryEnabled");
        MatcherAssert.assertThat((String)("Distributed property exchangelessPointInTimeRecoveryEnabled is not registered or has unexpected type [prop=" + prop + ']'), (Object)prop, (Matcher)Matchers.isA(DistributedBooleanProperty.class));
        DistributedBooleanProperty modeProp = (DistributedBooleanProperty)prop;
        modeProp.propagate((Serializable)Boolean.valueOf(false));
        this.checkExchangelessPITREnabled(ignite0, false);
    }

    private void testPropertyOnNodes(boolean initiallyEnabled) throws Exception {
        this.pitrEnabled = initiallyEnabled;
        IgniteEx ignite0 = this.startGrid(0);
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)initiallyEnabled, (boolean)this.crdInitFromConfigLsnrEnabled.check());
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((!initiallyEnabled ? 1 : 0) != 0, (boolean)this.crdInitFromConfigLsnrDisabled.check());
        this.checkPITREnabled(ignite0, initiallyEnabled);
        IgniteEx ignite1 = this.startGrid(1);
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)initiallyEnabled, (boolean)this.applyingClusterWideLsnrEnabled.check());
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((!initiallyEnabled ? 1 : 0) != 0, (boolean)this.applyingClusterWideLsnrDisabled.check());
        this.checkPITREnabled(ignite1, initiallyEnabled);
        this.applyingClusterWideLsnrEnabled.reset();
        this.pitrEnabled = false;
        IgniteEx ignite2 = this.startGrid(2);
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)initiallyEnabled, (boolean)this.applyingClusterWideLsnrEnabled.check());
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((!initiallyEnabled ? 1 : 0) != 0, (boolean)this.applyingClusterWideLsnrDisabled.check());
        this.checkPITREnabled(ignite2, initiallyEnabled);
        ignite0.cluster().state(ClusterState.ACTIVE);
        this.stopGrid(0);
        this.applyingClusterWideLsnrEnabled.reset();
        IgniteEx ignite3 = this.startGrid(3);
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)initiallyEnabled, (boolean)this.applyingClusterWideLsnrEnabled.check());
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((!initiallyEnabled ? 1 : 0) != 0, (boolean)this.applyingClusterWideLsnrDisabled.check());
        this.checkPITREnabled(ignite3, initiallyEnabled);
        this.stopAllGrids();
        this.applyingClusterWideLsnrEnabled.reset();
        ignite0 = this.startGrid(0);
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((boolean)initiallyEnabled, (boolean)this.applyingClusterWideLsnrEnabled.check());
        GridPointInTimeRecoveryDistributedPropertyTest.assertEquals((!initiallyEnabled ? 1 : 0) != 0, (boolean)this.applyingClusterWideLsnrDisabled.check());
        this.checkPITREnabled(ignite0, initiallyEnabled);
        this.stopAllGrids();
        Thread t = new Thread(() -> {
            try {
                IgniteEx client = this.startGrid(CLIENT);
                this.checkPITREnabled(client, initiallyEnabled);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
        GridPointInTimeRecoveryDistributedPropertyTest.doSleep((long)1000L);
        ignite0 = this.startGrid(0);
        this.checkPITREnabled(ignite0, initiallyEnabled);
        t.join();
        GridPointInTimeRecoveryDistributedPropertyTest.assertFalse((boolean)this.mixedClusterWarningLsnr.check());
    }
}

