/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.List;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeBaselineChangedTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    protected long getTestTimeout() {
        return super.getTestTimeout() * 4L;
    }

    @Test
    public void testSnapshotDisabledAfterBaselineChangedBecauseOneNodeHasFlag() throws Exception {
        GridPointInTimeBaselineChangedTest.assertFalse((String)"GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR should be false by default", (boolean)IgniteSystemProperties.getBoolean((String)"GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", (boolean)false));
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        System.setProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", "true");
        try {
            this.startGrid(2);
        }
        finally {
            System.clearProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR");
        }
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        List snapshotsBeforeBaselineChanged = gg.snapshot().list();
        this.startGrid(3);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        List snapshotsAfterBaselineChanged = gg.snapshot().list();
        GridPointInTimeBaselineChangedTest.assertEquals((Object)snapshotsBeforeBaselineChanged, (Object)snapshotsAfterBaselineChanged);
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"tmp", (boolean)false));
    }
}

