/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class SnapshotOperationsAfterMoveTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_1_NAME = "cache1";
    private static final String CACHE_2_NAME = "cache2";
    private static final int ENTRIES_COUNT = 300;
    private File moveDir;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x20000000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        BinaryConfiguration bCfg = new BinaryConfiguration();
        bCfg.setCompactFooter(false);
        cfg.setBinaryConfiguration(bCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_1_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        CacheConfiguration ccfg2 = new CacheConfiguration();
        ccfg2.setName(CACHE_2_NAME);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    @Test
    public void testMoveSnapshotAndRestore() throws Exception {
        this.startGrids(3);
        this.grid(0).active(true);
        this.awaitPartitionMapExchange();
        SnapshotFuture<Void> fut = this.populateCachesAndMoveSnapshot();
        fut.get();
        this.clearConsistentIdDirsMetadata();
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(this.moveDir), null, null).get();
        IgniteCache cache1 = ignite.cache(CACHE_1_NAME);
        IgniteCache cache2 = ignite.cache(CACHE_2_NAME);
        for (int i = 0; i < 300; ++i) {
            SnapshotOperationsAfterMoveTest.assertEquals((int)i, (int)((Integer)cache1.get((Object)i)));
            SnapshotOperationsAfterMoveTest.assertEquals((int)i, (int)((Integer)cache2.get((Object)i)));
        }
    }

    @Test
    public void testMoveSnapshotAndCheck() throws Exception {
        this.startGrids(3);
        this.grid(0).active(true);
        this.awaitPartitionMapExchange();
        SnapshotFuture<Void> fut = this.populateCachesAndMoveSnapshot();
        fut.get();
        this.clearConsistentIdDirsMetadata();
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(this.moveDir), false, null).get();
        SnapshotOperationsAfterMoveTest.assertTrue((boolean)issues.isEmpty());
    }

    @Test
    public void testMoveSnapshotAndInfo() throws Exception {
        this.startGrids(3);
        this.grid(0).active(true);
        this.awaitPartitionMapExchange();
        SnapshotFuture<Void> fut = this.populateCachesAndMoveSnapshot();
        fut.get();
        this.clearConsistentIdDirsMetadata();
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotInfoEx info = gg.snapshot().snapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(this.moveDir));
        SnapshotOperationsAfterMoveTest.assertEquals((Object)ignite.cluster().localNode().id(), (Object)info.initiatorNode());
    }

    @Test
    public void testMoveSnapshotAndList() throws Exception {
        this.startGrids(3);
        this.grid(0).active(true);
        this.awaitPartitionMapExchange();
        SnapshotFuture<Void> fut = this.populateCachesAndMoveSnapshot();
        fut.get();
        this.clearConsistentIdDirsMetadata();
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        List snapshotInfos = gg.snapshot().listSnapshots(Collections.singleton(this.moveDir));
        SnapshotOperationsAfterMoveTest.assertEquals((int)2, (int)snapshotInfos.size());
    }

    private SnapshotFuture<Void> populateCachesAndMoveSnapshot() throws Exception {
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache(CACHE_1_NAME);
        IgniteCache cache2 = ignite.cache(CACHE_2_NAME);
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)i);
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)(-i));
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null);
        fut2.get();
        return gg.snapshot().forceMoveSnapshot(fut.snapshotOperation().snapshotId(), this.moveDir, null);
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
        this.moveDir = this.createOrCleanMoveDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
        U.delete((File)this.moveDir);
    }

    @NotNull
    private File createOrCleanMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        U.delete((File)moveDir);
        moveDir.mkdirs();
        return moveDir;
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    private void clearConsistentIdDirsMetadata() throws IgniteCheckedException {
        for (File snapshotDir : this.moveDir.listFiles()) {
            for (File consistentIdDir : snapshotDir.listFiles()) {
                if (!consistentIdDir.isDirectory()) continue;
                for (File f : consistentIdDir.listFiles()) {
                    if (!f.isFile() || !f.toString().endsWith("snapshot-meta.bin") || f.delete()) continue;
                    this.info("Failed to delete: " + f);
                }
            }
        }
    }
}

