/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotNodeLeftDuringSnapshotOperationTest
extends GridCommonAbstractTest {
    private static final int NODES = 8;
    private static final int NON_BLT_NODES = 2;
    private static final int NODES_LEFT = 2;
    private static final int CACHES = 4;
    private static final int ENTRIES = 2048;
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private Set<String> snapshotDirs = new HashSet<String>();

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(gridName));
        this.snapshotDirs.add(gridName);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        AtomicConfiguration atomicCfg = new AtomicConfiguration();
        atomicCfg.setCacheMode(CacheMode.REPLICATED);
        cfg.setAtomicConfiguration(atomicCfg);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(ipFinder));
        CacheConfiguration[] ccfgs = new CacheConfiguration[4];
        for (int i = 0; i < 4; ++i) {
            CacheConfiguration ccfg = new CacheConfiguration("cache" + i);
            ccfg.setBackups(i + 1);
            ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
            ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
            ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            ccfgs[i] = ccfg;
        }
        cfg.setCacheConfiguration(ccfgs);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.deleteWorkFiles();
        for (int node = 0; node < 8; ++node) {
            this.startGrid(node);
        }
        this.grid(0).active(true);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void testLeftNodesDuringSnapshotCreation() throws Exception {
        IgniteEx ig = this.grid(1);
        GridGainImpl gg = (GridGainImpl)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.loadData(0);
        SnapshotFuture snapFut = snp.createFullSnapshot(null, "snapshot");
        snapFut.initFuture().get();
        gg = (GridGainImpl)this.grid(0).plugin("GridGain");
        GridCacheSnapshotManager manager = (GridCacheSnapshotManager)gg.provider().databaseManager();
        SnapshotOperationFuture snapOpFut = manager.snapshotFuture();
        SnapshotNodeLeftDuringSnapshotOperationTest.assertNotNull((Object)snapOpFut);
        this.stopGrid(1, false);
        try {
            snapOpFut.get();
        }
        catch (Exception e) {
            SnapshotNodeLeftDuringSnapshotOperationTest.fail((String)"Snasphot should be successful after one node left");
        }
    }

    @Test
    public void testLeftNodesDuringRestore() throws Exception {
        IgniteEx ig = this.grid(0);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.loadData(0);
        this.checkData(Sets.newHashSet(), 0);
        SnapshotFuture snapFut = snp.createFullSnapshot(null, "snapshot");
        snapFut.get();
        long snapshotId = snapFut.snapshotOperation().snapshotId();
        this.loadData(10);
        this.checkData(Sets.newHashSet(), 10);
        final SnapshotFuture restoreFut0 = snp.restoreSnapshot(snapshotId, null, "restore");
        this.info("2 will be stopped during restore.");
        GridConcurrentHashSet stoppedNodeIds = new GridConcurrentHashSet();
        AtomicBoolean started = new AtomicBoolean();
        restoreFut0.initFuture().listen((IgniteInClosure)new CI1<IgniteFuture<Void>>((Set)stoppedNodeIds, started){
            final /* synthetic */ Set val$stoppedNodeIds;
            final /* synthetic */ AtomicBoolean val$started;
            {
                this.val$stoppedNodeIds = set;
                this.val$started = atomicBoolean;
            }

            public void apply(IgniteFuture<Void> future) {
                IgniteInternalFuture nodeStopFut = GridTestUtils.runAsync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (int node = 7; node >= 6; --node) {
                            SnapshotNodeLeftDuringSnapshotOperationTest.this.info("Stop node " + SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(node).name());
                            try {
                                SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(node).close();
                                continue;
                            }
                            finally {
                                val$stoppedNodeIds.add(node);
                            }
                        }
                    }
                });
                try {
                    nodeStopFut.get();
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)"Exception during node stop.", (Throwable)e);
                }
                this.val$started.set(true);
            }
        });
        while (!started.get()) {
            Thread.sleep(1000L);
        }
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new GPC<Void>(){

            public Void call() throws Exception {
                restoreFut0.get();
                return null;
            }
        }, IgniteException.class, (String)"Failed to complete snapshot operation");
        this.info("Start new node and try restore.");
        for (Integer nodeId : stoppedNodeIds) {
            this.startGrid(nodeId);
        }
        SnapshotFuture restoreFut2 = snp.restoreSnapshot(snapshotId, null, "restore");
        restoreFut2.get();
        this.info("Check after restore");
        this.checkData(Sets.newHashSet(), 0);
    }

    @Test
    public void testLeftNonBaselineNodeDuringRestore() throws Exception {
        IgniteEx ig = this.grid(0);
        for (int i = 8; i < 10; ++i) {
            this.startGrid(i);
        }
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.loadData(0);
        this.checkData(Sets.newHashSet(), 0);
        SnapshotFuture snapFut = snp.createFullSnapshot(null, "snapshot");
        snapFut.get();
        long snapshotId = snapFut.snapshotOperation().snapshotId();
        this.loadData(10);
        this.checkData(Sets.newHashSet(), 10);
        SnapshotFuture restoreFut0 = snp.restoreSnapshot(snapshotId, null, "restore");
        this.info("2 non baseline nodes will be stopped during restore.");
        final AtomicBoolean started = new AtomicBoolean();
        restoreFut0.initFuture().listen((IgniteInClosure)new CI1<IgniteFuture<Void>>(){

            public void apply(IgniteFuture<Void> future) {
                IgniteInternalFuture nodeStopFut = GridTestUtils.runAsync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 8; i < 10; ++i) {
                            SnapshotNodeLeftDuringSnapshotOperationTest.this.info("Stop node " + SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(i).name());
                            SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(i).close();
                        }
                    }
                });
                try {
                    nodeStopFut.get();
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)"Exception during node stop.", (Throwable)e);
                }
                started.set(true);
            }
        });
        while (!started.get()) {
            Thread.sleep(1000L);
        }
        try {
            restoreFut0.get();
        }
        catch (IgniteException e) {
            SnapshotNodeLeftDuringSnapshotOperationTest.fail((String)("Failed to complete snapshot operation: " + (Object)((Object)e)));
        }
        this.info("Check after restore");
        this.checkData(Sets.newHashSet(), 0);
    }

    @Test
    public void testCoordinatorLeft() throws Exception {
        IgniteEx ig = this.grid(0);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snp = gg.snapshot();
        this.loadData(0);
        this.checkData(Sets.newHashSet(), 0);
        SnapshotFuture snapFut = snp.createFullSnapshot(null, "snapshot");
        snapFut.get();
        long snapshotId = snapFut.snapshotOperation().snapshotId();
        this.loadData(10);
        this.checkData(Sets.newHashSet(), 10);
        final SnapshotFuture restoreFut0 = snp.restoreSnapshot(snapshotId, null, "restore");
        this.info("2 will be stopped during restore.");
        GridConcurrentHashSet stoppedNodeIds = new GridConcurrentHashSet();
        final AtomicInteger cnt = new AtomicInteger(2);
        CountDownLatch stoppedNodes = new CountDownLatch(2);
        restoreFut0.initFuture().listen((IgniteInClosure)new CI1<IgniteFuture<Void>>((Set)stoppedNodeIds, stoppedNodes){
            final /* synthetic */ Set val$stoppedNodeIds;
            final /* synthetic */ CountDownLatch val$stoppedNodes;
            {
                this.val$stoppedNodeIds = set;
                this.val$stoppedNodes = countDownLatch;
            }

            public void apply(IgniteFuture<Void> future) {
                GridTestUtils.runAsync((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (cnt.get() > 0) {
                            int node = 2 - cnt.getAndDecrement();
                            IgniteEx ig = SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(node);
                            SnapshotNodeLeftDuringSnapshotOperationTest.this.info("Node " + ig.name() + " stopped.");
                            try {
                                ig.close();
                            }
                            catch (Throwable e) {
                                U.error((IgniteLogger)log, (Object)"Exception during node stop.", (Throwable)e);
                            }
                            finally {
                                val$stoppedNodeIds.add(node);
                                val$stoppedNodes.countDown();
                            }
                        }
                    }
                });
            }
        });
        stoppedNodes.await();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new GPC<Void>(){

            public Void call() throws Exception {
                restoreFut0.get();
                return null;
            }
        }, IgniteException.class, (String)"Node stopping.");
        this.info("Start new node and try restore.");
        assert (stoppedNodeIds.size() == 2);
        U.sleep((long)5000L);
        for (Integer nodeId : stoppedNodeIds) {
            try {
                this.startGrid(nodeId);
            }
            catch (Exception ex) {
                IgniteSpiException cause;
                if (X.hasCause((Throwable)ex, (Class[])new Class[]{IgniteSpiException.class}) && (cause = (IgniteSpiException)X.cause((Throwable)ex, IgniteSpiException.class)).getMessage().startsWith("BaselineTopology of joining node")) {
                    return;
                }
                SnapshotNodeLeftDuringSnapshotOperationTest.fail();
            }
        }
        IgniteEx lastNode = this.grid(7);
        gg = (GridGain)lastNode.plugin("GridGain");
        snp = gg.snapshot();
        SnapshotFuture restoreFut2 = snp.restoreSnapshot(snapshotId, null, "restore");
        restoreFut2.get();
        this.info("Check after restore");
        this.checkData(Sets.newHashSet(), 0);
    }

    private void loadData(final int offset) throws Exception {
        final AtomicInteger cnt = new AtomicInteger(4);
        GridTestUtils.runMultiThreaded((Runnable)new Runnable(){

            @Override
            public void run() {
                int id = cnt.decrementAndGet();
                String cacheName = "cache" + id;
                IgniteEx ig = SnapshotNodeLeftDuringSnapshotOperationTest.this.grid(id);
                try (IgniteDataStreamer st = ig.dataStreamer(cacheName);){
                    st.allowOverwrite(true);
                    for (int key = 0; key < 2048; ++key) {
                        st.addData((Object)key, (Object)("entry" + (key + offset)));
                        if (key % 1000 != 0) continue;
                        SnapshotNodeLeftDuringSnapshotOperationTest.this.info("load " + key + " entries on " + ig.name() + " offset " + offset);
                    }
                }
            }
        }, (int)4, (String)"loader");
    }

    private void checkData(Set<Integer> leftNodes, int offset) {
        LinkedHashMap missed = new LinkedHashMap();
        for (int node = 0; node < 8; ++node) {
            if (leftNodes.contains(node)) continue;
            IgniteEx ig = this.grid(node);
            LinkedHashMap cacheMiss = new LinkedHashMap();
            missed.put(node, cacheMiss);
            for (int i = 0; i < 4; ++i) {
                String cacheName = "cache" + i;
                IgniteCache cache = ig.cache(cacheName);
                ArrayList<Integer> missVal = new ArrayList<Integer>();
                for (int key = 0; key < 2048; ++key) {
                    String exp = "entry" + (key + offset);
                    if (!exp.equals(cache.get((Object)key))) {
                        missVal.add(key);
                    }
                    if (key % 1000 != 0) continue;
                    this.info("checked " + key + " in " + cacheName + " entries on " + ig.name() + " offset " + offset);
                }
                cacheMiss.put(cacheName, missVal);
            }
        }
        boolean fail = false;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : missed.entrySet()) {
            sb.append("Node ").append(this.grid((Integer)entry.getKey()).name()).append("\n");
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                sb.append("Cache ").append((String)entry1.getKey()).append("\n");
                for (Integer key : (List)entry1.getValue()) {
                    fail = true;
                    sb.append(key).append("\n");
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        this.info(sb.toString());
        if (fail) {
            SnapshotNodeLeftDuringSnapshotOperationTest.fail();
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        for (String snapshotDir : this.snapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
    }
}

