/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotMultiversionPageStoreTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_NAME = "cache1";
    private static final int ENTRIES_COUNT = 5000;
    private static final int PARTS = 16;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(1000L);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setCacheMode(CacheMode.PARTITIONED);
        ccfg1.setBackups(1);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void testStartWithLegacyStoreFiles() throws Exception {
        int i;
        System.setProperty("file.page.store.latest.version.override", "1");
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        for (i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.stopAllGrids();
        System.clearProperty("file.page.store.latest.version.override");
        this.startGrids(2);
        ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        cache = ig.getOrCreateCache(CACHE_NAME);
        for (i = 0; i < 5000; ++i) {
            SnapshotMultiversionPageStoreTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    @Test
    public void testMigrateToLatestVersionFullRestore() throws Exception {
        this.checkMigrateToLatestVersionWithRestore(true);
    }

    @Test
    public void testMigrateToLatestVersionIncrementalRestore() throws Exception {
        this.checkMigrateToLatestVersionWithRestore(false);
    }

    private void checkMigrateToLatestVersionWithRestore(boolean fullSnapshot) throws Exception {
        System.setProperty("file.page.store.latest.version.override", "1");
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        for (int i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)(-i));
        }
        GridGain gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        for (int i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SnapshotFuture snapshotFut = fullSnapshot ? gg.snapshot().createFullSnapshot(null, null) : gg.snapshot().createSnapshot(null, null);
        snapshotFut.get();
        this.checkStoreVersions((IgniteCache<Integer, Integer>)cache, 1);
        this.stopAllGrids();
        System.clearProperty("file.page.store.latest.version.override");
        this.startGrids(2);
        ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        gg = (GridGain)ig.plugin("GridGain");
        cache = ig.getOrCreateCache(CACHE_NAME);
        gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), null, null).get();
        for (int i = 0; i < 5000; ++i) {
            SnapshotMultiversionPageStoreTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
        this.checkStoreVersions((IgniteCache<Integer, Integer>)cache, 2);
    }

    private void checkStoreVersions(IgniteCache<Integer, Integer> cache, int ver) throws IgniteCheckedException {
        GridCacheAdapter internalCache = this.internalCache(cache);
        for (int i = 0; i < 16; ++i) {
            FilePageStoreManager storeMgr = (FilePageStoreManager)internalCache.context().shared().pageStore();
            int pageStoreVer = storeMgr.getStore(CU.cacheId((String)CACHE_NAME), i).version();
            SnapshotMultiversionPageStoreTest.assertEquals((int)ver, (int)pageStoreVer);
        }
    }

    @Test
    public void testDifferentVersionsAtTheSameTime() throws Exception {
        int i;
        System.setProperty("file.page.store.latest.version.override", "1");
        this.startGrids(2);
        IgniteEx ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        IgniteCache cache = ig.getOrCreateCache(CACHE_NAME);
        for (i = 0; i < 8; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.stopAllGrids();
        System.clearProperty("file.page.store.latest.version.override");
        this.startGrids(2);
        ig = this.ignite(0);
        ig.active(true);
        this.awaitPartitionMapExchange();
        cache = ig.getOrCreateCache(CACHE_NAME);
        for (i = 8; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        for (i = 0; i < 5000; ++i) {
            SnapshotMultiversionPageStoreTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }
}

