/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.junit.Test;

public class IncrementalSnapshotUnderStressTest
extends AbstractSnapshotTest {
    private static final int CACHES = 3;
    private static final int NODES = 3;
    public static final String CACHE_PREFIX = "IncrementalSnapshotUnderStressTest";
    private final AtomicBoolean stop = new AtomicBoolean();

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.getDataStorageConfiguration().setCheckpointFrequency(1000L);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalSnapshotUnderLoad() throws Exception {
        Thread stressLoader = null;
        try {
            IgniteEx ignite0 = this.startGrids(3);
            ignite0.cluster().active(true);
            this.startCachesDynamically(ignite0);
            stressLoader = this.stressLoadCaches(ignite0);
            GridGain gg = (GridGain)ignite0.plugin("GridGain");
            GridSnapshot snapshot = gg.snapshot();
            snapshot.createFullSnapshot(null, "full snap").get();
            for (int i = 0; i < 5; ++i) {
                snapshot.createSnapshot(null, "inc snap").get();
                Thread.sleep(5000L);
            }
        }
        finally {
            this.stop.set(true);
            if (stressLoader != null) {
                stressLoader.join(this.getTestTimeout());
            }
        }
    }

    private void startCachesDynamically(IgniteEx ignite) {
        ArrayList<CacheConfiguration> ccfg = new ArrayList<CacheConfiguration>(3);
        for (int i = 0; i < 3; ++i) {
            ccfg.add(new CacheConfiguration(CACHE_PREFIX + i).setGroupName(i % 2 == 0 ? "grp-even" : "grp-odd").setBackups(1).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC));
        }
        ignite.createCaches(ccfg);
    }

    private Thread stressLoadCaches(final IgniteEx ign1) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!IncrementalSnapshotUnderStressTest.this.stop.get()) {
                    for (int i = 0; i < 3; ++i) {
                        IgniteCache cache = ign1.cache(IncrementalSnapshotUnderStressTest.CACHE_PREFIX + i);
                        if (i % 2 == 1) continue;
                        long time = System.nanoTime();
                        for (int j = 0; j < 100; ++j) {
                            cache.put((Object)(time + (long)j), i % 2 == 0 ? new CacheValueObj("str " + j) : new CacheValueObj2("str " + j));
                        }
                    }
                }
            }
        };
        thread.start();
        return thread;
    }

    private static class CacheValueObj2 {
        private byte[] payload = new byte[10240];
        private String name;
        private long id;

        public CacheValueObj2(String name) {
            this.name = name;
            this.id = name.hashCode();
        }
    }

    private static class CacheValueObj {
        private byte[] payload = new byte[10240];
        private String marker;
        private long id;

        public CacheValueObj(String marker) {
            this.marker = marker;
            this.id = marker.hashCode();
        }
    }
}

