/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_TEST_SKIP_SNAPSHOT_SYNC", value="true"), @WithSystemProperty(key="IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC", value="true")})
public class IgniteSnapshotUpdateOperationsTest
extends AbstractSnapshotTest {
    protected File moveDir;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanup(true);
        this.moveDir = this.createOrCleanMoveDir();
    }

    @Override
    protected void afterTest() throws Exception {
        System.clearProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE");
        this.cleanup(true);
    }

    private void cleanup(boolean removeMoveDir) throws Exception {
        this.stopAllGrids(true);
        this.cleanSnapshotDirs(removeMoveDir);
    }

    @Test
    public void testThatRemovingLastSnapshotDoesntForceFullSnapshot() throws Exception {
        IgniteEx ex = this.startCluster();
        this.load((Ignite)ex);
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 2);
        gg.snapshot().deleteSnapshot(chain.get(1), new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
        gg.snapshot().createSnapshot(null, null).get();
    }

    @Test
    public void testMoveSingle() throws Exception {
        this.doTestSingle(SnapshotOperationType.MOVE, true);
    }

    @Test
    public void testCopyRestoreOnNewCluster() throws Exception {
        IgniteEx ex = this.startCluster();
        this.load((Ignite)ex);
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 6);
        gg.snapshot().copySnapshot(chain.get(chain.size() - 1), this.moveDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, false, null), null).get();
        int sizeOfValidChain = 3;
        for (int i = 0; i < sizeOfValidChain; ++i) {
            gg.snapshot().copySnapshot(chain.get(i), this.moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, false, null), null).get();
        }
        Set<Long> snapshots = this.getCurrentSnapshots(gg, null);
        for (int i = 0; i < chain.size(); ++i) {
            IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)snapshots.contains(chain.get(i)));
        }
        this.cleanup(false);
        ex = this.startCluster();
        gg = (GridGain)ex.plugin("GridGain");
        GridCacheSnapshotManager snapshot = (GridCacheSnapshotManager)ex.context().cache().context().snapshot();
        if (snapshot.pointInTimeRecoveryEnabled()) {
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)1, (int)this.getCurrentSnapshots(gg, null).size());
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)(sizeOfValidChain + 2), (int)this.getCurrentSnapshots(gg, Collections.singleton(this.moveDir)).size());
        } else {
            IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)this.getCurrentSnapshots(gg, null).isEmpty());
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)(sizeOfValidChain + 1), (int)this.getCurrentSnapshots(gg, Collections.singleton(this.moveDir)).size());
        }
        for (int i = 0; i < sizeOfValidChain; ++i) {
            try {
                gg.snapshot().restoreSnapshot(chain.get(i), Collections.singleton(this.moveDir), null, null).get();
            }
            catch (IgniteException e) {
                e.printStackTrace();
            }
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)300, (int)ex.cache("cache1").size(new CachePeekMode[0]));
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)300, (int)ex.cache("cache2").size(new CachePeekMode[0]));
        }
        try {
            gg.snapshot().restoreSnapshot(chain.get(chain.size() - 1), Collections.singleton(this.moveDir), null, null).get();
            IgniteSnapshotUpdateOperationsTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCopySingle() throws Exception {
        this.doTestSingle(SnapshotOperationType.COPY, true);
    }

    @Test
    public void testDeleteSingle() throws Exception {
        this.doTestSingle(SnapshotOperationType.DELETE, false);
    }

    @Test
    public void testMoveFrom() throws Exception {
        this.doTestFrom(SnapshotOperationType.MOVE, true);
    }

    @Test
    public void testCopyFrom() throws Exception {
        this.doTestFrom(SnapshotOperationType.COPY, true);
    }

    @Test
    public void testDeleteFrom() throws Exception {
        this.doTestFrom(SnapshotOperationType.DELETE, false);
    }

    private void doTestFrom(SnapshotOperationType operation, boolean snapshotsShouldExistAfter) throws Exception {
        IgniteEx ex = this.startCluster();
        GridGain gg = (GridGain)ex.plugin("GridGain");
        this.load((Ignite)ex);
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 6);
        GridLongList chain2 = this.createSnapshotChain(ex, gg.snapshot(), 6);
        GridLongList chain3 = this.createSnapshotChain(ex, gg.snapshot(), 6);
        this.doTest0(ex, gg, operation);
        List<GridLongList> list = Arrays.asList(chain, chain2, chain3);
        Collections.shuffle(list);
        for (GridLongList chn : list) {
            int i;
            long firstUpdated = this.doOperationWithRandomSnapshot(gg.snapshot(), chn, operation, 1, SnapshotChainMode.FROM_CURRENT_TO_LAST).get(0);
            Set<Long> infos = this.getCurrentSnapshots(gg, snapshotsShouldExistAfter ? null : Collections.singleton(this.moveDir));
            for (i = 0; i < chn.size(); ++i) {
                long id = chn.get(i);
                if (id >= firstUpdated) {
                    IgniteSnapshotUpdateOperationsTest.assertFalse((boolean)infos.contains(id));
                    continue;
                }
                IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)infos.contains(id));
            }
            if (!snapshotsShouldExistAfter) continue;
            infos = this.getCurrentSnapshots(gg, Collections.singleton(this.moveDir));
            for (i = 0; i < chn.size(); ++i) {
                IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)infos.contains(chn.get(i)));
            }
            gg.snapshot().restoreSnapshot(chn.get(chn.size() - 1), Collections.singleton(this.moveDir), null, null).get();
        }
    }

    @Test
    public void testSinglePartitionCopyRestrictions() throws Exception {
        IgniteEx ex = this.startCluster(1);
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 2);
        try {
            gg.snapshot().copySnapshot(chain.get(chain.size() - 1), this.moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, true, null), null).get();
            IgniteSnapshotUpdateOperationsTest.fail((String)"'Single partition copy' should fail for incremental snapshot.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gg.snapshot().copySnapshot(chain.get(0), this.moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.FROM_CURRENT_TO_LAST, false, true, null), null).get();
            IgniteSnapshotUpdateOperationsTest.fail((String)"'Single partition copy' should fail for not SINGLE or DEFAULT chain modes.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSinglePartitionCopyWhenWorkIsDoneOnTheFirstBatch() throws Exception {
        System.setProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", Long.toString(Long.MAX_VALUE));
        this.singlePartitionCopyTest();
    }

    @Test
    public void testListInfoWithCopy() throws Exception {
        this.testListAndInfoWithCopy(false);
    }

    @Test
    public void testListInfoWithSingleCopy() throws Exception {
        this.testListAndInfoWithCopy(true);
    }

    private void testListAndInfoWithCopy(boolean singleCopy) throws Exception {
        int i;
        IgniteEx ex = this.startCluster();
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), singleCopy ? 1 : 3);
        GridCacheSnapshotManager snpMgr = (GridCacheSnapshotManager)ex.context().cache().context().snapshot();
        if (snpMgr.pointInTimeRecoveryEnabled()) {
            SnapshotInfo info = (SnapshotInfo)gg.snapshot().list().get(0);
            for (int i2 = 0; i2 < chain.size(); ++i2) {
                IgniteSnapshotUpdateOperationsTest.assertFalse((info.snapshotId() == chain.get(i2) ? 1 : 0) != 0);
            }
            gg.snapshot().deleteSnapshot(info.snapshotId(), new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get();
        }
        int n = i = singleCopy ? 0 : 1;
        while (i < chain.size()) {
            gg.snapshot().copySnapshot(chain.get(i), this.moveDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, singleCopy, null), null).get();
            ++i;
        }
        List infos = gg.snapshot().listSnapshots(Collections.singleton(this.moveDir));
        Map<Long, SnapshotInfo> map = infos.stream().collect(Collectors.toMap(SnapshotInfo::snapshotId, x -> x));
        for (int i3 = 0; i3 < chain.size(); ++i3) {
            int expected = i3 == 0 && !singleCopy ? 1 : 2;
            Map attrs = map.get(chain.get(i3)).snapshotAttributes();
            this.checkPaths(attrs, expected);
            SnapshotInfoEx snapshot = gg.snapshot().snapshot(chain.get(i3), Collections.singleton(this.moveDir));
            this.checkPaths(snapshot.snapshotAttributes(), expected);
        }
    }

    private void checkPaths(Map<Object, Map<String, String>> attrs, int expected) {
        Set folders = SnapshotUtils.getSnapshotFolders(attrs);
        IgniteSnapshotUpdateOperationsTest.assertEquals((int)expected, (int)folders.size());
        if (expected == 1) {
            IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)folders.contains("<LOCAL>"));
        } else {
            IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)folders.stream().anyMatch(x -> x.startsWith(this.moveDir.getAbsolutePath())));
        }
    }

    @Test
    public void testSinglePartitionCopyWhenWorkIsDoneByMinimalBatches() throws Exception {
        System.setProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", "1");
        this.singlePartitionCopyTest();
    }

    private void singlePartitionCopyTest() throws Exception {
        IgniteEx ex = this.startCluster();
        GridGain gg = (GridGain)ex.plugin("GridGain");
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ex.context().cache().context().snapshot();
        boolean pointInTimeRecoveryEnabled = snapshotMgr.pointInTimeRecoveryEnabled();
        this.load((Ignite)ex);
        IgniteSnapshotUpdateOperationsTest.loadWithTestValuesAsync((Ignite)ex, "cache4", 3000, 0).get();
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, null);
        snapFut.get();
        long id = snapFut.snapshotOperation().snapshotId();
        SnapshotFuture future = gg.snapshot().copySnapshot(id, this.moveDir, true, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, true, null), null);
        while (!future.isDone()) {
            SnapshotStatus snapshotStatus = gg.snapshot().ongoingSnapshotOperation();
        }
        future.get();
        List infos = gg.snapshot().list();
        if (pointInTimeRecoveryEnabled) {
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)1, (int)infos.size());
            IgniteSnapshotUpdateOperationsTest.assertFalse((id == ((SnapshotInfo)infos.get(0)).snapshotId() ? 1 : 0) != 0);
        } else {
            IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)infos.isEmpty());
        }
        Set<File> optSearchPaths = Collections.singleton(this.moveDir);
        List infos2 = gg.snapshot().listSnapshots(optSearchPaths);
        if (pointInTimeRecoveryEnabled) {
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)2, (int)infos2.size());
            IgniteSnapshotUpdateOperationsTest.assertEquals((long)id, (long)((SnapshotInfo)infos2.get(1)).snapshotId());
        } else {
            IgniteSnapshotUpdateOperationsTest.assertEquals((int)1, (int)infos2.size());
            IgniteSnapshotUpdateOperationsTest.assertEquals((long)id, (long)((SnapshotInfo)infos2.get(0)).snapshotId());
        }
        List issues = (List)gg.snapshot().checkSnapshot(id, optSearchPaths, false, null).get();
        IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)issues.isEmpty());
        this.checkPartFilesUniqueness();
        ex.cache("cache4").destroy();
        gg.snapshot().restoreSnapshot(id, optSearchPaths, null, null).get();
        IgniteSnapshotUpdateOperationsTest.assertEquals((int)3000, (int)ex.cache("cache4").size(new CachePeekMode[0]));
        this.stopAllGrids(true);
        this.cleanup(false);
        ex = this.startCluster(1);
        gg = (GridGain)ex.plugin("GridGain");
        gg.snapshot().restoreSnapshot(id, optSearchPaths, null, null).get();
        IgniteSnapshotUpdateOperationsTest.assertEquals((int)3000, (int)ex.cache("cache4").size(new CachePeekMode[0]));
        this.stopGrid(0, true);
        IgniteSnapshotUpdateOperationsTest.assertEquals((int)3000, (int)this.grid("dummy").cache("cache4").size(new CachePeekMode[0]));
    }

    private void checkPartFilesUniqueness() {
        File[] files = this.moveDir.listFiles();
        IgniteSnapshotUpdateOperationsTest.assertNotNull((Object)files);
        IgniteSnapshotUpdateOperationsTest.assertEquals((int)1, (int)files.length);
        HashSet<Long> uniqIds = new HashSet<Long>();
        for (File consistentId : files[0].listFiles()) {
            if (!consistentId.isDirectory()) continue;
            for (File grpDirectory : consistentId.listFiles()) {
                int grpId = Integer.parseInt(grpDirectory.getName());
                for (File partIdFile : grpDirectory.listFiles()) {
                    String name = partIdFile.getName();
                    String partIdStr = name.substring("part-".length(), name.length() - ".bin".length());
                    int partId = Integer.parseInt(partIdStr);
                    IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)uniqIds.add(SnapshotUtils.uniquePartId((int)grpId, (int)partId)));
                }
            }
        }
    }

    private void doTestSingle(SnapshotOperationType operation, boolean snapshotsShouldExistAfter) throws Exception {
        IgniteEx ex = this.startCluster();
        GridGain gg = (GridGain)ex.plugin("GridGain");
        this.load((Ignite)ex);
        GridLongList chain = this.createSnapshotChain(ex, gg.snapshot(), 6);
        GridLongList chain2 = this.createSnapshotChain(ex, gg.snapshot(), 6);
        GridLongList chain3 = this.createSnapshotChain(ex, gg.snapshot(), 6);
        this.doTest0(ex, gg, operation);
        List<GridLongList> list = Arrays.asList(chain, chain2, chain3);
        Collections.shuffle(list);
        for (GridLongList chn : list) {
            int i;
            GridLongList updated = this.doOperationWithRandomSnapshot(gg.snapshot(), chn, operation, 3, SnapshotChainMode.SINGLE);
            Set<Long> infos = this.getCurrentSnapshots(gg, snapshotsShouldExistAfter ? null : Collections.singleton(this.moveDir));
            for (i = 0; i < chn.size(); ++i) {
                long id = chn.get(i);
                if (updated.contains(id)) {
                    IgniteSnapshotUpdateOperationsTest.assertFalse((boolean)infos.contains(id));
                    continue;
                }
                IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)infos.contains(id));
            }
            if (!snapshotsShouldExistAfter) continue;
            infos = this.getCurrentSnapshots(gg, Collections.singleton(this.moveDir));
            for (i = 0; i < chn.size(); ++i) {
                IgniteSnapshotUpdateOperationsTest.assertTrue((boolean)infos.contains(chn.get(i)));
            }
            gg.snapshot().restoreSnapshot(chn.get(chn.size() - 1), Collections.singleton(this.moveDir), null, null).get();
        }
    }

    protected void doTest0(IgniteEx ex, GridGain gg, SnapshotOperationType operation) throws IgniteCheckedException {
    }

    @NotNull
    protected IgniteEx startCluster() throws Exception {
        return this.startCluster(2);
    }

    @NotNull
    protected IgniteEx startCluster(int size) throws Exception {
        this.startGrid("dummy");
        this.startGrid("client");
        IgniteEx ex = this.startGrids(size);
        ex.cluster().active(true);
        return ex;
    }

    private Set<Long> getCurrentSnapshots(GridGain gg, Collection<File> paths) {
        return gg.snapshot().listSnapshots(paths).stream().map(s -> s.snapshotId()).collect(Collectors.toSet());
    }

    private GridLongList doOperationWithRandomSnapshot(GridSnapshot snapshot, GridLongList chain0, SnapshotOperationType operation, int times, SnapshotChainMode chainMode) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        GridLongList chain = new GridLongList(chain0.array());
        GridLongList res = new GridLongList();
        for (int i = 0; i < times; ++i) {
            int idx = rand.nextInt(chain.size());
            long id = chain.get(idx);
            res.add(id);
            chain.removeIndex(idx);
            this.doOperation(snapshot, operation, id, chainMode);
        }
        return res;
    }

    private void doOperation(GridSnapshot snapshot, SnapshotOperationType operation, long id, SnapshotChainMode mode) {
        switch (operation) {
            case COPY: {
                snapshot.copySnapshot(id, this.moveDir, new SnapshotUpdateOperationParams(mode, true, false, null), null).get();
                break;
            }
            case MOVE: {
                snapshot.moveSnapshot(id, this.moveDir, false, new SnapshotUpdateOperationParams(mode, true, false, null), null).get();
                break;
            }
            case DELETE: {
                snapshot.deleteSnapshot(id, new SnapshotUpdateOperationParams(mode, true, false, null), null).get();
                break;
            }
            default: {
                IgniteSnapshotUpdateOperationsTest.fail();
            }
        }
    }

    protected GridLongList createSnapshotChain(IgniteEx ig, GridSnapshot snapshot, int length) throws IgniteCheckedException {
        return this.createSnapshotChain(ig, snapshot, null, length);
    }

    protected GridLongList createSnapshotChain(IgniteEx ig, GridSnapshot snapshot, Set<String> cacheNames, int length) throws IgniteCheckedException {
        IgniteSnapshotUpdateOperationsTest.assertTrue((length > 0 ? 1 : 0) != 0);
        SnapshotFuture fut = snapshot.createFullSnapshot(cacheNames, null);
        fut.get();
        GridLongList res = new GridLongList();
        res.add(fut.snapshotOperation().snapshotId());
        IgniteCache cache = ig.cache("cache1");
        IgniteCache cache2 = ig.cache("cache2");
        for (int i = 0; i < length - 1; ++i) {
            int shift = (int)System.currentTimeMillis();
            for (int j = 0; j < 300 / length; ++j) {
                int next = ThreadLocalRandom.current().nextInt(300);
                cache.put((Object)next, (Object)(next + shift));
                cache2.put((Object)next, (Object)new AbstractSnapshotTest.TestValue(next, next + shift));
            }
            fut = snapshot.createSnapshot(cacheNames, null);
            fut.get();
            res.add(fut.snapshotOperation().snapshotId());
        }
        return res;
    }
}

