/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.TestUtils;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Test;

public class IgniteDbSnapshotSameTopologyWithEncryptionTest
extends IgniteDbSnapshotSameTopologyTest {
    public static final String KEYSTORE_PATH = IgniteUtils.resolveIgnitePath((String)(TestUtils.TEST_ROOT + "/snapshot/snapshot-encryption.jks")).getAbsolutePath();
    public static final char[] KEYSTORE_PASSWORD = "keep_clear_mind".toCharArray();
    public static final String STORAGE_MASTER_KEY = "ignite.master.key";
    private static final String STORAGE_MASTER_KEY_2 = "ignite.master.key2";
    private static final String SNAPSHOT_MASTER_KEY = "snapshot.master.key";
    private static final String SNAPSHOT_MASTER_KEY_2 = "snapshot.master.key2";
    public static final String RESTORE_CANCEL_CACHE_NAME = "new-cache";

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(KEYSTORE_PATH);
        encSpi.setKeyStorePassword(KEYSTORE_PASSWORD);
        encSpi.setMasterKeyName(STORAGE_MASTER_KEY);
        return super.getConfiguration(igniteInstanceName).setEncryptionSpi((EncryptionSpi)encSpi);
    }

    @Override
    protected CacheConfiguration<?, ?> getCacheConfig(String cacheName) {
        CacheConfiguration ccfg;
        switch (cacheName) {
            case "new-cache": {
                ccfg = IgniteDbSnapshotSameTopologyWithEncryptionTest.defaultCacheConfiguration().setName(RESTORE_CANCEL_CACHE_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
                break;
            }
            default: {
                ccfg = super.getCacheConfig(cacheName);
            }
        }
        if (CU.isPersistentCache(ccfg, (DataStorageConfiguration)this.getDataStorageConfiguration())) {
            ccfg.setEncryptionEnabled(true);
        }
        return ccfg;
    }

    @Override
    protected Map<String, Object> getTestRestoreParameters() {
        EncryptionSpi spi = ignite.configuration().getEncryptionSpi();
        HashSet<Integer> encryptedGrps = new HashSet<Integer>();
        for (String cacheName : ignite.cacheNames()) {
            CacheConfiguration ccfg = (CacheConfiguration)ignite.cache(cacheName).getConfiguration(CacheConfiguration.class);
            if (!ccfg.isEncryptionEnabled()) continue;
            encryptedGrps.add(CU.cacheGroupId((String)cacheName, (String)ccfg.getGroupName()));
        }
        return Collections.singletonMap("SNAPSHOT_RESTORE_ENCRYPTION_KEYS", SnapshotUtils.encryptSnapshotEncryptionKeys((EncryptionSpi)spi, (Map)SnapshotUtils.createSnapshotEncryptionKeys((EncryptionSpi)spi, encryptedGrps), (String)spi.getMasterKeyName()));
    }

    @Test
    public void testIncrementalSnapshotWithDifferentMasterKeys() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        IgniteCache cache3 = ignite.cache("cache3");
        cache1.clear();
        cache2.clear();
        cache3.clear();
        cache1.put((Object)1, (Object)new AbstractSnapshotTest.TestValue(1, 1));
        cache2.put((Object)2, (Object)new AbstractSnapshotTest.TestValue(2, 2));
        cache3.put((Object)3, (Object)new AbstractSnapshotTest.TestValue(3, 3));
        this.forceCheckpoint();
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, SNAPSHOT_MASTER_KEY), "First test snapshot.");
        fut1.get();
        cache1.put((Object)4, (Object)new AbstractSnapshotTest.TestValue(4, 4));
        cache2.put((Object)5, (Object)new AbstractSnapshotTest.TestValue(5, 5));
        cache3.put((Object)6, (Object)new AbstractSnapshotTest.TestValue(6, 6));
        this.forceCheckpoint();
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, SNAPSHOT_MASTER_KEY_2), "Second test snapshot.");
        fut2.get();
        cache1.put((Object)7, (Object)new AbstractSnapshotTest.TestValue(7, 7));
        cache2.put((Object)8, (Object)new AbstractSnapshotTest.TestValue(8, 8));
        cache3.put((Object)9, (Object)new AbstractSnapshotTest.TestValue(9, 9));
        this.forceCheckpoint();
        SnapshotFuture fut3 = gg.snapshot().createSnapshot(null, null);
        fut3.get();
        cache1.put((Object)10, (Object)new AbstractSnapshotTest.TestValue(10, 10));
        cache2.put((Object)11, (Object)new AbstractSnapshotTest.TestValue(11, 11));
        cache3.put((Object)12, (Object)new AbstractSnapshotTest.TestValue(12, 12));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)4, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)4, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)4, (int)cache3.size(new CachePeekMode[0]));
        List list = gg.snapshot().list();
        for (SnapshotInfo snap : list) {
            if (fut1.snapshotOperation().snapshotId() == snap.snapshotId()) {
                IgniteDbSnapshotSameTopologyWithEncryptionTest.assertTrue((boolean)snap.fullSnapshot());
            }
            if (fut2.snapshotOperation().snapshotId() == snap.snapshotId()) {
                IgniteDbSnapshotSameTopologyWithEncryptionTest.assertFalse((boolean)snap.fullSnapshot());
            }
            if (fut3.snapshotOperation().snapshotId() != snap.snapshotId()) continue;
            IgniteDbSnapshotSameTopologyWithEncryptionTest.assertFalse((boolean)snap.fullSnapshot());
        }
        gg.snapshot().restoreSnapshot(fut3.snapshotOperation().snapshotId(), null, null).get();
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)3, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(1, 1), (Object)cache1.get((Object)1));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(4, 4), (Object)cache1.get((Object)4));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(7, 7), (Object)cache1.get((Object)7));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertNull((Object)cache1.get((Object)10));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)3, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(2, 2), (Object)cache2.get((Object)2));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(5, 5), (Object)cache2.get((Object)5));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(8, 8), (Object)cache2.get((Object)8));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertNull((Object)cache2.get((Object)11));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((int)3, (int)cache3.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(3, 3), (Object)cache3.get((Object)3));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(6, 6), (Object)cache3.get((Object)6));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(9, 9), (Object)cache3.get((Object)9));
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertNull((Object)cache3.get((Object)12));
    }

    @Test
    public void testCreateSnapshotWithInvalidKeyName() {
        String invalidKeyName = "INVALID_snapshot.master.key";
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, invalidKeyName), "First test snapshot.");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> ((SnapshotFuture)fut1).get(), IgniteException.class, (String)("SPI parameter failed condition check: No such master key found [masterKeyName=" + invalidKeyName + ']'));
    }

    @Test
    public void testChangeMasterKeyAndSnapshot() throws Exception {
        int keyToCheck = 44;
        ignite.cache("cache3").put((Object)keyToCheck, (Object)keyToCheck);
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, SNAPSHOT_MASTER_KEY), "First test snapshot.");
        latch.await();
        ignite.encryption().changeMasterKey(STORAGE_MASTER_KEY_2);
        snapFut.get();
        ignite.cache("cache3").put((Object)keyToCheck, (Object)(keyToCheck + 1));
        gg.snapshot().restoreSnapshot(snapFut.snapshotOperation().snapshotId(), null, null).get();
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)keyToCheck, (Object)ignite.cache("cache3").get((Object)keyToCheck));
    }

    @Test
    public void testChangeCacheKeyAndSnapshot() throws Exception {
        int keyToCheck = 44;
        ignite.cache("cache3").put((Object)keyToCheck, (Object)keyToCheck);
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, SNAPSHOT_MASTER_KEY), "First test snapshot.");
        latch.await();
        ignite.encryption().changeCacheGroupKey((Collection)ImmutableList.of((Object)this.getOrCreateDefaultCacheName((Ignite)ignite), (Object)"Group2", (Object)"cache3"));
        snapFut.get();
        ignite.cache("cache3").put((Object)keyToCheck, (Object)(keyToCheck + 1));
        gg.snapshot().restoreSnapshot(snapFut.snapshotOperation().snapshotId(), null, null).get();
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertEquals((Object)keyToCheck, (Object)ignite.cache("cache3").get((Object)keyToCheck));
    }

    @Test
    public void testRestoreAndCancelWithAnotherCache() throws Exception {
        IgniteCache newCache = ignite.getOrCreateCache(this.getCacheConfig(RESTORE_CANCEL_CACHE_NAME));
        for (int i = 0; i < 100; ++i) {
            newCache.put((Object)i, (Object)i);
        }
        SnapshotFuture createFut = gg.snapshot().createFullSnapshot(null, null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, null, SNAPSHOT_MASTER_KEY), "First test snapshot.");
        createFut.get();
        long snapId = createFut.snapshotOperation().snapshotId();
        newCache.destroy();
        SnapshotFuture fut2 = gg.snapshot().restoreSnapshot(snapId, null, null);
        IgniteUuid operationId1 = fut2.snapshotOperation().operationId();
        fut2.initFuture().get();
        IgniteFuture res1 = gg.snapshot().cancelSnapshotOperation(operationId1, null);
        this.checkIsCanceledOrAlreadyDone(fut2, (IgniteFuture<Boolean>)res1);
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotFuture fut1 = gg.snapshot().restoreSnapshot(snapId, null, null);
        IgniteUuid operationId = fut1.snapshotOperation().operationId();
        latch.await();
        IgniteFuture res = gg.snapshot().cancelSnapshotOperation(operationId, null);
        this.checkIsCanceledOrAlreadyDone(fut1, (IgniteFuture<Boolean>)res);
        IgniteDbSnapshotSameTopologyWithEncryptionTest.assertNull((Object)ignite.cache(RESTORE_CANCEL_CACHE_NAME));
        newCache = ignite.createCache(this.getCacheConfig(RESTORE_CANCEL_CACHE_NAME));
        for (int i = 0; i < 100; ++i) {
            newCache.put((Object)i, (Object)i);
        }
        newCache.destroy();
    }
}

