/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;

public class IgniteDbSnapshotSameTopologyTestMultiNode
extends IgniteDbSnapshotSameTopologyTest {
    private static Set<String> dirs = new HashSet<String>();

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pluginConfiguration : configuration.getPluginConfigurations()) {
            if (!(pluginConfiguration instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pluginConfiguration;
            break;
        }
        assert (ggCfg != null);
        SnapshotConfiguration dbCfg = ggCfg.getSnapshotConfiguration();
        dbCfg.setSnapshotsPath(gridName);
        return configuration;
    }

    @Override
    protected String snapshotPathForNode(String gridName) {
        dirs.add(gridName);
        return gridName;
    }

    @Override
    protected Set<String> snapshotFolders() {
        return dirs;
    }

    @Override
    protected void removeFileOfOneNode(long id) throws IgniteCheckedException {
        String snapshotDirName = null;
        for (String dir : snapshotDirs) {
            if (dir.equals("dummy")) continue;
            snapshotDirName = dir;
            break;
        }
        File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), snapshotDirName, (boolean)false);
        File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        U.delete((File)fullSnapDir);
    }
}

