/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotNotStableTopologiesTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class IgniteDbSnapshotNotStableTopologiesMultiNodeTest
extends IgniteDbSnapshotNotStableTopologiesTest {
    private static final Set<String> allSnapshotDirs = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pluginConfiguration : configuration.getPluginConfigurations()) {
            if (!(pluginConfiguration instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pluginConfiguration;
            break;
        }
        assert (ggCfg != null);
        if (this.useTestSpi != 0) {
            FileDatabaseSnapshotSpi spi = new FileDatabaseSnapshotSpi();
            spi.setSnapshotDirectory(this.snapshotPathForNode(gridName));
            GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(this.createSnapshotSpi(this.useTestSpi, (DatabaseSnapshotSpi)spi));
        }
        return configuration;
    }

    @Override
    protected String snapshotPathForNode(String gridName) {
        allSnapshotDirs.add(gridName);
        snapshotDirs.add(gridName);
        return gridName;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        for (String snapshotDir : snapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
        snapshotDirs.clear();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        for (String snapshotDir : allSnapshotDirs) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDir, (boolean)false));
        }
        allSnapshotDirs.clear();
    }

    @Override
    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfFullSnapshotIsLocal_NoTwoNode() throws Exception {
        this.testSnapshotChainFullIsLocalAndIncremetalOnesAreRemote(false, chain -> {
            this.stopGrid(2);
            this.stopGrid(1);
            return null;
        });
    }

    @Override
    @Test
    public void testRestoreOfSharedIncrementalSnapshotShouldWorkIfIntermidiateSnapshotIsLocal_NoTwoNode() throws Exception {
        this.testSnapshotChainOneIntermidiateIncremetalSnapshotIsRemote(false, chain -> {
            this.stopGrid(2);
            this.stopGrid(1);
            return null;
        });
    }

    @Test
    public void testCheckWhenAffinityAssignmentChangedAfterSnapshotHasBeenCreated() throws Exception {
        IgniteEx ignite = this.startGrids(3);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache("cache1");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        fut.get();
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get();
        IgniteDbSnapshotNotStableTopologiesMultiNodeTest.assertTrue((boolean)issues.isEmpty());
        this.stopGrid(2);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get();
        IgniteDbSnapshotNotStableTopologiesMultiNodeTest.assertFalse((boolean)issues.isEmpty());
    }

    @Test
    public void testThatRestoreFailsIfThereAreNoSomePartitions() throws Exception {
        IgniteDbSnapshotNotStableTopologiesMultiNodeTest.assertEquals((int)0, (int)this.getBackupCount());
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        fut.get();
        this.stopGrid(1);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        try {
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get();
            IgniteDbSnapshotNotStableTopologiesMultiNodeTest.fail();
        }
        catch (IgniteException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Not enough partitions in current topology to complete restore operation"));
        }
    }

    @Override
    protected Set<String> snapshotFolders() {
        return snapshotDirs;
    }

    @Override
    protected void removeFileOfOneNode(long id) throws IgniteCheckedException {
        String snapshotDirName = null;
        for (String dir : snapshotDirs) {
            if (dir.equals("dummy")) continue;
            snapshotDirName = dir;
            break;
        }
        File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), snapshotDirName, (boolean)false);
        File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
        U.delete((File)fullSnapDir);
    }
}

