/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotDataStructuresAfterRestoreTest
extends AbstractSnapshotTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreLocks() throws Exception {
        long snapshotId;
        String lck1 = "lck1";
        String lck2 = "lck2";
        IgniteEx ignite = this.startGrid();
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteLock lock1 = ignite.reentrantLock(lck1, true, true, true);
        final IgniteLock lock2 = ignite.reentrantLock(lck2, true, true, true);
        lock1.lock();
        try {
            IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock1 should be locked by the current thread", (lock1.isLocked() && lock1.isHeldByCurrentThread() ? 1 : 0) != 0);
            final CountDownLatch lockLatch = new CountDownLatch(1);
            final CountDownLatch unlockLatch = new CountDownLatch(1);
            IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    lock2.lock();
                    try {
                        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock2 should be locked by the current thread", (boolean)(lock2.isLocked() && lock2.isHeldByCurrentThread()));
                        lockLatch.countDown();
                        unlockLatch.await();
                    }
                    finally {
                        lock2.unlock();
                    }
                    return null;
                }
            });
            try {
                lockLatch.await();
                IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock2 should be locked by the other thread", (lock2.isLocked() && !lock2.isHeldByCurrentThread() ? 1 : 0) != 0);
                SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(null, null);
                snapshotFut.get();
                snapshotId = snapshotFut.snapshotOperation().snapshotId();
            }
            finally {
                unlockLatch.countDown();
                fut.get();
            }
        }
        finally {
            lock1.unlock();
        }
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock1 should not be locked", (!lock1.isLocked() && !lock1.isHeldByCurrentThread() ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock2 should not be locked", (!lock2.isLocked() && !lock2.isHeldByCurrentThread() ? 1 : 0) != 0);
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock1 should not be locked after snapshot restore", (!lock1.isLocked() && !lock1.isHeldByCurrentThread() ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock2 should not be locked after snapshot restore", (!lock2.isLocked() && !lock2.isHeldByCurrentThread() ? 1 : 0) != 0);
        IgniteLock lock3 = ignite.reentrantLock(lck1, true, true, false);
        IgniteLock lock4 = ignite.reentrantLock(lck2, true, true, false);
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock1 should be the same instance after restore", (lock1 == lock3 ? 1 : 0) != 0);
        IgniteDbSnapshotDataStructuresAfterRestoreTest.assertTrue((String)"lock2 should be the same instance after restore", (lock2 == lock4 ? 1 : 0) != 0);
    }
}

