/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCountersDescriptor;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class IgniteDbSnapshotCorruptedTrackingPagesTest
extends AbstractSnapshotTest {
    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setCacheConfiguration(new CacheConfiguration[0]);
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testIncrementalSnapshotRepairsCorruptedPages() throws Exception {
        this.testSnapshotRepairsCorruptedPages(false);
    }

    @Test
    public void testFullSnapshotRepairsCorruptedPages() throws Exception {
        this.testSnapshotRepairsCorruptedPages(true);
    }

    private void testSnapshotRepairsCorruptedPages(boolean fullSnapshot) throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.getOrCreateCache(new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)));
        GridCacheSharedContext ctx = ignite.context().cache().context();
        int cacheGrpId = CU.cacheId((String)"default");
        long trackingPageId = 0x1000000000001L;
        PageMemoryEx mem = (PageMemoryEx)ctx.cacheContext(cacheGrpId).dataRegion().pageMemory();
        int key = 0;
        cache.put((Object)(++key), (Object)key);
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)0L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        gg.snapshot().createFullSnapshot(Collections.singleton("default"), null).get();
        for (int i = 0; i < 3; ++i) {
            cache.put((Object)(++key), (Object)key);
            IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)(i + 2), (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
            gg.snapshot().createFullSnapshot(Collections.singleton("default"), null).get();
        }
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)5L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        this.corruptPartition(ctx.database(), cacheGrpId);
        this.stopGrid(0);
        ignite = this.startGrid(0);
        gg = (GridGain)ignite.plugin("GridGain");
        cache = ignite.cache("default");
        ctx = ignite.context().cache().context();
        mem = (PageMemoryEx)ctx.cacheContext(cacheGrpId).dataRegion().pageMemory();
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)5L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        cache.put((Object)(++key), (Object)key);
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)-9223372036854775807L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        if (fullSnapshot) {
            gg.snapshot().createFullSnapshot(Collections.singleton("default"), null).get();
        } else {
            gg.snapshot().createSnapshot(Collections.singleton("default"), null).get();
        }
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)1L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        this.stopGrid(0);
        File cpDir = ((GridCacheDatabaseSharedManager)ctx.database()).checkpointDirectory();
        this.removeLastCheckpointEndMarker(cpDir);
        ignite = this.startGrid(0);
        gg = (GridGain)ignite.plugin("GridGain");
        cache = ignite.cache("default");
        ctx = ignite.context().cache().context();
        mem = (PageMemoryEx)ctx.cacheContext(cacheGrpId).dataRegion().pageMemory();
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)1L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        for (int i = 0; i < 3; ++i) {
            cache.put((Object)(++key), (Object)key);
            IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)(i + 2), (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
            gg.snapshot().createFullSnapshot(Collections.singleton("default"), null).get();
            IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)(i + 3), (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        }
        this.corruptPartition(ctx.database(), cacheGrpId);
        this.stopGrid(0);
        ignite = this.startGrid(0);
        gg = (GridGain)ignite.plugin("GridGain");
        ctx = ignite.context().cache().context();
        mem = (PageMemoryEx)ctx.cacheContext(cacheGrpId).dataRegion().pageMemory();
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)5L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        if (fullSnapshot) {
            gg.snapshot().createFullSnapshot(Collections.singleton("default"), null).get();
        } else {
            gg.snapshot().createSnapshot(Collections.singleton("default"), null).get();
        }
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)2L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
        this.stopGrid(0);
        this.removeLastCheckpointEndMarker(cpDir);
        ignite = this.startGrid(0);
        ctx = ignite.context().cache().context();
        mem = (PageMemoryEx)ctx.cacheContext(cacheGrpId).dataRegion().pageMemory();
        IgniteDbSnapshotCorruptedTrackingPagesTest.assertEquals((long)2L, (long)this.getLastSnapshotTag(mem, cacheGrpId, trackingPageId));
    }

    private void removeLastCheckpointEndMarker(File cpDir) {
        File[] files = cpDir.listFiles(file -> file.getName().endsWith("START.bin"));
        Arrays.sort(files, Comparator.comparingLong(file -> Long.parseLong(file.getName().split("[-]")[0])));
        new File(files[files.length - 1].getAbsolutePath().replace("START.bin", "END.bin")).delete();
    }

    @Test
    public void testNodeWorkingWithCorruptedTrackingPages() throws Exception {
        IgniteEx igniteEx = this.startGrid(1);
        igniteEx.cluster().active(true);
        String cacheName = "testNodeWorkingWithCorruptedTrackingPages";
        igniteEx.getOrCreateCache(new CacheConfiguration(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)));
        int shift = 0;
        IgniteDbSnapshotCorruptedTrackingPagesTest.loadWithIntsAsync((Ignite)igniteEx, cacheName, shift++, 1).get();
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null).get();
        for (int i = 1; i < 4; ++i) {
            IgniteDbSnapshotCorruptedTrackingPagesTest.loadWithIntsAsync((Ignite)igniteEx, cacheName, shift++, 1).get();
            gg.snapshot().createSnapshot(Collections.singleton(cacheName), null).get();
        }
        GridCacheSharedContext ctx = igniteEx.context().cache().context();
        int cacheGrpId = CU.cacheId((String)cacheName);
        IgniteCacheDatabaseSharedManager dbMgr = ctx.database();
        this.corruptPartition(dbMgr, cacheGrpId);
        this.stopGrid(1, false);
        igniteEx = this.startGrid(1);
        IgniteDbSnapshotCorruptedTrackingPagesTest.loadWithIntsAsync((Ignite)igniteEx, cacheName, shift++, 1).get();
        IgniteCache cache = igniteEx.cache(cacheName);
        for (int i = 0; i < 300; ++i) {
            MatcherAssert.assertThat((Object)cache.get((Object)i), (Matcher)Matchers.is((Object)(i + shift - 1)));
        }
        gg = (GridGain)igniteEx.plugin("GridGain");
        SnapshotFuture incrSnapshot = gg.snapshot().createSnapshot(Collections.singleton(cacheName), null);
        incrSnapshot.initFuture().get();
        cache.put((Object)-1, (Object)-1);
        incrSnapshot.get();
        this.stopGrid(1, false);
        igniteEx = this.startGrid(1);
        gg = (GridGain)igniteEx.plugin("GridGain");
        cache = igniteEx.cache(cacheName);
        incrSnapshot = gg.snapshot().createSnapshot(Collections.singleton(cacheName), null);
        incrSnapshot.get();
        long lastIncrSnapId = incrSnapshot.snapshotOperation().snapshotId();
        long totalSize = this.getSnapshotSizeInByteOnCluster(lastIncrSnapId);
        long sizeInPages = totalSize / (long)igniteEx.configuration().getDataStorageConfiguration().getPageSize();
        long estimatedSizeInPages = 10L;
        MatcherAssert.assertThat((Object)sizeInPages, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(estimatedSizeInPages)));
        cache.clear();
        gg.snapshot().restoreSnapshot(incrSnapshot.snapshotOperation().snapshotId(), null, null).get();
        MatcherAssert.assertThat((Object)cache.get((Object)-1), (Matcher)Matchers.is((Object)-1));
        TreeSet<Long> snapshotIds = new TreeSet<Long>();
        for (SnapshotInfo snapshotInfo : gg.snapshot().list(null)) {
            if (snapshotInfo.snapshotId() == lastIncrSnapId) continue;
            snapshotIds.add(snapshotInfo.snapshotId());
        }
        shift = 0;
        for (Long snapshotId : snapshotIds) {
            gg.snapshot().restoreSnapshot(snapshotId.longValue(), null, null).get();
            for (int i = 0; i < 300; ++i) {
                MatcherAssert.assertThat((Object)cache.get((Object)i), (Matcher)Matchers.is((Object)(i + shift)));
            }
            ++shift;
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptPartition(IgniteCacheDatabaseSharedManager dbMgr, int cacheGrpId) throws IgniteCheckedException {
        dbMgr.checkpointReadLock();
        try {
            String metaStorageKey = "snapshot-descriptor-" + cacheGrpId;
            SnapshotCountersDescriptor desc = (SnapshotCountersDescriptor)dbMgr.metaStorage().read(metaStorageKey);
            dbMgr.metaStorage().write(metaStorageKey, (Serializable)new SnapshotCountersDescriptor(cacheGrpId).lastSuccessfulSnapshotId(desc.lastSuccessfulSnapshotId()).lastSuccessfulSnapshotTag(0L).nextSnapshotTag(1L));
        }
        finally {
            dbMgr.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastSnapshotTag(PageMemoryEx pageMem, int grpId, long trackingPageId) throws IgniteCheckedException {
        long trackingPage = pageMem.acquirePage(grpId, trackingPageId);
        try {
            long l;
            long pageAddr = pageMem.readLock(grpId, trackingPageId, trackingPage);
            try {
                l = GridUnsafe.getLong((long)(pageAddr + 40L));
            }
            catch (Throwable throwable) {
                pageMem.readUnlock(grpId, trackingPageId, trackingPage);
                throw throwable;
            }
            pageMem.readUnlock(grpId, trackingPageId, trackingPage);
            return l;
        }
        finally {
            pageMem.releasePage(grpId, trackingPageId, trackingPage);
        }
    }
}

