/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_TEST_SKIP_SNAPSHOT_SYNC", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_METRICS_HISTORY_SIZE", value="5"), @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="REQUIRE")})
public class IgniteDbIncrementalSnapshotVerificationTest
extends AbstractSnapshotTest {
    @Test
    public void testMustCheckFullSnapshotChainMetadata() throws Exception {
        SnapshotMetadataV2 metadata;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        ignite.getOrCreateCache("localCache");
        ignite.getOrCreateCache("cache2");
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        File moveDir = this.createOrCleanMoveDir();
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null);
        snapshot.get(30L, TimeUnit.SECONDS);
        IgniteDbIncrementalSnapshotVerificationTest.loadWithIntsAsync((Ignite)ignite, this.getOrCreateDefaultCacheName((Ignite)ignite), 10, 1, 150).get(30L, TimeUnit.SECONDS);
        SnapshotFuture incSnapshot1 = gg.snapshot().createSnapshot(null, null);
        incSnapshot1.get(30L, TimeUnit.SECONDS);
        IgniteDbIncrementalSnapshotVerificationTest.loadWithIntsAsync((Ignite)ignite, "cache2", 10, 1, 150).get(30L, TimeUnit.SECONDS);
        SnapshotFuture incSnapshot2 = gg.snapshot().createSnapshot(null, null);
        incSnapshot2.get(30L, TimeUnit.SECONDS);
        IgniteDbIncrementalSnapshotVerificationTest.loadWithIntsAsync((Ignite)ignite, "localCache", 10, 1, 150).get(10L, TimeUnit.SECONDS);
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(null, null);
        incSnapshot.get(30L, TimeUnit.SECONDS);
        long fullSnapId = snapshot.snapshotOperation().snapshotId();
        gg.snapshot().copySnapshot(fullSnapId, moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, true, null), null).get(30L, TimeUnit.SECONDS);
        ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite)).clear();
        ignite.close();
        FsSnapshotPath fullSnapPath = new FsSnapshotPath(new FsSnapshotPath(moveDir).getFile().listFiles()[0]);
        FsSnapshotPath metaFile = fullSnapPath.resolve("snapshot-meta.bin");
        JdkMarshaller marshaller = new JdkMarshaller();
        try (InputStream inputStream = SnapshotUtils.stream((SnapshotPath)metaFile);){
            metadata = (SnapshotMetadataV2)marshaller.unmarshal(inputStream, ((Object)((Object)this)).getClass().getClassLoader());
        }
        metaFile.delete();
        GridTestUtils.setFieldValue((Object)metadata, (String)"id", (Object)-1);
        var15_13 = null;
        try (FileOutputStream stream = new FileOutputStream(metaFile.getFile());){
            stream.write(new JdkMarshaller().marshal((Object)metadata));
        }
        catch (Throwable throwable) {
            var15_13 = throwable;
            throw throwable;
        }
        ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridGain finalGg = gg = (GridGain)ignite.plugin("GridGain");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> finalGg.snapshot().restoreSnapshot(incSnapshot.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get(30L, TimeUnit.SECONDS), IgniteException.class, (String)"Metadata partial hash verification failure");
    }
}

