/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.UnwrapDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.UnwrapMvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.SegmentHeader;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.AbstractReadFileHandle;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.AbstractReadFileHandleProxy;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.DescriptorFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.IteratorParametersBuilder;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.SnapshotPathDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoteWalIterator
extends GridCloseableIteratorAdapter<IgniteBiTuple<WALPointer, WALRecord>>
implements WALIterator {
    private static final SegmentFileInputFactory FILE_INPUT_FACTORY = new SimpleSegmentFileInputFactory();
    private static final long serialVersionUID = 0L;
    private final IgniteLogger log;
    private final RecordSerializerFactory serializerFactory;
    private final GridKernalContext kernalCtx;
    private int curIdx = -1;
    private final ByteBufferExpander buf;
    private AbstractReadFileHandle currWalSegment;
    protected long curWalSegmIdx = -1L;
    protected IgniteBiTuple<WALPointer, WALRecord> curRec;
    private WALPointer lastRead;
    private IgniteCheckedException curException;
    @NotNull
    private final List<SnapshotPathDescriptor> walFileDescriptors;

    public RemoteWalIterator(IgniteLogger log, IteratorParametersBuilder builder, GridCacheSharedContext sharedCtx, SnapshotPath path) throws IgniteCheckedException {
        this.log = log;
        this.buf = new ByteBufferExpander(builder.bufferSize, ByteOrder.nativeOrder());
        this.walFileDescriptors = new DescriptorFactory(log).createDescriptors(path);
        this.serializerFactory = new RecordSerializerFactoryImpl(sharedCtx);
        this.kernalCtx = sharedCtx.kernalContext();
        this.init();
        this.advance();
    }

    private void init() {
        if (this.walFileDescriptors.isEmpty()) {
            return;
        }
        this.curWalSegmIdx = this.walFileDescriptors.get(this.curIdx + 1).idx() - 1L;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initialized WAL cursor [curWalSegmIdx=" + this.curWalSegmIdx + ']');
        }
    }

    public Optional<WALPointer> lastRead() {
        return Optional.ofNullable(this.lastRead);
    }

    protected boolean onHasNext() throws IgniteCheckedException {
        return this.curRec != null;
    }

    protected IgniteBiTuple<WALPointer, WALRecord> onNext() throws IgniteCheckedException {
        if (this.curException != null) {
            throw this.curException;
        }
        IgniteBiTuple<WALPointer, WALRecord> ret = this.curRec;
        try {
            this.advance();
        }
        catch (IgniteCheckedException e) {
            this.curException = e;
        }
        return ret;
    }

    protected void advance() throws IgniteCheckedException {
        try {
            while (true) {
                this.curRec = this.advanceRecord(this.currWalSegment);
                if (this.curRec != null) {
                    this.lastRead = (WALPointer)this.curRec.get1();
                    if (((WALRecord)this.curRec.get2()).type() == null) continue;
                    return;
                }
                this.currWalSegment = this.advanceSegment(this.currWalSegment);
                if (this.currWalSegment == null) break;
            }
            return;
        }
        catch (WalSegmentTailReachedException e) {
            AbstractReadFileHandle currWalSegment = this.currWalSegment;
            IgniteCheckedException e0 = this.validateTailReachedException(e, currWalSegment);
            if (e0 != null) {
                throw e0;
            }
            this.log.warning(e.getMessage());
            this.curRec = null;
            return;
        }
    }

    private IgniteCheckedException validateTailReachedException(WalSegmentTailReachedException tailReachedException, AbstractReadFileHandle currWalSegment) {
        SnapshotPathDescriptor lastWALSegmentDesc = this.walFileDescriptors.get(this.walFileDescriptors.size() - 1);
        assert (lastWALSegmentDesc != null);
        return lastWALSegmentDesc.idx() != currWalSegment.idx() ? new IgniteCheckedException("WAL tail reached not in the last available segment, potentially corrupted segment, last available segment idx=" + lastWALSegmentDesc.idx() + ", path=" + lastWALSegmentDesc.getAbsolutePath() + ", last read segment idx=" + currWalSegment.idx(), (Throwable)tailReachedException) : null;
    }

    private AbstractReadFileHandle advanceSegment(@Nullable AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
        if (curWalSegment != null) {
            curWalSegment.close();
        }
        ++this.curWalSegmIdx;
        ++this.curIdx;
        if (this.curIdx >= this.walFileDescriptors.size()) {
            return null;
        }
        SnapshotPathDescriptor fd = this.walFileDescriptors.get(this.curIdx);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file().getAbsolutePath() + ']');
        }
        assert (fd != null);
        this.curRec = null;
        return this.initReadHandle(fd);
    }

    private AbstractReadFileHandle initReadHandle(@NotNull SnapshotPathDescriptor desc) throws IgniteCheckedException {
        SegmentHeader segmentHeader;
        SnapshotPathDescriptor fd = desc;
        SegmentIO fileIO = null;
        while (true) {
            try {
                fileIO = fd.toReadOnlyIO();
                segmentHeader = RecordV1Serializer.readSegmentHeader((SegmentIO)fileIO, (SegmentFileInputFactory)FILE_INPUT_FACTORY);
            }
            catch (IOException | IgniteCheckedException e) {
                this.log.error("Failed to init segment curWalSegmIdx=" + this.curWalSegmIdx + ", curIdx=" + this.curIdx, e);
                U.closeQuiet((AutoCloseable)fileIO);
                ++this.curIdx;
                if (this.curIdx >= this.walFileDescriptors.size()) {
                    return null;
                }
                fd = this.walFileDescriptors.get(this.curIdx);
                continue;
            }
            break;
        }
        return this.initReadHandle(fd, fileIO, segmentHeader);
    }

    private AbstractReadFileHandle initReadHandle(@NotNull SnapshotPathDescriptor desc, @NotNull SegmentIO fileIO, @NotNull SegmentHeader segmentHdr) throws IgniteCheckedException {
        try {
            boolean isCompacted = segmentHdr.isCompacted();
            if (isCompacted) {
                this.serializerFactory.skipPositionCheck(true);
            }
            FileInput in = FILE_INPUT_FACTORY.createFileInput(fileIO, this.buf);
            int serVer = segmentHdr.getSerializerVersion();
            AbstractReadFileHandleProxy abstractReadFileHandleProxy = new AbstractReadFileHandleProxy(new FileWriteAheadLogManager.ReadFileHandle(fileIO, this.serializerFactory.createSerializer(serVer), in, null));
            return abstractReadFileHandleProxy;
        }
        catch (EOFException | SegmentEofException ignore) {
            try {
                fileIO.close();
            }
            catch (IOException ce) {
                throw new IgniteCheckedException((Throwable)ce);
            }
            AbstractReadFileHandle abstractReadFileHandle = null;
            return abstractReadFileHandle;
        }
        catch (IgniteCheckedException e) {
            U.closeWithSuppressingException((AutoCloseable)fileIO, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            U.closeWithSuppressingException((AutoCloseable)fileIO, (Exception)e);
            throw new IgniteCheckedException("Failed to initialize WAL segment after reading segment header: " + desc.file().getAbsolutePath(), (Throwable)e);
        }
        finally {
            this.serializerFactory.clearSegmentLocalState();
        }
    }

    private IgniteBiTuple<WALPointer, WALRecord> advanceRecord(@Nullable AbstractReadFileHandle hnd) throws IgniteCheckedException {
        if (hnd == null) {
            return null;
        }
        FileWALPointer actualFilePtr = new FileWALPointer(hnd.idx(), (int)hnd.in().position(), 0);
        try {
            WALRecord rec = hnd.ser().readRecord(hnd.in(), (WALPointer)actualFilePtr);
            actualFilePtr.length(rec.size());
            return new IgniteBiTuple((Object)actualFilePtr, (Object)this.postProcessRecord(rec));
        }
        catch (IOException | IgniteCheckedException e) {
            if (e instanceof WalSegmentTailReachedException) {
                throw new WalSegmentTailReachedException("WAL segment tail reached. [idx=" + hnd.idx() + ", isWorkDir=" + hnd.workDir() + ", serVer=" + hnd.ser() + ", actualFilePtr=" + actualFilePtr + ']', e);
            }
            if (!(e instanceof SegmentEofException) && !(e instanceof EOFException)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Stopping WAL iteration due to an exception: " + e.getMessage() + ", ptr=" + actualFilePtr);
                }
                throw new IgniteCheckedException(e);
            }
            return null;
        }
    }

    @NotNull
    private WALRecord postProcessRecord(@NotNull WALRecord rec) {
        IgniteCacheObjectProcessor processor = this.kernalCtx.cacheObjects();
        if (processor == null) {
            return rec;
        }
        if (rec.type() == WALRecord.RecordType.DATA_RECORD || rec.type() == WALRecord.RecordType.DATA_RECORD_V2 || rec.type() == WALRecord.RecordType.MVCC_DATA_RECORD) {
            try {
                return RemoteWalIterator.postProcessDataRecord((DataRecord)rec, this.kernalCtx, processor);
            }
            catch (Exception e) {
                this.log.error("Failed to perform post processing for data record ", (Throwable)e);
            }
        }
        return rec;
    }

    @NotNull
    private static WALRecord postProcessDataRecord(@NotNull DataRecord dataRec, GridKernalContext kernalCtx, IgniteCacheObjectProcessor processor) throws IgniteCheckedException {
        CacheObjectContext fakeCacheObjCtx = new CacheObjectContext(kernalCtx, null, null, false, false, false, false, false);
        List entries = dataRec.writeEntries();
        ArrayList<DataEntry> postProcessedEntries = new ArrayList<DataEntry>(entries.size());
        for (DataEntry dataEntry : entries) {
            DataEntry postProcessedEntry = RemoteWalIterator.postProcessDataEntry(processor, fakeCacheObjCtx, dataEntry);
            postProcessedEntries.add(postProcessedEntry);
        }
        MvccDataRecord res = dataRec instanceof MvccDataRecord ? new MvccDataRecord(postProcessedEntries, dataRec.timestamp()) : new DataRecord(postProcessedEntries, dataRec.timestamp());
        res.size(dataRec.size());
        res.position(dataRec.position());
        return res;
    }

    @NotNull
    private static DataEntry postProcessDataEntry(IgniteCacheObjectProcessor processor, CacheObjectContext fakeCacheObjCtx, DataEntry dataEntry) throws IgniteCheckedException {
        CacheObject val;
        KeyCacheObject key;
        boolean keepBinary;
        if (dataEntry instanceof RecordDataV1Serializer.EncryptedDataEntry) {
            return dataEntry;
        }
        boolean bl = keepBinary = !fakeCacheObjCtx.kernalContext().marshallerContext().initialized();
        if (dataEntry instanceof MarshalledDataEntry) {
            MarshalledDataEntry lazyDataEntry = (MarshalledDataEntry)dataEntry;
            key = processor.toKeyCacheObject(fakeCacheObjCtx, lazyDataEntry.getKeyType(), lazyDataEntry.getKeyBytes());
            byte type = lazyDataEntry.getValType();
            val = type == 0 ? null : processor.toCacheObject(fakeCacheObjCtx, type, lazyDataEntry.getValBytes());
        } else {
            key = dataEntry.key();
            val = dataEntry.value();
        }
        return RemoteWalIterator.unwrapDataEntry(fakeCacheObjCtx, dataEntry, key, val, keepBinary);
    }

    @NotNull
    private static DataEntry unwrapDataEntry(CacheObjectContext coCtx, DataEntry dataEntry, KeyCacheObject key, CacheObject val, boolean keepBinary) {
        if (dataEntry instanceof MvccDataEntry) {
            return new UnwrapMvccDataEntry(dataEntry.cacheId(), key, val, dataEntry.op(), dataEntry.nearXidVersion(), dataEntry.writeVersion(), dataEntry.expireTime(), dataEntry.partitionId(), dataEntry.partitionCounter(), ((MvccDataEntry)dataEntry).mvccVer(), (CacheObjectValueContext)coCtx, keepBinary);
        }
        return new UnwrapDataEntry(dataEntry.cacheId(), key, val, dataEntry.op(), dataEntry.nearXidVersion(), dataEntry.writeVersion(), dataEntry.expireTime(), dataEntry.partitionId(), dataEntry.partitionCounter(), (CacheObjectValueContext)coCtx, keepBinary, dataEntry.flags());
    }

    protected void onClose() throws IgniteCheckedException {
        try {
            this.buf.close();
        }
        catch (Exception ex) {
            throw new IgniteCheckedException((Throwable)ex);
        }
    }
}

