/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import org.apache.ignite.IgniteException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.copy.CopyStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;

public class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private final SnapshotOperationContext snapshotOperationContext;
    private final CopyStrategy copyStrategy;
    private final Path srcPath;
    private final SnapshotPath targetPath;
    private final Consumer<Runnable> taskConsumer;

    public CopyFileVisitor(Path srcPath, SnapshotPath targetPath, SnapshotOperationContext snapshotOperationContext, CopyStrategy copyStrategy, Consumer<Runnable> taskConsumer) {
        this.snapshotOperationContext = snapshotOperationContext;
        this.copyStrategy = copyStrategy;
        this.srcPath = srcPath;
        this.targetPath = targetPath;
        this.taskConsumer = taskConsumer;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.snapshotOperationContext.isCancelled()) {
            return FileVisitResult.TERMINATE;
        }
        this.targetPath.resolve(this.srcPath.relativize(dir).toString()).createDirectories();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.snapshotOperationContext.isCancelled()) {
            return FileVisitResult.TERMINATE;
        }
        if (this.isDataFile(file)) {
            Path relativeDir = this.srcPath.relativize(file).getParent();
            SnapshotPath targetDir = relativeDir != null ? this.targetPath.resolve(relativeDir.toString()) : this.targetPath;
            this.taskConsumer.accept(() -> {
                try {
                    this.copyStrategy.copy(file, targetDir);
                }
                catch (IOException e) {
                    throw new IgniteException("Issue in copy file " + file + " to " + targetDir, (Throwable)e);
                }
                this.snapshotOperationContext.reportWork(attrs.size());
            });
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isDataFile(Path file) {
        String s = file.getFileName().toString();
        return !(!Files.isRegularFile(file, new LinkOption[0]) || !s.endsWith(".bin") && !s.endsWith(".zip") && !s.endsWith(".zst") && !s.endsWith(".lz4") && !s.endsWith(".snappy") || !s.startsWith("part-") && !s.startsWith("index.bin") && !s.startsWith("snapshot-registry.bin"));
    }
}

