/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.TreeSet;
import org.apache.ignite.configuration.CacheConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataDigestWriter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;

public class SnapshotMetadataV2DigestWriter
implements SnapshotMetadataDigestWriter {
    public static final SnapshotMetadataV2DigestWriter INSTANCE = new SnapshotMetadataV2DigestWriter();

    @Override
    public void writeDigestFields(Object metadata, ObjectOutput out) throws IOException {
        assert (metadata instanceof SnapshotMetadataV2);
        SnapshotMetadataV2 meta = (SnapshotMetadataV2)metadata;
        TreeSet sortedCacheGrpIds = new TreeSet(meta.cacheGroupIds());
        Map cacheGroupsMeta = meta.cacheGroupsMetadata();
        assert (cacheGroupsMeta != null);
        for (Integer cacheGrpId : sortedCacheGrpIds) {
            CacheSnapshotMetadata cacheGrp = (CacheSnapshotMetadata)cacheGroupsMeta.get(cacheGrpId);
            assert (cacheGrp != null);
            assert (cacheGrp.storedCacheDataList() != null) : "must be called before prepareMarshal() or after finishUnmarshal()";
            out.writeShort(((CacheConfiguration)cacheGrp.cacheConfigurations().iterator().next()).getAffinity().partitions());
            TreeSet cacheNames = new TreeSet(cacheGrp.cacheNames());
            out.writeInt(cacheNames.size());
            for (String name : cacheNames) {
                out.writeUTF(name);
            }
        }
    }
}

