/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.jpountz.lz4.LZ4Factory;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteComputeImpl;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.UserCommandExceptions;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.pagemem.wal.record.SnapshotRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.TrackingPageDeltaRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.T5;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.processors.cache.database.CollectDependantSnapshotSetTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotDescriptorV2Task;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResult;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResultV2;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskV2;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotListTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV2;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotPartitionDistributionTaskV3;
import org.gridgain.grid.internal.processors.cache.database.CollectSnasphotListTaskResult;
import org.gridgain.grid.internal.processors.cache.database.GetOngoingOperationTask;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotAwareClusterStateProcessorImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.messages.FinishSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AbstractFullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.BrokenTrackingPageLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompatibleSnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DistributedSnapshotSecurityLevel;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FullPageIdIncrementalSnapshotIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.MessageDigestFactoryImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.NoopSnapshotRegistryTransformer;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCheckFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotConfigurableFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCopyFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCountersDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateTransferParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDeleteFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotFutureImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoEssential;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetastoreCommonInformation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMoveFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRecoveryFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotTestFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.CachedSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.ReplicationStateChangeFuture;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.recovery.ReplicationRecoveryFuture;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotMXBean;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheSnapshotManager
extends IgniteCacheSnapshotManager<GridSnapshotOperationEx>
implements GridSnapshotManager,
MetastorageLifecycleListener,
PartitionsExchangeAware {
    public static final ThreadLocal<DatabaseSnapshotSpi> TEST_SNAPSHOT_SPI = new ThreadLocal();
    public static final String GG_TEST_SKIP_SNAPSHOT_SYNC = "GG_TEST_SKIP_SNAPSHOT_SYNC";
    public static final String SNAPSHOT_DOES_NOT_EXIST = "Snapshot does not exist [id=";
    public static final String LAST_SNAPSHOTS_ARE_DIFFERENT_ON_NODES_FOR_CACHE_GROUP = "Last snapshots are different on nodes for cache group = ";
    public static final String CONCURRENT_SNAPSHOT_OPERATIONS_ARE_NOT_ALLOWED_CLUSTER_WIDE = "Concurrent snapshot operations are not allowed cluster-wide.";
    public static final String SNAPSHOT_META_FILE_NAME = "snapshot-meta.bin";
    public static final String SNAPSHOT_REGISTRY_FILE_NAME = "snapshot-registry.bin";
    public static final String CACHE_NAME_CLASH_ERROR_MSG = "There are clashes between existing caches and that ones which could be restored from snapshot(id=";
    public static final String NOT_ENOUGH_PARTITIONS_ERROR_MSG = "Not enough partitions in current topology to complete restore operation";
    public static final String ZIP_COMPRESSION_IS_NOT_FULLY_SUPPORTED = "Zip compression is not supported by all nodes!";
    public static final String COPY_IS_NOT_SUPPORTED = "Failed to start snapshot COPY: there are nodes which don't support the operation.";
    public static final String PARALLELISM_SHOULD_BE_POSITIVE = "Parallelism should be positive";
    public static final String THROTTLING_SHOULD_BE_POSITIVE = "Throttling threshold should be positive";
    public static final String INVALID_COMPRESSION_LEVEL = "Invalid compression level";
    public static final String INAPPLICABLE_COMPRESSION_LEVEL = "Inapplicable compression level, compression is off.";
    public static final String INCOMPATIBLE_SECURITY_SETTINGS = "Incompatible snapshot security settings detected on some nodes.";
    public static final String WRONG_SECURITY_LEVEL_ERROR = "Failed to resolve snapshot security level using system property (are there any misspellings?).";
    public static final String PITR_TURNED_ON_EXCHANGELESS_SNAPSHOTS_DISABLED_MSG = "Creating exchangeless snapshots is disabled, will switch to legacy snapshots creation mode.";
    public static final String PITR_TURNED_OFF_EXCHANGELESS_SNAPSHOTS_ENABLED_MSG = "Creating exchangeless snapshots is enabled.";
    public static final String PITR_ENABLED_PROPERTY_NAME = "pointInTimeRecoveryEnabled";
    public static final String EXCHANGELESS_PITR_ENABLED_PROPERTY_NAME = "exchangelessPointInTimeRecoveryEnabled";
    public static final String PITR_ENABLED_MIXED_CLUSTER_WARN = "There are nodes in cluster that don't support pointInTimeRecoveryEnabled distributed property, using value from node configuration, point-in-time recovery is now ";
    public static final String WAL_MODE_NONE_WARNING_ON_START = "Creating exchangeless snapshots is impossible when WAL mode is set to " + WALMode.NONE + ", will switch to legacy snapshots creation mode.";
    public static final String PITR_ENABLED_MESSAGE_ON_CREATION = "Creating snapshot with exchange, because point-in-time recovery is enabled.";
    public static final String WAL_MODE_NONE_MESSAGE_ON_CREATION = "Creating snapshot with exchange, because WAL mode is set to " + WALMode.NONE + ".";
    public static final String INVALID_DEST = "Invalid destination path.";
    public static final String METASTORE_KEY_PREFIX = "snapshot-descriptor-";
    public static final String COMMON_INFO_METASTORE_KEY = "snapshot-common-information";
    private static final String PITR_PROPERTY_UPDATE_MESSAGE = "Point-in-time recovery parameter '%s' was changed from '%s' to '%s'";
    public static final String PITR_INIT_FROM_CONFIG_MSG = "Parameter 'pointInTimeRecoveryEnabled' has been picked up from configuration, point-in-time recovery is now ";
    public static final String PITR_APPLYING_CLUSTER_WIDE_VALUE_MSG = "Ignoring configuration property 'pointInTimeRecoveryEnabled', applying cluster-wide property value, point-in-time recovery is now ";
    private final TrackingPageIO latestTrackingIO = (TrackingPageIO)TrackingPageIO.VERSIONS.latest();
    private final BrokenTrackingPageLogger trackingPageLog = new BrokenTrackingPageLogger();
    private final PageMetaIO pageMetaIO = (PageMetaIO)PageMetaIO.VERSIONS.latest();
    private final ConcurrentMap<Integer, Long> nextSnapshotTagForCacheGrp = new ConcurrentHashMap<Integer, Long>();
    private final ConcurrentMap<Integer, Long> lastSuccessfulSnapshotTagForCacheGrp = new ConcurrentHashMap<Integer, Long>();
    private final ConcurrentMap<Integer, Long> lastSuccessfulSnapshotIdsForCacheGrp = new ConcurrentHashMap<Integer, Long>();
    private final ConcurrentMap<Integer, Long> lastSuccessfulFullSnapshotIdsForCacheGrp = new ConcurrentHashMap<Integer, Long>();
    private volatile long lastSuccessfulFullSnapshotIdForAllCaches;
    private final Object metaMux = new Object();
    private volatile StripedExecutor snapshotExecutor;
    private volatile ExecutorService snapshotMsgExecutor;
    private final DistributedBooleanProperty pointInTimeRecoveryEnabled = DistributedBooleanProperty.detachedBooleanProperty((String)"pointInTimeRecoveryEnabled");
    private volatile boolean dfltPointInTimeRecoveryEnabled;
    private final PointInTimeDistributedPropertyChangesListener pointInTimeDistributedPropertyChangesListener = new PointInTimeDistributedPropertyChangesListener();
    public final boolean DFLT_GG_POINT_IN_TIME_EXCHANGELESS_SUPPORT = IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_POINT_IN_TIME_RECOVERY", (boolean)true);
    private final DistributedBooleanProperty exchangelessPointInTimeRecoveryMode = DistributedBooleanProperty.detachedBooleanProperty((String)"exchangelessPointInTimeRecoveryEnabled");
    private final GridFutureAdapter<Void> firstActivationFut = new GridFutureAdapter();
    private final AtomicReference<SnapshotOperationFuture> snapshotFut = new AtomicReference();
    private final AtomicReference<SnapshotOperationFuture> consistentCutFut = new AtomicReference();
    private final AtomicReference<SnapshotOperationFuture> customFut = new AtomicReference();
    private final List<AtomicReference<SnapshotOperationFuture>> operationFutRefs = F.asList((Object[])new AtomicReference[]{this.snapshotFut, this.consistentCutFut, this.customFut});
    private final AtomicReference<T2<GridSnapshotOperationEx, Set<GroupPartitionId>>> reservedParts = new AtomicReference();
    private final DatabaseSnapshotSpi dbSnapshotSpi;
    private final SnapshotConfiguration snapCfg;
    private GridSnapshotImpl snapApi;
    private GridCacheDatabaseSharedManager dbSharedMgr;
    private int pageSize;
    private volatile State state = State.STARTING;
    private final AtomicBoolean listenersAdded = new AtomicBoolean();
    private static final String METRICS_MBEAN_NAME = "SnapshotMetrics";
    private static final String MBEAN_NAME = "Snapshot";
    private static final int TX_DR_WAL_BUFFER_SIZE = Integer.getInteger("TX_DR_WAL_BUFFER_SIZE", -1);
    private static final String TX_DR_SKIP_STRICT_BOUNDS_CHECK = "TX_DR_SKIP_STRICT_BOUNDS_CHECK";
    private volatile SnapshotMetricsMXBeanImpl snapshotMetricsMXBean;
    private volatile SnapshotMXBeanImpl snapshotMXBean;
    private volatile ObjectName snapshotMetricsMbeanName;
    private ObjectName snapshotMbeanName;
    private volatile GridSnapshotOperationEx lastSnpOperationFromCheckpointer;
    private volatile boolean cutApplyingInProgress;
    private boolean mutableCustomMsgs;
    private volatile ReadWriteMetastorage metastorage;
    private DistributedSnapshotSecurityLevel distributedSnapshotSecurityLevel;
    private final InMemorySingleCutStore cutStore = new InMemorySingleCutStore();
    private final List<IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage>> locStageCompletedLsnrs = new CopyOnWriteArrayList<IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage>>();

    public GridCacheSnapshotManager(GridGainConfiguration ggCfg) {
        SnapshotConfiguration snapCfg;
        SnapshotConfiguration snapshotConfiguration = snapCfg = ggCfg.getSnapshotConfiguration() == null ? new SnapshotConfiguration() : new SnapshotConfiguration(ggCfg.getSnapshotConfiguration());
        if (snapCfg.getMessageDigestFactory() == null) {
            snapCfg.setMessageDigestFactory((MessageDigestFactory)new MessageDigestFactoryImpl());
        }
        if (snapCfg.getRegistryTransformer() == null) {
            snapCfg.setRegistryTransformer((SnapshotRegistryTransformer)new NoopSnapshotRegistryTransformer());
        }
        this.snapCfg = snapCfg;
        this.dfltPointInTimeRecoveryEnabled = snapCfg.isPointInTimeRecoveryEnabled();
        DatabaseSnapshotSpi snapSpi = TEST_SNAPSHOT_SPI.get();
        if (snapSpi == null) {
            snapSpi = new FileDatabaseSnapshotSpi();
            ((FileDatabaseSnapshotSpi)snapSpi).setSnapshotDirectory(snapCfg.getSnapshotsPath());
        } else {
            TEST_SNAPSHOT_SPI.set(null);
        }
        this.dbSnapshotSpi = snapSpi;
    }

    public SnapshotConfiguration config() {
        return this.snapCfg;
    }

    public DatabaseSnapshotSpi snapshotSpi() {
        return this.dbSnapshotSpi;
    }

    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.cctx.kernalContext().addNodeAttribute("plugins.gg.snapshot.security.settings", (Object)(this.config().getMessageDigestFactory().getAlgorithmCode() + ";" + this.config().getRegistryTransformer().getTransformerName()));
        this.mutableCustomMsgs = this.cctx.discovery().mutableCustomMessages();
        this.snapApi = new GridSnapshotImpl(this.cctx, (GridSnapshotManager)this, this.snapCfg);
        if (!this.cctx.kernalContext().clientNode()) {
            this.dbSharedMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
            this.pageSize = this.cctx.gridConfig().getDataStorageConfiguration().getPageSize();
        }
        this.startSnapshotExecutors();
        if (this.listenersAdded.compareAndSet(false, true)) {
            this.addListeners();
        }
        this.cctx.kernalContext().internalSubscriptionProcessor().registerMetastorageListener((MetastorageLifecycleListener)this);
        this.distributedSnapshotSecurityLevel = new DistributedSnapshotSecurityLevel(this.cctx.kernalContext());
        this.trackingPageLog.setLog(this.log);
        this.cctx.exchange().registerExchangeAwareComponent((PartitionsExchangeAware)this);
        this.cctx.tm().trackPendingTxs();
        this.checkExchangelessSnapshotRestrictionsOnStart();
        this.registerPointInTimeRecoveryDistributedProperties();
        this.logCompressionCodecs();
    }

    private void registerPointInTimeRecoveryDistributedProperties() {
        this.cctx.kernalContext().internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.exchangelessPointInTimeRecoveryMode.addListener(DistributedConfigurationUtils.makeUpdateListener((String)PITR_PROPERTY_UPDATE_MESSAGE, (IgniteLogger)this.log));
            dispatcher.registerProperty((DistributedChangeableProperty)this.exchangelessPointInTimeRecoveryMode);
        });
        this.cctx.kernalContext().internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled.addListener(DistributedConfigurationUtils.makeUpdateListener((String)GridCacheSnapshotManager.PITR_PROPERTY_UPDATE_MESSAGE, (IgniteLogger)GridCacheSnapshotManager.this.log));
                GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled.addListener((name, oldVal, newVal) -> GridCacheSnapshotManager.this.pointInTimeDistributedPropertyChangesListener.onPropertyChanged((Boolean)newVal));
                dispatcher.registerProperties((DistributedChangeableProperty[])new DistributedBooleanProperty[]{GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled});
            }

            public void onReadyToWrite() {
                GridCacheSnapshotManager.this.pointInTimeDistributedPropertyChangesListener.onDistributedMetastorageReadyForWrite();
            }
        });
    }

    private void checkExchangelessSnapshotRestrictionsOnStart() {
        if (IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true) && this.pointInTimeRecoveryEnabled() && !this.exchangelessPointInTimeRecoveryModeEnabled() && this.log.isInfoEnabled()) {
            this.log.info(PITR_TURNED_ON_EXCHANGELESS_SNAPSHOTS_DISABLED_MSG);
        }
        if (this.cctx.kernalContext().config().getDataStorageConfiguration() != null && GridCacheUtils.isPersistenceEnabled((IgniteConfiguration)this.cctx.kernalContext().config()) && this.cctx.kernalContext().config().getDataStorageConfiguration().getWalMode() == WALMode.NONE && this.log.isInfoEnabled()) {
            this.log.info(WAL_MODE_NONE_WARNING_ON_START);
        }
    }

    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.state = State.INACTIVE;
        try {
            if (!this.cctx.kernalContext().clientNode()) {
                this.dbSnapshotSpi.stop();
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to stop database snapshot SPI", (Throwable)e);
        }
        this.cctx.exchange().unregisterExchangeAwareComponent((PartitionsExchangeAware)this);
    }

    protected void onKernalStart0(boolean active) {
        super.onKernalStart0(active);
        this.pointInTimeDistributedPropertyChangesListener.onKernalStart();
    }

    protected void onKernalStop0(boolean cancel) {
        ExecutorService snapshotMsgExecutor;
        super.onKernalStop0(cancel);
        for (SnapshotOperationFuture fut : this.operationFutures()) {
            fut.destroy(new IgniteCheckedException("Node stopping."));
        }
        StripedExecutor snapshotExecutor = this.snapshotExecutor;
        if (snapshotExecutor != null) {
            snapshotExecutor.shutdownNow();
        }
        if ((snapshotMsgExecutor = this.snapshotMsgExecutor) != null) {
            snapshotMsgExecutor.shutdownNow();
        }
        if (snapshotExecutor != null) {
            try {
                snapshotExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.log.warning("Error while waiting for snapshot executor termination", (Throwable)ex);
            }
        }
        if (snapshotMsgExecutor != null) {
            try {
                snapshotMsgExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.log.warning("Error while waiting for snapshot executor termination", (Throwable)ex);
            }
        }
        this.snapshotExecutor = null;
        this.snapshotMsgExecutor = null;
        try {
            this.cutStore.cleanup();
        }
        catch (IgniteCheckedException ex) {
            this.log.warning("Cannot cleanup consistent cut store", (Throwable)ex);
        }
        this.unRegisterMetricsMXBean();
    }

    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activated snapshot manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + ']');
        }
        if (this.state == State.INACTIVE) {
            this.startSnapshotExecutors();
        }
        this.distributedSnapshotSecurityLevel.onActivate(kctx);
        this.cctx.kernalContext().resource().injectGeneric((Object)this.dbSnapshotSpi);
        this.cctx.kernalContext().resource().injectGeneric((Object)this.config().getMessageDigestFactory());
        this.cctx.kernalContext().resource().injectGeneric((Object)this.config().getRegistryTransformer());
        this.dbSnapshotSpi.start();
        this.state = State.ACTIVE;
        this.firstActivationFut.onDone();
        this.registerMetricsMXBean();
    }

    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        metastorage.iterate(METASTORE_KEY_PREFIX, (key, val) -> {
            SnapshotCountersDescriptor desc = (SnapshotCountersDescriptor)((Object)((Object)val));
            Integer grpId = Integer.valueOf(key.replace(METASTORE_KEY_PREFIX, ""));
            if (this.log.isInfoEnabled()) {
                this.log.info("Read descriptor " + (Object)((Object)desc));
            }
            long lastSuccessfulSnapshotTag = desc.lastSuccessfulSnapshotTag();
            long nextSnapshotTag = desc.nextSnapshotTag();
            assert (lastSuccessfulSnapshotTag != nextSnapshotTag) : "grpId = " + grpId + ", nextSnapshotTag = lastSuccessfulSnapshotTag =" + nextSnapshotTag;
            this.lastSuccessfulSnapshotIdsForCacheGrp.putIfAbsent(grpId, desc.lastSuccessfulSnapshotId());
            this.lastSuccessfulFullSnapshotIdsForCacheGrp.putIfAbsent(grpId, desc.lastSuccessfulFullSnapshotId());
            this.lastSuccessfulSnapshotTagForCacheGrp.putIfAbsent(grpId, lastSuccessfulSnapshotTag);
            this.nextSnapshotTagForCacheGrp.putIfAbsent(grpId, nextSnapshotTag);
        }, true);
        SnapshotMetastoreCommonInformation commonInfo = (SnapshotMetastoreCommonInformation)((Object)metastorage.read(COMMON_INFO_METASTORE_KEY));
        if (commonInfo != null) {
            this.lastSuccessfulFullSnapshotIdForAllCaches = commonInfo.lastFullSnapshotIdForAllCaches();
        }
    }

    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) {
        this.metastorage = metastorage;
    }

    private void startSnapshotExecutors() {
        this.snapshotExecutor = new StripedExecutor(this.operationFutRefs.size(), this.cctx.igniteInstanceName(), "db-snapshot-executor", this.log, (IgniteInClosure & Serializable)t -> U.error((IgniteLogger)this.log, (Object)"Unexpected exception occurred in a snapshot executor pool", (Throwable)t), null, this.cctx.kernalContext().config().getFailureDetectionTimeout().longValue());
        this.snapshotMsgExecutor = this.initializeSnapshotThreadPool("db-snapshot-msg-executor");
        Runnable awaitActivationTask = () -> {
            try {
                this.firstActivationFut.get();
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"First activation future was unexpectedly completed with error", (Throwable)e);
            }
        };
        for (int i = 0; i < this.snapshotExecutor.stripesCount(); ++i) {
            this.snapshotExecutor.execute(i, awaitActivationTask);
        }
        this.snapshotMsgExecutor.execute(awaitActivationTask);
    }

    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deactivated snapshot manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + ']');
        }
        this.onKernalStop0(false);
        this.stop0(false);
    }

    private void registerMetricsMXBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        this.snapshotMetricsMXBean = new SnapshotMetricsMXBeanImpl(this.dbSnapshotSpi.snapshotWorkingDirectory());
        this.snapshotMXBean = new SnapshotMXBeanImpl(this.cctx);
        try {
            IgniteConfiguration cfg = this.cctx.kernalContext().config();
            this.snapshotMetricsMbeanName = U.registerMBean((MBeanServer)cfg.getMBeanServer(), (String)cfg.getIgniteInstanceName(), (String)METRICS_MBEAN_NAME, (String)METRICS_MBEAN_NAME, (Object)this.snapshotMetricsMXBean, SnapshotMetricsMXBean.class);
            this.snapshotMbeanName = U.registerMBean((MBeanServer)cfg.getMBeanServer(), (String)cfg.getIgniteInstanceName(), (String)MBEAN_NAME, (String)MBEAN_NAME, (Object)this.snapshotMXBean, SnapshotMXBean.class);
            this.dbSnapshotSpi.setSnapshotMetrics((SnapshotMetricsMXBean)this.snapshotMetricsMXBean);
        }
        catch (Throwable e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to register MBean for snapshot metrics", (Throwable)e);
        }
    }

    private void unRegisterMetricsMXBean() {
        ObjectName mBeanName = this.snapshotMetricsMbeanName;
        if (mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            if (this.snapshotMetricsMbeanName != null) {
                this.cctx.kernalContext().config().getMBeanServer().unregisterMBean(this.snapshotMetricsMbeanName);
                this.snapshotMetricsMXBean = null;
                this.snapshotMetricsMbeanName = null;
            }
            if (this.snapshotMbeanName != null) {
                this.cctx.kernalContext().config().getMBeanServer().unregisterMBean(this.snapshotMbeanName);
                this.snapshotMXBean = null;
                this.snapshotMbeanName = null;
            }
        }
        catch (Throwable e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to unregister SnapshotMetrics MBean.", (Throwable)e);
        }
    }

    private ExecutorService initializeSnapshotThreadPool(String msg) {
        return Executors.newSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory(this.cctx.igniteInstanceName(), msg));
    }

    private void addListeners() {
        this.cctx.gridIO().addMessageListener(GridTopic.TOPIC_SNAPSHOT, new GridMessageListener(){

            public void onMessage(final UUID nodeId, final Object msg, byte plc) {
                if (GridCacheSnapshotManager.this.log.isDebugEnabled()) {
                    GridCacheSnapshotManager.this.log.debug("New message from TOPIC_SNAPSHOT received [msg=" + msg + ", fromNode=" + GridCacheSnapshotManager.this.cctx.discovery().node(nodeId) + ", localNode=" + GridCacheSnapshotManager.this.cctx.localNode() + ", plc=" + plc + ']');
                }
                GridCacheSnapshotManager.this.submitTaskToSnapshotMessageExecutor(new Runnable(){

                    @Override
                    public void run() {
                        if (GridCacheSnapshotManager.this.state == State.INACTIVE) {
                            return;
                        }
                        for (SnapshotOperationFuture snOpFut : GridCacheSnapshotManager.this.operationFutures()) {
                            snOpFut.onMessage(nodeId, msg);
                        }
                    }
                });
            }
        });
        GridDiscoveryManager discovery = this.cctx.discovery();
        discovery.setCustomEventListener(StartSnapshotOperationDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<StartSnapshotOperationDiscoveryMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartSnapshotOperationDiscoveryMessage msg) {
                if (GridCacheSnapshotManager.this.log.isDebugEnabled()) {
                    GridCacheSnapshotManager.this.log.debug("StartSnapshotOperationDiscoveryMessage received [msg=" + msg + ", topVer=" + topVer + ", snd=" + snd + ", localNode=" + GridCacheSnapshotManager.this.cctx.localNode() + ']');
                }
                GridCacheSnapshotManager.this.processStartSnapshotOperationDiscoveryMessage(msg, topVer);
            }
        });
        discovery.setCustomEventListener(StartSnapshotOperationAckDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<StartSnapshotOperationAckDiscoveryMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartSnapshotOperationAckDiscoveryMessage msg) {
                if (GridCacheSnapshotManager.this.log.isDebugEnabled()) {
                    GridCacheSnapshotManager.this.log.debug("StartSnapshotOperationAckDiscoveryMessage received [msg=" + msg + ", topVer=" + topVer + ", snd=" + snd + ", localNode=" + GridCacheSnapshotManager.this.cctx.localNode() + ']');
                }
                GridCacheSnapshotManager.this.processStartSnapshotOperationAckDiscoveryMessage(msg, topVer);
            }
        });
        discovery.setCustomEventListener(FinishSnapshotOperationAckDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<FinishSnapshotOperationAckDiscoveryMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, FinishSnapshotOperationAckDiscoveryMessage msg) {
                if (GridCacheSnapshotManager.this.log.isDebugEnabled()) {
                    GridCacheSnapshotManager.this.log.debug("FinishSnapshotOperationAckDiscoveryMessage received[msg=" + msg + ", topVer=" + topVer + ", snd=" + snd + ", localNode=" + GridCacheSnapshotManager.this.cctx.localNode() + ']');
                }
                GridCacheSnapshotManager.this.processFinishSnapshotOperationAckDiscoveryMessage(msg, topVer);
            }
        });
        this.cctx.gridEvents().addDiscoveryEventListener(new DiscoveryEventListener(){

            public void onEvent(final DiscoveryEvent e, final DiscoCache discoCache) {
                if (GridCacheSnapshotManager.this.state == State.INACTIVE) {
                    return;
                }
                GridCacheSnapshotManager.this.submitTaskToSnapshotMessageExecutor(new Runnable(){

                    @Override
                    public void run() {
                        GridCacheSnapshotManager.this.distributedSnapshotSecurityLevel.onNodeLeft(e.eventNode());
                        for (SnapshotOperationFuture snapshotOperationFut : GridCacheSnapshotManager.this.operationFutures()) {
                            if (snapshotOperationFut == null) {
                                return;
                            }
                            assert (e.type() == 11 || e.type() == 12) : e;
                            ClusterNode n = e.eventNode();
                            assert (!GridCacheSnapshotManager.this.cctx.localNode().id().equals(n.id()));
                            assert (GridCacheSnapshotManager.this.cctx.discovery().node(n.id()) == null);
                            snapshotOperationFut.onNodeLeft(n, discoCache);
                        }
                    }
                });
            }
        }, 11, new int[]{12});
        this.cctx.gridEvents().addDiscoveryEventListener((evt, discoCache) -> this.pointInTimeDistributedPropertyChangesListener.onTopologyChanged(), 10, new int[]{11, 12});
    }

    private void processStartSnapshotOperationDiscoveryMessage(final StartSnapshotOperationDiscoveryMessage msg, AffinityTopologyVersion topVer) {
        block17: {
            SnapshotOperationFuture snOpFut;
            block19: {
                block18: {
                    if (this.state == State.INACTIVE) {
                        return;
                    }
                    AtomicReference<SnapshotOperationFuture> operationFutRef = this.operationFutureReference(msg.snapshotOperation().type());
                    while (true) {
                        boolean crd;
                        boolean done = (snOpFut = operationFutRef.get()) != null && snOpFut.isDone();
                        ClusterNode crdNode = this.cctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
                        boolean bl = crd = crdNode != null && crdNode.isLocal();
                        if (done) {
                            if (!operationFutRef.compareAndSet(snOpFut, null)) {
                                this.releaseParts(this.reservedParts.get());
                                continue;
                            }
                            snOpFut = null;
                        }
                        if (snOpFut != null && !msg.operationId().equals((Object)snOpFut.id())) {
                            if (msg.validatedByCoordinator()) {
                                assert (!snOpFut.started() && snOpFut.initiator() && this.reservedParts.get() == null) : "snOpFut.started() - " + snOpFut.started() + ", snOpFut.initiator() - " + snOpFut.initiator() + ", reservedParts.get()=" + this.reservedParts.get();
                                operationFutRef.set(null);
                                final SnapshotOperationFuture finalSnOpFut = snOpFut;
                                this.submitTaskToSnapshotExecutor(finalSnOpFut.type(), new Runnable(){

                                    @Override
                                    public void run() {
                                        finalSnOpFut.destroy(msg.error());
                                    }
                                });
                                snOpFut = null;
                            } else {
                                if (crd) {
                                    msg.error(new IllegalStateException("Concurrent snapshot operations are not allowed cluster-wide. Wait while snapshot process will be ended. Snapshot in progress [" + snOpFut + ']'));
                                    if (!this.mutableCustomMsgs) {
                                        msg.stopProcess(true);
                                    }
                                }
                                return;
                            }
                        }
                        if (msg.hasError()) {
                            if (snOpFut != null) {
                                this.destroySnapshotFuture(msg, snOpFut);
                            }
                            break block17;
                        }
                        if (this.mutableCustomMsgs && !msg.validatedByCoordinator() && !crd) break block17;
                        msg.validatedByCoordinator(true);
                        this.generateEncryptionKeys(msg, crd);
                        if (snOpFut != null) break block18;
                        snOpFut = this.createSnapshotOperationFuture(this.currentProtocolVersion(), msg.snapshotOperation().type(), msg.operationId(), false, msg.initiatorNodeId(), null, null, topVer, msg.snapshotOperation());
                        if (operationFutRef.compareAndSet(null, snOpFut)) break;
                    }
                    for (SnapshotOperationFuture fut : this.operationFutures()) {
                        if (fut == snOpFut) continue;
                        if (fut.type().isExclusiveOperation()) {
                            operationFutRef.compareAndSet(snOpFut, null);
                            msg.error(new IllegalStateException("Concurrent snapshot operations are not allowed cluster-wide. Exclusive operation is in process: " + fut.snapshotInfo()));
                            this.log.error("Operation canceled", (Throwable)msg.error());
                            return;
                        }
                        if (!snOpFut.type().isExclusiveOperation()) continue;
                        fut.cancelAsync(false);
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info("Exclusive operation started. Pending operation will be canceled [fut=" + fut + ']');
                    }
                    break block19;
                }
                if (snOpFut.topologyVersion() == null) {
                    snOpFut.topologyVersion(topVer);
                }
            }
            assert (this.reservedParts.get() == null || msg.snapshotOperation().type() == SnapshotOperationType.CONSISTENT_CUT) : this.reservedParts.get();
            if (!snOpFut.checkStartMessage(msg, this.mutableCustomMsgs)) {
                this.destroySnapshotFuture(msg, snOpFut);
            }
        }
    }

    private void generateEncryptionKeys(StartSnapshotOperationDiscoveryMessage msg, boolean crd) {
        if (!crd) {
            return;
        }
        EncryptionSpi encryptionSpi = this.cctx.kernalContext().config().getEncryptionSpi();
        if (encryptionSpi instanceof NoopEncryptionSpi) {
            return;
        }
        try {
            switch (msg.snapshotOperation().type()) {
                case CREATE: {
                    SnapshotEncryptionOptions ops = GridSnapshotOperationAttrs.getEncryptionOptions((GridSnapshotOperationEx)msg.snapshotOperation());
                    if (ops == null || F.isEmpty((Map)ops.getEncryptedCacheKeys())) break;
                    Map<Integer, GroupKey> encryptionKeys = SnapshotUtils.createSnapshotEncryptionKeys(encryptionSpi, ops.getEncryptedCacheKeys().keySet());
                    String masterKeyName = ops.getMasterKeyName();
                    if (F.isEmpty((String)masterKeyName)) {
                        this.log.warning("Master key was not set, cluster key would be used for snapshot.");
                        masterKeyName = encryptionSpi.getMasterKeyName();
                    }
                    GridSnapshotOperationAttrs.setEncryptionOptions((GridSnapshotOperationEx)msg.snapshotOperation(), (SnapshotEncryptionOptions)new SnapshotEncryptionOptions(masterKeyName, encryptionSpi.masterKeyDigest(masterKeyName), SnapshotUtils.encryptSnapshotEncryptionKeys(encryptionSpi, encryptionKeys, masterKeyName), ops.optimizedCompressedEncryption()));
                    break;
                }
                case RESTORE: {
                    if (F.isEmpty((Map)GridSnapshotOperationAttrs.getRestoreEncryptionKeys((GridSnapshotOperationEx)msg.snapshotOperation()))) break;
                    Map<Integer, GroupKey> encryptionKeys = SnapshotUtils.createSnapshotEncryptionKeys(encryptionSpi, GridSnapshotOperationAttrs.getRestoreEncryptionKeys((GridSnapshotOperationEx)msg.snapshotOperation()).keySet());
                    GridSnapshotOperationAttrs.setRestoreEncryptionKeys((GridSnapshotOperationEx)msg.snapshotOperation(), SnapshotUtils.encryptSnapshotEncryptionKeys(encryptionSpi, encryptionKeys, encryptionSpi.getMasterKeyName()));
                    break;
                }
            }
        }
        catch (IgniteSpiException spiEx) {
            U.error((IgniteLogger)this.log, (Object)spiEx.getMessage(), (Throwable)spiEx);
            msg.error((Exception)((Object)new IgniteCheckedException(spiEx.getMessage())));
        }
    }

    private void destroySnapshotFuture(final StartSnapshotOperationDiscoveryMessage msg, SnapshotOperationFuture snOpFut) {
        AtomicReference<SnapshotOperationFuture> operationFutRef = this.operationFutureReference(snOpFut.type());
        boolean b = operationFutRef.compareAndSet(snOpFut, null);
        assert (b && this.reservedParts.get() == null) : this.reservedParts.get();
        final SnapshotOperationFuture finalSnOpFut = snOpFut;
        this.submitTaskToSnapshotExecutor(finalSnOpFut.type(), new Runnable(){

            @Override
            public void run() {
                finalSnOpFut.destroy(msg.error());
            }
        });
    }

    private void processStartSnapshotOperationAckDiscoveryMessage(final StartSnapshotOperationAckDiscoveryMessage msg, final AffinityTopologyVersion topVer) {
        if (this.state == State.INACTIVE) {
            return;
        }
        AtomicReference<SnapshotOperationFuture> operationFutRef = this.operationFutureReference(msg.snapshotOperation().type());
        final SnapshotOperationFuture snOpFut = operationFutRef.get();
        if (msg.hasError()) {
            if (snOpFut != null && snOpFut.id().equals((Object)msg.operationId())) {
                operationFutRef.compareAndSet(snOpFut, null);
                assert (this.reservedParts.get() == null) : this.reservedParts.get();
                this.submitTaskToSnapshotExecutor(snOpFut.type(), new Runnable(){

                    @Override
                    public void run() {
                        snOpFut.destroy(msg.error());
                    }
                });
            }
        } else {
            if (snOpFut == null) {
                return;
            }
            ArrayList<ClusterNode> nodes = this.getServerNodes(snOpFut.topologyVersion());
            SnapshotOperationInfoImpl snapshotInfo = new SnapshotOperationInfoImpl(snOpFut.id(), msg.snapshotOperation(), msg.initiatorNodeId(), topVer, nodes);
            snOpFut.init(snapshotInfo);
            if (!snOpFut.checkStartAckMessage(msg, this.mutableCustomMsgs) && snOpFut != null && snOpFut.id().equals((Object)msg.operationId())) {
                operationFutRef.compareAndSet(snOpFut, null);
                assert (this.reservedParts.get() == null) : this.reservedParts.get();
                this.submitTaskToSnapshotExecutor(snOpFut.type(), new Runnable(){

                    @Override
                    public void run() {
                        snOpFut.destroy(msg.error());
                    }
                });
            }
            if (!msg.needExchange()) {
                this.submitTaskToSnapshotMessageExecutor(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GridCacheSnapshotManager.this.startLocalSnapshotOperation(msg.initiatorNodeId(), msg.snapshotOperation(), topVer);
                        }
                        catch (IgniteCheckedException e) {
                            U.error((IgniteLogger)GridCacheSnapshotManager.this.log, (Object)"Error while starting snapshot operation", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    @NotNull
    private ArrayList<ClusterNode> getServerNodes(AffinityTopologyVersion topVer) {
        if (topVer == null) {
            topVer = this.cctx.discovery().topologyVersionEx();
        }
        Collection nodes0 = this.cctx.discovery().serverTopologyNodes(topVer.topologyVersion());
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(nodes0.size());
        for (ClusterNode node : nodes0) {
            nodes.add((ClusterNode)new TcpDiscoveryNode(node));
        }
        return nodes;
    }

    private void processFinishSnapshotOperationAckDiscoveryMessage(final FinishSnapshotOperationAckDiscoveryMessage msg, final AffinityTopologyVersion topVer) {
        GridSnapshotOperationEx snapshotOperation;
        SnapshotOperationFuture snOpFut;
        AtomicReference<SnapshotOperationFuture> operationFutRef = null;
        SnapshotOperationFuture snOpFut0 = null;
        for (AtomicReference<SnapshotOperationFuture> futRef : this.operationFutRefs) {
            snOpFut0 = futRef.get();
            if (snOpFut0 != null && msg.operationId().equals((Object)snOpFut0.id())) {
                operationFutRef = futRef;
                break;
            }
            snOpFut0 = null;
        }
        if ((snOpFut = snOpFut0) == null) {
            return;
        }
        SnapshotOperationInfoImpl snapshotInfo = snOpFut.snapshotInfo();
        boolean notInBaseline0 = snOpFut.isNotInBaseline();
        assert (this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon() || snOpFut.isCurrentStageFinished() || notInBaseline0) : "isDaemonOrClient=" + (this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon()) + ", snapFut.isCurrentStageFinished=" + snOpFut.isCurrentStageFinished() + ", fut=" + snOpFut + ", snOpFut.isNotInBaseline=" + notInBaseline0;
        assert (operationFutRef != null);
        operationFutRef.set(null);
        if (this.snapshotMetricsMXBean != null && snapshotInfo != null && !GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)snapshotInfo.snapshotOperation())) {
            this.snapshotMetricsMXBean.snapshotFinished(snapshotInfo.snapshotId());
        }
        final T2<GridSnapshotOperationEx, Set<GroupPartitionId>> partToResolve = this.reservedParts.get();
        this.reservedParts.set(null);
        GridSnapshotOperationEx gridSnapshotOperationEx = snapshotOperation = snapshotInfo != null ? snapshotInfo.snapshotOperation() : null;
        assert (this.cctx.kernalContext().clientNode() || snapshotOperation != null) : "Snapshot future is not initialized on finish step on server node. operationId = " + msg.operationId();
        this.submitTaskToSnapshotExecutor(snOpFut.type(), new Runnable(){

            @Override
            public void run() {
                try {
                    IgniteInternalFuture fut;
                    if (msg.needExchange() && !(fut = GridCacheSnapshotManager.this.cctx.exchange().affinityReadyFuture(topVer)).isDone()) {
                        fut.get();
                    }
                    snOpFut.finish(msg);
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)GridCacheSnapshotManager.this.log, (Object)("Failed to finish snapshot operation [op=" + snapshotOperation + ']'), (Throwable)e);
                }
                finally {
                    GridCacheSnapshotManager.this.releaseParts((T2<GridSnapshotOperationEx, Set<GroupPartitionId>>)partToResolve);
                }
            }
        });
        if (msg.success() && snapshotOperation != null && snapshotOperation.type() == SnapshotOperationType.CREATE) {
            this.updateLastSnapshotIdsInLocalMap(snapshotOperation);
        }
    }

    private SnapshotOperationFuture createSnapshotOperationFuture(int protoVer, SnapshotOperationType type, IgniteUuid id, boolean initiator, UUID initiatorId, GridFutureAdapter clientInitFut, GridFutureAdapter clientDoneFut, @Nullable AffinityTopologyVersion topVer, GridSnapshotOperationEx snapshotOperation) {
        SnapshotOperationFuture opFut;
        switch (type) {
            case CHECK: {
                opFut = new SnapshotCheckFuture(protoVer, id, initiator, initiatorId, clientInitFut, (GridFutureAdapter<List<SnapshotIssue>>)clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case CREATE: {
                opFut = new SnapshotCreateFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean, false);
                break;
            }
            case DELETE: {
                opFut = new SnapshotDeleteFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case MOVE: {
                opFut = new SnapshotMoveFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case COPY: {
                opFut = new SnapshotCopyFuture(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, (GridFutureAdapter<Void>)clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case RESTORE: {
                opFut = new SnapshotRestoreFuture(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case RECOVERY: {
                opFut = new SnapshotRecoveryFuture(protoVer, id, initiator, initiatorId, (GridFutureAdapter<?>)clientInitFut, (GridFutureAdapter<?>)clientDoneFut, this, (GridCacheSharedContext<?, ?>)this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case REPLICATION_RECOVERY: {
                opFut = new ReplicationRecoveryFuture(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, (GridFutureAdapter<Long>)clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case TEST: {
                opFut = new SnapshotTestFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case CONSISTENT_CUT: {
                opFut = new ConsistentCutFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case REPLICATION_STATE_CHANGE: {
                opFut = new ReplicationStateChangeFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            case CONFIGURABLE: {
                opFut = new SnapshotConfigurableFuture(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected snapshot operation - " + type));
            }
        }
        if (topVer != null) {
            opFut.topologyVersion(topVer);
        }
        return opFut;
    }

    public GridSnapshot dbApi() {
        return this.snapApi;
    }

    public SnapshotFuture<Void> startGlobalSnapshotCreation(Set<String> cacheNames, @Nullable File storePath, boolean fullSnapshot, @Nullable Map<String, Serializable> metaParameters, @Nullable String msg, @Nullable IgniteUuid opId, SnapshotCreateParameters snapshotCreateParameters) {
        return this.startGlobalSnapshotCreation(cacheNames, storePath, fullSnapshot, metaParameters, msg, opId, new SnapshotCommonParameters(), snapshotCreateParameters);
    }

    private boolean isExtendedCompressionSupported() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().aliveServerNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_COMPRESSION_EXTENDED_OPTION);
    }

    private void validateCompressionCodec(CompressionOption codec, boolean zipCompressionSupported) {
        if (!this.snapCfg.isCompressionCodecSupported(codec)) {
            throw new IgniteException("Unsupported compression codec: " + codec);
        }
        if (codec == CompressionOption.ZIP && !zipCompressionSupported) {
            throw new IgniteException(ZIP_COMPRESSION_IS_NOT_FULLY_SUPPORTED);
        }
        if (!(codec != CompressionOption.ZSTD && codec != CompressionOption.LZ4 && codec != CompressionOption.SNAPPY || this.isExtendedCompressionSupported())) {
            throw new IgniteException("Not entire set of nodes support compression option: " + codec);
        }
    }

    private void validateCompressionLevel(CompressionOption compOpt, int lvl) {
        if (!compOpt.isCompressed() && lvl != -1) {
            throw new IgniteException(INAPPLICABLE_COMPRESSION_LEVEL);
        }
        if (lvl != -1 && !compOpt.isCompressionLvlValid(lvl)) {
            throw new IgniteException("Invalid compression level=" + lvl + ", should be between " + compOpt.minCompressionLevel() + " and " + compOpt.maxCompressionLevel());
        }
    }

    public SnapshotFuture<Void> startGlobalSnapshotCreation(Set<String> cacheNames, @Nullable File storePath, boolean fullSnapshot, @Nullable Map<String, Serializable> metaParameters, @Nullable String msg, @Nullable IgniteUuid opId, SnapshotCommonParameters snapshotCommonParameters, SnapshotCreateParameters snapshotCreateParameters) {
        Map<Integer, CacheGroupDescriptor> cacheGroups;
        SnapshotSecurityLevel securityLevel;
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        boolean zipCompressionSupported = this.isZipCompressionSupported();
        boolean commonParametersSupported = this.isCommonParametersSupported();
        CompressionOption compressionOption = snapshotCreateParameters.getCompressionOption();
        this.validateCompressionCodec(compressionOption, zipCompressionSupported);
        if (snapshotCommonParameters.getSnapshotOperationParallelism() <= 0) {
            throw new IgniteException(PARALLELISM_SHOULD_BE_POSITIVE);
        }
        if (snapshotCreateParameters.getWriteThrottlingThreshold() < 0) {
            throw new IgniteException(THROTTLING_SHOULD_BE_POSITIVE);
        }
        this.validateCompressionLevel(compressionOption, snapshotCreateParameters.getCompressionLevel());
        try {
            securityLevel = this.validateSecuritySettings(SnapshotSecurityLevel.DISABLED);
            cacheGroups = this.validateAndResolveCacheGroups(cacheNames);
        }
        catch (Exception e) {
            return this.errorSnapshotFuture(new IgniteCheckedException((Throwable)e));
        }
        long id = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Create snapshot request received [snapshotId=" + id + ", caches=" + cacheNames + ", msg='" + msg + "', full - " + fullSnapshot + ", snapshotCommonParameters - " + snapshotCommonParameters + ", snapshotCreateParameters - " + snapshotCreateParameters + ", securityLevel - " + securityLevel + "]");
        }
        if (opId == null) {
            opId = IgniteUuid.randomUuid();
        }
        HashMap<String, Object> extraParam0 = new HashMap<String, Object>();
        if (!F.isEmpty(metaParameters)) {
            extraParam0.putAll(metaParameters);
        }
        boolean exchangeless = this.checkExchangelessOptionWithFallback(snapshotCreateParameters);
        snapshotCreateParameters.exchangelessSnapshot(exchangeless);
        extraParam0.put("FULL_SNAPSHOT", fullSnapshot);
        extraParam0.put("EXCHANGELESS_SNAPSHOT", exchangeless);
        GridSnapshotOperationAttrs.CREATE_PATH_KEY.put(extraParam0, (Object)storePath);
        if (zipCompressionSupported || snapshotCreateParameters instanceof SnapshotCreateTransferParameters) {
            extraParam0.put("SNAPSHOT_CREATE_PARAMETERS", snapshotCreateParameters);
            if (commonParametersSupported) {
                extraParam0.put("SNAPSHOT_COMMON_PARAMETERS_KEY", snapshotCommonParameters);
            }
        }
        extraParam0.put("SNAPSHOT_SECURITY_LEVEL_KEY", securityLevel.name());
        if (cacheGroups.values().stream().anyMatch(grp -> grp.config().isEncryptionEnabled())) {
            GroupKeyEncrypted emptyKey = new GroupKeyEncrypted(0, new byte[0]);
            Map<Integer, GroupKeyEncrypted> grpsWithEncryption = cacheGroups.values().stream().filter(cacheDesc -> cacheDesc.config().isEncryptionEnabled()).map(CacheGroupDescriptor::groupId).collect(Collectors.toMap(grpId -> grpId, grpId -> emptyKey));
            extraParam0.put("SNAPSHOT_ENCRYPTION_OPS", new SnapshotEncryptionOptions(snapshotCreateParameters.encryptionMasterKeyName(), null, grpsWithEncryption, this.getOptimizedCompressedEncryptionOption(compressionOption)));
        }
        HashMap<String, Object> extraParam = extraParam0;
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.CREATE, id, new HashSet<Integer>(cacheGroups.keySet()), this.resolveCacheNames(cacheGroups.keySet()), msg, extraParam, null, null, null);
        StartSnapshotOperationDiscoveryMessage discoMsg = new StartSnapshotOperationDiscoveryMessage(opId, operation, this.cctx.localNodeId(), this.lastSuccessfulFullSnapshotIdForAllCaches, this.mutableCustomMsgs);
        boolean inNotBaseline = SnapshotUtils.nodeIsNotInBaseline(this.cctx.localNode(), this.cctx, AffinityTopologyVersion.NONE);
        boolean supportsSmartIncremental = IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY);
        for (CacheGroupDescriptor grpDesc : cacheGroups.values()) {
            if (inNotBaseline || !this.cctx.discovery().cacheGroupAffinityNode(this.cctx.localNode(), grpDesc.groupId())) continue;
            long snapshotId = this.getLastSuccessfulSnapshotIdForCacheGroup(grpDesc.groupId());
            discoMsg.lastSnapshotId(grpDesc.groupId(), snapshotId);
            if (supportsSmartIncremental || snapshotId != 0L || fullSnapshot || snapshotCreateParameters.allCaches() && this.lastSuccessfulFullSnapshotIdForAllCaches != 0L) continue;
            IgniteCheckedException e = new IgniteCheckedException("Can't create incremental snapshot: last full snapshot was not found for cache group = " + grpDesc.cacheOrGroupName() + " on node = " + this.cctx.localNode());
            return this.errorSnapshotFuture(e);
        }
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.CREATE, opId, (GridSnapshotOperationEx)operation);
        try {
            this.cctx.discovery().sendCustomEvent((DiscoveryCustomMessage)discoMsg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return fut;
    }

    private boolean getOptimizedCompressedEncryptionOption(CompressionOption compressionOption) {
        return compressionOption.isCompressed() && IgniteFeatures.allNodesSupport((GridKernalContext)this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.OPTIMIZED_COMPRESSED_ENCRYPTED_SNAPSHOTS) && IgniteSystemProperties.getBoolean((String)"GG_OPTIMIZED_COMPRESSED_ENCRYPTED_SNAPSHOTS", (boolean)true);
    }

    private void validatePartitionLoss(Collection<String> cacheNames) {
        ArrayList<String> cachesWithLostPartitions = new ArrayList<String>();
        for (String cacheName : cacheNames) {
            GridCacheContext cacheCtx = this.cctx.cacheContext(CU.cacheId((String)cacheName));
            if (cacheCtx == null || cacheCtx.config().getPartitionLossPolicy() == PartitionLossPolicy.IGNORE || cacheCtx.topology().lostPartitions().isEmpty()) continue;
            cachesWithLostPartitions.add(cacheName);
        }
        if (!cachesWithLostPartitions.isEmpty()) {
            throw new IgniteException("The partition loss policy doesn't allow to create snapshot for caches with lost partitions [cachesWithLostPartitions=" + cachesWithLostPartitions + ']');
        }
    }

    private boolean checkExchangelessOptionWithFallback(SnapshotCreateParameters snapshotCreateParameters) {
        if (snapshotCreateParameters.exchangelessSnapshot()) {
            if (this.pointInTimeRecoveryEnabled() && !this.exchangelessPointInTimeRecoveryModeEnabled()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(PITR_ENABLED_MESSAGE_ON_CREATION);
                }
                return false;
            }
            if (this.cctx.kernalContext().config().getDataStorageConfiguration() != null && this.cctx.kernalContext().config().getDataStorageConfiguration().getWalMode() == WALMode.NONE) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(WAL_MODE_NONE_MESSAGE_ON_CREATION);
                }
                return false;
            }
            if (!IgniteFeatures.allNodesSupport((GridKernalContext)this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.EXCHANGELESS_SNAPSHOT)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Creating snapshot with exchange, because some nodes in cluster don't support EXCHANGELESS_SNAPSHOT feature.");
                }
                return false;
            }
        }
        return snapshotCreateParameters.exchangelessSnapshot();
    }

    private boolean isNotActive() {
        return this.state != State.ACTIVE || !this.cctx.kernalContext().state().publicApiActiveState(false);
    }

    private Set<String> resolveCacheNames(Set<Integer> grpIds) {
        HashSet<String> cacheNames = new HashSet<String>();
        for (Integer grpId : grpIds) {
            CacheGroupDescriptor grpDesc = (CacheGroupDescriptor)this.cctx.cache().cacheGroupDescriptors().get(grpId);
            if (grpDesc == null) continue;
            cacheNames.addAll(grpDesc.caches().keySet());
        }
        return cacheNames;
    }

    public SnapshotFuture<Void> startGlobalSnapshotRestore(long snapshotId, @Nullable Set<String> includedCacheOrGroups, boolean forceRestore, @Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg, SnapshotCommonParameters snapshotCommonParameters, @Nullable Map<String, Serializable> metaParameters) {
        return this.startGlobalSnapshotRestore(snapshotId, includedCacheOrGroups, null, forceRestore, optSearchPaths, c, msg, snapshotCommonParameters, metaParameters);
    }

    public SnapshotFuture<Void> startGlobalSnapshotRestore(long snapshotId, @Nullable Set<String> includedCacheOrGroups, @Nullable Set<String> excludedCacheOrGroups, boolean forceRestore, @Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg, SnapshotCommonParameters snapshotCommonParameters, @Nullable Map<String, Serializable> metaParameters) {
        SnapshotOperationParameters params;
        SnapshotSecurityLevel securityLevel;
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        if (snapshotCommonParameters.getSnapshotOperationParallelism() <= 0) {
            throw new IgniteException(PARALLELISM_SHOULD_BE_POSITIVE);
        }
        boolean commonParametersSupported = this.isCommonParametersSupported();
        if (this.log.isInfoEnabled()) {
            this.log.info("Restore snapshot request received [snapshotId=" + snapshotId + ", caches=" + includedCacheOrGroups + ", excludedCaches=" + excludedCacheOrGroups + ", msg='" + msg + "']");
        }
        try {
            if (c != null) {
                this.cctx.kernalContext().resource().injectGeneric(c);
            }
            securityLevel = this.validateSecuritySettings(SnapshotSecurityLevel.IGNORE_EXISTING);
            params = this.resolveSnapshotOperationParameters(snapshotId, SnapshotOperationType.RESTORE, includedCacheOrGroups, excludedCacheOrGroups, forceRestore, optSearchPaths, c);
            this.validateCacheNamesClash(snapshotId, params.cacheGroupIds(), params.cacheNamesWithGroupId());
        }
        catch (IgniteCheckedException ex) {
            return this.errorSnapshotFuture(ex);
        }
        if (this.log.isInfoEnabled()) {
            if (params.cacheNames() != null && !params.cacheNames().equals(includedCacheOrGroups)) {
                this.log.info("Restoring all caches from affected cache groups [snapshotId=" + snapshotId + ", caches=" + params.cacheNames() + ", restoreStrategy=" + params.restoreStrategy() + ", optSearchPaths=" + optSearchPaths + ", snapshotCommonParameters - " + snapshotCommonParameters + ", securityLevel=" + securityLevel + "]");
            } else {
                this.log.info("Chosen snapshot restore strategy [snapshotId=" + snapshotId + ", restoreStrategy=" + params.restoreStrategy() + ", optSearchPaths=" + optSearchPaths + ", snapshotCommonParameters - " + snapshotCommonParameters + ", securityLevel=" + securityLevel + "]");
            }
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (optSearchPaths != null) {
            if (this.isSupportSftpDestination()) {
                GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY_V2.put(attrs, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths));
            } else {
                GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY.put(attrs, GridCacheSnapshotManager.convertToFileCollection(optSearchPaths));
            }
        }
        attrs.put("FORCE_RESTORE_KEY", forceRestore);
        attrs.put("SNAPSHOT_RESTORE_STRATEGY", params.restoreStrategy());
        attrs.put("SNAPSHOT_SECURITY_LEVEL_KEY", securityLevel.name());
        if (metaParameters != null) {
            attrs.putAll(metaParameters);
        }
        if (commonParametersSupported) {
            attrs.put("SNAPSHOT_COMMON_PARAMETERS_KEY", snapshotCommonParameters);
        }
        try {
            SnapshotDescriptor descriptor = this.getSnapshotDescriptorFromCluster(snapshotId, GridSnapshotOperationAttrs.getOptionalPathsParameter((SnapshotOperationType)SnapshotOperationType.RESTORE, attrs), c);
            Map cacheGroupsMetadata = descriptor.snapshotMetadata().cacheMetadata();
            if (cacheGroupsMetadata.values().stream().anyMatch(CacheSnapshotMetadata::isEncryptionEnabled)) {
                GroupKeyEncrypted emptyKey = new GroupKeyEncrypted(0, new byte[0]);
                Map<Integer, GroupKeyEncrypted> grpsWithEncryption = cacheGroupsMetadata.values().stream().filter(CacheSnapshotMetadata::isEncryptionEnabled).map(CacheSnapshotMetadata::groupId).collect(Collectors.toMap(grpId -> grpId, grpId -> emptyKey));
                attrs.put("SNAPSHOT_RESTORE_ENCRYPTION_KEYS", grpsWithEncryption);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to get a snapshot distribution description.  [Id=" + snapshotId + ']'), (Throwable)e);
        }
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.RESTORE, snapshotId, params.cacheGroupIds(), params.cacheNames(), msg, attrs, null, null, c);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.RESTORE, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    @Nullable
    private static Collection<File> convertToFileCollection(@Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths) {
        if (optSearchPaths == null) {
            return null;
        }
        return optSearchPaths.stream().map(org.gridgain.grid.persistentstore.SnapshotPath::path).collect(Collectors.toList());
    }

    @Nullable
    private static Collection<File> convertToFileCollection0(@Nullable Collection<SnapshotRemotePath> optSearchPaths) {
        if (optSearchPaths == null) {
            return null;
        }
        return optSearchPaths.stream().map(SnapshotRemotePath::path).collect(Collectors.toList());
    }

    @Nullable
    private static Collection<SnapshotRemotePath> convertToSnapshotPathCollection(@Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> paths) {
        if (paths == null) {
            return null;
        }
        return paths.stream().map(SnapshotRemotePath::new).collect(Collectors.toList());
    }

    protected boolean isSupportSftpDestination() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_SFTP_UPLOAD_V2);
    }

    private boolean isSecuritySettingsCompatible() {
        Object settings = null;
        for (ClusterNode next : this.cctx.discovery().aliveServerNodes()) {
            Object attr = next.attribute("plugins.gg.snapshot.security.settings");
            if (settings == null) {
                settings = attr == null ? "" : attr;
                continue;
            }
            if (F.eq(settings, (Object)attr)) continue;
            return false;
        }
        return true;
    }

    private boolean isZipCompressionSupported() {
        return GridGainFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().aliveServerNodes(), (GridGainFeatures)GridGainFeatures.SNAPSHOT_ZIP_COMPRESSION);
    }

    private boolean isCommonParametersSupported() {
        return GridGainFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().aliveServerNodes(), (GridGainFeatures)GridGainFeatures.COMMON_PARAMETERS_SUPPORTED);
    }

    public SnapshotFuture<Void> startGlobalRecoveryToPointInTime(long time, @Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, @Nullable Set<String> cacheNames, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        SnapshotOperationParameters params;
        SnapshotSecurityLevel securityLevel;
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        if (!this.pointInTimeRecoveryEnabled()) {
            throw new IllegalStateException("Recovery to point in time is disabled in configuration");
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Point in time recovery request received [time=" + time + ", caches=" + cacheNames + ", msg='" + msg + "']");
        }
        long snapshotId = this.resolveLastSnapshot(time, optSearchPaths);
        boolean hasEncryptedCache = false;
        try {
            SnapshotDescriptor descriptor = this.getSnapshotDescriptorFromCluster(snapshotId, null, c);
            Map cacheGroupsMetadata = descriptor.snapshotMetadata().cacheMetadata();
            if (cacheGroupsMetadata.values().stream().anyMatch(CacheSnapshotMetadata::isEncryptionEnabled)) {
                hasEncryptedCache = true;
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to get a snapshot distribution description.  [Id=" + snapshotId + ']'), (Throwable)e);
        }
        if (hasEncryptedCache) {
            return this.errorSnapshotFuture(new IgniteCheckedException("Point in time recovery is not allowed if there is encrypted cache"));
        }
        Map<Object, Set<Object>> consistentIdMapping = null;
        try {
            securityLevel = this.validateSecuritySettings(SnapshotSecurityLevel.IGNORE_EXISTING);
            params = this.chooseStrategyOfRestore(snapshotId, SnapshotOperationType.RECOVERY, cacheNames, null, optSearchPaths, true, c);
            this.validateCacheNamesClash(snapshotId, params.cacheGroupIds(), params.cacheNamesWithGroupId());
            if (params.restoreStrategy() == SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING) {
                consistentIdMapping = this.calcConsistentIdMapping(optSearchPaths, c, snapshotId, params);
            }
        }
        catch (IgniteCheckedException ex) {
            if (UserCommandExceptions.causedByUserCommandException((Throwable)ex)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Snapshot request encountered an exception [ex=" + (Object)((Object)ex) + ']');
                }
            } else {
                U.error((IgniteLogger)this.log, (Object)"Error while calculating snapshot strategy", (Throwable)ex);
            }
            return this.errorSnapshotFuture(ex);
        }
        if (this.log.isInfoEnabled() && params.cacheNames() != null && !params.cacheNames().equals(cacheNames)) {
            this.log.info("Recovering all caches from affected cache groups: [snapshotId=" + snapshotId + ", caches=" + params.cacheNames() + "]");
        }
        HashMap<String, Object> extraParam = new HashMap<String, Object>();
        extraParam.put("POINT_IN_TIME", time);
        extraParam.put("SNAPSHOT_RESTORE_STRATEGY", params.restoreStrategy());
        if (this.isSupportSftpDestination()) {
            GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY_V2.put(extraParam, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths));
        } else {
            GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY.put(extraParam, GridCacheSnapshotManager.convertToFileCollection(optSearchPaths));
        }
        if (params.stgy == SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING) {
            assert (consistentIdMapping != null);
            extraParam.put("CONSISTENT_ID_MAPPING", consistentIdMapping);
        }
        extraParam.put("SNAPSHOT_SECURITY_LEVEL_KEY", securityLevel.name());
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.RECOVERY, snapshotId, params.cacheGroupIds(), params.cacheNames(), msg, extraParam, null, null, c);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.RECOVERY, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    public SnapshotFuture<Long> startGlobalReplicationRecovery(Set<UUID> nodes, long replicationSesId, String msg) {
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        HashMap<String, Object> extraParam = new HashMap<String, Object>();
        extraParam.put("REPLICATION_SESSION_ID", replicationSesId);
        extraParam.put("REPLICATION_RECOVERY_NODES", nodes);
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl op = new GridSnapshotOperationImpl(SnapshotOperationType.REPLICATION_RECOVERY, 0L, null, null, msg, extraParam, null, null, null);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.REPLICATION_RECOVERY, opId, (GridSnapshotOperationEx)op);
        this.sendDiscoveryMessage(opId, op);
        return fut;
    }

    private Map<Object, Set<Object>> calcConsistentIdMapping(@Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, long snapshotId, SnapshotOperationParameters params) throws IgniteCheckedException {
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotId, SnapshotPathFactory.create(GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths), this.log, this.snapCfg.getSftpConfiguration()), c, true, null, false);
        assert (snapshot != null && snapshot.metadata() != null) : "Snapshot doesn't exist id=" + snapshotId + ", path=" + optSearchPaths;
        SnapshotMetadataV2 meta = snapshot.metadata();
        Map<Integer, IgnitePredicate> nodeFilters = this.collectNodeFilters(params, meta);
        List srvNodes = this.cctx.discovery().serverNodes(this.cctx.discovery().topologyVersionEx());
        if (srvNodes.isEmpty()) {
            throw new IllegalStateException("No nodes to do recovery");
        }
        HashMap<String, Object> oldCIds = new HashMap<String, Object>();
        for (ClusterNode node : meta.topology()) {
            oldCIds.put(U.maskForFileName((CharSequence)node.consistentId().toString()), node.consistentId());
        }
        HashMap<Object, Set<Object>> finalConsistentIdMapping = new HashMap<Object, Set<Object>>();
        if (!nodeFilters.isEmpty()) {
            Map<String, Set<Object>> oldConsistentId2NewOneMapping = this.oldConsistentId2NewOneMapping(meta, nodeFilters, srvNodes);
            int cnt = 1;
            while (!oldConsistentId2NewOneMapping.isEmpty()) {
                for (Map.Entry<String, Set<Object>> entry : oldConsistentId2NewOneMapping.entrySet()) {
                    Set<Object> newCIds = entry.getValue();
                    if (newCIds.size() != cnt) continue;
                    this.addOldCIdToNewCIdWithMinimalSizeOfOldCIdsSet(finalConsistentIdMapping, newCIds, oldCIds.get(entry.getKey()));
                    oldConsistentId2NewOneMapping.remove(entry.getKey());
                }
                ++cnt;
            }
        } else {
            Iterator iter = srvNodes.iterator();
            Set newClusterCIds = srvNodes.stream().map(x -> x.consistentId()).collect(Collectors.toSet());
            for (ClusterNode clusterNode : meta.topology()) {
                Object consistentId = clusterNode.consistentId();
                if (!meta.baselineTopology().consistentIds().contains(consistentId)) continue;
                String cId = U.maskForFileName((CharSequence)consistentId.toString());
                if (newClusterCIds.contains(consistentId)) {
                    finalConsistentIdMapping.computeIfAbsent(consistentId, x -> new HashSet()).add(cId);
                    continue;
                }
                if (!iter.hasNext()) {
                    iter = srvNodes.iterator();
                }
                ClusterNode next = (ClusterNode)iter.next();
                assert (next != null);
                finalConsistentIdMapping.computeIfAbsent(next.consistentId(), x -> new HashSet()).add(cId);
            }
        }
        return finalConsistentIdMapping;
    }

    private void addOldCIdToNewCIdWithMinimalSizeOfOldCIdsSet(Map<Object, Set<Object>> finalConsistentIdMapping, Set<Object> newCIds, Object oldCId) {
        Object minCId = null;
        int minSize = Integer.MAX_VALUE;
        if (newCIds.contains(oldCId)) {
            finalConsistentIdMapping.computeIfAbsent(oldCId, x -> new HashSet()).add(oldCId);
        } else {
            for (Object newCId : newCIds) {
                Set<Object> oldCIds = finalConsistentIdMapping.get(newCId);
                if (oldCIds == null) {
                    finalConsistentIdMapping.computeIfAbsent(newCId, x -> new HashSet()).add(oldCId);
                    minCId = null;
                    break;
                }
                if (oldCIds.size() >= minSize) continue;
                minSize = oldCIds.size();
                minCId = newCId;
            }
            if (minCId != null) {
                finalConsistentIdMapping.computeIfAbsent(minCId, x -> new HashSet()).add(oldCId);
            }
        }
    }

    private Map<Integer, IgnitePredicate> collectNodeFilters(SnapshotOperationParameters params, SnapshotMetadataV2 meta) throws IgniteCheckedException {
        HashMap<Integer, IgnitePredicate> nodeFilters = new HashMap<Integer, IgnitePredicate>();
        for (Integer grpId : params.cacheGroupIds()) {
            CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)meta.cacheGroupsMetadata().get(grpId);
            if (cacheMeta == null) {
                throw new IgniteCheckedException("No data about group id in meta! grpId=" + grpId);
            }
            assert (cacheMeta.checkPartitions());
            assert (!cacheMeta.cacheConfigurations().isEmpty());
            CacheConfiguration cacheConfiguration = (CacheConfiguration)cacheMeta.cacheConfigurations().iterator().next();
            if (cacheConfiguration.getNodeFilter() == null) continue;
            nodeFilters.put(grpId, cacheConfiguration.getNodeFilter());
        }
        return nodeFilters;
    }

    private Map<String, Set<Object>> oldConsistentId2NewOneMapping(SnapshotMetadataV2 meta, Map<Integer, IgnitePredicate> nodeFilters, List<ClusterNode> srvNodes) {
        HashMap<String, Set> grpIdsForOldConsistentIds = new HashMap<String, Set>();
        HashMap<Object, Set> gprIdsForNewConsistentIds = new HashMap<Object, Set>();
        for (CacheSnapshotMetadata cacheMeta : meta.cacheGroupsMetadata().values()) {
            int grpId = cacheMeta.groupId();
            IgnitePredicate nodeFilterForGrp = nodeFilters.get(grpId);
            for (ClusterNode clusterNode : srvNodes) {
                if (nodeFilterForGrp != null && !nodeFilterForGrp.apply((Object)clusterNode)) continue;
                gprIdsForNewConsistentIds.computeIfAbsent(clusterNode.consistentId(), x -> new HashSet()).add(grpId);
            }
            for (Map map : cacheMeta.partitionSizesPerNode().values()) {
                for (Map.Entry e : map.entrySet()) {
                    grpIdsForOldConsistentIds.computeIfAbsent((String)e.getKey(), x -> new HashSet()).add(grpId);
                }
            }
        }
        ConcurrentHashMap<String, Set<Object>> oldConsistentId2NewOneMapping = new ConcurrentHashMap<String, Set<Object>>();
        for (Map.Entry e : grpIdsForOldConsistentIds.entrySet()) {
            Set grpIds = (Set)e.getValue();
            for (Map.Entry entry : gprIdsForNewConsistentIds.entrySet()) {
                if (!((Set)entry.getValue()).containsAll(grpIds)) continue;
                oldConsistentId2NewOneMapping.computeIfAbsent((String)e.getKey(), (Function<String, Set<Object>>)((Function<String, Set>)x -> new HashSet())).add(entry.getKey());
            }
        }
        return oldConsistentId2NewOneMapping;
    }

    private long resolveLastSnapshot(long time, @Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths) {
        try {
            List<SnapshotInfoEssential> snapshots = this.getSnapshotList(optSearchPaths);
            SnapshotInfoEssential candidate = null;
            long minDelta = Long.MAX_VALUE;
            for (SnapshotInfoEssential snp : snapshots) {
                long delta;
                long snpId = snp.snapshotId();
                if (time < snpId || (delta = time - snpId) >= minDelta) continue;
                boolean canRestore = true;
                if (!F.isEmpty((Map)snp.clusterCutTimestamps())) {
                    for (Map.Entry nodeTimestamp : snp.clusterCutTimestamps().entrySet()) {
                        if (time < snpId || time > (Long)nodeTimestamp.getValue()) continue;
                        canRestore = false;
                        break;
                    }
                }
                if (!canRestore) continue;
                candidate = snp;
                minDelta = delta;
            }
            if (this.log.isInfoEnabled()) {
                if (candidate == null) {
                    this.log.info("Snapshot not found for recovery, will try to recover from WAL itself.");
                } else {
                    this.log.info("Recovery over last found snapshot, snapshotId=" + candidate + " full=" + candidate.fullSnapshot());
                }
            }
            return candidate == null ? -1L : candidate.snapshotId();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public List<SnapshotInfoEssential> getSnapshotList(@Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths) throws IgniteCheckedException {
        this.checkClusterState();
        if (this.log.isInfoEnabled()) {
            this.log.info("Received request to collect snapshot list from cluster, optSearchPaths = " + optSearchPaths);
        }
        ComputeTaskInternalFuture fut = this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotListTask(), null);
        TreeMap<Long, SnapshotInfoEssential> res = new TreeMap<Long, SnapshotInfoEssential>();
        if (optSearchPaths != null) {
            for (org.gridgain.grid.persistentstore.SnapshotPath optSearchPath : optSearchPaths) {
                SnapshotPath searchPath = SnapshotPathFactory.create(new SnapshotRemotePath(optSearchPath), this.config().getSftpConfiguration());
                searchPath = CachedSnapshotPath.cachedPath((SnapshotPath)searchPath);
                Map walSizes = null;
                for (SnapshotMetadataV2 meta : this.dbSnapshotSpi.listRemoteSnapshots(searchPath)) {
                    SnapshotInfo info = (SnapshotInfo)res.get(meta.id());
                    if (info == null) {
                        HashMap<String, String> val = new HashMap<String, String>();
                        val.put("SNAPSHOT_DIR", searchPath.getAbsolutePath());
                        if (meta.pointInTimeRecoveryEnabled() && walSizes == null) {
                            walSizes = this.dbSnapshotSpi.remoteSnapshotWalSizes(searchPath);
                        }
                        Map cutTimestamps = null;
                        if (meta.pointInTimeRecoveryEnabled() && meta.exchangelessSnapshot()) {
                            meta.consistentCutMetas().entrySet().stream().collect(Collectors.toMap(k -> (Short)k.getKey(), v -> ((ConsistentCutMeta)v.getValue()).cutPtrTime()));
                        }
                        res.put(meta.id(), new SnapshotInfoEssential(meta.id(), meta.fullSnapshot(), meta.initiatorNodeId(), meta.cacheNames(), meta.message(), meta.topology().size(), meta.baselineTopology().size(), Collections.singletonMap("<CLUSTER_WIDE>", val), meta.compressionOption(), meta.compressionLevel(), meta.sizeInBytes(), !meta.pointInTimeRecoveryEnabled() ? 0L : walSizes.getOrDefault(meta.id(), 0L), meta.topology().stream().map(ClusterNode::version).collect(Collectors.toSet()), cutTimestamps));
                        continue;
                    }
                    this.addAdditionalPath(info, searchPath.getAbsolutePath());
                }
            }
        }
        for (SnapshotInfoEssential info : ((CollectSnasphotListTaskResult)fut.get()).infos().values()) {
            if (res.containsKey(info.snapshotId())) {
                SnapshotInfo snapshotInfo = (SnapshotInfo)res.get(info.snapshotId());
                if (snapshotInfo.fullSnapshot() != info.fullSnapshot() || !snapshotInfo.initiatorNode().equals(info.initiatorNode())) {
                    U.warn((IgniteLogger)this.log, (Object)("SnapshotInfo contain conflicting information on different nodes! SnapshotId = " + info.snapshotId() + ", FullSnapshot - " + snapshotInfo.fullSnapshot() + " vs. " + info.fullSnapshot() + ", InitiatorNode - " + snapshotInfo.initiatorNode() + " vs. " + snapshotInfo.initiatorNode()));
                }
                this.addAdditionalPath(snapshotInfo, "<LOCAL>");
                continue;
            }
            res.put(info.snapshotId(), info);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("GetSnapshotList: Collecting snapshots finished, size = " + res.size());
        }
        return new ArrayList<SnapshotInfoEssential>(res.values());
    }

    private void addAdditionalPath(SnapshotInfo info, String path) {
        Map attrs = info.snapshotAttributes();
        assert (attrs != null && attrs.size() == 1);
        Map clusterWideAttrs = (Map)attrs.get("<CLUSTER_WIDE>");
        assert (clusterWideAttrs instanceof HashMap);
        clusterWideAttrs.put(path, "SNAPSHOT_DIR");
    }

    @Nullable
    public SnapshotInfoExtended getSnapshotInfo(long snapshotId, @Nullable Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths) throws IgniteCheckedException {
        this.checkClusterState();
        if (this.log.isInfoEnabled()) {
            this.log.info("Received request to collect snapshot info for id = " + snapshotId + ", optSearchPaths = " + optSearchPaths);
        }
        return this.getSnapshotInfo0(snapshotId, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths));
    }

    @Nullable
    private SnapshotInfoExtended getSnapshotInfo0(long snapshotId, @Nullable Collection<SnapshotRemotePath> optSearchPaths) throws IgniteCheckedException {
        CollectSnapshotInfoTaskResultV2 info = this.isSupportSftpDestination() ? (CollectSnapshotInfoTaskResultV2)this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotInfoTaskV2(), (Object)new CollectSnapshotInfoTaskV2.CollectSnapshotInfoTaskV2Params(snapshotId, optSearchPaths)).get() : (CollectSnapshotInfoTaskResultV2)this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotInfoTask(), (Object)new T3((Object)snapshotId, GridCacheSnapshotManager.convertToFileCollection0(optSearchPaths), null)).get();
        if (info == null || info.descriptorForNode().isEmpty()) {
            return null;
        }
        SnapshotInfoExtended desc = null;
        HashMap snapshotAttrs = new HashMap();
        long size = 0L;
        long sizeWithoutIndexes = 0L;
        long walSize = 0L;
        try {
            for (SnapshotInfoExtended detail : info.descriptorForNode().values()) {
                if (desc == null) {
                    desc = detail;
                } else if (detail.snapshotAttributes() != null) {
                    snapshotAttrs.putAll(detail.snapshotAttributes());
                }
                size += detail.size();
                sizeWithoutIndexes += detail.sizeWithoutIndexes();
                walSize += detail.walSize();
            }
        }
        catch (IgniteException e) {
            U.error((IgniteLogger)this.log, (Object)("Snapshot metadata can't be merged for snapshot with id: " + snapshotId), (Throwable)e);
            throw e;
        }
        assert (desc != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received data from cluster for id = " + snapshotId);
        }
        if (!snapshotAttrs.isEmpty() || desc.size() != size || desc.walSize() != walSize) {
            if (desc.snapshotAttributes() != null) {
                snapshotAttrs.putAll(desc.snapshotAttributes());
            }
            desc = new SnapshotInfoExtended(desc.snapshotId(), desc.initiatorNode(), desc.fullSnapshot(), desc.cacheNamesWithGroups(), desc.cacheModes(), desc.topology(), desc.baselineTopology(), desc.previousSnapshots(), snapshotAttrs, desc.message(), size, sizeWithoutIndexes, desc.compressionOption(), desc.compressionLevel(), walSize, desc.masterKeyName());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Received info from cluster for id = " + snapshotId + ", description = " + desc);
        }
        return desc;
    }

    public CollectSnapshotInfoTaskResult getLocalSnapshotInfo(long snapshotId, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean compat, boolean newMeta) {
        CollectSnapshotInfoTaskResult res = new CollectSnapshotInfoTaskResult(snapshotId);
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotId, null, c, false, null, false);
        if (snapshot != null) {
            if (newMeta) {
                SnapshotDescriptorV2 desc = new SnapshotDescriptorV2(snapshot.metadata());
                desc.addAttribute(this.cctx.localNode().consistentId(), "SNAPSHOT_DIR", "<LOCAL>");
                res.descriptorForNodeV2().put(this.cctx.localNodeId(), desc);
            } else {
                CompatibleSnapshotDescriptor desc = compat ? new CompatibleSnapshotDescriptor(snapshot.metadata().toOldMetadata()) : new SnapshotDescriptor(snapshot.metadata().toOldMetadata());
                desc.addAttribute(this.cctx.localNode().consistentId(), "SNAPSHOT_DIR", "<LOCAL>");
                res.descriptorForNode().put(this.cctx.localNodeId(), (SnapshotDescriptor)desc);
            }
        }
        return res;
    }

    public SnapshotFuture<Void> startGlobalSnapshotDeletion(long snapshotId, SnapshotUpdateOperationParameters operationParams, String msg) throws IgniteCheckedException {
        NavigableSet<Long> dependentSnapshotIds;
        SnapshotOperationParameters params;
        this.checkClusterState();
        if (this.log.isInfoEnabled()) {
            this.log.info("Delete snapshot request received [snapshotId=" + snapshotId + ", msg='" + msg + '\'' + ", params=" + operationParams + "]");
        }
        SnapshotOperationType operationType = SnapshotOperationType.DELETE;
        SnapshotChainMode chainMode = this.chainMode(operationParams);
        try {
            params = this.validateAndGetSnapshotOperationParameters(snapshotId, null, (Collection<SnapshotRemotePath>)null, true);
            if (chainMode != SnapshotChainMode.SINGLE) {
                dependentSnapshotIds = this.getDependentSnapshotIds(snapshotId, params.cacheGrpIds);
                this.checkChainModeAndDepencies(chainMode, dependentSnapshotIds);
            } else {
                dependentSnapshotIds = null;
            }
            this.validatePointInTimeRecoveryRestriction(snapshotId, operationType, chainMode, false, dependentSnapshotIds);
        }
        catch (IgniteCheckedException ex) {
            return this.errorSnapshotFuture(ex);
        }
        if (this.log.isInfoEnabled() && params.cacheNames() != null) {
            this.log.info("Deleting all caches from affected cache groups [snapshotId=" + snapshotId + ", caches=" + params.cacheNames() + "]");
        }
        Map<String, SnapshotUpdateOperationParameters> extraParam = this.isCopyOperationSupportedClusterWide() ? Collections.singletonMap("SNAPSHOT_UPDATE_OPERATION_PARAMS", operationParams) : Collections.singletonMap("FORCE_FLAG", chainMode == SnapshotChainMode.FROM_CURRENT_TO_LAST);
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(operationType, snapshotId, params.cacheGroupIds(), params.cacheNames(), msg, extraParam, dependentSnapshotIds, null, null);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(operationType, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    public SnapshotFuture<List<SnapshotIssue>> startGlobalSnapshotCheck(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCacheOrGroups, boolean forceRestore, Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, boolean skipCrc, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg, SnapshotCommonParameters snapshotCommonParameters) throws IgniteCheckedException {
        return this.startGlobalSnapshotCheck(snapshotId, type, includedCacheOrGroups, null, forceRestore, optSearchPaths, skipCrc, c, msg, snapshotCommonParameters);
    }

    public SnapshotFuture<List<SnapshotIssue>> startGlobalSnapshotCheck(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCacheOrGroups, @Nullable Set<String> excludedCacheOrGroups, boolean force, Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, boolean skipCrc, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg, SnapshotCommonParameters snapshotCommonParameters) throws IgniteCheckedException {
        SnapshotOperationParameters params;
        SnapshotSecurityLevel securityLevel;
        this.checkClusterState();
        if (snapshotCommonParameters.getSnapshotOperationParallelism() <= 0) {
            throw UserCommandExceptions.invalidUserCommandException((String)PARALLELISM_SHOULD_BE_POSITIVE, (GridKernalContext)this.cctx.kernalContext());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Check snapshot request received [snapshotId=" + snapshotId + ", msg='" + msg + "']");
        }
        try {
            securityLevel = this.validateSecuritySettings(SnapshotSecurityLevel.IGNORE_EXISTING);
            params = this.resolveSnapshotOperationParameters(snapshotId, type, includedCacheOrGroups, excludedCacheOrGroups, force, optSearchPaths, c);
            this.validateCacheNamesClash(snapshotId, params.cacheGroupIds(), params.cacheNamesWithGroupId());
        }
        catch (SnapshotCheckException ex) {
            U.error((IgniteLogger)this.log, (Object)"Error snapshot resolving parameters", (Throwable)((Object)ex));
            return new SnapshotFutureImpl(this.doneFuture(null), this.doneFuture(Collections.singletonList(new SnapshotIssue("<whole snapshot>", -1, ex.getMessage()))), null);
        }
        catch (IgniteCheckedException ex) {
            if (UserCommandExceptions.causedByUserCommandException((Throwable)ex)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Snapshot request encountered an exception [ex=" + (Object)((Object)ex) + ']');
                }
            } else {
                U.error((IgniteLogger)this.log, (Object)"Error while calculating snapshot strategy", (Throwable)ex);
            }
            return this.errorSnapshotFuture(ex);
        }
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.CHECK, snapshotId, params.cacheGroupIds(), params.cacheNames(), msg, this.resolveCheckExtraParameters(optSearchPaths, skipCrc, params, force, securityLevel, snapshotCommonParameters), null, null, null);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.CHECK, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    public SnapshotFuture<Void> startGlobalSnapshotMoving(long snapshotId, org.gridgain.grid.persistentstore.SnapshotPath destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParams, String msg) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Move snapshot request received [snapshotId=" + snapshotId + ", msg='" + msg + "']");
        }
        return this.startGlobalSnapshotCopyLikeOperation(snapshotId, destPath, skipWalMove, operationParams, msg, SnapshotOperationType.MOVE);
    }

    public SnapshotFuture<Void> startGlobalSnapshotCopying(long snapshotId, org.gridgain.grid.persistentstore.SnapshotPath destPath, boolean skipWalCp, SnapshotUpdateOperationParameters operationParams, String msg) throws IgniteCheckedException {
        if (!this.isCopyOperationSupportedClusterWide()) {
            return this.errorSnapshotFuture(new IgniteCheckedException(COPY_IS_NOT_SUPPORTED));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Copy snapshot request received [snapshotId=" + snapshotId + ", msg='" + msg + "']");
        }
        return this.startGlobalSnapshotCopyLikeOperation(snapshotId, destPath, skipWalCp, operationParams, msg, SnapshotOperationType.COPY);
    }

    public SnapshotFuture<Void> startGlobalCustomSnapshotOperation(CustomStagesConfiguration customStagesConfiguration, @Nullable String msg) {
        if (customStagesConfiguration == null) {
            throw new NullPointerException("Stage configuration can't be null.");
        }
        if (!IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.kernalContext().grid().cluster().nodes(), (IgniteFeatures)IgniteFeatures.CUSTOM_SNAPSHOT_OPERATIONS)) {
            throw new IgniteException("Some nodes in cluster don't support custom cluster-wide operations, so operation will be cancelled.");
        }
        if (customStagesConfiguration.stagesNum() == 0 || customStagesConfiguration.stage(0) == null) {
            throw new IgniteException("Incorrect configuration of custom snapshot operation [cfg=" + customStagesConfiguration + "]");
        }
        long snapshotId = System.currentTimeMillis();
        HashMap<String, Object> extraParams = new HashMap<String, Object>();
        extraParams.put("CUSTOM_STAGES_CONFIGURATION", customStagesConfiguration);
        extraParams.put("IMPLICIT_SNAPSHOT_OPERATION", Boolean.TRUE);
        GridSnapshotOperationImpl snapshotOperation = new GridSnapshotOperationImpl(SnapshotOperationType.CONFIGURABLE, snapshotId, null, null, msg, extraParams, null, null, null);
        IgniteUuid opId = IgniteUuid.randomUuid();
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.CONFIGURABLE, opId, (GridSnapshotOperationEx)snapshotOperation);
        this.sendDiscoveryMessage(opId, snapshotOperation);
        return fut;
    }

    @NotNull
    private SnapshotFuture<Void> startGlobalSnapshotCopyLikeOperation(long snapshotId, org.gridgain.grid.persistentstore.SnapshotPath destPath, boolean skipWalCp, @Nullable SnapshotUpdateOperationParameters operationParams, String msg, SnapshotOperationType operationType) throws IgniteCheckedException {
        NavigableSet<Long> dependentSnapshotIds;
        this.checkClusterState();
        if (destPath.path() == null && !this.isSupportSftpDestination()) {
            throw new IgniteCheckedException("Not all nodes support upload via SFTP feature!");
        }
        IgniteUuid opId = IgniteUuid.randomUuid();
        SnapshotChainMode chainMode = this.chainMode(operationParams);
        SnapshotInfoExtended desc = this.getSnapshotInfo0(snapshotId, null);
        try {
            this.validateAndGetSnapshotOperationParameters(snapshotId, null, desc, false);
            if (chainMode != SnapshotChainMode.SINGLE) {
                dependentSnapshotIds = this.getDependentSnapshotIds(snapshotId, null);
                this.checkChainModeAndDepencies(chainMode, dependentSnapshotIds);
            } else {
                dependentSnapshotIds = null;
            }
            if (operationParams != null && operationParams.singleFileCopy()) {
                this.validateSingleCopyRestrictions(desc, chainMode, skipWalCp);
            }
            this.validatePointInTimeRecoveryRestriction(snapshotId, operationType, chainMode, skipWalCp, dependentSnapshotIds);
        }
        catch (IgniteCheckedException ex) {
            return this.errorSnapshotFuture(ex);
        }
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(operationType, snapshotId, null, null, msg, this.resolveMoveOrCopyExtraParameters(destPath, skipWalCp, operationParams), dependentSnapshotIds, null, null);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(operationType, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    private void validateSingleCopyRestrictions(SnapshotInfoExtended desc, SnapshotChainMode chainMode, boolean skipWalCp) throws IgniteCheckedException {
        if (!desc.fullSnapshot() || chainMode != SnapshotChainMode.DEFAULT && chainMode != SnapshotChainMode.SINGLE) {
            throw this.invalidUserCommandCheckedException("'Single partition copy' is allowed only for single full snapshot.");
        }
        if (this.pointInTimeRecoveryEnabled() && !skipWalCp) {
            throw this.invalidUserCommandCheckedException("'Single partition copy' is not allowed for moving wal files. Use -skipWal parameter.");
        }
    }

    public SnapshotStatus getOngoingOperation() throws IgniteCheckedException {
        this.checkClusterState();
        ClusterNode crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, this.cctx);
        if (crd == null) {
            return null;
        }
        if (crd.isLocal()) {
            SnapshotOperationFuture snOpFut = this.snapshotFut.get();
            if (snOpFut != null) {
                if (snOpFut.initialized()) {
                    return snOpFut.snapshotStatus();
                }
                if (snOpFut.delayed()) {
                    ArrayList<ClusterNode> nodes = this.getServerNodes(snOpFut.topVer);
                    return new SnapshotStatus(snOpFut.id(), (SnapshotOperationInfo)new SnapshotOperationInfoImpl(snOpFut.id(), (GridSnapshotOperationEx)new GridSnapshotOperationImpl(SnapshotOperationType.CREATE, -1L, Collections.emptySet(), Collections.emptySet(), "DELAYED SNAPSHOT CREATION", Collections.singletonMap("FULL_SNAPSHOT", true), null, null, null), snOpFut.initiatorNodeId(), snOpFut.topVer, nodes), Collections.emptyMap(), -1L, -1L, 0, false);
                }
            }
            return null;
        }
        ComputeTaskInternalFuture fut = this.cctx.kernalContext().task().execute((ComputeTask)new GetOngoingOperationTask(), null);
        return (SnapshotStatus)fut.get();
    }

    public IgniteInternalFuture<Boolean> cancelSnapshotOperation(IgniteUuid id, boolean force, String msg) {
        for (AtomicReference<SnapshotOperationFuture> opRef : this.operationFutRefs) {
            SnapshotOperationFuture fut = opRef.get();
            if (fut == null || !fut.id().equals((Object)id)) continue;
            if (!force && fut.type() == SnapshotOperationType.DELETE) {
                return new GridFinishedFuture((Throwable)new IgniteException("Snapshot operation in non-cancelable state! Use -force to stop ASAP DELETE operation."));
            }
            return fut.cancelAsync(force);
        }
        return new GridFinishedFuture((Object)false);
    }

    public CollectSnapshotInfoTaskResultV2 getLocalSnapshotInfoV2(long snapshotId, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
        CollectSnapshotInfoTaskResultV2 res = new CollectSnapshotInfoTaskResultV2(snapshotId);
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotId, null, c, false, null, false);
        if (snapshot != null) {
            HashMap<String, String> val = new HashMap<String, String>();
            val.put("SNAPSHOT_DIR", "<LOCAL>");
            HashMap<Object, HashMap<String, String>> attrs = new HashMap<Object, HashMap<String, String>>();
            attrs.put(this.cctx.localNode().consistentId(), val);
            SnapshotMetadataV2 metadata = snapshot.metadata(U.maskForFileName((CharSequence)this.cctx.localNode().consistentId().toString()));
            if (metadata == null || !metadata.isCorrect()) {
                this.log.warning("Broken metadata for snapshotId = " + snapshotId + ", metadata = " + metadata);
                return res;
            }
            long walSize = !metadata.pointInTimeRecoveryEnabled() ? 0L : this.localWalSize(metadata, this.dbSnapshotSpi.nextLocalSnapshot(metadata.id()));
            SnapshotInfoExtended desc = new SnapshotInfoExtended(metadata.id(), metadata.initiatorNodeId(), metadata.fullSnapshot(), metadata.cacheNamesWithGroups(), metadata.cacheModes(), metadata.topology(), metadata.baselineTopology(), metadata.previousSnapshots(), attrs, metadata.message(), metadata.sizeInBytes(), metadata.sizeOnlyDataInBytes(), metadata.compressionOption(), metadata.compressionLevel(), walSize, metadata.encryptionOptions() != null ? metadata.encryptionOptions().getMasterKeyName() : null);
            res.descriptorForNode().put(this.cctx.localNodeId(), desc);
        }
        return res;
    }

    public SnapshotFuture<Object> startGlobalTestSnapshotOperation(Map<String, Object> params, String msg) throws IgniteCheckedException {
        IgniteUuid opId = IgniteUuid.randomUuid();
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.TEST, -1L, null, null, msg, params, null, null, null);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.TEST, opId, (GridSnapshotOperationEx)operation);
        this.sendDiscoveryMessage(opId, operation);
        return fut;
    }

    private SnapshotChainMode chainMode(@Nullable SnapshotUpdateOperationParameters operationParams) {
        return operationParams == null ? SnapshotChainMode.DEFAULT : operationParams.chainMode();
    }

    private void releaseParts(T2<GridSnapshotOperationEx, Set<GroupPartitionId>> partToRelease) {
        this.reservedParts.compareAndSet(partToRelease, null);
        if (partToRelease != null && !F.isEmpty((Collection)((Collection)partToRelease.get2()))) {
            for (GroupPartitionId groupPartitionId : (Set)partToRelease.get2()) {
                int partId = groupPartitionId.getPartitionId();
                try {
                    if (partId == 65535) continue;
                    CacheGroupContext cacheGrp = this.cctx.cache().cacheGroup(groupPartitionId.getGroupId());
                    if (cacheGrp == null) {
                        SnapshotOperationFuture fut = this.snapshotFuture();
                        if (fut != null && fut.isCancelled()) continue;
                        U.error((IgniteLogger)this.log, (Object)("cacheGroup is null for grpId = " + groupPartitionId.getGroupId() + " while releasing partitions"));
                        continue;
                    }
                    GridDhtLocalPartition part = cacheGrp.topology().localPartition(partId);
                    if (part == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("local partition is null partId =" + partId + ",  grpId = " + groupPartitionId.getGroupId() + " while releasing partitions");
                        continue;
                    }
                    part.release();
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)this.log, (Object)("Error during releasing partition = " + partId + ", grpId=" + groupPartitionId.getGroupId()), (Throwable)e);
                }
            }
        }
    }

    private void checkChainModeAndDepencies(SnapshotChainMode chainMode, NavigableSet<Long> dependentSnapshotIds) throws IgniteCheckedException {
        if (chainMode == SnapshotChainMode.DEFAULT && dependentSnapshotIds.size() > 1) {
            StringBuilder errorMsg = new StringBuilder("Use -chain parameter to define how to work with the snapshot chain. This snapshot has dependant ones, couldn't work with default settings. Dependent snapshot ids:");
            for (Long snapId : dependentSnapshotIds) {
                errorMsg.append(snapId).append(", ");
            }
            errorMsg.delete(errorMsg.length() - 2, errorMsg.length());
            throw this.invalidUserCommandCheckedException(errorMsg.toString());
        }
        if (!this.isCopyOperationSupportedClusterWide() && chainMode != SnapshotChainMode.DEFAULT && chainMode != SnapshotChainMode.FROM_CURRENT_TO_LAST) {
            throw this.invalidUserCommandCheckedException("SnapshotChainMode=" + chainMode + " is not supported by all nodes in cluster");
        }
    }

    private IgniteCheckedException invalidUserCommandCheckedException(String errorMessage) {
        return UserCommandExceptions.invalidUserCommandCheckedException((String)errorMessage, (GridKernalContext)this.cctx.kernalContext());
    }

    private SnapshotOperationParameters resolveSnapshotOperationParameters(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCachesOrGroups, @Nullable Set<String> excludedCachesOrGroups, boolean force, Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) throws IgniteCheckedException {
        return this.chooseStrategyOfRestore(snapshotId, type, includedCachesOrGroups, excludedCachesOrGroups, optSearchPaths, force, c);
    }

    private Object resolveCheckExtraParameters(Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, boolean skipCrc, SnapshotOperationParameters params, boolean forceRestore, SnapshotSecurityLevel securityLevel, SnapshotCommonParameters snapshotCommonParameters) {
        HashMap<String, Object> checkExtraParams = new HashMap<String, Object>();
        checkExtraParams.put("SNAPSHOT_RESTORE_STRATEGY", params.restoreStrategy());
        if (this.isSupportSftpDestination()) {
            GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY_V2.put(checkExtraParams, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths));
        } else {
            GridSnapshotOperationAttrs.OPTIONAL_SEARCH_PATHS_KEY.put(checkExtraParams, GridCacheSnapshotManager.convertToFileCollection(optSearchPaths));
        }
        checkExtraParams.put("SKIP_CRC", skipCrc);
        checkExtraParams.put("FORCE_RESTORE_KEY", forceRestore);
        checkExtraParams.put("SNAPSHOT_SECURITY_LEVEL_KEY", securityLevel.name());
        if (this.isCommonParametersSupported()) {
            checkExtraParams.put("SNAPSHOT_COMMON_PARAMETERS_KEY", snapshotCommonParameters);
        }
        return checkExtraParams;
    }

    @NotNull
    private <T> SnapshotFuture<T> errorSnapshotFuture(IgniteCheckedException ex) {
        return new SnapshotFutureImpl(this.doneFuture(ex), this.doneFuture(ex), null);
    }

    private <T> GridFutureAdapter<T> doneFuture(T res) {
        GridFutureAdapter fut = new GridFutureAdapter();
        fut.onDone(res);
        return fut;
    }

    private <T> GridFutureAdapter<T> doneFuture(Throwable error) {
        GridFutureAdapter fut = new GridFutureAdapter();
        fut.onDone(error);
        return fut;
    }

    private void sendDiscoveryMessage(IgniteUuid opId, GridSnapshotOperationImpl operation) {
        StartSnapshotOperationDiscoveryMessage discoMsg = new StartSnapshotOperationDiscoveryMessage(opId, operation, this.cctx.localNodeId(), this.lastSuccessfulFullSnapshotIdForAllCaches, this.mutableCustomMsgs);
        try {
            this.cctx.discovery().sendCustomEvent((DiscoveryCustomMessage)discoMsg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    private boolean isCopyOperationSupportedClusterWide() {
        return GridGainFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (GridGainFeatures)GridGainFeatures.SNAPSHOT_COPY_OPERATION_SUPPORT);
    }

    private Object resolveMoveOrCopyExtraParameters(org.gridgain.grid.persistentstore.SnapshotPath destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParams) {
        if (this.isSupportSftpDestination()) {
            HashMap<String, Boolean> extraParams = new HashMap<String, Boolean>();
            GridSnapshotOperationAttrs.MOVING_PATH_KEY_V2.put(extraParams, (Object)new SnapshotRemotePath(destPath));
            extraParams.put("SKIP_WAL_MOVE_FLAG", skipWalMove);
            if (this.isCopyOperationSupportedClusterWide() && operationParams != null) {
                extraParams.put("SNAPSHOT_UPDATE_OPERATION_PARAMS", (Boolean)operationParams);
            }
            return extraParams;
        }
        HashMap<String, Boolean> extraParams = new HashMap<String, Boolean>();
        GridSnapshotOperationAttrs.MOVING_PATH_KEY.put(extraParams, (Object)destPath.path());
        extraParams.put("SKIP_WAL_MOVE_FLAG", skipWalMove);
        if (this.isCopyOperationSupportedClusterWide() && operationParams != null) {
            extraParams.put("SNAPSHOT_UPDATE_OPERATION_PARAMS", (Boolean)operationParams);
        }
        return extraParams;
    }

    private void checkClusterState() throws IgniteCheckedException {
        if (this.isNotActive()) {
            throw new IgniteCheckedException("Cluster is not active");
        }
    }

    public SnapshotFuture<Void> startGlobalConsistentCut() {
        return this.startGlobalConsistentCut(null);
    }

    public SnapshotFuture<Void> startGlobalConsistentCut(@Nullable Map<String, Serializable> extraParameters) {
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        GridSnapshotOperationImpl operation = new GridSnapshotOperationImpl(SnapshotOperationType.CONSISTENT_CUT, System.currentTimeMillis(), null, null, null, extraParameters, null, null, null);
        IgniteUuid opId = IgniteUuid.randomUuid();
        StartSnapshotOperationDiscoveryMessage discoMsg = new StartSnapshotOperationDiscoveryMessage(opId, operation, this.cctx.localNodeId(), this.lastSuccessfulFullSnapshotIdForAllCaches, this.mutableCustomMsgs);
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.CONSISTENT_CUT, opId, (GridSnapshotOperationEx)operation);
        try {
            this.cctx.discovery().sendCustomEvent((DiscoveryCustomMessage)discoMsg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return fut;
    }

    public SnapshotFuture<Void> startGlobalReplicationStateChange(ClusterRole role, ReplicationState state, long sesId, long newSesId) {
        if (this.isNotActive()) {
            throw new IllegalStateException("Cluster is not active");
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting global replication state change [role=" + role + ", state=" + state + ", sessionId=" + sesId + ']');
        }
        HashMap<String, Serializable> extraParam = new HashMap<String, Serializable>();
        extraParam.put("REPLICATION_STATE", Integer.valueOf(state.ordinal()));
        extraParam.put("REPLICATION_CLUSTER_ROLE", Integer.valueOf(role.ordinal()));
        extraParam.put("REPLICATION_SESSION_ID", Long.valueOf(sesId));
        extraParam.put("REPLICATION_NEW_SESSION_ID", Long.valueOf(newSesId));
        if (role == ClusterRole.MASTER && state == ReplicationState.SWITCH) {
            extraParam.put("NEED_EXCHANGE_ON_START", Boolean.TRUE);
        }
        GridSnapshotOperationImpl op = new GridSnapshotOperationImpl(SnapshotOperationType.REPLICATION_STATE_CHANGE, System.currentTimeMillis(), null, null, null, extraParam, null, null, null);
        IgniteUuid opId = IgniteUuid.randomUuid();
        SnapshotFutureImpl fut = this.checkAndUpdateSnapshotProgress(SnapshotOperationType.REPLICATION_STATE_CHANGE, opId, (GridSnapshotOperationEx)op);
        this.sendDiscoveryMessage(opId, op);
        return fut;
    }

    private boolean isNotCancelableOp(SnapshotOperationType op) {
        return op == SnapshotOperationType.DELETE;
    }

    SnapshotDescriptor getSnapshotDescriptorFromCluster(long snapshotId, Collection<SnapshotRemotePath> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) throws IgniteCheckedException {
        int maxSpinCnt = (int)Math.round(2.5 * Math.sqrt(this.cctx.discovery().allNodes().size())) + 3;
        HashSet<UUID> respondedNodes = new HashSet<UUID>();
        int spins = 0;
        while (spins++ < maxSpinCnt) {
            try {
                ComputeTaskInternalFuture fut = this.isSupportSftpDestination() ? this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotInfoTaskV2.CollectSnapshotDescriptorTask(), (Object)new CollectSnapshotInfoTaskV2.CollectSnapshotDescriptorTaskParams(snapshotId, optSearchPaths, c, respondedNodes, spins)) : this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotInfoTask.CollectSnapshotDescriptorTask(), (Object)new T5((Object)snapshotId, GridCacheSnapshotManager.convertToFileCollection0(optSearchPaths), c, respondedNodes, (Object)spins));
                CollectSnapshotInfoTask.SnapshotDescriptorOptional optional = (CollectSnapshotInfoTask.SnapshotDescriptorOptional)fut.get();
                if (optional.isPresent()) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("getSnapshotDescriptorFromCluster successfully finished after " + spins + " iterations.");
                    }
                    return optional.descriptor();
                }
                respondedNodes.addAll(optional.nodes());
            }
            catch (ClusterTopologyException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                break;
            }
        }
        this.log.error("Too many spins: can't find snapshot descriptor in cluster [snapshotId=" + snapshotId + "]");
        return null;
    }

    public SnapshotDescriptorV2 getMergedSnapshotDescriptorFromClusterV2(long snapshotId, Collection<File> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) throws IgniteCheckedException {
        return (SnapshotDescriptorV2)this.getMergedSnapshotDescriptorFromClusterV2Async(snapshotId, optSearchPaths, c).get();
    }

    public ComputeTaskInternalFuture<SnapshotDescriptorV2> getMergedSnapshotDescriptorFromClusterV2Async(long snapshotId, Collection<File> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
        IgniteComputeImpl compute = this.getComputeNoFailover();
        return compute.executeAsync0((ComputeTask)new CollectSnapshotDescriptorV2Task(), (Object)new T3((Object)snapshotId, optSearchPaths, c));
    }

    private IgniteComputeImpl getComputeNoFailover() {
        return (IgniteComputeImpl)((ClusterGroupAdapter)this.cctx.kernalContext().cluster().get().forServers()).compute().withNoFailover();
    }

    long getLastSuccessfulSnapshotIdForCacheGroup(int grpId) {
        Long id = (Long)this.lastSuccessfulSnapshotIdsForCacheGrp.get(grpId);
        if (id == null) {
            this.tryInitLegacyCountersForCacheGroup(grpId);
            id = this.lastSuccessfulSnapshotIdsForCacheGrp.getOrDefault(grpId, 0L);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Get snapshot counter for group = " + grpId + " lastSuccessfulSnapshotId = " + id);
        }
        return id;
    }

    long getLastSuccessfulFullSnapshotIdForCacheGroup(int grpId) {
        Long id = (Long)this.lastSuccessfulFullSnapshotIdsForCacheGrp.get(grpId);
        if (id == null) {
            this.tryInitLegacyCountersForCacheGroup(grpId);
            id = this.lastSuccessfulFullSnapshotIdsForCacheGrp.getOrDefault(grpId, 0L);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Get snapshot counter for group = " + grpId + " lastSuccessfulFullSnapshotId = " + id);
        }
        return id;
    }

    @Nullable
    public IgniteInternalFuture tryStartLocalSnapshotOperation(@Nullable DiscoveryEvent discoveryEvt, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        if (discoveryEvt != null && discoveryEvt.type() == 18) {
            Long snapshotId;
            GridClusterStateProcessor stateProc;
            DiscoveryCustomEvent discoCustomEvt = (DiscoveryCustomEvent)discoveryEvt;
            DiscoveryCustomMessage customMsg = discoCustomEvt.customMessage();
            if (customMsg instanceof StartSnapshotOperationAckDiscoveryMessage) {
                StartSnapshotOperationAckDiscoveryMessage snapshotMsg = (StartSnapshotOperationAckDiscoveryMessage)customMsg;
                assert (snapshotMsg.needExchange());
                return this.startLocalSnapshotOperation(snapshotMsg.initiatorNodeId(), snapshotMsg.snapshotOperation(), topVer);
            }
            if (fut instanceof SnapshotCreateFuture && fut.delayed() && (stateProc = this.cctx.kernalContext().state()) instanceof GridSnapshotAwareClusterStateProcessorImpl && (snapshotId = ((GridSnapshotAwareClusterStateProcessorImpl)stateProc).startSnapshot(customMsg)) != null) {
                try {
                    this.initDelayedSnapshotCreation(snapshotId, discoCustomEvt.affinityTopologyVersion(), "[src=PITR, user=CLUSTER, comment=Auto created snapshot on cluster activation for PITR]");
                    return this.startLocalSnapshotOperation(fut.initiatorNodeId(), fut.snapshotInfo().snapshotOperation(), topVer);
                }
                catch (Throwable e) {
                    fut.cancelAsync(false);
                    throw e;
                }
            }
        }
        return null;
    }

    public IgniteInternalFuture startLocalSnapshotOperation(UUID initiatorNodeId, GridSnapshotOperationEx op, final AffinityTopologyVersion topVer) throws IgniteCheckedException {
        AtomicReference<SnapshotOperationFuture> operationFutRef = this.operationFutureReference(op.type());
        final SnapshotOperationFuture fut = operationFutRef.get();
        if (SnapshotUtils.nodeIsNotInBaseline(this.cctx.localNode(), this.cctx, topVer) || this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon()) {
            if (fut != null) {
                this.submitTaskToSnapshotExecutor(fut.type(), new Runnable(){

                    @Override
                    public void run() {
                        fut.start(topVer);
                    }
                });
            }
            return null;
        }
        if (fut == null || fut.isDone()) {
            return null;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Snapshot operation " + op.type() + " " + (Object)((Object)fut.stage()) + " started at " + SnapshotTaskBase.LOG_DATE_FORMAT.format(Instant.now()) + " [snapshotId=" + op.snapshotId() + ", caches=" + op.cacheNames() + ", " + SnapshotTaskBase.buildInitiatorMessage(this.cctx.localNodeId(), initiatorNodeId) + ", msg='" + op.message() + "']");
        }
        switch (op.type()) {
            case CREATE: {
                Checkpointer cp = this.dbSharedMgr.getCheckpointer();
                fut.map(topVer);
                if (cp != null) {
                    this.updateMetastoreSnapshotCounterDecriptor(op.cacheGroupIds(), desc -> desc.nextSnapshotTag(this.getNextSnapshotTagForCacheGroup(desc.groupId()) + 1L));
                    return cp.wakeupForSnapshotCreation((SnapshotOperation)op);
                }
                return null;
            }
            case RESTORE: 
            case CHECK: 
            case DELETE: 
            case MOVE: 
            case COPY: 
            case RECOVERY: 
            case REPLICATION_RECOVERY: 
            case TEST: 
            case CONSISTENT_CUT: 
            case REPLICATION_STATE_CHANGE: 
            case CONFIGURABLE: {
                this.submitTaskToSnapshotExecutor(fut.type(), new Runnable(){

                    @Override
                    public void run() {
                        fut.start(topVer);
                    }
                });
                return new GridFinishedFuture();
            }
        }
        throw new AssertionError((Object)("Unexpected operation type - " + op.type()));
    }

    public void onCacheStop(GridCacheContext<?, ?> cctx, boolean destroy) {
        if (!destroy) {
            return;
        }
        SnapshotOperationFuture snapshotFut = this.snapshotFut.get();
        if (snapshotFut == null || snapshotFut.type() != SnapshotOperationType.CREATE) {
            return;
        }
        SnapshotOperationInfoImpl snapshotInfo = snapshotFut.snapshotInfo();
        if (snapshotInfo == null || !snapshotInfo.cacheNames().contains(cctx.name())) {
            return;
        }
        this.cancelOnCacheStop(snapshotFut);
    }

    public void onCacheGroupStop(CacheGroupContext gctx, boolean destroy) {
        int grpId = gctx.groupId();
        if (destroy) {
            this.resetSnapshotCounters(Collections.singletonMap(grpId, new SnapshotCountersDescriptor(grpId)), true);
            SnapshotOperationFuture snapshotFut = this.snapshotFut.get();
            if (snapshotFut == null || snapshotFut.type() != SnapshotOperationType.CREATE) {
                return;
            }
            SnapshotOperationInfoImpl snapshotInfo = snapshotFut.snapshotInfo();
            if (snapshotInfo == null || !snapshotInfo.snapshotOperation().cacheGroupIds().contains(grpId)) {
                return;
            }
            this.cancelOnCacheStop(snapshotFut);
        } else {
            this.nextSnapshotTagForCacheGrp.remove(grpId);
            this.lastSuccessfulSnapshotIdsForCacheGrp.remove(grpId);
            this.lastSuccessfulFullSnapshotIdsForCacheGrp.remove(grpId);
            this.lastSuccessfulSnapshotTagForCacheGrp.remove(grpId);
        }
    }

    protected void cancelOnCacheStop(SnapshotOperationFuture<?> snapshotFut) {
        IgniteInternalFuture<Boolean> fut = snapshotFut.cancelAsync(false);
        if (fut != null) {
            try {
                fut.get(60000L);
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Error occurred while waiting for snapshot cancel future to complete", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeTrackerPage(Long page, FullPageId fullId, PageMemory pageMem) {
        int grpId = fullId.groupId();
        long pageId = fullId.pageId();
        if (PageIdUtils.pageIndex((long)pageId) == 0) {
            return;
        }
        long lastSuccessfulSnapshotTag = this.getLastSuccessfulSnapshotTagForCacheGroup(grpId);
        if (lastSuccessfulSnapshotTag < 0L) {
            return;
        }
        long trackingPageId = this.latestTrackingIO.trackingPageFor(pageId, pageMem.realPageSize(grpId));
        if (pageId == trackingPageId) {
            return;
        }
        try {
            long trackingPage = pageMem.acquirePage(grpId, trackingPageId);
            try {
                long pageAddr = pageMem.writeLock(grpId, trackingPageId, trackingPage);
                try {
                    if (PageIO.getType((long)pageAddr) == 0) {
                        PageMetrics metrics = pageMem.metrics().cacheGrpPageMetrics(grpId);
                        this.latestTrackingIO.initNewPage(pageAddr, trackingPageId, pageMem.pageSize(), metrics);
                        if (PageHandler.isWalDeltaRecordNeeded((PageSupport)pageMem, (int)grpId, (long)trackingPageId, (long)trackingPage, (IgniteWriteAheadLogManager)this.cctx.wal(), null)) {
                            this.cctx.wal().log((WALRecord)new InitNewPageRecord(grpId, trackingPageId, this.latestTrackingIO.getType(), this.latestTrackingIO.getVersion(), trackingPageId));
                        }
                    }
                    long nextSnapshotTag = this.getNextSnapshotTagForCacheGroup(grpId);
                    PageIO trackingPageIO = PageIO.getPageIO((long)pageAddr);
                    assert (trackingPageIO instanceof TrackingPageIO) : trackingPageIO;
                    long lastTag = ((TrackingPageIO)trackingPageIO).markChanged(pageMem.pageBuffer(pageAddr), pageId, nextSnapshotTag, lastSuccessfulSnapshotTag, pageMem.realPageSize(grpId));
                    if (lastTag > 0L) {
                        this.trackingPageLog.log(grpId, PageIdUtils.partId((long)pageId), trackingPageId, lastTag, nextSnapshotTag);
                    }
                    if (PageHandler.isWalDeltaRecordNeeded((PageSupport)pageMem, (int)grpId, (long)trackingPageId, (long)trackingPage, (IgniteWriteAheadLogManager)this.cctx.wal(), null)) {
                        this.cctx.wal().log((WALRecord)new TrackingPageDeltaRecord(grpId, trackingPageId, pageId, nextSnapshotTag, lastSuccessfulSnapshotTag));
                    }
                }
                catch (AssertionError e) {
                    throw new AssertionError("Assert during handling page: " + fullId, (Throwable)((Object)e));
                }
                finally {
                    pageMem.writeUnlock(grpId, trackingPageId, trackingPage, null, true);
                }
            }
            finally {
                pageMem.releasePage(grpId, trackingPageId, trackingPage);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("There was an exception while updating tracking page: " + U.hexLong((long)trackingPageId)), (Throwable)e);
        }
    }

    private <T> SnapshotFutureImpl<T> checkAndUpdateSnapshotProgress(SnapshotOperationType type, IgniteUuid operationId, GridSnapshotOperationEx snapshotOperation) {
        GridFutureAdapter initFut = new GridFutureAdapter();
        GridFutureAdapter doneFut = new GridFutureAdapter();
        AtomicReference<SnapshotOperationFuture> operationFutRef = this.operationFutureReference(type);
        SnapshotOperationFuture prevOperation = operationFutRef.get();
        SnapshotOperationFuture snapOpFut = this.createSnapshotOperationFuture(this.currentProtocolVersion(), type, operationId, true, this.cctx.localNodeId(), initFut, doneFut, null, snapshotOperation);
        if (prevOperation != null) {
            if (!prevOperation.id().equals((Object)operationId)) {
                String msg = " Wait while snapshot process will be ended. Snapshot creation is in progress. [";
                msg = prevOperation.snapshotInfo != null ? msg + prevOperation.snapshotInfo().toString() + ']' : msg + "initiatorNodeId=" + prevOperation.initiatorNodeId() + ", id=" + prevOperation.id() + ']';
                throw new IllegalStateException(CONCURRENT_SNAPSHOT_OPERATIONS_ARE_NOT_ALLOWED_CLUSTER_WIDE + msg);
            }
        } else {
            if (!operationFutRef.compareAndSet(null, snapOpFut)) {
                SnapshotOperationFuture pendingProgress = operationFutRef.get();
                throw new IllegalStateException("Concurrent snapshot operations are not allowed cluster-wide. Wait while snapshot process will be ended. Pending snapshot operation: " + (pendingProgress != null ? pendingProgress.snapshotInfo() : "UNKNOWN"));
            }
            for (SnapshotOperationFuture fut : this.operationFutures()) {
                if (fut == snapOpFut) continue;
                if (fut.type().isExclusiveOperation()) {
                    operationFutRef.compareAndSet(snapOpFut, null);
                    throw new IllegalStateException("Concurrent snapshot operations are not allowed cluster-wide. Exclusive operation is in process: " + fut.snapshotInfo());
                }
                if (!type.isExclusiveOperation()) continue;
                fut.cancelAsync(false);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("Exclusive operation started. Pending operation will be canceled [fut=" + fut + ']');
            }
        }
        AffinityTopologyVersion ver = this.cctx.discovery().topologyVersionEx();
        return new SnapshotFutureImpl((IgniteInternalFuture)initFut, (IgniteInternalFuture)doneFut, (SnapshotOperationInfo)new SnapshotOperationInfoImpl(operationId, snapshotOperation, this.cctx.localNodeId(), ver, this.getServerNodes(ver)));
    }

    private int currentProtocolVersion() {
        return 1;
    }

    private Map<Integer, CacheGroupDescriptor> validateAndResolveCacheGroups(Collection<String> cacheNames) {
        if (cacheNames.isEmpty()) {
            throw new IgniteException((Throwable)new IllegalArgumentException("Empty cache list"));
        }
        HashSet<String> names = new HashSet<String>(cacheNames);
        Map<Integer, CacheGroupDescriptor> grpIdToDesc = this.cctx.kernalContext().cache().cacheDescriptors().values().stream().filter(d -> names.remove(d.cacheName())).collect(Collectors.toMap(DynamicCacheDescriptor::groupId, DynamicCacheDescriptor::groupDescriptor, (d1, d2) -> d1));
        if (!names.isEmpty()) {
            throw new IgniteException("The following caches do not exist: " + String.join((CharSequence)", ", cacheNames));
        }
        this.validatePartitionLoss(cacheNames);
        return grpIdToDesc;
    }

    public void setLastSuccessfulSnapshotIdForCacheGroup(int grpId, long snapshotId, boolean isFull, long snapshotTag) {
        this.updateMetastoreSnapshotCounterDecriptor(Collections.singleton(grpId), desc -> {
            desc.lastSuccessfulSnapshotId(snapshotId);
            if (isFull) {
                desc.setLastSuccessfulFullSnapshotId(snapshotId);
            }
            desc.lastSuccessfulSnapshotTag(snapshotTag);
        });
        if (snapshotId == 0L) {
            assert (snapshotTag == 0L);
            this.lastSuccessfulSnapshotIdsForCacheGrp.remove(grpId);
            if (isFull) {
                this.lastSuccessfulFullSnapshotIdsForCacheGrp.remove(grpId);
            }
            this.lastSuccessfulSnapshotTagForCacheGrp.remove(grpId);
        } else {
            this.lastSuccessfulSnapshotIdsForCacheGrp.put(grpId, snapshotId);
            if (isFull) {
                this.lastSuccessfulFullSnapshotIdsForCacheGrp.put(grpId, snapshotId);
            }
            this.lastSuccessfulSnapshotTagForCacheGrp.put(grpId, snapshotTag);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update snapshot counters for group = " + grpId + ", lastSuccessfulSnapshotId = " + snapshotId + ", lastSuccessfulSnapshotTag = " + snapshotTag);
        }
    }

    public void setLastSuccessfulFullSnapshotIdForAllCaches(long id, boolean full, boolean allCaches) {
        if (full) {
            long val = allCaches ? id : 0L;
            this.updateMetastoreSnapshotCommonInformation(commonInfo -> commonInfo.lastFullSnapshotIdForAllCaches(val));
            this.lastSuccessfulFullSnapshotIdForAllCaches = val;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Update lastSuccessfulFullSnapshotIdForAllCaches: " + val);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("There will be no updates since snapshot is not full.");
        }
    }

    public long getNextSnapshotTagForCacheGroup(int grpId) {
        long nextSnapshotId = this.nextSnapshotTagForCacheGrp.getOrDefault(grpId, 1L);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Get snapshot counter for group = " + grpId + " nextSnapshotId = " + nextSnapshotId);
        }
        return nextSnapshotId;
    }

    private long getLastSuccessfulSnapshotTagForCacheGroup(int grpId) {
        long lastSuccessfulTagForCache = this.lastSuccessfulSnapshotTagForCacheGrp.getOrDefault(grpId, 0L);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Get snapshot counter for group = " + grpId + " lastSuccessfulTagForCache = " + lastSuccessfulTagForCache);
        }
        return lastSuccessfulTagForCache;
    }

    private long incrementAndGetNextSnapshotTagForCacheGroup(int grpId) {
        long nextSnapshotTag = this.nextSnapshotTagForCacheGrp.getOrDefault(grpId, 1L) + 1L;
        this.nextSnapshotTagForCacheGrp.put(grpId, nextSnapshotTag);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update snapshot counters for group = " + grpId + ", nextSnapshotTag = " + nextSnapshotTag);
        }
        return nextSnapshotTag;
    }

    public IgniteFuture<?> onMarkCheckPointBegin(final GridSnapshotOperationEx snpOperation, final CheckpointRecord cpRec, final PartitionAllocationMap map) {
        map.prepareForSnapshot();
        final SnapshotOperationFuture fut = this.snapshotFuture();
        final HashMap<Integer, Long> nextSnapshotTagsForCache = new HashMap<Integer, Long>();
        HashSet<Integer> grpIds = new HashSet<Integer>();
        boolean incSnapshot = fut != null && fut.type() == SnapshotOperationType.CREATE && !((SnapshotCreateFuture)fut).isFullSnapshot();
        for (GroupPartitionId cacheIdAndPartId : map.keySet()) {
            Integer grpId = cacheIdAndPartId.getGroupId();
            if (!grpIds.add(grpId)) continue;
            long nextSnapshotTag = this.incrementAndGetNextSnapshotTagForCacheGroup(grpId);
            nextSnapshotTagsForCache.put(grpId, nextSnapshotTag);
        }
        if (fut == null || fut.type() != SnapshotOperationType.CREATE || fut.isNotInBaseline()) {
            this.releasePartsInSnapshotExecutor(snpOperation, map);
            return null;
        }
        final boolean fullSnapshot = !incSnapshot;
        GridFutureAdapter<Void> initFut = fut.initFuture();
        try {
            initFut.get();
        }
        catch (Exception e) {
            this.releasePartsInSnapshotExecutor(snpOperation, map);
            return null;
        }
        if (!fut.snapshotInfo().snapshotOperation().equals(snpOperation) || fut.error() != null) {
            this.releasePartsInSnapshotExecutor(snpOperation, map);
            return null;
        }
        this.lastSnpOperationFromCheckpointer = snpOperation;
        final SnapshotCreateFuture createFut = (SnapshotCreateFuture)fut;
        long snpId = createFut.snapshotInfo().snapshotOperation().snapshotId();
        final AtomicReference<WALPointer> ptr = new AtomicReference<WALPointer>();
        IgniteWriteAheadLogManager wal = this.cctx.wal();
        if (wal.serializerVersion() > 1) {
            try {
                ptr.set(this.cctx.wal().log((WALRecord)new SnapshotRecord(snpId, fullSnapshot), RolloverType.NEXT_SEGMENT));
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"Error while writing snasphot record", (Throwable)e);
                createFut.cancelSnapshotCreation("Error during writing Snapshot Record to WAL on node " + this.cctx.localNodeId(), e);
                this.releasePartsInSnapshotExecutor(snpOperation, map);
                return null;
            }
        }
        final GridFutureAdapter futAdapter = new GridFutureAdapter();
        IgniteFutureImpl res = new IgniteFutureImpl((IgniteInternalFuture)futAdapter);
        this.cctx.kernalContext().txDr().onMarkCheckPointBegin(snpId, (WALPointer)ptr.get(), (SnapshotOperation)snpOperation);
        this.submitTaskToSnapshotMessageExecutor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractFullPageIdIterable pageIds = fullSnapshot ? new FullPageIdIterable(GridCacheSnapshotManager.this.context(), nextSnapshotTagsForCache, GridCacheSnapshotManager.this.lastSuccessfulSnapshotTagForCacheGrp, map) : new FullPageIdIncrementalSnapshotIterable(GridCacheSnapshotManager.this.context(), nextSnapshotTagsForCache, GridCacheSnapshotManager.this.lastSuccessfulSnapshotTagForCacheGrp, map);
                    createFut.prepareCreate(pageIds, snpOperation, map, (WALPointer)ptr.get(), cpRec);
                }
                finally {
                    futAdapter.onDone();
                }
                AtomicReference atomicReference = GridCacheSnapshotManager.this.snapshotFut;
                synchronized (atomicReference) {
                    SnapshotOperationFuture fut0 = (SnapshotOperationFuture)GridCacheSnapshotManager.this.snapshotFut.get();
                    if (fut0 == null || fut0 != fut) {
                        GridCacheSnapshotManager.this.releasePartsInSnapshotExecutor(snpOperation, map);
                    } else {
                        GridCacheSnapshotManager.this.reservedParts.set(new T2((Object)snpOperation, (Object)map.keySet()));
                    }
                }
            }
        });
        return res;
    }

    private void releasePartsInSnapshotExecutor(final GridSnapshotOperationEx snpOperation, final PartitionAllocationMap map) {
        this.submitTaskToSnapshotMessageExecutor(new Runnable(){

            @Override
            public void run() {
                GridCacheSnapshotManager.this.releaseParts((T2<GridSnapshotOperationEx, Set<GroupPartitionId>>)new T2((Object)snpOperation, (Object)map.keySet()));
            }
        });
    }

    public boolean snapshotOperationInProgress() {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        return fut != null && !fut.isDone() && !fut.delayed();
    }

    public boolean partitionsAreFrozen(CacheGroupContext grp) {
        SnapshotOperationInfoImpl info;
        SnapshotOperationFuture fut = this.snapshotFut.get();
        if (fut != null && !fut.isDone() && (info = fut.snapshotInfo()) != null) {
            GridSnapshotOperationEx op = info.snapshotOperation();
            return op.type() == SnapshotOperationType.RECOVERY && (grp == null || op.cacheGroupIds().contains(grp.groupId())) || op.type() == SnapshotOperationType.REPLICATION_RECOVERY;
        }
        return false;
    }

    public void beforeCheckpointPageWritten() {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        if (fut == null || fut.type() != SnapshotOperationType.CREATE) {
            return;
        }
        SnapshotCreateFuture createFut = (SnapshotCreateFuture)fut;
        createFut.beforeCheckpointPageWritten();
    }

    public void afterCheckpointPageWritten() {
        SnapshotOperationInfoImpl info;
        SnapshotOperationFuture snapFut = this.snapshotFut.get();
        GridSnapshotOperationEx lastSnpOperationFromCheckpointer = this.lastSnpOperationFromCheckpointer;
        if (snapFut != null && lastSnpOperationFromCheckpointer != null && (info = snapFut.snapshotInfo()) != null && info.snapshotOperation().equals(lastSnpOperationFromCheckpointer)) {
            this.lastSnpOperationFromCheckpointer = null;
            snapFut.notifyCheckpointComplete();
            this.submitTaskToSnapshotExecutor(snapFut.type(), () -> snapFut.start(null));
        }
    }

    public void beforePageWrite(FullPageId fullId) {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        if (fut != null && fut.type() == SnapshotOperationType.CREATE) {
            ((SnapshotCreateFuture)fut).safelyCopyPage(fullId);
        }
    }

    public boolean restoreOrRecoveryInProgress() {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        return fut != null && (fut.type() == SnapshotOperationType.RECOVERY || fut.type() == SnapshotOperationType.RESTORE);
    }

    private NavigableSet<Long> getDependentSnapshotIds(long snapshotId, Set<Integer> cacheGroupIds) throws IgniteCheckedException {
        return (NavigableSet)this.cctx.kernalContext().task().execute((ComputeTask)new CollectDependantSnapshotSetTask(), (Object)new T2((Object)snapshotId, cacheGroupIds)).get();
    }

    public NavigableSet<Long> collectDependentSnapshotIds(Long fullSnapshotId, @Nullable Collection<Integer> grpIds) throws IgniteCheckedException {
        return this.collectDependentSnapshotIds(Collections.singleton(fullSnapshotId), grpIds);
    }

    public NavigableSet<Long> collectDependentSnapshotIds(Set<Long> fullSnapshotIds, @Nullable Collection<Integer> grpIds) throws IgniteCheckedException {
        TreeMap<Long, HashMap> snapshotIdToGroupIdPrevSnapshotIdMapMap = new TreeMap<Long, HashMap>();
        ArrayList<SnapshotMetadataV2> snapshots = new ArrayList<SnapshotMetadataV2>();
        Iterator iterator = this.dbSnapshotSpi.localSnapshots(true).iterator();
        while (iterator.hasNext()) {
            SnapshotMetadataV2 meta;
            SnapshotMetadataV2 snapshot0 = meta = (SnapshotMetadataV2)iterator.next();
            if (fullSnapshotIds.contains(meta.id())) {
                snapshots.add(snapshot0);
            } else if (snapshot0.fullSnapshot()) continue;
            HashMap vals = U.newHashMap((int)snapshot0.cacheGroupIds().size());
            snapshotIdToGroupIdPrevSnapshotIdMapMap.put(meta.id(), vals);
            for (Integer n : snapshot0.cacheGroupIds()) {
                if (grpIds != null && !grpIds.contains(n)) continue;
                CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)snapshot0.cacheGroupsMetadata().get(n);
                Set<Long> prevSnapshotIds = cacheMeta.previousSnapshotIds();
                if (prevSnapshotIds.isEmpty()) {
                    prevSnapshotIds = Collections.singleton(cacheMeta.previousSnapshotId(null));
                }
                assert (prevSnapshotIds.size() == 1) : prevSnapshotIds;
                vals.put(n, F.first(prevSnapshotIds));
            }
        }
        if (snapshots.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        TreeSet<Long> dependentSnapshots = new TreeSet<Long>(Collections.reverseOrder());
        for (Long snapshotId : fullSnapshotIds) {
            dependentSnapshots.add(snapshotId);
            Set cacheGrpsFromPrevSnapshot = ((Map)snapshotIdToGroupIdPrevSnapshotIdMapMap.remove(snapshotId)).keySet();
            for (Map.Entry entry : snapshotIdToGroupIdPrevSnapshotIdMapMap.entrySet()) {
                for (Integer grpId : cacheGrpsFromPrevSnapshot) {
                    Long prevSnapId = (Long)((Map)entry.getValue()).get(grpId);
                    if (prevSnapId == null || !dependentSnapshots.contains(prevSnapId) || !((Map)entry.getValue()).containsKey(grpId)) continue;
                    dependentSnapshots.add((Long)entry.getKey());
                }
            }
        }
        return dependentSnapshots;
    }

    private void updateLastSnapshotIdsInLocalMap(GridSnapshotOperationEx snapshotOperation) {
        for (Integer grpId : snapshotOperation.cacheGroupIds()) {
            if (this.cctx.cache().cacheGroupDescriptors().get(grpId) == null || !this.cctx.discovery().cacheGroupAffinityNode(this.cctx.localNode(), grpId.intValue())) continue;
            this.lastSuccessfulSnapshotIdsForCacheGrp.put(grpId, snapshotOperation.snapshotId());
            if (!GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapshotOperation).booleanValue()) continue;
            this.lastSuccessfulFullSnapshotIdsForCacheGrp.put(grpId, snapshotOperation.snapshotId());
        }
    }

    public void submitTaskToSnapshotExecutor(SnapshotOperationType type, Runnable task) {
        if (this.snapshotExecutor != null) {
            try {
                int stripe = this.operationFutRefs.indexOf(this.operationFutureReference(type));
                this.snapshotExecutor.execute(stripe, task);
            }
            catch (Exception ex) {
                this.log.warning("Error during submitting task to snapshot executor", (Throwable)ex);
            }
        }
    }

    private Future<?> submitTaskToSnapshotMessageExecutor(final Runnable task) {
        try {
            if (this.snapshotMsgExecutor != null) {
                return this.snapshotMsgExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.run();
                        }
                        catch (Exception ex) {
                            GridCacheSnapshotManager.this.log().error("Error in snapshot message executor", (Throwable)ex);
                        }
                        catch (Throwable th) {
                            U.error((IgniteLogger)GridCacheSnapshotManager.this.log(), (Object)"Snapshot message executor died because of", (Throwable)th);
                            throw th;
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            this.log.warning("Error during submitting task to snapshot message executor", (Throwable)ex);
        }
        return null;
    }

    private SnapshotOperationParameters chooseStrategyOfRestore(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCachesOrGroups, @Nullable Set<String> excludedCachesOrGroups, Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, boolean forceRestore, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) throws IgniteCheckedException {
        SnapshotRestoreStrategy stgy;
        boolean isInSharedFolder;
        Collection paths = optSearchPaths == null ? null : (Collection)optSearchPaths.stream().map(SnapshotRemotePath::new).collect(Collectors.toList());
        SnapshotOperationParameters params = this.checkSnapshotInSharedFolder(snapshotId, type, includedCachesOrGroups, excludedCachesOrGroups, SnapshotPathFactory.create(paths, this.log, this.snapCfg.getSftpConfiguration()), forceRestore, c, new HashSet<Long>());
        if (params != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Strategy was calculated locally, params=" + params);
            }
            return params;
        }
        CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult res = this.collectSnapshotPartitionsDistribution(snapshotId, type, includedCachesOrGroups, excludedCachesOrGroups, optSearchPaths, c);
        if (this.log.isDebugEnabled()) {
            this.log.debug("CollectSnapshotPartitionDistributionTask finished, result=" + res.getResult());
        }
        if ((isInSharedFolder = this.isInSharedFolder(snapshotId, res)) && !SnapshotUtils.nodeIsNotInBaseline(this.cctx.localNode(), this.cctx, null)) {
            throw new IgniteCheckedException("Current node doesn't have access to shared folder. node=" + this.cctx.localNode());
        }
        if (!isInSharedFolder) {
            this.checkPresenceOfAllPartitions(res);
        }
        Set<Integer> cacheGrpIds = null;
        Map<String, Integer> cacheNamesFromMeta = null;
        for (Map.Entry<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> e0 : res.getResult().entrySet()) {
            Map<String, Integer> cacheNamesWithGroups = e0.getValue().cacheNamesWithGroups();
            if (cacheNamesWithGroups == null) continue;
            params = this.getSnapshotOperationParameters(snapshotId, includedCachesOrGroups, excludedCachesOrGroups, cacheNamesWithGroups, forceRestore);
            cacheGrpIds = params.cacheGroupIds();
            cacheNamesFromMeta = params.cacheNamesWithGroupId();
            break;
        }
        assert (cacheGrpIds != null && cacheNamesFromMeta != null) : "cacheGrpIds=" + cacheGrpIds + ", cacheNamesFromMeta=" + cacheNamesFromMeta;
        Object object = isInSharedFolder ? (type == SnapshotOperationType.RESTORE ? SnapshotRestoreStrategy.RESTORE_BY_AFFINITY : (type == SnapshotOperationType.RECOVERY ? SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING : null)) : (stgy = SnapshotRestoreStrategy.RESTORE_LOCAL_PARTITIONS);
        assert (stgy != null) : "Not supported operation type=" + type;
        return new SnapshotOperationParameters(cacheGrpIds, cacheNamesFromMeta, stgy);
    }

    private CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult collectSnapshotPartitionsDistribution(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCachesOrGroups, @Nullable Set<String> excludedCachesOrGroups, Collection<org.gridgain.grid.persistentstore.SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) throws IgniteCheckedException {
        if (this.isSupportSftpDestination()) {
            if (this.isSnapshotOperationWithExcludeCachesSupported()) {
                assert (includedCachesOrGroups == null || excludedCachesOrGroups == null);
                boolean inclusionMode = excludedCachesOrGroups == null;
                Set<String> cacheOrGroups = inclusionMode ? includedCachesOrGroups : excludedCachesOrGroups;
                return (CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult)this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotPartitionDistributionTaskV3(), (Object)new CollectSnapshotPartitionDistributionTaskV3.CollectSnapshotPartitionDistributionV3Params(snapshotId, cacheOrGroups, inclusionMode, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths), c)).get();
            }
            return (CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult)this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotPartitionDistributionTaskV2(), (Object)new CollectSnapshotPartitionDistributionTaskV2.CollectSnapshotPartitionDistributionV2Params(snapshotId, type, null, GridCacheSnapshotManager.convertToSnapshotPathCollection(optSearchPaths), c)).get();
        }
        return (CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult)this.cctx.kernalContext().task().execute((ComputeTask)new CollectSnapshotPartitionDistributionTask(), (Object)new T5((Object)snapshotId, (Object)type, null, GridCacheSnapshotManager.convertToFileCollection(optSearchPaths), c)).get();
    }

    public boolean isSnapshotOperationWithExcludeCachesSupported() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER);
    }

    private void checkPresenceOfAllPartitions(CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult res) throws IgniteCheckedException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        HashMap partitionsPerGrp = new HashMap();
        HashMap<Integer, Object> partCountsPerGrp = new HashMap<Integer, Object>();
        for (Map.Entry<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> entry : res.getResult().entrySet()) {
            Map<Integer, T2<Integer, Set<Integer>>> partitionsPerGrp0 = entry.getValue().getPartitionsPerGroup();
            if (partitionsPerGrp0 == null) continue;
            for (Map.Entry<Integer, T2<Integer, Set<Integer>>> e1 : partitionsPerGrp0.entrySet()) {
                Integer old;
                Integer grpId = e1.getKey();
                Set parts = (Set)partitionsPerGrp.get(grpId);
                Set ps0 = (Set)e1.getValue().get2();
                if (parts == null) {
                    partitionsPerGrp.put(grpId, new HashSet(ps0));
                } else {
                    parts.addAll(ps0);
                }
                if ((old = (Integer)partCountsPerGrp.put(grpId, e1.getValue().get1())) == null || ((Integer)e1.getValue().get1()).equals(old)) continue;
                String msg = "Cache configuration differs on different nodes (partition counts: old=" + old + ", new=" + e1.getValue().get1() + ")";
                U.error((IgniteLogger)this.log, (Object)msg);
                errorMessages.add(msg);
            }
        }
        for (Map.Entry<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> entry : partitionsPerGrp.entrySet()) {
            String msg;
            Integer grpId = (Integer)((Object)entry.getKey());
            Integer cntOfPartsFromCfg = (Integer)partCountsPerGrp.get(grpId);
            if (cntOfPartsFromCfg == null) {
                msg = "No data of partitions count from cfg for grpId: " + grpId;
                U.error((IgniteLogger)this.log, (Object)msg);
                errorMessages.add(msg);
                continue;
            }
            if (((Set)((Object)entry.getValue())).size() == cntOfPartsFromCfg.intValue()) continue;
            msg = "Not enough partitions in current topology to complete restore operation for grpId=" + grpId + ", collectedCount=" + ((Set)((Object)entry.getValue())).size() + ", countFromCfg=" + cntOfPartsFromCfg;
            U.error((IgniteLogger)this.log, (Object)msg);
            errorMessages.add(msg);
        }
        if (!F.isEmpty(errorMessages)) {
            throw new SnapshotCheckException("Checking for the presence of all partitions failed:\n\t" + String.join((CharSequence)"\n\t", errorMessages));
        }
    }

    private boolean isInSharedFolder(long snapshotId, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionTaskResult res) throws IgniteCheckedException {
        Boolean isInSharedFolder = null;
        for (Map.Entry<UUID, CollectSnapshotPartitionDistributionTask.CollectSnapshotPartitionDistributionJobResult> e0 : res.getResult().entrySet()) {
            ClusterNode node = this.cctx.discovery().node(e0.getKey());
            Boolean isInSharedFolder0 = e0.getValue().isInSharedFolder();
            if (isInSharedFolder0 == null) continue;
            if (isInSharedFolder == null) {
                isInSharedFolder = isInSharedFolder0;
                continue;
            }
            if (isInSharedFolder == isInSharedFolder0) continue;
            throw new IgniteCheckedException("Node treat snapshotIsInShared folder as " + isInSharedFolder0 + ", while others not. node=" + node);
        }
        if (isInSharedFolder == null) {
            throw this.invalidUserCommandCheckedException(SNAPSHOT_DOES_NOT_EXIST + snapshotId + ']');
        }
        return isInSharedFolder;
    }

    private SnapshotOperationParameters checkSnapshotInSharedFolder(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCacheOrGroups, @Nullable Set<String> excludedCacheOrGroups, Collection<SnapshotPath> optSearchPaths, boolean forceRestore, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, Set<Long> alreadyCheckedSnapshots) throws IgniteCheckedException {
        FileSnapshot snapshot = (FileSnapshot)this.dbSnapshotSpi.snapshot(snapshotId, optSearchPaths, c, true, null, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking remote snapshot for strategy choosing, snapshot=" + snapshot);
        }
        if (snapshot != null && snapshot.metadata() != null) {
            SnapshotMetadataV2 metadata = snapshot.metadata();
            alreadyCheckedSnapshots.add(snapshotId);
            Map cacheGroupsMetadata = metadata.cacheGroupsMetadata();
            SnapshotOperationParameters params = this.getSnapshotOperationParameters(snapshotId, includedCacheOrGroups, excludedCacheOrGroups, metadata.cacheNamesWithGroups(), forceRestore);
            Set<Integer> cacheGrpIds = params.cacheGroupIds();
            Map<String, Integer> cacheNamesFromMeta = params.cacheNamesWithGroupId();
            if (!this.checkPresenceOfAllPartitions(cacheGrpIds, cacheGroupsMetadata)) {
                return null;
            }
            if (this.isOnlyOneConsistentIdPresentedInMetadata(cacheGroupsMetadata)) {
                return new SnapshotOperationParameters(cacheGrpIds, cacheNamesFromMeta, SnapshotRestoreStrategy.RESTORE_LOCAL_PARTITIONS);
            }
            if (!snapshot.metadata().fullSnapshot()) {
                for (CacheSnapshotMetadata snapshotMetadata : snapshot.metadata().cacheGroupsMetadata().values()) {
                    for (Long previousSnapshotId : snapshotMetadata.previousSnapshotIds()) {
                        SnapshotOperationParameters parameters;
                        if (previousSnapshotId == null || previousSnapshotId == 0L || alreadyCheckedSnapshots.contains(previousSnapshotId) || (parameters = this.checkSnapshotInSharedFolder(previousSnapshotId, type, includedCacheOrGroups, excludedCacheOrGroups, optSearchPaths, forceRestore, c, alreadyCheckedSnapshots)) != null && parameters.stgy != SnapshotRestoreStrategy.RESTORE_OWN_CONSISTENT_ID) continue;
                        return new SnapshotOperationParameters(cacheGrpIds, cacheNamesFromMeta, SnapshotRestoreStrategy.RESTORE_OWN_CONSISTENT_ID);
                    }
                }
            }
            return new SnapshotOperationParameters(cacheGrpIds, cacheNamesFromMeta, type == SnapshotOperationType.RECOVERY ? SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING : SnapshotRestoreStrategy.RESTORE_BY_AFFINITY);
        }
        return null;
    }

    private boolean isOnlyOneConsistentIdPresentedInMetadata(Map<Integer, CacheSnapshotMetadata> cacheGroupsMetadata) {
        String cId = null;
        for (CacheSnapshotMetadata cacheMetadata : cacheGroupsMetadata.values()) {
            for (Map map : cacheMetadata.partitionSizesPerNode().values()) {
                if (map.keySet().size() > 1) {
                    return false;
                }
                if (map.isEmpty()) continue;
                String first = (String)F.first(map.keySet());
                if (cId != null && !cId.equals(first)) {
                    return false;
                }
                cId = first;
            }
        }
        return true;
    }

    private boolean checkPresenceOfAllPartitions(Set<Integer> cacheGrpIds, Map<Integer, CacheSnapshotMetadata> cacheGroupsMetadata) throws IgniteCheckedException {
        for (Integer grpId : cacheGrpIds) {
            CacheSnapshotMetadata meta = cacheGroupsMetadata.get(grpId);
            if (!meta.hasCacheConfiguration()) {
                throw new IgniteCheckedException("Couldn't deserialise cache configuration from snapshot metadata. To work with snapshot you should provide cache configuration transformer.");
            }
            if (meta.checkPartitions()) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("There is no full set of partition for group with id=" + grpId + ". Couldn't choose strategy on local node.");
            }
            return false;
        }
        return true;
    }

    private SnapshotOperationParameters validateAndGetSnapshotOperationParameters(long snapshotId, @Nullable Set<String> cacheNames, @Nullable Collection<SnapshotRemotePath> optSearchPaths, boolean forceRestore) throws IgniteCheckedException {
        SnapshotInfoExtended desc = this.getSnapshotInfo0(snapshotId, optSearchPaths);
        return this.validateAndGetSnapshotOperationParameters(snapshotId, cacheNames, desc, forceRestore);
    }

    private SnapshotOperationParameters validateAndGetSnapshotOperationParameters(long snapshotId, @Nullable Set<String> cacheNames, @Nullable SnapshotInfoExtended desc, boolean forceRestore) throws IgniteCheckedException {
        if (cacheNames != null && cacheNames.isEmpty()) {
            throw new IgniteException((Throwable)new IllegalArgumentException("Empty cache list is not allowed."));
        }
        if (desc == null) {
            throw this.invalidUserCommandCheckedException(SNAPSHOT_DOES_NOT_EXIST + snapshotId + ']');
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Received snapshot metadata from the cluster: " + desc);
        }
        if (cacheNames != null) {
            return this.getSnapshotOperationParameters(snapshotId, cacheNames, null, desc.cacheNamesWithGroups(), forceRestore);
        }
        return new SnapshotOperationParameters(new HashSet<Integer>(desc.cacheNamesWithGroups().values()), desc.cacheNamesWithGroups(), null);
    }

    private void validateCacheNamesClash(long snapshotId, Set<Integer> grpToRestore, Map<String, Integer> cacheNamesWithGroups) throws IgniteCheckedException {
        SB error = null;
        for (Map.Entry<String, Integer> e : cacheNamesWithGroups.entrySet()) {
            String cacheName = e.getKey();
            DynamicCacheDescriptor desc = this.cctx.cache().cacheDescriptor(cacheName);
            if (desc == null || e.getValue().equals(desc.groupId()) || grpToRestore.contains(desc.groupId())) continue;
            if (error == null) {
                error = new SB(CACHE_NAME_CLASH_ERROR_MSG);
                error.a(snapshotId).a("): ");
            }
            error.a("existing cache (name=").a(cacheName).a(") belongs to group(id=").a(desc.groupId()).a(", name=").a(desc.groupDescriptor().cacheOrGroupName()).a("), cache in snapshot belongs to group(id=").a((Object)e.getValue()).a("); ");
        }
        if (error != null) {
            throw new SnapshotCheckException(error.toString());
        }
    }

    private SnapshotOperationParameters getSnapshotOperationParameters(long snapshotId, @Nullable Set<String> includedCachesOrGroups, @Nullable Set<String> excludedCachesOrGroups, Map<String, Integer> cacheNamesWithGroups, boolean forceRestore) throws IgniteCheckedException {
        HashSet<Integer> grpToRestore;
        Set requestedGrps;
        Set requestedCaches;
        T2<Set<String>, Set<Integer>> tup;
        if (!F.isEmpty(includedCachesOrGroups) && !F.isEmpty(excludedCachesOrGroups)) {
            throw UserCommandExceptions.invalidUserCommandException((String)"Pass either include caches or exclude caches parameter.", (GridKernalContext)this.cctx.kernalContext());
        }
        if (!F.isEmpty(includedCachesOrGroups)) {
            tup = this.extractCacheNamesAndGroups(snapshotId, includedCachesOrGroups, cacheNamesWithGroups);
            requestedCaches = (Set)tup.get1();
            requestedGrps = (Set)tup.get2();
            this.validateAllCachesFromGroupsListed(snapshotId, requestedCaches, requestedGrps, forceRestore, cacheNamesWithGroups, "-included_caches");
            grpToRestore = new HashSet(requestedGrps);
            requestedCaches.stream().map(cacheNamesWithGroups::get).forEach(grpToRestore::add);
        } else {
            grpToRestore = new HashSet<Integer>(cacheNamesWithGroups.values());
        }
        if (!F.isEmpty(excludedCachesOrGroups)) {
            tup = this.extractCacheNamesAndGroups(snapshotId, excludedCachesOrGroups, cacheNamesWithGroups);
            requestedCaches = (Set)tup.get1();
            requestedGrps = (Set)tup.get2();
            this.validateAllCachesFromGroupsListed(snapshotId, requestedCaches, requestedGrps, forceRestore, cacheNamesWithGroups, "-excluded_caches");
            grpToRestore.removeAll(requestedGrps);
            requestedCaches.stream().map(cacheNamesWithGroups::get).forEach(grpToRestore::remove);
        }
        Map<String, Integer> cacheToRestore = cacheNamesWithGroups.entrySet().stream().filter(e -> grpToRestore.contains(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SnapshotOperationParameters(grpToRestore, cacheToRestore, null);
    }

    private T2<Set<String>, Set<Integer>> extractCacheNamesAndGroups(long snapshotId, Set<String> cachesOrGroups, Map<String, Integer> cacheNamesWithGroups) throws IgniteCheckedException {
        HashSet<Integer> availableGroups = new HashSet<Integer>(cacheNamesWithGroups.values());
        HashSet<String> userRequestedCaches = new HashSet<String>();
        HashSet<Integer> userRequestedGroups = new HashSet<Integer>();
        ArrayList<String> missingCacheNames = new ArrayList<String>();
        for (String cacheOrGroup : cachesOrGroups) {
            if (cacheNamesWithGroups.containsKey(cacheOrGroup)) {
                userRequestedCaches.add(cacheOrGroup);
                continue;
            }
            Integer grpId = CU.cacheId((String)cacheOrGroup);
            if (availableGroups.contains(grpId)) {
                userRequestedGroups.add(grpId);
                continue;
            }
            missingCacheNames.add(cacheOrGroup);
        }
        if (!F.isEmpty(missingCacheNames)) {
            throw new IgniteCheckedException("Caches (cache groups) are not contained in snapshot " + snapshotId + ": " + missingCacheNames);
        }
        return new T2(userRequestedCaches, userRequestedGroups);
    }

    private Collection<String> calcNotRequestedCaches(Map<String, Integer> allCaches, Set<String> requestedCaches, Set<Integer> requestGrps) {
        ArrayList<String> notRequestedCaches = new ArrayList<String>();
        HashMap<Integer, List> grpsToCaches = new HashMap<Integer, List>();
        HashSet<Integer> grpsToCheck = new HashSet<Integer>();
        for (Map.Entry<String, Integer> entry : allCaches.entrySet()) {
            String cache = entry.getKey();
            Integer grpId = entry.getValue();
            if (requestGrps.contains(grpId)) continue;
            grpsToCaches.computeIfAbsent(grpId, k -> new ArrayList()).add(cache);
            if (!requestedCaches.contains(cache)) continue;
            grpsToCheck.add(grpId);
        }
        for (Integer grpId : grpsToCheck) {
            for (String cache : (List)grpsToCaches.get(grpId)) {
                if (requestedCaches.contains(cache)) continue;
                notRequestedCaches.add(cache);
            }
        }
        return notRequestedCaches;
    }

    private void validateAllCachesFromGroupsListed(long snapshotId, @Nullable Set<String> requestedCaches, @Nullable Set<Integer> requestedGrps, boolean forceRestore, Map<String, Integer> allCaches, String parameterName) throws IgniteCheckedException {
        Collection<String> notRequestedCaches = this.calcNotRequestedCaches(allCaches, requestedCaches, requestedGrps);
        if (notRequestedCaches.isEmpty()) {
            return;
        }
        SB strBuilder = new SB();
        if (!notRequestedCaches.isEmpty()) {
            strBuilder.a("Following caches contained in snapshot's cache groups, ").a("but not listed in ").a(parameterName).a(" parameter for snapshot operation (").a(snapshotId).a("): ");
            strBuilder.a(String.join((CharSequence)", ", notRequestedCaches));
            strBuilder.nl();
        }
        if (!forceRestore) {
            strBuilder.a("Set -force parameter to true to bypass this issue or list all logical caches in ").a(parameterName).a(" parameter");
            String msg = strBuilder.toString();
            U.error((IgniteLogger)this.log, (Object)msg);
            throw new SnapshotCheckException(msg);
        }
        strBuilder.a("Issue is ignored by -force parameter");
        U.warn((IgniteLogger)this.log, (Object)strBuilder.toString());
    }

    private void validatePointInTimeRecoveryRestriction(long snapshotId, SnapshotOperationType op, SnapshotChainMode chainMode, boolean skipWal, NavigableSet<Long> dependentSnapshotIds) throws IgniteCheckedException {
        if (!this.pointInTimeRecoveryEnabled()) {
            return;
        }
        List<SnapshotInfoEssential> snapshots = this.getSnapshotList(null);
        SnapshotInfo lastSnapshot = (SnapshotInfo)snapshots.get(snapshots.size() - 1);
        if (lastSnapshot.snapshotId() == snapshotId) {
            switch (op) {
                case DELETE: 
                case MOVE: {
                    throw this.invalidUserCommandCheckedException("failed to " + op + " snapshot (the snapshot is last) [snapshotId=" + snapshotId + ", type=" + (lastSnapshot.fullSnapshot() ? "full" : "inc") + ", chain=[ ... | " + snapshotId + "]");
                }
                case COPY: {
                    if (skipWal) break;
                    throw this.invalidUserCommandCheckedException("failed to COPY snapshot with WAL files (the snapshot is last). Use -skip_wal to COPY snapshot without WAL files. ");
                }
            }
        }
        if (dependentSnapshotIds == null) {
            assert (chainMode == SnapshotChainMode.SINGLE);
        } else if (dependentSnapshotIds.contains(lastSnapshot.snapshotId()) && chainMode == SnapshotChainMode.FROM_CURRENT_TO_LAST) {
            switch (op) {
                case DELETE: 
                case MOVE: {
                    throw this.invalidUserCommandCheckedException("failed to " + op + " snapshot ( (the last snapshot in the dependency chain depends on the snapshot which you are trying to " + op.name().toLowerCase() + "). Use 'force " + op.name().toLowerCase() + "' to " + op + " the whole chain [snapshotId=" + snapshotId + ", type=" + (lastSnapshot.fullSnapshot() ? "full" : "inc") + ", chain=[ ... | " + this.buildSnapshotChainTail(snapshotId, dependentSnapshotIds, op) + "]]");
                }
                case COPY: {
                    if (skipWal) break;
                    throw this.invalidUserCommandCheckedException("failed to COPY snapshot chain with WAL files (the last snapshot belong to the chain). Use -skip_wal to COPY snapshots without WAL files. ");
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private String buildSnapshotChainTail(long snapshotId, NavigableSet<Long> dependentSnapshotIds, SnapshotOperationType snapshotOperationType) {
        SB sb = new SB();
        Long lastSnapshotId = (Long)dependentSnapshotIds.last();
        for (long snpId : dependentSnapshotIds.descendingSet()) {
            if (snpId != lastSnapshotId) {
                sb.a(" <- ");
            }
            if (snpId == snapshotId) {
                sb.a("(you tried to ").a((Object)snapshotOperationType).a(" snapshot with snapshotId=");
            }
            sb.a(snpId);
            if (snpId != snapshotId) continue;
            sb.a(")");
        }
        return sb.toString();
    }

    public IgniteFuture getOngoingOperationFuture() {
        SnapshotOperationFuture fut = this.snapshotFut.get();
        if (fut == null) {
            return null;
        }
        return new IgniteFutureImpl((IgniteInternalFuture)fut);
    }

    @NotNull
    AtomicReference<SnapshotOperationFuture> operationFutureReference(SnapshotOperationType type) {
        if (type == SnapshotOperationType.CONSISTENT_CUT) {
            return this.consistentCutFut;
        }
        if (type == SnapshotOperationType.CONFIGURABLE) {
            return this.customFut;
        }
        return this.snapshotFut;
    }

    private Collection<SnapshotOperationFuture> operationFutures() {
        ArrayList<SnapshotOperationFuture> futs = new ArrayList<SnapshotOperationFuture>(2);
        for (AtomicReference<SnapshotOperationFuture> futRef : this.operationFutRefs) {
            SnapshotOperationFuture fut = futRef.get();
            if (fut == null) continue;
            futs.add(fut);
        }
        return futs;
    }

    public SnapshotOperationFuture snapshotFuture() {
        return this.snapshotFut.get();
    }

    public int pageSize() {
        assert (this.pageSize != 0) : "Page size is not setup";
        return this.pageSize;
    }

    Map<Integer, SnapshotCountersDescriptor> getSnapshotCounters(Collection<Integer> grps) {
        HashMap<Integer, SnapshotCountersDescriptor> cntrsMap = new HashMap<Integer, SnapshotCountersDescriptor>();
        for (Integer grpId : grps) {
            SnapshotCountersDescriptor cntrs = new SnapshotCountersDescriptor(grpId).lastSuccessfulSnapshotId(this.getLastSuccessfulSnapshotIdForCacheGroup(grpId)).lastSuccessfulSnapshotTag(this.getLastSuccessfulSnapshotTagForCacheGroup(grpId)).nextSnapshotTag(this.getNextSnapshotTagForCacheGroup(grpId));
            cntrsMap.put(grpId, cntrs);
        }
        return Collections.unmodifiableMap(cntrsMap);
    }

    void resetSnapshotCounters(Map<Integer, SnapshotCountersDescriptor> cntrsMap, boolean reset) {
        for (Map.Entry<Integer, SnapshotCountersDescriptor> entry : cntrsMap.entrySet()) {
            int grpId = entry.getKey();
            SnapshotCountersDescriptor cntrs = entry.getValue();
            if (reset) {
                this.nextSnapshotTagForCacheGrp.remove(grpId);
                this.lastSuccessfulSnapshotIdsForCacheGrp.remove(grpId);
                this.lastSuccessfulFullSnapshotIdsForCacheGrp.remove(grpId);
                this.lastSuccessfulSnapshotTagForCacheGrp.remove(grpId);
            } else {
                this.nextSnapshotTagForCacheGrp.put(grpId, cntrs.nextSnapshotTag());
                this.lastSuccessfulSnapshotIdsForCacheGrp.put(grpId, cntrs.lastSuccessfulSnapshotId());
                this.lastSuccessfulFullSnapshotIdsForCacheGrp.put(grpId, cntrs.lastSuccessfulFullSnapshotId());
                this.lastSuccessfulSnapshotTagForCacheGrp.put(grpId, cntrs.lastSuccessfulSnapshotTag());
            }
            this.updateSnapshotDataInMetastorage(m -> {
                try {
                    if (reset) {
                        this.metastorage.remove(METASTORE_KEY_PREFIX + grpId);
                    } else {
                        this.metastorage.write(METASTORE_KEY_PREFIX + grpId, (Serializable)((Object)cntrs));
                    }
                }
                catch (IgniteCheckedException e) {
                    String msg = "Failed to " + (reset ? "reset" : "restore") + "snapshot counters from metastorage for grpId=" + grpId;
                    this.log.error(msg, (Throwable)e);
                    throw new IgniteException(msg, (Throwable)e);
                }
            });
        }
    }

    public boolean needTxReadLogging() {
        return this.pointInTimeRecoveryEnabled();
    }

    public boolean pointInTimeRecoveryEnabled() {
        if (IgniteFeatures.allNodesSupport((GridKernalContext)this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.POINT_IN_TIME_DISTRIBUTED_PROPERTY)) {
            return (Boolean)this.pointInTimeRecoveryEnabled.getOrDefault((Serializable)Boolean.valueOf(this.dfltPointInTimeRecoveryEnabled));
        }
        return this.dfltPointInTimeRecoveryEnabled;
    }

    public boolean exchangelessPointInTimeRecoveryModeEnabled() {
        GridKernalContext ctx = this.cctx.kernalContext();
        DiscoCache discoCache = ctx.discovery().discoCache();
        if (discoCache == null || IgniteFeatures.allNodesSupports((GridKernalContext)ctx, (Iterable)discoCache.serverNodes(), (IgniteFeatures)IgniteFeatures.POINT_IN_TIME_RECOVERY_EXCHANGELESS_SUPPORT)) {
            return (Boolean)this.exchangelessPointInTimeRecoveryMode.getOrDefault((Serializable)Boolean.valueOf(this.DFLT_GG_POINT_IN_TIME_EXCHANGELESS_SUPPORT));
        }
        return false;
    }

    public IgniteInternalFuture prepareDelayedSnapshotCreation(IgniteUuid opId, UUID initiatorId, AffinityTopologyVersion topVer) {
        boolean initiator = this.cctx.localNodeId().equals(initiatorId);
        SnapshotOperationFuture snapFut = new SnapshotCreateFuture(this.currentProtocolVersion(), opId, initiator, initiatorId, initiator ? new GridFutureAdapter() : null, initiator ? new GridFutureAdapter() : null, this, this.cctx, this.snapCfg, this.snapshotMetricsMXBean, true);
        boolean success = this.snapshotFut.compareAndSet(null, snapFut);
        if (!success) {
            snapFut = this.snapshotFut.get();
            throw new IllegalStateException("Concurrent snapshot operations are not allowed cluster-wide. Wait while snapshot process will be ended. Snapshot in progress [" + snapFut + "]");
        }
        return snapFut;
    }

    private void initDelayedSnapshotCreation(long snapshotId, AffinityTopologyVersion topVer, String msg) {
        SnapshotOperationFuture snapFut = this.snapshotFut.get();
        Collection cacheNames = F.viewReadOnly(this.cctx.cache().cacheDescriptors().values(), (IgniteClosure)new IgniteClosure<DynamicCacheDescriptor, String>(){

            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, (IgnitePredicate[])new IgnitePredicate[]{new IgnitePredicate<DynamicCacheDescriptor>(){

            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache() && desc.groupDescriptor().persistenceEnabled();
            }
        }});
        Map<Integer, CacheGroupDescriptor> groups = this.validateAndResolveCacheGroups(cacheNames);
        ArrayList<ClusterNode> nodes = this.getServerNodes(topVer);
        SnapshotOperationInfoImpl snapshotInfo = new SnapshotOperationInfoImpl(snapFut.id(), (GridSnapshotOperationEx)new GridSnapshotOperationImpl(SnapshotOperationType.CREATE, snapshotId, new HashSet<Integer>(groups.keySet()), new HashSet<String>(this.resolveCacheNames(groups.keySet())), msg, (Object)true, null, null, null), snapFut.initiatorNodeId(), topVer, nodes);
        snapFut.init(snapshotInfo);
    }

    boolean cancelLocalDelayedSnapshotCreation(long snapshotId) throws IgniteCheckedException {
        SnapshotOperationFuture snapFut = this.snapshotFut.get();
        if (snapFut != null) {
            if (!snapFut.delayed()) {
                return false;
            }
            snapFut.cancel();
            return this.snapshotFut.compareAndSet(snapFut, null);
        }
        return false;
    }

    public IgniteInternalFuture<Boolean> cancelGlobalDelayedSnapshotCreation(long snapshotId) throws IgniteException {
        return this.cctx.kernalContext().task().execute((ComputeTask)new CancelGlobalDelayedSnapshotCreationTask(snapshotId), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConsistentCut(long cutId, long lastAppliedCutId, boolean useLocNodeWal, IgniteInClosure<WALPointer> onWalPointerApplied) throws IgniteCheckedException {
        TransactionalDrProcessorImpl txdrProc = (TransactionalDrProcessorImpl)this.cctx.kernalContext().txDr();
        ConsistentCutStore cutStore = txdrProc.consistentCutStore();
        ConsistentCut cut = cutStore.restore(cutId);
        ConsistentCut lastCut = lastAppliedCutId > 0L ? cutStore.restore(lastAppliedCutId) : null;
        FileWALPointer startPtr = lastAppliedCutId > 0L ? (FileWALPointer)lastCut.fuzzyBorderStartPtr() : null;
        FileWALPointer endPtr = (FileWALPointer)cut.cutPtr();
        long startTs = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying consistent cut locally: [cut=" + cut + ", lastCut=" + lastCut + ']');
        }
        this.cutApplyingInProgress = true;
        ConistentCutApplyPartitions applyParts = this.reservePartitionsForConsistentCutApply();
        try (WALIterator it = this.walIterator(startPtr, endPtr, useLocNodeWal ? -1L : cut.spawnId());){
            IgniteBiPredicate & Serializable entryPred;
            FileWALPointer fuzzyBorderPtr = (FileWALPointer)cut.fuzzyBorderStartPtr();
            if (lastCut == null) {
                entryPred = (IgniteBiPredicate & Serializable)(rec, e) -> {
                    if (rec.type() != WALRecord.RecordType.DATA_RECORD && rec.type() != WALRecord.RecordType.DATA_RECORD_V2) {
                        return false;
                    }
                    FileWALPointer ptr = (FileWALPointer)rec.position();
                    boolean withinConsistentCut = ptr.compareTo(fuzzyBorderPtr) < 0 || ptr.compareTo(fuzzyBorderPtr) >= 0 && (e == null || e.nearXidVersion() == null || !cut.skipTxs().contains(e.nearXidVersion()));
                    return withinConsistentCut && applyParts.apply((DataEntry)e);
                };
            } else {
                FileWALPointer appliedCutPtr = (FileWALPointer)lastCut.cutPtr();
                entryPred = (IgniteBiPredicate & Serializable)(rec, e) -> {
                    if (rec.type() != WALRecord.RecordType.DATA_RECORD && rec.type() != WALRecord.RecordType.DATA_RECORD_V2) {
                        return false;
                    }
                    FileWALPointer ptr = (FileWALPointer)rec.position();
                    boolean withinConsistentCut = ptr.compareTo(appliedCutPtr) < 0 && (e == null || e.nearXidVersion() == null || lastCut.skipTxs().contains(e.nearXidVersion())) || ptr.compareTo(appliedCutPtr) >= 0 && ptr.compareTo(fuzzyBorderPtr) < 0 || ptr.compareTo(fuzzyBorderPtr) >= 0 && (e == null || e.nearXidVersion() == null || !cut.skipTxs().contains(e.nearXidVersion()));
                    return withinConsistentCut && applyParts.apply((DataEntry)e);
                };
            }
            this.dbSharedMgr.applyUpdates(it, null, (IgniteBiPredicate)entryPred, true, onWalPointerApplied, true);
            if (this.log.isInfoEnabled()) {
                this.log.info("Successfully applied consistent cut: [cut=" + cut + ", applyTime=" + (System.currentTimeMillis() - startTs) + "ms]");
            }
            txdrProc.gc().updateLastAppliedCut(cut);
        }
        finally {
            applyParts.reservedParts().forEach(GridDhtLocalPartition::release);
            Set<Integer> unexpectedCaches = applyParts.unexpectedCaches();
            if (!unexpectedCaches.isEmpty()) {
                this.logUnexpectedCachesWarning(unexpectedCaches);
            }
            this.cutApplyingInProgress = false;
        }
    }

    private void logUnexpectedCachesWarning(Set<Integer> unexpectedCaches) {
        StringBuilder unexpectedCachesMsg = new StringBuilder();
        unexpectedCachesMsg.append("Updates in WAL were skipped for the following non-replicating caches ");
        unexpectedCachesMsg.append("(total=").append(unexpectedCaches.size()).append("): ");
        for (Integer cacheId : unexpectedCaches) {
            GridCacheContext ctx = this.cctx.cacheContext(cacheId.intValue());
            unexpectedCachesMsg.append("[cacheId=").append(cacheId).append(", ");
            if (ctx == null) {
                unexpectedCachesMsg.append("cacheName=<unknown>, grpId=<unknown>, grpName=<unknown>], ");
                continue;
            }
            unexpectedCachesMsg.append("cacheName=").append(ctx.name()).append(", ");
            unexpectedCachesMsg.append("grpId=").append(ctx.groupId()).append(", ");
            unexpectedCachesMsg.append("grpName=").append(ctx.group().cacheOrGroupName()).append("], ");
        }
        unexpectedCachesMsg.setLength(unexpectedCachesMsg.length() - 2);
        U.warn((IgniteLogger)this.log, (Object)unexpectedCachesMsg.toString());
    }

    private ConistentCutApplyPartitions reservePartitionsForConsistentCutApply() {
        ArrayList<GridDhtLocalPartition> reservedPartitions = new ArrayList<GridDhtLocalPartition>();
        HashSet<GroupPartitionId> applyPartitions = new HashSet<GroupPartitionId>();
        HashSet<Integer> replicatedGroups = new HashSet<Integer>();
        HashMap<Integer, Integer> cacheToGrpIds = new HashMap<Integer, Integer>();
        Set publicPersistentGrpIds = this.cctx.cache().cacheGroupDescriptors().values().stream().filter(arg_0 -> TransactionalDrProcessorImpl.PUBLIC_PERSISTENT_CACHE_GROUP_FILTER.apply(arg_0)).map(CacheGroupDescriptor::groupId).collect(Collectors.toSet());
        for (Integer grpId : publicPersistentGrpIds) {
            CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId.intValue());
            for (GridCacheContext ctx : grp.caches()) {
                cacheToGrpIds.put(ctx.cacheId(), grp.groupId());
            }
            if (grp.config().getCacheMode() == CacheMode.REPLICATED) {
                replicatedGroups.add(grpId);
                continue;
            }
            List idealAssignment = grp.affinity().idealAssignment().assignment();
            for (GridDhtLocalPartition part : grp.topology().localPartitions()) {
                List idealAssignmentNodes = (List)idealAssignment.get(part.id());
                boolean locNodeIsIdealOwner = false;
                for (ClusterNode n : idealAssignmentNodes) {
                    if (!n.isLocal()) continue;
                    locNodeIsIdealOwner = true;
                }
                if (locNodeIsIdealOwner) {
                    applyPartitions.add(new GroupPartitionId(grpId.intValue(), part.id()));
                    continue;
                }
                if (!part.reserve()) continue;
                if (part.state() == GridDhtPartitionState.RENTING) {
                    part.release();
                    continue;
                }
                applyPartitions.add(new GroupPartitionId(grpId.intValue(), part.id()));
                reservedPartitions.add(part);
            }
        }
        return new ConistentCutApplyPartitions(reservedPartitions, applyPartitions, replicatedGroups, cacheToGrpIds);
    }

    public boolean cutApplyingInProgress() {
        return this.cutApplyingInProgress;
    }

    public SnapshotSecurityLevel resolveSecurityLevel() {
        return this.distributedSnapshotSecurityLevel.get();
    }

    private SnapshotSecurityLevel validateSecuritySettings(SnapshotSecurityLevel skipLevel) throws IgniteCheckedException {
        try {
            SnapshotSecurityLevel securityLevel = this.resolveSecurityLevel();
            if (securityLevel.compareTo((Enum)skipLevel) > 0 && !this.isSecuritySettingsCompatible()) {
                throw new IgniteCheckedException(INCOMPATIBLE_SECURITY_SETTINGS);
            }
            return securityLevel;
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public WALIterator walIterator(@Nullable FileWALPointer startPtr, @Nullable FileWALPointer endPtr, long spawnId) throws IgniteCheckedException {
        GridKernalContext ctx = this.cctx.kernalContext();
        if (spawnId == -1L) {
            return ctx.cache().context().wal().replay((WALPointer)startPtr);
        }
        TransactionalDrProcessorImpl txdrProc = (TransactionalDrProcessorImpl)ctx.txDr();
        File walDir = txdrProc.walDir(spawnId);
        IgniteWalIteratorFactory iterFactory = new IgniteWalIteratorFactory(this.log);
        IgniteWalIteratorFactory.IteratorParametersBuilder params = this.getWalIteratorParameters().strictBoundsCheck(!Boolean.getBoolean(TX_DR_SKIP_STRICT_BOUNDS_CHECK)).binaryMetadataFileStoreDir(null).marshallerMappingFileStoreDir(null).sharedContext(ctx.cache().context());
        if (startPtr != null) {
            params.from(startPtr);
        }
        if (endPtr != null) {
            params.to(endPtr);
        }
        return iterFactory.iterator(params.copy().filesOrDirs(new File[]{walDir}));
    }

    public IgniteWalIteratorFactory.IteratorParametersBuilder getWalIteratorParameters() throws IgniteCheckedException {
        GridKernalContext ctx = this.cctx.kernalContext();
        String workDir = ctx.config().getWorkDirectory();
        String subFolder = ctx.pdsFolderResolver().resolveFolders().folderName();
        DataStorageConfiguration dsCfg = ctx.config().getDataStorageConfiguration();
        IgniteWalIteratorFactory.IteratorParametersBuilder params = new IgniteWalIteratorFactory.IteratorParametersBuilder();
        int bufSize = TX_DR_WAL_BUFFER_SIZE == -1 ? dsCfg.getWalRecordIteratorBufferSize() : TX_DR_WAL_BUFFER_SIZE;
        params.binaryMetadataFileStoreDir(new File(U.resolveWorkDirectory((String)workDir, (String)"db/binary_meta", (boolean)false), subFolder)).marshallerMappingFileStoreDir(U.resolveWorkDirectory((String)workDir, (String)"db/marshaller", (boolean)false)).pageSize(dsCfg.getPageSize()).ioFactory(dsCfg.getFileIOFactory()).bufferSize(bufSize);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitLegacyCountersForCacheGroup(int grpId) {
        long metaId = 0L;
        long metaPage = 0L;
        PageMemoryEx pageMem = null;
        try {
            CacheGroupContext ctx = this.context().cache().cacheGroup(grpId);
            if (ctx == null || !ctx.affinityNode() || !ctx.persistenceEnabled()) {
                return;
            }
            pageMem = (PageMemoryEx)ctx.dataRegion().pageMemory();
            metaId = PageMemory.META_PAGE_ID;
            metaPage = pageMem.acquirePage(grpId, metaId);
            long pageAddr = pageMem.readLock(grpId, metaId, metaPage);
            try {
                long nextSnapshotTag = this.pageMetaIO.getNextSnapshotTag(pageAddr);
                this.nextSnapshotTagForCacheGrp.putIfAbsent(grpId, nextSnapshotTag);
                long lastSuccessfulSnapshotTag = this.pageMetaIO.getLastSuccessfulSnapshotTag(pageAddr);
                this.lastSuccessfulSnapshotTagForCacheGrp.putIfAbsent(grpId, lastSuccessfulSnapshotTag);
                long lastSuccessfulSnapshotId = this.pageMetaIO.getLastSuccessfulSnapshotId(pageAddr);
                this.lastSuccessfulSnapshotIdsForCacheGrp.putIfAbsent(grpId, lastSuccessfulSnapshotId);
                long lastSuccessfulFullSnapshotId = this.pageMetaIO.getLastSuccessfulFullSnapshotId(pageAddr);
                this.lastSuccessfulFullSnapshotIdsForCacheGrp.putIfAbsent(grpId, lastSuccessfulFullSnapshotId);
                assert (nextSnapshotTag != lastSuccessfulSnapshotTag) : "grpId = " + grpId + ", nextSnapshotTag = lastSuccessfulSnapshotTag =" + nextSnapshotTag;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Init legacy snapshot counters for group = " + grpId + ", nextSnapshotTag = " + nextSnapshotTag + ", lastSuccessfulSnapshotTag = " + lastSuccessfulSnapshotTag + ", lastSuccessfulSnapshotId = " + lastSuccessfulSnapshotId);
                }
            }
            finally {
                pageMem.readUnlock(grpId, metaId, metaPage);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            if (metaPage != 0L && pageMem != null) {
                pageMem.releasePage(grpId, metaId, metaPage);
            }
        }
    }

    public void updateSnapshotSecurityLevel(SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.cctx.kernalContext().security().authorize(SecurityPermission.CHANGE_SNAPSHOT_SECURITY_LEVEL);
        this.distributedSnapshotSecurityLevel.update(level);
    }

    public SnapshotSecurityLevel getSnapshotSecurityLevel() {
        return this.distributedSnapshotSecurityLevel.get();
    }

    public SnapshotMetadata snapshotMetadata(long snapshotId, Collection<SnapshotRemotePath> optSearchPaths) throws IgniteCheckedException {
        SnapshotDescriptor desc = this.getSnapshotDescriptorFromCluster(snapshotId, null, null);
        return desc.snapshotMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSnapshotDataInMetastorage(Consumer<ReadWriteMetastorage> act) {
        ReadWriteMetastorage metastorage = this.metastorage;
        assert (metastorage != null);
        Object object = this.metaMux;
        synchronized (object) {
            this.dbSharedMgr.checkpointReadLock();
            try {
                act.accept(metastorage);
            }
            finally {
                this.dbSharedMgr.checkpointReadUnlock();
            }
        }
    }

    private void updateMetastoreSnapshotCounterDecriptor(Collection<Integer> grpIds, Consumer<SnapshotCountersDescriptor> act) {
        this.updateSnapshotDataInMetastorage(m -> {
            for (Integer grpId : grpIds) {
                try {
                    long nextSnapshotTag;
                    long lastSuccessfulSnapshotTag;
                    SnapshotCountersDescriptor desc = (SnapshotCountersDescriptor)((Object)((Object)m.read(METASTORE_KEY_PREFIX + grpId)));
                    if (desc == null) {
                        long lastSuccessfulSnapshotId = this.lastSuccessfulSnapshotIdsForCacheGrp.getOrDefault(grpId, 0L);
                        long lastSuccessfulSnapshotTag2 = this.lastSuccessfulSnapshotTagForCacheGrp.getOrDefault(grpId, 0L);
                        long nextSnapshotTag2 = this.nextSnapshotTagForCacheGrp.getOrDefault(grpId, 1L);
                        assert (lastSuccessfulSnapshotTag2 != nextSnapshotTag2) : "grpId = " + grpId + ", nextSnapshotTag = lastSuccessfulSnapshotTag =" + nextSnapshotTag2;
                        desc = new SnapshotCountersDescriptor(grpId).lastSuccessfulSnapshotId(lastSuccessfulSnapshotId).lastSuccessfulSnapshotTag(lastSuccessfulSnapshotTag2).nextSnapshotTag(nextSnapshotTag2);
                    } else {
                        lastSuccessfulSnapshotTag = desc.lastSuccessfulSnapshotTag();
                        nextSnapshotTag = desc.nextSnapshotTag();
                        assert (lastSuccessfulSnapshotTag != nextSnapshotTag) : "grpId = " + grpId + ", nextSnapshotTag = lastSuccessfulSnapshotTag =" + nextSnapshotTag;
                    }
                    act.accept(desc);
                    lastSuccessfulSnapshotTag = desc.lastSuccessfulSnapshotTag();
                    nextSnapshotTag = desc.nextSnapshotTag();
                    assert (lastSuccessfulSnapshotTag != nextSnapshotTag) : "grpId = " + grpId + ", nextSnapshotTag = lastSuccessfulSnapshotTag =" + nextSnapshotTag;
                    m.write(METASTORE_KEY_PREFIX + grpId, (Serializable)((Object)desc));
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Failed to write snapshot tags to metastorage for grpId=" + grpId, (Throwable)e);
                    throw new IgniteException((Throwable)e);
                }
            }
        });
    }

    private void updateMetastoreSnapshotCommonInformation(Consumer<SnapshotMetastoreCommonInformation> act) {
        this.updateSnapshotDataInMetastorage(m -> {
            try {
                SnapshotMetastoreCommonInformation commonInfo = (SnapshotMetastoreCommonInformation)((Object)((Object)m.read(COMMON_INFO_METASTORE_KEY)));
                if (commonInfo == null) {
                    commonInfo = new SnapshotMetastoreCommonInformation();
                }
                act.accept(commonInfo);
                m.write(COMMON_INFO_METASTORE_KEY, (Serializable)((Object)commonInfo));
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed update snapshot common information to metastorage", (Throwable)e);
                throw new IgniteException((Throwable)e);
            }
        });
    }

    public ConsistentCutStore consistentCutStore() {
        return this.cutStore;
    }

    public void registerConsistentCutStoreListener(IgniteInClosure<ConsistentCut> clo) {
        this.cutStore.registerConsistentCutStoreListener(clo);
    }

    public void unregisterConsistentCutStoreListener(IgniteInClosure<ConsistentCut> clo) {
        this.cutStore.unregisterConsistentCutStoreListener(clo);
    }

    public void onPartitionStatesRestored(GridDhtPartitionsExchangeFuture fut) {
        SnapshotOperationFuture snapFut = this.snapshotFuture();
        if (snapFut != null) {
            snapFut.onPartitionStatesRestored(fut);
        }
    }

    public void onInitAfterTopologyLock(GridDhtPartitionsExchangeFuture fut) {
        SnapshotOperationFuture snapFut;
        DiscoveryCustomMessage msg;
        if (fut.firstEvent().type() == 18 && (msg = ((DiscoveryCustomEvent)fut.firstEvent()).customMessage()) instanceof WalStateAbstractMessage && (snapFut = this.snapshotFuture()) != null) {
            WalStateAbstractMessage walStateMsg = (WalStateAbstractMessage)msg;
            snapFut.onWalStateChanged(walStateMsg.groupId(), walStateMsg.exchangeMessage().caches(), walStateMsg.exchangeMessage().enable());
        }
    }

    public void registerLocalStageCompletedListener(IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage> lsnr) {
        this.locStageCompletedLsnrs.add(lsnr);
    }

    public void unregisterLocalStageCompletedListener(IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage> lsnr) {
        this.locStageCompletedLsnrs.remove(lsnr);
    }

    public void notifyLocalStageCompletedListeners(SnapshotOperationFuture fut, SnapshotOperationStage stage) {
        this.locStageCompletedLsnrs.forEach(lsnr -> lsnr.apply((Object)fut, (Object)stage));
    }

    public long localWalSize(SnapshotMetadataV2 curr, @Nullable SnapshotMetadataV2 next) {
        IgniteWriteAheadLogManager wal = this.cctx.wal();
        assert (wal != null);
        if (curr.pointInTimeRecoveryEnabled() && (next != null && next.pointInTimeRecoveryEnabled() || this.pointInTimeRecoveryEnabled())) {
            FileWALPointer low = (FileWALPointer)F.firstEntry((Map)curr.walPoints()).getValue();
            FileWALPointer higher = next != null ? (FileWALPointer)F.firstEntry((Map)next.walPoints()).getValue() : (FileWALPointer)wal.lastWritePointer();
            long walSize = 0L;
            for (long i = low.index(); i < higher.index(); ++i) {
                walSize += wal.segmentSize(i);
            }
            if (next == null) {
                walSize += (long)(higher.fileOffset() + higher.length());
            }
            return walSize;
        }
        return 0L;
    }

    private void logCompressionCodecs() {
        if (this.log.isInfoEnabled()) {
            this.log.info("Loaded LZ4 instance: " + LZ4Factory.fastestInstance().toString());
        }
    }

    private class PointInTimeDistributedPropertyChangesListener {
        GridFutureAdapter<Void> distributedMetastorageReadyForWriteFut = new GridFutureAdapter();
        GridFutureAdapter<Void> kernalStartedFut = new GridFutureAdapter();
        GridCompoundFuture<Void, Void> initializeFut = new GridCompoundFuture();
        boolean clusterSupportsDistributedProp = true;

        public PointInTimeDistributedPropertyChangesListener() {
            this.initializeFut.add(this.distributedMetastorageReadyForWriteFut);
            this.initializeFut.add(this.kernalStartedFut);
            this.initializeFut.listen((IgniteInClosure & Serializable)fut -> this.onStart());
            this.initializeFut.markInitialized();
        }

        void onDistributedMetastorageReadyForWrite() {
            this.distributedMetastorageReadyForWriteFut.onDone();
        }

        void onKernalStart() {
            this.kernalStartedFut.onDone();
        }

        void onStart() {
            this.clusterSupportsDistributedProp = IgniteFeatures.allNodesSupport((GridKernalContext)GridCacheSnapshotManager.this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.POINT_IN_TIME_DISTRIBUTED_PROPERTY);
            if (GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled.get() == null) {
                if (GridCacheSnapshotManager.this.log.isInfoEnabled()) {
                    GridCacheSnapshotManager.this.log.info(GridCacheSnapshotManager.PITR_INIT_FROM_CONFIG_MSG + IgniteUtils.enabledString((boolean)GridCacheSnapshotManager.this.dfltPointInTimeRecoveryEnabled) + '.');
                }
                if (IgniteFeatures.allNodesSupport((GridKernalContext)GridCacheSnapshotManager.this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.POINT_IN_TIME_DISTRIBUTED_PROPERTY)) {
                    DistributedConfigurationUtils.setDefaultValue((DistributedProperty)GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled, (Serializable)Boolean.valueOf(GridCacheSnapshotManager.this.dfltPointInTimeRecoveryEnabled), (IgniteLogger)GridCacheSnapshotManager.this.log);
                }
            } else if (GridCacheSnapshotManager.this.log.isInfoEnabled()) {
                GridCacheSnapshotManager.this.log.info(GridCacheSnapshotManager.PITR_APPLYING_CLUSTER_WIDE_VALUE_MSG + IgniteUtils.enabledString((boolean)F.eq((Object)GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled.get(), (Object)true)) + '.');
            }
            this.onSomethingChanged(null);
        }

        void onTopologyChanged() {
            boolean clusterSupportsDistributedProp = IgniteFeatures.allNodesSupport((GridKernalContext)GridCacheSnapshotManager.this.cctx.kernalContext(), (IgniteFeatures)IgniteFeatures.POINT_IN_TIME_DISTRIBUTED_PROPERTY);
            if (this.clusterSupportsDistributedProp != clusterSupportsDistributedProp) {
                this.clusterSupportsDistributedProp = clusterSupportsDistributedProp;
                this.onSomethingChanged(null);
            }
        }

        void onPropertyChanged(@Nullable Boolean newVal) {
            this.onSomethingChanged(newVal);
        }

        void onSomethingChanged(@Nullable Boolean newVal) {
            boolean actualVal = GridCacheSnapshotManager.this.pointInTimeRecoveryEnabled();
            if (newVal == null) {
                newVal = actualVal;
            }
            if (newVal.booleanValue() && !this.clusterSupportsDistributedProp) {
                GridCacheSnapshotManager.this.log.warning(GridCacheSnapshotManager.PITR_ENABLED_MIXED_CLUSTER_WARN + IgniteUtils.enabledString((boolean)actualVal));
            }
            if (!GridCacheSnapshotManager.this.exchangelessPointInTimeRecoveryModeEnabled() && GridCacheSnapshotManager.this.log.isInfoEnabled()) {
                if (actualVal) {
                    GridCacheSnapshotManager.this.log.info(GridCacheSnapshotManager.PITR_TURNED_ON_EXCHANGELESS_SNAPSHOTS_DISABLED_MSG);
                } else {
                    GridCacheSnapshotManager.this.log.info(GridCacheSnapshotManager.PITR_TURNED_OFF_EXCHANGELESS_SNAPSHOTS_ENABLED_MSG);
                }
            }
        }
    }

    private static class InMemorySingleCutStore
    implements ConsistentCutStore {
        private final AtomicReference<ConsistentCut> cutStore = new AtomicReference();
        private final CopyOnWriteArrayList<IgniteInClosure<ConsistentCut>> lsnrs = new CopyOnWriteArrayList();

        private InMemorySingleCutStore() {
        }

        public void registerConsistentCutStoreListener(IgniteInClosure<ConsistentCut> clo) {
            this.lsnrs.add(clo);
        }

        public void unregisterConsistentCutStoreListener(IgniteInClosure<ConsistentCut> clo) {
            this.lsnrs.remove(clo);
        }

        @Override
        public void save(ConsistentCut consistentCut) throws IgniteCheckedException {
            this.cutStore.set(consistentCut);
            this.lsnrs.forEach((Consumer<IgniteInClosure<ConsistentCut>>)((Consumer<IgniteInClosure>)clo -> clo.apply((Object)consistentCut)));
        }

        @Override
        public ConsistentCut restore(long id) throws IgniteCheckedException {
            ConsistentCut cut = this.cutStore.get();
            if (cut == null || cut.id() != id) {
                throw new IgniteCheckedException("Consistent cut " + id + " not found.");
            }
            return cut;
        }

        @Override
        public boolean delete(long id) throws IgniteCheckedException {
            return this.cutStore.getAndSet(null) != null;
        }

        @Override
        public void cleanup() throws IgniteCheckedException {
            this.cutStore.set(null);
        }

        @Override
        public List<Long> list() throws IgniteCheckedException {
            return this.list(0L);
        }

        @Override
        public List<Long> list(long startId) throws IgniteCheckedException {
            return this.list(startId, Long.MAX_VALUE);
        }

        @Override
        public List<Long> list(long startId, long endId) throws IgniteCheckedException {
            ConsistentCut cut = this.cutStore.get();
            if (cut == null || cut.id() < startId || cut.id() > endId) {
                return Collections.emptyList();
            }
            return Collections.singletonList(cut.id());
        }
    }

    private static class ConistentCutApplyPartitions
    implements IgnitePredicate<DataEntry> {
        private static final long serialVersionUID = 0L;
        private final List<GridDhtLocalPartition> reservedParts;
        private final Set<GroupPartitionId> applyPartitions;
        private final Set<Integer> replicatedGroups;
        private final Map<Integer, Integer> cacheToGrpId;
        private final GridConcurrentHashSet<Integer> unexpectedCaches;

        public ConistentCutApplyPartitions(List<GridDhtLocalPartition> reservedParts, Set<GroupPartitionId> applyPartitions, Set<Integer> replicatedGroups, Map<Integer, Integer> cacheToGrpId) {
            this.reservedParts = reservedParts;
            this.applyPartitions = applyPartitions;
            this.replicatedGroups = replicatedGroups;
            this.cacheToGrpId = cacheToGrpId;
            this.unexpectedCaches = new GridConcurrentHashSet();
        }

        public boolean apply(DataEntry entry) {
            if (entry == null) {
                return true;
            }
            int cacheId = entry.cacheId();
            Integer grpId = this.cacheToGrpId.get(cacheId);
            if (grpId == null) {
                this.unexpectedCaches.add((Object)cacheId);
                return false;
            }
            return this.replicatedGroups.contains(grpId) || this.applyPartitions.contains(new GroupPartitionId(grpId.intValue(), entry.partitionId()));
        }

        public List<GridDhtLocalPartition> reservedParts() {
            return this.reservedParts;
        }

        public Set<Integer> unexpectedCaches() {
            return U.sealSet(this.unexpectedCaches);
        }
    }

    private static enum State {
        STARTING,
        ACTIVE,
        INACTIVE;

    }

    private static class SnapshotOperationParameters {
        private final Set<Integer> cacheGrpIds;
        private final Map<String, Integer> cacheNamesWithGroupId;
        @Nullable
        private final SnapshotRestoreStrategy stgy;

        SnapshotOperationParameters(Set<Integer> cacheGrpIds, Map<String, Integer> cacheNamesWithGrpId, @Nullable SnapshotRestoreStrategy stgy) {
            this.cacheGrpIds = cacheGrpIds;
            this.cacheNamesWithGroupId = cacheNamesWithGrpId;
            this.stgy = stgy;
        }

        Set<Integer> cacheGroupIds() {
            return this.cacheGrpIds;
        }

        Set<String> cacheNames() {
            return new HashSet<String>(this.cacheNamesWithGroupId.keySet());
        }

        Map<String, Integer> cacheNamesWithGroupId() {
            return this.cacheNamesWithGroupId;
        }

        SnapshotRestoreStrategy restoreStrategy() {
            return this.stgy;
        }
    }

    private static class CancelLocalDelayedSnapshotCreationJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        private final long snapshotId;
        @IgniteInstanceResource
        private IgniteEx ignite;

        public CancelLocalDelayedSnapshotCreationJob(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public Object execute() throws IgniteException {
            IgniteCacheSnapshotManager snapMgr = this.ignite.context().cache().context().snapshot();
            try {
                if (snapMgr instanceof GridCacheSnapshotManager) {
                    return ((GridCacheSnapshotManager)snapMgr).cancelLocalDelayedSnapshotCreation(this.snapshotId);
                }
                return false;
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException((Throwable)ex);
            }
        }
    }

    private static class CancelGlobalDelayedSnapshotCreationTask
    extends ComputeTaskAdapter<Void, Boolean> {
        private static final long serialVersionUID = 0L;
        private final long snapshotId;

        public CancelGlobalDelayedSnapshotCreationTask(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Nullable
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) throws IgniteException {
            HashMap<CancelLocalDelayedSnapshotCreationJob, ClusterNode> map = new HashMap<CancelLocalDelayedSnapshotCreationJob, ClusterNode>();
            for (ClusterNode node : subgrid) {
                map.put(new CancelLocalDelayedSnapshotCreationJob(this.snapshotId), node);
            }
            return map;
        }

        @Nullable
        public Boolean reduce(List<ComputeJobResult> results) throws IgniteException {
            boolean globalRes = true;
            for (ComputeJobResult result : results) {
                if (result.getException() != null) {
                    throw result.getException();
                }
                if (result.getData() != Boolean.FALSE) continue;
                globalRes = false;
            }
            return globalRes;
        }
    }

    private static class SnapshotCheckException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;

        public SnapshotCheckException(String msg) {
            super(msg);
        }
    }
}

