/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.TrackingPageIsCorruptedException;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AbstractFullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullPageIdIterable
extends AbstractFullPageIdIterable {
    FullPageIdIterable(GridCacheSharedContext<?, ?> sharedCtx, Map<Integer, Long> nextSnapshotTagsForCacheGrp, Map<Integer, Long> lastSuccessfulSnapshotIdsForCache, PartitionAllocationMap partStateMap) {
        super(sharedCtx, nextSnapshotTagsForCacheGrp, lastSuccessfulSnapshotIdsForCache, partStateMap);
    }

    @Override
    protected PageIdIterable.CountingIterator<FullPageId> createIterator(Queue<T2<GroupPartitionId, PagesAllocationRange>> queue) {
        return new FullPageIdIterator(queue);
    }

    @Override
    public boolean contains(@NotNull FullPageId fullId) {
        long idx = PageIdUtils.pageIndex((long)fullId.pageId());
        PagesAllocationRange cnt = this.partStateMap.get(PartitionAllocationMap.createCachePartId((FullPageId)fullId));
        return cnt != null && (long)cnt.getCurrAllocatedPageCnt() > idx;
    }

    @Override
    @Nullable
    public FullPageId next(@Nullable FullPageId fullId) {
        int maxAllocPageIdx;
        if (this.partStateMap.isEmpty()) {
            return null;
        }
        if (fullId == null) {
            return this.nextStartPage(null);
        }
        int partId = PageIdUtils.partId((long)fullId.pageId());
        int grpId = fullId.groupId();
        int idx = PageIdUtils.pageIndex((long)fullId.pageId());
        GroupPartitionId curCachePartId = PartitionAllocationMap.createCachePartId((FullPageId)fullId);
        PagesAllocationRange range = this.partStateMap.get(curCachePartId);
        int n = maxAllocPageIdx = range == null ? -1 : range.getCurrAllocatedPageCnt() - 1;
        if (range == null || idx > maxAllocPageIdx && maxAllocPageIdx >= 0) {
            return this.nextStartPage(null);
        }
        if (idx == maxAllocPageIdx || maxAllocPageIdx == -1) {
            return this.nextStartPage(curCachePartId);
        }
        long pageId = PageIdUtils.pageId((int)partId, (byte)PageIdUtils.flag((long)fullId.pageId()), (int)(idx + 1));
        long trackingPageId = this.io.trackingPageFor(pageId, this.realPageSize(grpId));
        if (trackingPageId == pageId) {
            try (AbstractFullPageIdIterable.TrackingPageBufferScope ignored = this.borrowTrackingPage(grpId, trackingPageId);){
                this.io.wasChanged(this.getCachedTrackingPage(), pageId, this.getCurrentSnapshotTag(grpId), this.getLastSuccessfulSnapshotTag(grpId), this.realPageSize(grpId));
            }
            catch (TrackingPageIsCorruptedException ex) {
                if (ex != TrackingPageIsCorruptedException.INSTANCE) {
                    U.error((IgniteLogger)this.sharedCtx.logger(this.getClass()), (Object)("Corrupted nextSnapshotTag grpId=" + grpId + ", partition=" + partId + ", trackingPageId=" + U.hexLong((long)trackingPageId) + ", lastSavedTag=" + ex.lastTag() + ", nextSnapshotTag=" + ex.passedTag()), (Throwable)ex);
                }
                this.markCorruptedTrackingPage(trackingPageId, grpId);
            }
        }
        return new FullPageId(pageId, grpId);
    }

    @Override
    public boolean isEmpty() {
        return this.next(null) == null;
    }

    private class FullPageIdIterator
    implements PageIdIterable.CountingIterator<FullPageId> {
        private final Queue<T2<GroupPartitionId, PagesAllocationRange>> queue;
        private Map.Entry<GroupPartitionId, PagesAllocationRange> currEntry;
        private int currPageIdx;
        private FullPageId next;
        private int overallAdvanceCnt;

        private FullPageIdIterator(Queue<T2<GroupPartitionId, PagesAllocationRange>> queue) {
            this.queue = queue;
            this.overallAdvanceCnt = 0;
            this.advance();
        }

        private void advance() {
            if (this.currEntry == null) {
                this.currEntry = (Map.Entry)this.queue.poll();
                if (this.currEntry == null) {
                    return;
                }
            } else if (this.currPageIdx < this.currEntry.getValue().getCurrAllocatedPageCnt() - 1) {
                ++this.currPageIdx;
            } else {
                this.currPageIdx = 0;
                this.currEntry = (Map.Entry)this.queue.poll();
                if (this.currEntry == null) {
                    this.next = null;
                    ++this.overallAdvanceCnt;
                    return;
                }
            }
            int cacheId = this.currEntry.getKey().getGroupId();
            int partId = this.currEntry.getKey().getPartitionId();
            long pageId = PageIdUtils.pageId((int)partId, (byte)0, (int)this.currPageIdx);
            this.next = new FullPageId(pageId, cacheId);
            ++this.overallAdvanceCnt;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FullPageId next() {
            FullPageId next = this.next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public int currentInternalCount() {
            return this.overallAdvanceCnt - 1;
        }

        @Override
        public int totalInternalCount() {
            return FullPageIdIterable.this.getTotalPageCnt();
        }
    }
}

